/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

  	document.getElementById('deck').selectedIndex = 0;
  	oma_init();
  	ome_init();
		oea_init();

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuAbonnements() {
	try {

		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuAbonnements').collapsed = true;
		document.getElementById('bMenuEcritures').collapsed = false;

		document.activeElement.blur();
		oma_listerAbonnements();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuEcritures() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuEcritures').collapsed = true;
		document.getElementById('bMenuAbonnements').collapsed = false;

		document.activeElement.blur();
		ome_listerEcheances();

	} catch (e) {
		recup_erreur(e);
	}
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 2: oea_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
