/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var nouvel_exercice = false; // variable globale indiquant s'il faut creer un nouvel exercice

var aJOD = new Arbre('ComboListe/combo-journaux.tmpl', 'JournalEX');
var aPerExt = new Arbre('Compta/Exercice/combo-periodeExtourne.tmpl', 'DateEX');


function init() {
	try {

		aJOD.setParam('Type_Journal', 'OD');
		
		var qGet = new QueryHttp("Compta/Exercice/getNbExerciceOuvert.tmpl");
		var result = qGet.execute();

		var nbExosOuverts = result.responseXML.documentElement.getAttribute('Nb_Exercice_Ouvert');
		
		qGet = new QueryHttp("Compta/Exercice/getDatesExercice.tmpl");
		qGet.setParam("Sel_Exercice", "C");
		var result = qGet.execute();

		var dateDebut = result.responseXML.documentElement.getAttribute('Debut_Exercice');
    var dateFin = result.responseXML.documentElement.getAttribute('Fin_Exercice');

		document.getElementById("Ancien_Exercice").value = "Ancien Exercice: Du "+ dateDebut +" au "+ dateFin;
		document.getElementById("JournalAN").focus();

		var aJAN = new Arbre('ComboListe/combo-journaux.tmpl', 'JournalAN');
		aJAN.setParam('Type_Journal', 'AN');
		aJAN.initTree(selectJournalAN);

		if (nbExosOuverts>1) {
			qGet.setParam("Sel_Exercice", "S");
			result = qGet.execute();

			var dateDebutNew = result.responseXML.documentElement.getAttribute('Debut_Exercice');
    	var dateFinNew = result.responseXML.documentElement.getAttribute('Fin_Exercice');

			document.getElementById("Nouvel_Exercice").value = "Nouvel Exercice: Du "+ dateDebutNew +" au "+ dateFinNew;
		}
		else {
			// il faut creer un nouvel exercice
			nouvel_exercice = true;
			document.getElementById('labelDate_Fin').collapsed = false;
			document.getElementById('Date_Fin').collapsed = false;
			document.getElementById('Date_Fin').value = dateFin.substring(0,6)+(parseIntBis(dateFin.substring(6,10))+1);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function displayEX(d) {
  try {

	  document.getElementById('JournalEX').collapsed = d;
	  document.getElementById('DateEX').collapsed = d;
	  document.getElementById('labelJournalEX').collapsed = d;
	  document.getElementById('labelDateEX').collapsed = d;

    if (d) {
			aJOD.deleteTree();
			aPerExt.deleteTree();
		}
		else {
			aJOD.initTree(selectJournal);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function selectJournal() {
	try {

		document.getElementById('JournalEX').value = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function initPeriodesEX() {
	try {
		
		var journalEX = document.getElementById('JournalEX').value;
		document.getElementById('DateEX').value = "";
		
		if (!isEmpty(journalEX)) {
			aPerExt.setParam('Journal_Id', journalEX);
			aPerExt.initTree();
		}
		else {
			aPerExt.deleteTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function selectJournalAN() {
	try {

    document.getElementById('JournalAN').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function reinit() {
	try {

		document.getElementById('progression').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

    document.getElementById('bMenuPrincipal').disabled = false;
    document.getElementById('bFermerSession').disabled = false;
    document.getElementById('Date_Fin').disabled = false;
    document.getElementById('JournalAN').disabled = false;
    document.getElementById('DetailTiers').disabled = false;
		document.getElementById('DetailAux').disabled = false;
    document.getElementById('AExtourner').disabled = false;
    document.getElementById('bOK').disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function precloture() {
	try {

		document.getElementById('progression').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

    document.getElementById('bMenuPrincipal').disabled = true;
    document.getElementById('bFermerSession').disabled = true;
    document.getElementById('Date_Fin').disabled = true;
    document.getElementById('JournalAN').disabled = true;
    document.getElementById('DetailTiers').disabled = true;
		document.getElementById('DetailAux').disabled = true;
    document.getElementById('AExtourner').disabled = true;
    document.getElementById('bOK').disabled = true;

		var Date_Fin = '';
		if (nouvel_exercice) {
			var Date_Fin = document.getElementById('Date_Fin').value;
		}
		var JournalAN = document.getElementById('JournalAN').value;
		var DetailTiers = document.getElementById('DetailTiers').checked;
		var DetailAux = document.getElementById('DetailAux').checked;
		var AExtourner = document.getElementById('AExtourner').checked;
		var JournalEX = '';
		var DateEX = '';
		if (AExtourner) {
			JournalEX = document.getElementById('JournalEX').value;
			DateEX = document.getElementById('DateEX').value;
		}

		if (isEmpty(JournalAN)) {
			showWarning("Impossible de cloturer l'exercice aucun journal d'A Nouveau disponible");
  		reinit();
		}
		else if (AExtourner && isEmpty(JournalEX)) {
			showWarning("Veuillez s\u00E9lectionner un journal \u00E0 extourner");
  		reinit();
		}
		else if (AExtourner && isEmpty(DateEX)) {
			showWarning("Veuillez s\u00E9lectionner une p\u00E9riode \u00E0 extourner");
  		reinit();
		}
		else if (nouvel_exercice && (isEmpty(Date_Fin) || !isDate(Date_Fin))) {
			showWarning("Date de fin du nouvel exercice incorrecte");
  		reinit();
		}
		else {
			var cloture = 1;

			if (nouvel_exercice) {
				var qNewExo = new QueryHttp("Compta/UpdateDatabase/CreerExercice.tmpl");
				qNewExo.setParam('Fin_Exercice', Date_Fin);
				qNewExo.setParam('JournalAN', JournalAN);
				var result = qNewExo.execute();

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
					cloture = 0;
					document.getElementById('Date_Fin').focus();
				}
				else {
    			showMessage("Le nouvel exercice a \u00E9t\u00E9 cr\u00E9\u00E9 avec succ\u00E9s");
  			}
			}

			if (cloture==1) {

				var qVerifCloture = new QueryHttp("Compta/UpdateDatabase/VerifCloture.tmpl");
				var result = qVerifCloture.execute();

    		var resultat = result.responseXML.documentElement.getAttribute('Resultat');

    		var coherenceResultat = parseIntBis(result.responseXML.documentElement.getAttribute('Resultat_Coherent'));

    		if (coherenceResultat==1) {
      		var page = "chrome://opensi/content/compta/user/cloture/confirmation_cloture.xul?"+ cookie();
      		page += "&Resultat="+ resultat;
      		page += "&JournalAN="+ JournalAN;
      		page += "&DetailTiers="+ DetailTiers;
					page += "&DetailAux="+ DetailAux;
      		page += "&AExtourner="+ AExtourner;
      		page += "&JournalEX="+ JournalEX;
      		page += "&DateEX="+ DateEX;
					window.location = page;
				}
				else {
					var msg = "Attention: Incoh\u00E9rence lors de la cloture. ";
      		msg += "La diff\u00E9rence entre les produits(7) et les charges(6) ";
      		msg += "n'est pas \u00E9gale \u00E0 la variation th\u00E9orique de vos capitaux propres !";
					showWarning(msg);
					reinit();
				}
    	}
			else {
    		reinit();
    	}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

  	window.location = "chrome://opensi/content/compta/user/menu_exercice.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}
