/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");



function init() {
  try {

		var nf = new NumberFormat("0.00", true);

		var aJSAN = new Arbre('ComboListe/combo-journaux.tmpl', 'journaux');
		aJSAN.setParam("Sans_AN", true);
		aJSAN.initTree(initJournal);

    var solde = parseFloat(ParamValeur('solde'));
    if (solde > 0) {
      document.getElementById('montant').value = nf.format(solde);
      document.getElementById('lblMontant').value = 'Montant au cr\u00E9dit :';
    }
		else {
      solde = - solde;
      document.getElementById('montant').value = nf.format(solde);
      document.getElementById('lblMontant').value = 'Montant au d\u00E9bit :';
    }
    document.getElementById('libelle').value = "Diff\u00E9rence de lettrage";
    document.getElementById('contrepartie').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function initJournal() {
	try {

		document.getElementById('journaux').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function changerCompte() {
	try {

		var numCompte = document.getElementById('contrepartie').value;
    var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourChangerCompte, numCompte, "", "", "", false);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById('contrepartie').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function validerEcriture() {
  try {

		var date = document.getElementById('date').value;
		var libelle = document.getElementById('libelle').value;
		var journal = document.getElementById('journaux').value;
		var contrepartie = document.getElementById('contrepartie').value;

		if (isEmpty(contrepartie)) { showWarning("Contrepartie manquante"); }
		else if (isEmpty(journal)) { showWarning("Journal manquant"); }
		else if (isEmpty(date)) { showWarning("Date manquante"); }
    else if (!isDate(date)) { showWarning("Date incorrecte"); }
		else if (isEmpty(libelle)) { showWarning("Libell\u00E9 manquant !"); }
		else {

			var qCreate = new QueryHttp("Compta/Consultation/genEcrEquiLettrage.tmpl");
			qCreate.setParam('Num_Compte', ParamValeur('NumCompte'));
			qCreate.setParam('Solde', ParamValeur('solde'));
			qCreate.setParam('Date', date);
			qCreate.setParam('Libelle', libelle);
			qCreate.setParam('Contrepartie', contrepartie);
			qCreate.setParam('Journal_Id', journal);
			var result = qCreate.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var opId = result.responseXML.documentElement.getAttribute('Op_Id');
    		window.arguments[0](opId);
    		window.close();
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}
