/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aOperations = new Arbre("Compta/Revision/list-revisionComptes.tmpl", "listeRevision");

var debit = 0;
var credit = 0;
var solde = 0;
var comptePrecedent = "";
var compteSuivant = "";
var compte = "";
var numop = '';
var listeop = new Array();
var nfs = new NumberFormat("0.00", true);
var nf = new NumberFormat("0.00", false);
var exoN1 = false;
var premierCompte;
var dernierCompte;
var lettrable;
var lettragePossibleAN;
var nbLigneLettrage = 0;
var lettrageEnCours = false;

var qListRC = new QueryHttp("Compta/Revision/getDataListRC.tmpl");

var pageCourante;
var nbPages;



function init() {
  try {

		document.getElementById('lettrageEcritures').value = "N";

    var cpte = ParamValeur('compte');
    var nomprec = ParamValeur('nomprec');
    numop = ParamValeur('numop');

		initRevision();

    if (isEmpty(cpte)) {
      document.getElementById('compte').focus();
    }
		else {
      document.getElementById('compte').value = cpte;
      ok();
    }

    if (!isEmpty(nomprec)) {
      document.getElementById('bRetour'+ nomprec).collapsed = false;
    }
		infoExoN1();

		var aModesReglements = new Arbre("ComboListe/combo-modesReglement.tmpl", "modeReglement");
		aModesReglements.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function initRevision() {
  try {

		var qGet = new QueryHttp("Compta/Revision/getInitRevision.tmpl");
		qGet.setParam("Exo_N1", exoN1);
		var result = qGet.execute();

		premierCompte = result.responseXML.documentElement.getAttribute('Premier_Compte');
    dernierCompte = result.responseXML.documentElement.getAttribute('Dernier_Compte');
		lettrable = result.responseXML.documentElement.getAttribute('Lettrable')=="true";
		lettragePossibleAN = result.responseXML.documentElement.getAttribute('Lettrage_Possible_AN')=="true";

  } catch (e) {
    recup_erreur(e);
  }
}


function listerOperations() {
	try {

		var lettrage = document.getElementById('lettrageEcritures').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var triLibelle = document.getElementById('triLibelle').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeRevision').disabled = true;
		document.getElementById('pageDeb').disabled = true;
    document.getElementById('lettrageEcritures').disabled = true;
		document.getElementById('modeReglement').disabled = true;
		document.getElementById('triLibelle').disabled = true;
    document.getElementById('bCpteDebut').disabled = true;
    document.getElementById('bCptePrec').disabled = true;
    document.getElementById('compte').disabled = true;
    document.getElementById('bCpteSuiv').disabled = true;
    document.getElementById('bCpteFin').disabled = true;
    document.getElementById('ok').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;

		aOperations.deleteTree();

		qListRC.setParam("Tri_Libelle", triLibelle);
		qListRC.setParam("Num_Compte", compte);
		qListRC.setParam("Exo_N1", exoN1);
		qListRC.setParam("Lettrage", lettrage);
		qListRC.setParam("Mode_Reglement", modeReglement);
		qListRC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListRC.setParam("Current_Page", pageCourante);
		if (!isEmpty(numop)) {
			qListRC.setParam("Op_Id", numop);
		}

		var result = qListRC.execute();

		var contenu = result.responseXML.documentElement;

		if (!isEmpty(numop)) {
			pageCourante = contenu.getAttribute("Page_Courante");
			document.getElementById('pageDeb').value = pageCourante;
			qListRC.removeParam("Op_Id");
		}

		document.getElementById('totalDebit').value = contenu.getAttribute("Total_Debit");
		document.getElementById('totalCredit').value = contenu.getAttribute("Total_Credit");
		nbPages = contenu.getAttribute("Nb_Pages");
		var listOpId = contenu.getAttribute("List_Op_Id");
		var soldePrecedent = contenu.getAttribute("Solde_Precedent");

		aOperations.setParam("Tri_Libelle", triLibelle);
		aOperations.setParam("List_Op_Id", listOpId);
		aOperations.setParam("List_Let_En_Cours", listeop);
		aOperations.setParam("Solde_Precedent", soldePrecedent);
		aOperations.setParam("Exo_N1", exoN1);
		aOperations.initTree(initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0
		document.getElementById('bDebut').disabled = (pageCourante==1);
		document.getElementById('bFin').disabled = (pageCourante>=nbPages);

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageDebut() {
	try {

		pageCourante = 1;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageFin() {
	try {

		pageCourante = nbPages;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageDeb(ev) {
  try {

		if (ev.keyCode==13) {
			var p = document.getElementById("pageDeb").value;

			if (!isNaN(p)) {
				if (parseIntBis(p)>nbPages) {
					pageCourante = nbPages;
				}
				else if (parseIntBis(p)<1) {
					pageCourante = 1;
				}
				else {
					pageCourante = p;
				}
			}

			majPagination();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);
		document.getElementById('bDebut').disabled = (pageCourante==1);
		document.getElementById('bFin').disabled = (pageCourante==nbPages);

		document.getElementById('listeRevision').disabled = true;
		document.getElementById('pageDeb').disabled = true;
    document.getElementById('lettrageEcritures').disabled = true;
		document.getElementById('modeReglement').disabled = true;
		document.getElementById('triLibelle').disabled = true;
    document.getElementById('bCpteDebut').disabled = true;
    document.getElementById('bCptePrec').disabled = true;
    document.getElementById('compte').disabled = true;
    document.getElementById('bCpteSuiv').disabled = true;
    document.getElementById('bCpteFin').disabled = true;
    document.getElementById('ok').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;

		qListRC.setParam("Current_Page", pageCourante);
		var result = qListRC.execute();
		var listOpId = result.responseXML.documentElement.getAttribute("List_Op_Id");
		var soldePrecedent = result.responseXML.documentElement.getAttribute("Solde_Precedent");

		// Correction bug pagination (cas filtre lettr + dlettrage ou non lettr + lettrage induisant un changement de pagination implicite)
		nbPages = result.responseXML.documentElement.getAttribute("Nb_Pages");
		pageCourante = parseIntBis(result.responseXML.documentElement.getAttribute("Page_Courante"));

		aOperations.setParam("List_Op_Id", listOpId);
		aOperations.setParam("List_Let_En_Cours", listeop);
		aOperations.setParam("Solde_Precedent", soldePrecedent);
		aOperations.initTree(initPagination); // Correction bug pagination (remplacement afterMajPagination par initPagination)

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeRevision').disabled = false;

		var qGet = new QueryHttp("Compta/Comptes/getInfosCompte.tmpl");
		qGet.setParam("Num_Compte", compte);
		qGet.setParam("Infos_Compte", true);
		qGet.setParam("Prec_Suiv", true);
		qGet.setParam("Exo_N1", exoN1);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

    document.getElementById('compte').value = compte;
    document.getElementById('libelle_compte').value = contenu.getAttribute('Intitule');
    document.getElementById('type_compte').value = contenu.getAttribute('Type_Compte');

    document.getElementById('solde_compte').value = contenu.getAttribute('Solde_N');
    document.getElementById('debit_compte').value = contenu.getAttribute('Debit_N');
    document.getElementById('credit_compte').value = contenu.getAttribute('Credit_N');

    document.getElementById('old_solde_compte').value = contenu.getAttribute('Solde_N1');
    document.getElementById('old_debit_compte').value = contenu.getAttribute('Debit_N1');
    document.getElementById('old_credit_compte').value = contenu.getAttribute('Credit_N1');

    comptePrecedent = contenu.getAttribute('Compte_Prec');
    compteSuivant = contenu.getAttribute('Compte_Suiv');

    document.getElementById('bCptePrec').disabled = isEmpty(comptePrecedent);
    document.getElementById('bCpteSuiv').disabled = isEmpty(compteSuivant);
    document.getElementById('bCpteDebut').disabled = (document.getElementById('compte').value == premierCompte);
    document.getElementById('bCpteFin').disabled = (document.getElementById('compte').value == dernierCompte);

    document.getElementById('pageDeb').disabled = (nbPages<=1);
    document.getElementById('lettrageEcritures').disabled = false;
		document.getElementById('modeReglement').disabled = false;
		document.getElementById('triLibelle').disabled = false;
		document.getElementById('compte').disabled = false;
    document.getElementById('ok').disabled = false;
		document.getElementById('bEditionCsv').disabled = (aOperations.nbLignes()==0);

    if (aOperations.isNotNull()) {
      var lignefocus = 0;
      var found = false;
      if (!isEmpty(numop) && numop!=0) {
        while (!found && lignefocus<aOperations.nbLignes()) {
          if (aOperations.getCellText(lignefocus,'opid') == numop) {
            found = true;
          }
					else {
            lignefocus++;
          }
        }
        numop = '';
      }

			if (aOperations.nbLignes()>0 && found) {
      	aOperations.select(lignefocus);
     		aOperations.ensureRowIsVisible(lignefocus);
				document.getElementById('listeRevision').focus();
			}
			else {
        aOperations.select(0);
        aOperations.ensureRowIsVisible(0);
        document.getElementById('listeRevision').focus();
			}
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnEditionCsv() {
	try {

		var lettrage = document.getElementById('lettrageEcritures').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var triLibelle = document.getElementById('triLibelle').checked;

		var qEditionCsv = new QueryHttp("Compta/Revision/csvRevisionComptes.tmpl");

		qEditionCsv.setParam("Num_Compte", compte);
		qEditionCsv.setParam("Exo_N1", exoN1);
		qEditionCsv.setParam("Lettrage", lettrage);
		qEditionCsv.setParam("Mode_Reglement", modeReglement);
		qEditionCsv.setParam("Tri_Libelle", triLibelle);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function exoNmoins1() {
  try {

  	exoN1 = true;

		initRevision();

  	document.getElementById('exon').collapsed = false;
  	document.getElementById('exonmoins1').collapsed = true;
  	document.getElementById('lblnmoins1').collapsed = false;
		document.getElementById('bDelettrer').collapsed = true;

  	if (document.getElementById('compte').value!="") {
  		ok();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function exoN() {
  try {

		exoN1 = false;

		initRevision();

		document.getElementById('exon').collapsed = true;
		document.getElementById('exonmoins1').collapsed = false;
		document.getElementById('lblnmoins1').collapsed = true;
		document.getElementById('bDelettrer').collapsed = false;

		if (document.getElementById('compte').value!="") {
			ok();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function infoExoN1() {
  try {

		var qGet = new QueryHttp("Compta/Commons/getInfosExerciceN1.tmpl");
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		if (contenu.getAttribute('Exist')=="true") {
			document.getElementById('lblnmoins1').value = "EXERCICE du "+ contenu.getAttribute('Debut_Exercice') +" au "+ contenu.getAttribute('Fin_Exercice');
		}
		else {
			document.getElementById('lblnmoins1').collapsed = true;
			document.getElementById('exonmoins1').collapsed = true;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function loadCompte(cpte) {
  try {

		if (ParamValeur('let')=='1') {
			document.getElementById('lettrageEcritures').value = "";
		}

		compte = cpte;
		listerOperations();

	} catch (e) {
    recup_erreur(e);
  }
}


function retour_prec() {
  try {

    window.location = ParamValeur('prec');

	} catch (e) {
    recup_erreur(e);
  }
}


function keypress(e,id) {
  try {

    switch(e.keyCode) {
      case 13: // 'Enter'
				if (id=="listeRevision") {
        	ecritures();
        }
				else if (id=="compte") {
        	ok();
        }
        break;
      case 32: // Barre d'Espace
        lettrage();
        break;
      case 118 : // 'F7'
        validLettrage();
        break;
      case 119 : // 'F8'
        annulLettrage();
        break;
      case 123: // 'F12'
        rechecr();
				break;
      case 84: // ctrl + t
				if (e.ctrlKey) {
      		transfertcompte_window();
				}
        break;
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function rechecr() {
  try {

    var url = "chrome://opensi/content/compta/user/saisie/popup-rechercheEcriture.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherEcriture);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourRechercherEcriture(opId) {
  try {

		window.location = "chrome://opensi/content/compta/user/saisie/menuSaisie.xul?Op_Id="+ opId;

	} catch (e) {
    recup_erreur(e);
  }
}


function ok() {
  try {

		razLettrage();

    var numCompte = document.getElementById('compte').value;

		if (isEmpty(numCompte)) {
      document.getElementById('compte').focus();
    }
		else {
			var qSearch = new QueryHttp("Compta/Comptes/searchNumCompte.tmpl");
			qSearch.setParam("Num_Compte", numCompte);
			qSearch.setParam("Search_Like", true);
			qSearch.setParam("Centralisateur", false);
			var result = qSearch.execute();

			var findCompte = result.responseXML.documentElement.getAttribute("Num_Compte");

			if (!isEmpty(findCompte)) {
				loadCompte(findCompte);
			}
			else {
				recherche_compte(numCompte);
				document.getElementById('compte').focus();
			}
		}

  } catch(e) {
    recup_erreur(e);
  }
}


function compteSuiv() {
  try {

    document.getElementById('compte').value = compteSuivant;
    ok();

	} catch (e) {
    recup_erreur(e);
  }
}


function comptePrec() {
  try {

    document.getElementById('compte').value = comptePrecedent;
    ok();

	} catch (e) {
    recup_erreur(e);
  }
}


function compteDebut() {
  try {

		document.getElementById('compte').value = premierCompte;
    ok();

  } catch (e) {
    recup_erreur(e);
  }
}


function compteFin() {
  try {

		document.getElementById('compte').value = dernierCompte;
		ok();

  } catch (e) {
    recup_erreur(e);
  }
}


function recherche_compte(numCompte) {
  try {

    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercheCompte, numCompte, "", "", "", false);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourRechercheCompte(numCompte, compteId) {
	try {

		document.getElementById('compte').value = numCompte;
		loadCompte(numCompte);

	} catch (e) {
		recup_erreur(e);
	}
}


function lettrage() {
  try {

		if (!lettrageEnCours) {
			lettrageEnCours = true;

			if (lettrable && aOperations.getRangeCount()>0) {

				var start = new Object();
				var end = new Object();
				var numRanges = aOperations.getRangeCount();

				for (var t=0; t<numRanges; t++) {
	  			aOperations.getRangeAt(t,start,end);

					for (var idx = start.value; idx <= end.value; idx++) {

						var aux = aOperations.getCellText(idx,'debit');
		    		var aux2 = '';
		    		for (i = 0;i<aux.length;i++) {
		      		var c = aux.charCodeAt(i);
		      		if ((c != 160) && (c != 32)) aux2 += aux.charAt(i);
		    		}
		    		var td = parseFloat(aux2.replace(',','.'));
		    		if (isNaN(td)) td = 0;

		    		aux = aOperations.getCellText(idx,'credit');
		    		aux2 = '';
		    		for (i = 0;i<aux.length;i++) {
		      		var c = aux.charCodeAt(i);
		      		if ((c != 160) && (c != 32)) aux2 += aux.charAt(i);
		    		}
		    		var tc = parseFloat(aux2.replace(',','.'));
		    		if (isNaN(tc)) tc = 0;

		    		var tl = aOperations.getCellText(idx,'lettre');

						if (lettragePossibleAN || aOperations.getCellText(idx, 'type_journal')!='AN') {
		      		if (isEmpty(tl)) {
		        		debit = parseFloat(nf.format(debit + td));
		        		credit = parseFloat(nf.format(credit + tc));
		        		solde =  parseFloat(nf.format(credit - debit));
		        		maj_aff_solde();
								aOperations.setCellText(idx,'lettre','+');
								nbLigneLettrage++;
								ajouterListeOp(aOperations.getCellText(idx,'opid'));
		      		}
							else if (tl == '+') {
								aOperations.setCellText(idx,'lettre','');
		        		debit = parseFloat(nf.format(debit - td));
		        		credit = parseFloat(nf.format(credit - tc));
		        		solde = parseFloat(nf.format(credit - debit));
		        		nbLigneLettrage--;
		        		if (nbLigneLettrage==0) {
		          		document.getElementById('lettrage').collapsed = true;
		        		}
								else {
		          		maj_aff_solde();
		        		}
								ajouterListeOp(aOperations.getCellText(idx,'opid'));
		      		}
		    		}
					}
				}

				if (nbLigneLettrage>1 && solde==0) {
		      validLettrage();
		    }
			}

			lettrageEnCours = false;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function ajouterListeOp(opid) {
  try {

		var i = 0;
		var supp = false;
  	while (i<listeop.length && !supp) {
			if (listeop[i]==opid) {
				supp = true;
			}
			i++;
		}
		if (supp) {
			listeop.splice(i-1,1);
		}
		else {
			listeop.push(opid);
		}
		listeop.sort();

  } catch (e) {
    recup_erreur(e);
  }
}


function annulLettrage() {
  try {

		if (lettrable) {

      var tl = aOperations.getSelectedCellText('lettre');

      if (isEmpty(tl)) return -1;
      if (tl == '+') return -1;

      if (confirm("Voulez-vous annuler le lettrage des lignes d'\u00E9critures lettr\u00E9es par "+ tl +" ?")) {

				var qDLet = new QueryHttp("Compta/Consultation/delettrer.tmpl");
				qDLet.setParam('Lettre', tl);
				qDLet.setParam('Num_Compte', compte);
				qDLet.execute();

        for (var i=0; i<aOperations.nbLignes(); i++) {
          if (tl == aOperations.getCellText(i,'lettre')) {
            aOperations.setCellText(i,'lettre','');
						aOperations.getItem(i).firstChild.setAttribute("properties",'disabled');
          }
        }
      }
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function maj_aff_solde() {
  try {

    document.getElementById('lettrage').collapsed = false;
    document.getElementById('total_debit_lett').value = nfs.format(debit);
    document.getElementById('total_credit_lett').value = nfs.format(credit);
    document.getElementById('total_solde_lett').value = nfs.format(solde);

  } catch (e) {
    recup_erreur(e);
  }
}


function razLettrage() {
  try {

    debit = 0;
    credit = 0;
    solde = 0;
    nbLigneLettrage = 0;
		listeop = new Array();
    document.getElementById('lettrage').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function lettrer() {
  try {

    if (nbLigneLettrage>1) {

			var qLet = new QueryHttp("Compta/Consultation/lettrer.tmpl");
			qLet.setParam('Num_Compte', compte);
			qLet.setParam('Liste_Op', listeop);
			var result = qLet.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var lettre = result.responseXML.documentElement.getAttribute('Lettre');

      	for (var i=0; i<aOperations.nbLignes(); i++) {
        	var tl = aOperations.getCellText(i,'lettre');
        	if (tl == '+') {
						aOperations.setCellText(i,'lettre',lettre);
						aOperations.getItem(i).firstChild.setAttribute("properties",'enabled');
        	}
				}

      	razLettrage();
			}
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function validLettrage() {
  try {

		if (lettrable) {

      if (solde == 0) {
        lettrer();
      }
			else if (confirm("Le lettrage n'est pas \u00E9quilibr\u00E9. Voulez vous saisir une \u00E9criture de lettrage ?")) {

        var page = "chrome://opensi/content/compta/user/consultation/lettrage.xul?"+ cookie() +"&NumCompte="+ compte +"&solde="+ (0 - solde);
        window.openDialog(page,'','chrome,modal,centerscreen', retourEcartLettrage);
        listerOperations();
      }
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function retourEcartLettrage(opid) {
  try {

		ajouterListeOp(opid);
		nbLigneLettrage++;
		lettrer();

	} catch (e) {
    recup_erreur(e);
  }
}


function ecritures() {
  try {

		if (!exoN1 && aOperations.isSelected()) {
   		window.location = "chrome://opensi/content/compta/user/saisie/menuSaisie.xul?"+ cookie() +"&Op_Id="+ aOperations.getSelectedCellText('opid');
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function plan_comptable() {
  try {

    var page = "chrome://opensi/content/compta/user/comptes/popup-planComptable.xul";
    window.openDialog(page,'','chrome,modal,centerscreen', retourPlanComptable);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourPlanComptable(numCompte) {
  try {

		document.getElementById('compte').value = numCompte;
		document.getElementById('compte').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function retour_consultation() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}


function transfertcompte_window() {
  try {

		if (!exoN1) {
    	if (aOperations.getRangeCount()>0) {
				var page = "chrome://opensi/content/compta/user/consultation/chgt_compte.xul?"+ cookie();
				var comptesrc = document.getElementById('compte').value;
  			window.openDialog(page,'','chrome,modal,centerscreen',comptesrc,transfertcompte);
    	}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function transfertcompte(comptesrc, comptedest, transAll) {
	try {

		var queryEdit = new QueryHttp("Compta/UpdateDatabase/update_compte.tmpl");
		queryEdit.setParam("CompteDest",comptedest);
  	queryEdit.setParam("CompteSrc",comptesrc);
		queryEdit.setParam("TransAll", transAll);

		var result = null;

    if (transAll) {
			//transfert de toutes les operations du compte
   	  result = queryEdit.execute();
		}
    else if (aOperations.getRangeCount()>0) {

			var start = new Object();
			var end = new Object();
			var numRanges = aOperations.getRangeCount();
			var operations = "";

			for (var t=0; t<numRanges; t++) {
	  		aOperations.getRangeAt(t,start,end);
	  		for (var v = start.value; v <= end.value; v++) {
	    		operations += aOperations.getCellText(v,'opid') +",";
				}
			}

 			queryEdit.setParam("Liste_Op", operations);
   	  result = queryEdit.execute();
    }

		if (result!=null) {
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var nbOpTrans = result.responseXML.documentElement.getAttribute('NbOpTrans');
				showMessage(nbOpTrans +" op\u00E9rations ont \u00E9t\u00E9 transf\u00E9r\u00E9es dans le compte "+ comptedest);
	  		loadCompte(transAll?comptedest:comptesrc);
			}
		}

  } catch (e) {
  	recup_erreur(e);
  }
}
