/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var lastFichierPDF = null;



function init() {
  try {

		document.getElementById('typeCompte').value = "G";
		document.getElementById('typePlan').value = "D";
		document.getElementById('actif').checked = true;
		document.getElementById('facultatif').checked = true;
		document.getElementById('developpement').value = "3";
		pressOnTypePlan();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypePlan() {
  try {

		var typePlan = document.getElementById('typePlan').value;
		document.getElementById('gSelectionPCD').collapsed = typePlan=="G";
		document.getElementById('gSelectionPCG').collapsed = typePlan=="D";
		document.getElementById('gDeveloppement').collapsed = typePlan=="D";

	} catch (e) {
    recup_erreur(e);
  }
}


function editionPDF() {
	try {

		var typePlan = document.getElementById('typePlan').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var actif = document.getElementById('actif').checked;
		var facultatif = document.getElementById('facultatif').checked;
		var developpement = document.getElementById('developpement').value;

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

		document.getElementById('pdfPlanComptable').setAttribute("src", "");
		lastFichierPDF = null;

		var qEditionPdf;

		if (typePlan=="D") {
			qEditionPdf = new QueryHttp("Compta/Editions/pdfPlanComptableDossier.tmpl");
			qEditionPdf.setParam("Type_Compte", typeCompte);
			qEditionPdf.setParam("Actif", actif);
		}
		else {
			qEditionPdf = new QueryHttp("Compta/Editions/pdfPlanComptableGeneral.tmpl");
			qEditionPdf.setParam("Facultatif", facultatif);
			qEditionPdf.setParam("Developpement", developpement);
		}

		qEditionPdf.execute(editionPDF_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function editionPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
			var page = getDirPdf() + fichierPDF;
			document.getElementById('pdfPlanComptable').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourOptions').collapsed = false;

			lastFichierPDF = fichierPDF;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		if (lastFichierPDF!=null) {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CGPC", lastFichierPDF);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function editionCSV() {
	try {

		var typePlan = document.getElementById('typePlan').value;
		var typeCompte = document.getElementById('typeCompte').value;
		var actif = document.getElementById('actif').checked;
		var facultatif = document.getElementById('facultatif').checked;
		var developpement = document.getElementById('developpement').value;

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

		var qEditionCsv;

		if (typePlan=="D") {
			qEditionCsv = new QueryHttp("Compta/Editions/csvPlanComptableDossier.tmpl");
			qEditionCsv.setParam("Type_Compte", typeCompte);
			qEditionCsv.setParam("Actif", actif);
		}
		else {
			qEditionCsv = new QueryHttp("Compta/Editions/csvPlanComptableGeneral.tmpl");
			qEditionCsv.setParam("Facultatif", facultatif);
			qEditionCsv.setParam("Developpement", developpement);
		}

		qEditionCsv.execute(editionCSV_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function editionCSV_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourOptions() {
  try {

		document.getElementById('pdfPlanComptable').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourOptions').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

  } catch (e) {
    recup_erreur(e);
  }
}
