/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var opi_aParamCompte = new Arbre('Compta/ImportBanque/list-paramCompteImportBanque.tmpl', 'opi-treeParamCompte');
var opi_aParamModeReg = new Arbre('Compta/ImportBanque/list-paramModeRegImportBanque.tmpl', 'opi-treeParamModeReg');
var opi_aParamNumPiece = new Arbre('Compta/ImportBanque/list-paramNumPieceImportBanque.tmpl', 'opi-treeParamNumPiece');

var opi_selLigneCompte;
var opi_selLigneModeReg;
var opi_selLigneNumPiece;
var opi_paramId;



function opi_init() {
	try {

		opi_paramId = 0;
		opi_selLigneCompte = false;
		opi_selLigneModeReg = false;
		opi_selLigneNumPiece = false;

		var aModesReg = new Arbre('ComboListe/combo-modesReglement.tmpl', 'opi-listeModeReg');
		aModesReg.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function opi_reset() {
	try {

		var newParam = oib_paramId;

		if (opi_paramId!=newParam) {
			opi_selLigneCompte = false;
			opi_selLigneModeReg = false;
			opi_selLigneNumPiece = false;

			opi_activeAllLignes(false);
			opi_videLignes();

			opi_paramId = newParam;

			if (opi_paramId!=0) {
				opi_aParamCompte.setParam("Param_Id", opi_paramId);
				opi_aParamCompte.initTree();
				opi_aParamModeReg.setParam("Param_Id", opi_paramId);
				opi_aParamModeReg.initTree();
				opi_aParamNumPiece.setParam("Param_Id", opi_paramId);
				opi_aParamNumPiece.initTree();
			}
			else {
				opi_aParamCompte.deleteTree();
				opi_aParamModeReg.deleteTree();
				opi_aParamNumPiece.deleteTree();
			}

			opi_activeAllLignes(true);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function opi_activeAllLignes(boolean) {
	try {
		opi_activeLigneCompte(boolean);
		opi_activeLigneModeReg(boolean);
		opi_activeLigneNumPiece(boolean);
	} catch (e) {
  		recup_erreur(e);
	}
}

function opi_activeLigneCompte(boolean) {
	try {
		if (opi_selLigneCompte) {
			document.getElementById('opi-libelleRechercheAffectation').disabled = true;
			document.getElementById('opi-bSupprimerAffectation').disabled = !boolean;
		} else {
			document.getElementById('opi-libelleRechercheAffectation').disabled = !boolean;
			document.getElementById('opi-bSupprimerAffectation').disabled = true;
		}
		document.getElementById('opi-libelleRemplacementAffectation').disabled = !boolean;
		document.getElementById('opi-compteRecetteAffectation').disabled = !boolean;
		document.getElementById('opi-bRechercheCompteRecetteAffectation').disabled = !boolean;
		document.getElementById('opi-compteDepenseAffectation').disabled = !boolean;
		document.getElementById('opi-bRechercheCompteDepenseAffectation').disabled = !boolean;
		document.getElementById('opi-bNouveauAffectation').disabled = !boolean;
		document.getElementById('opi-bEnregistrerAffectation').disabled = !boolean;
	} catch (e) {
  		recup_erreur(e);
	}
}

function opi_activeLigneModeReg(boolean) {
	try {
		if (opi_selLigneModeReg) {
			document.getElementById('opi-libelleRechercheModeReg').disabled = true;
			document.getElementById('opi-bSupprimerModeReg').disabled = !boolean;
		} else {
			document.getElementById('opi-libelleRechercheModeReg').disabled = !boolean;
			document.getElementById('opi-bSupprimerModeReg').disabled = true;
		}
		document.getElementById('opi-listeModeReg').disabled = !boolean;
		document.getElementById('opi-bNouveauModeReg').disabled = !boolean;
		document.getElementById('opi-bEnregistrerModeReg').disabled = !boolean;
	} catch (e) {
  		recup_erreur(e);
	}
}

function opi_activeLigneNumPiece(boolean) {
	try {
		if (opi_selLigneNumPiece) {
			document.getElementById('opi-libelleRechercheNumPiece').disabled = true;
			document.getElementById('opi-bSupprimerNumPiece').disabled = !boolean;
		} else {
			document.getElementById('opi-libelleRechercheNumPiece').disabled = !boolean;
			document.getElementById('opi-bSupprimerNumPiece').disabled = true;
		}
		document.getElementById('opi-listeModeReg').disabled = !boolean;
		document.getElementById('opi-bEnregistrerNumPiece').disabled = !boolean;
		document.getElementById('opi-bNouveauNumPiece').disabled = !boolean;
	} catch (e) {
  		recup_erreur(e);
	}
}

function opi_videLignes() {
	try {
		document.getElementById('opi-libelleRechercheAffectation').value = "";
		document.getElementById('opi-libelleRemplacementAffectation').value = "";
		document.getElementById('opi-compteRecetteAffectation').value = "";
		document.getElementById('opi-compteDepenseAffectation').value = "";

		document.getElementById('opi-libelleRechercheModeReg').value = "";
		document.getElementById('opi-listeModeReg').value = "";


		document.getElementById('opi-libelleRechercheNumPiece').value = "";
		document.getElementById('opi-nbCarNumPiece').value = "";
	} catch (e) {
  		recup_erreur(e);
	}
}

function opi_selectOnTreeCompte() {
	try {
 		if (opi_aParamCompte.isSelected()) {
 			opi_selLigneCompte = true;
 			var index = opi_aParamCompte.getCurrentIndex();
			document.getElementById('opi-libelleRechercheAffectation').value = opi_aParamCompte.getCellText(index,'opi-colLibRechCompte');
			document.getElementById('opi-libelleRemplacementAffectation').value = opi_aParamCompte.getCellText(index,'opi-colLibRempCompte');
			document.getElementById('opi-compteRecetteAffectation').value = opi_aParamCompte.getCellText(index,'opi-colRecette');
			document.getElementById('opi-compteDepenseAffectation').value = opi_aParamCompte.getCellText(index,'opi-colDepense');
			opi_activeLigneCompte(true);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnRechercheCompteRecetteAffectation() {
	try {
		opi_rechercheCompteRecetteAffectation();
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnRechercheCompteDepenseAffectation() {
	try {
		opi_rechercheCompteDepenseAffectation();
	} catch (e) {
		recup_erreur(e);
	}
}


function opi_rechercheCompteRecetteAffectation() {
	try {

		var numCompte = document.getElementById('opi-compteRecetteAffectation').value;
		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', opi_retourRechercheCompteRecetteAffectation, numCompte, "", "", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function opi_retourRechercheCompteRecetteAffectation(numCompte, compteId) {
	try {

		document.getElementById('opi-compteRecetteAffectation').value = numCompte;
		opi_activeLigneCompte(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opi_rechercheCompteDepenseAffectation() {
	try {

		var numCompte = document.getElementById('opi-compteDepenseAffectation').value;
		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', opi_retourRechercheCompteDepenseAffectation, numCompte, "", "", "", false);

	} catch (e) {
 		recup_erreur(e);
	}
}


function opi_retourRechercheCompteDepenseAffectation(numCompte, compteId) {
	try {

		document.getElementById('opi-compteDepenseAffectation').value = numCompte;
		opi_activeLigneCompte(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opi_pressOnNouveauAffectation() {
	try {
		opi_activeLigneCompte(false);
		opi_newAffectation();
		opi_activeLigneCompte(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_newAffectation() {
	try {
		opi_aParamCompte.clearSelection();
		opi_selLigneCompte = false;

		document.getElementById('opi-libelleRechercheAffectation').value = "";
		document.getElementById('opi-libelleRemplacementAffectation').value = "";
		document.getElementById('opi-compteRecetteAffectation').value = "";
		document.getElementById('opi-compteDepenseAffectation').value = "";
	} catch (e) {
		recup_erreur(e);
	}
}


function opi_pressOnEnregistrerAffectation() {
	try {

		opi_activeLigneCompte(false);
		if (isEmpty(document.getElementById('opi-libelleRechercheAffectation').value)) { showWarning("Libell\u00E9 incorrect !"); }
		else if (!isCompteCorrect(document.getElementById('opi-compteRecetteAffectation').value)) { showWarning("Num\u00E9ro de compte de recettes incorrect !"); }
		else if (!isCompteCorrect(document.getElementById('opi-compteDepenseAffectation').value)) { showWarning("Num\u00E9ro de compte de d\u00E9penses incorrect !"); }
		else {
			opi_saveAffectation();
		}
		opi_activeLigneCompte(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opi_saveAffectation() {
	try {
		var qSave = new QueryHttp("Compta/ImportBanque/saveParamCompte.tmpl");

		qSave.setParam("Param_Id", opi_paramId);
		qSave.setParam("Lib_Rech", document.getElementById('opi-libelleRechercheAffectation').value);
		qSave.setParam("Lib_Remp", document.getElementById('opi-libelleRemplacementAffectation').value);
		qSave.setParam("Compte_Rec", document.getElementById('opi-compteRecetteAffectation').value);
		qSave.setParam("Compte_Dep", document.getElementById('opi-compteDepenseAffectation').value);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opi_aParamCompte.deleteTree();
			opi_aParamCompte.initTree();
			opi_newAffectation();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opi_pressOnSupprimerAffectation() {
	try {
		opi_activeLigneCompte(false);
		opi_deleteAffectation();
		opi_activeLigneCompte(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function opi_deleteAffectation() {
	try {

		if (isEmpty(document.getElementById('opi-libelleRechercheAffectation').value)) { showWarning("Veuillez selectionner une ligne \u00E0 supprimer"); }
		else {
			var qDelete = new QueryHttp("Compta/ImportBanque/deleteParamCompte.tmpl");
			qDelete.setParam("Param_Id", opi_paramId);
			qDelete.setParam("Lib_Rech", document.getElementById('opi-libelleRechercheAffectation').value);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opi_aParamCompte.deleteTree();
				opi_aParamCompte.initTree();
				opi_newAffectation();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function opi_selectOnTreeModeReg() {
	try {
 		if (opi_aParamModeReg.isSelected()) {
 			opi_selLigneModeReg = true;
 			var index = opi_aParamModeReg.getCurrentIndex();
			document.getElementById('opi-libelleRechercheModeReg').value = opi_aParamModeReg.getCellText(index,'opi-colLibRechModeReg');
			document.getElementById('opi-listeModeReg').value = opi_aParamModeReg.getCellText(index,'opi-colParamModeRegId');
			opi_activeLigneModeReg(true);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnNouveauModeReg() {
	try {
		opi_activeLigneModeReg(false);
		opi_newModeReg();
		opi_activeLigneModeReg(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_newModeReg() {
	try {
		opi_aParamModeReg.clearSelection();
		opi_selLigneModeReg = false;

		document.getElementById('opi-libelleRechercheModeReg').value = "";
		document.getElementById('opi-listeModeReg').value = "";
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnEnregistrerModeReg() {
	try {
		opi_activeLigneModeReg(false);

		if (isEmpty(document.getElementById('opi-libelleRechercheModeReg').value)) { showWarning("Libell\u00E9 incorrect !"); }
		else if (document.getElementById('opi-listeModeReg').value=="") { showWarning("Veuillez choisir un mode de r\u00E9glement !"); }
		else {
			opi_saveModeReg();
		}
		opi_activeLigneModeReg(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_saveModeReg() {
	try {
		var qSave = new QueryHttp("Compta/ImportBanque/saveParamModeReg.tmpl");

		qSave.setParam("Param_Id", opi_paramId);
		qSave.setParam("Lib_Mode_Reg", document.getElementById('opi-libelleRechercheModeReg').value);
		qSave.setParam("Mode_Reg_Id", document.getElementById('opi-listeModeReg').value);

		var result = qSave.execute();
		var errors = new Errors(result);

		if (errors.hasNext()) {
			errors.show();
		} else {
			// rafraichir l'arbre
			opi_aParamModeReg.deleteTree();
			opi_aParamModeReg.initTree();
			opi_newModeReg();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnSupprimerModeReg() {
	try {
		opi_activeLigneModeReg(false);
		opi_deleteModeReg();
		opi_activeLigneModeReg(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_deleteModeReg() {
	try {
		if (isEmpty(document.getElementById('opi-libelleRechercheModeReg').value)) { showWarning("Veuillez selectionner une ligne \u00E0 supprimer"); }
		else {
			var qDelete = new QueryHttp("Compta/ImportBanque/deleteParamModeReg.tmpl");

			qDelete.setParam("Param_Id", opi_paramId);
			qDelete.setParam("Lib_Mode_Reg", document.getElementById('opi-libelleRechercheModeReg').value);

			var result = qDelete.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			} else {
				// rafraichir l'arbre
				opi_aParamModeReg.deleteTree();
				opi_aParamModeReg.initTree();
				opi_newModeReg();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_selectOnTreeNumPiece() {
	try {
 		if (opi_aParamNumPiece.isSelected()) {
 			opi_selLigneNumPiece = true;
 			var index = opi_aParamNumPiece.getCurrentIndex();
			document.getElementById('opi-libelleRechercheNumPiece').value = opi_aParamNumPiece.getCellText(index,'opi-colLibRechNumPiece');
			document.getElementById('opi-nbCarNumPiece').value = opi_aParamNumPiece.getCellText(index,'opi-colNbCarNumPiece');
			opi_activeLigneNumPiece(true);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnNouveauNumPiece() {
	try {
		opi_activeLigneNumPiece(false);
		opi_newNumPiece();
		opi_activeLigneNumPiece(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_newNumPiece() {
	try {
		opi_aParamNumPiece.clearSelection();
		opi_selLigneNumPiece = false;

		document.getElementById('opi-libelleRechercheNumPiece').value = "";
		document.getElementById('opi-nbCarNumPiece').value = "";
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnEnregistrerNumPiece() {
	try {
		opi_activeLigneNumPiece(false);
		// verif libelle
		if (isEmpty(document.getElementById('opi-libelleRechercheNumPiece').value)) { showWarning("Libell\u00E9 incorrect !"); }
		// verif nb car
		else if (!isPositiveOrNullInteger(document.getElementById('opi-nbCarNumPiece').value)) { showWarning("Nombre de caract\u00E8res incorrect !") }
		// verif nb car <= 20
		else if (document.getElementById('opi-nbCarNumPiece').value>20) { showWarning("Le nombre de caract\u00E8res ne peut exc\u00E9der 20 !"); }
		else {
			opi_saveNumPiece();
		}
		opi_activeLigneNumPiece(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_saveNumPiece() {
	try {
		var qSave = new QueryHttp("Compta/ImportBanque/saveParamNumPiece.tmpl");

		qSave.setParam("Param_Id", opi_paramId);
		qSave.setParam("Lib_Num_Piece", document.getElementById('opi-libelleRechercheNumPiece').value);
		qSave.setParam("Nb_Car_Piece", document.getElementById('opi-nbCarNumPiece').value);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opi_aParamNumPiece.initTree();
			opi_newNumPiece();
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function opi_pressOnSupprimerNumPiece() {
	try {
		opi_activeLigneNumPiece(false);
		opi_deleteNumPiece();
		opi_activeLigneNumPiece(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function opi_deleteNumPiece() {
	try {
		if (isEmpty(document.getElementById('opi-libelleRechercheNumPiece').value)) { showWarning("Veuillez selectionner une ligne \u00E0 supprimer"); }
		else {
			var qDelete = new QueryHttp("Compta/ImportBanque/deleteParamNumPiece.tmpl");
			qDelete.setParam("Param_Id", opi_paramId);
			qDelete.setParam("Lib_Num_Piece", document.getElementById('opi-libelleRechercheNumPiece').value);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opi_aParamNumPiece.initTree();
				opi_newNumPiece();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}
