/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var typeRappro;



function init() {
  try {

	  typeRappro = getConfig().getModeRappro();

		if (typeRappro=="C") {
			document.getElementById("titre").value = "AJOUT D'UN NOUVEAU COMPTE EN RAPPROCHEMENT";
			document.getElementById("boxCompte").collapsed = false;

			var aComptesRB = new Arbre('Compta/RapprochementBancaire/combo-comptesRB.tmpl', 'compteRB');
			aComptesRB.setParam("Non_Rappro", true);
			aComptesRB.initTree(initCompteRB);
		}
		else {
			document.getElementById("titre").value = "AJOUT D'UN NOUVEAU JOURNAL EN RAPPROCHEMENT";
			document.getElementById("boxJournal").collapsed = false;

			var aJournauxRB = new Arbre('Compta/RapprochementBancaire/combo-journauxRB.tmpl', 'journalRB');
			aJournauxRB.setParam("Non_Rappro", true);
			aJournauxRB.initTree(initJournalRB);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function initCompteRB() {
  try {

		if (document.getElementById("compteRB").itemCount>0) {
			document.getElementById("compteRB").selectedIndex = 0;
		}
		else {
			showWarning("Tous les comptes de banque sont d\u00E9j\u00E0 inscrits en rapprochement");
			window.close();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function initJournalRB() {
  try {

		if (document.getElementById("journalRB").itemCount>0) {
			document.getElementById("journalRB").selectedIndex = 0;
		}
		else {
			showWarning("Tous les journaux de tr\u00E9sorerie sont d\u00E9j\u00E0 inscrits en rapprochement");
			window.close();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ok() {
  try {

		var compteId = "";
		var journalId = "";

		if (typeRappro=="C") {
  		compteId = document.getElementById("compteRB").value;
  	}
  	else {
  		journalId = document.getElementById("journalRB").value;
  	}

  	var dateRappro = document.getElementById("dateRappro").value;
  	var dateReleve = document.getElementById("dateReleve").value;
		var numReleve = document.getElementById("numReleve").value;
  	var soldeReleve = document.getElementById("soldeReleve").value;
		
		var qGet = new QueryHttp("Compta/Exercice/getDatesExercice.tmpl");
		qGet.setParam("Sel_Exercice", "C");
		var result = qGet.execute();

		var dateDebutExercice = result.responseXML.documentElement.getAttribute('Debut_Exercice');
		var dateFinExercice = result.responseXML.documentElement.getAttribute('Fin_Exercice');

  	if (isEmpty(soldeReleve)) { soldeReleve = 0; }
  	if (isNaN(soldeReleve)) {
  		showWarning("Solde de relev\u00E9 incorrect");
  		return false;
  	}

		if (!isEmpty(dateRappro)) {
	  	if (!isDate(dateRappro)) {
	  		showWarning("La date de debut de rapprochement n'est pas au bon format");
	     	return false;
	  	}
	  	if (!isDateInterval(dateDebutExercice, dateRappro)) {
	  		showWarning("La date de debut de rapprochement ne peut pas \u00EAtre ant\u00E9rieure \u00E0 la date de d\u00E9but de l'exercice");
	     	return false;
	  	}
	  }
	  else {
			dateRappro = dateDebutExercice;
	  	showWarning("La date de debut de rapprochement sera la date de d\u00E9but de l'exercice");
	  }

		if (!isDate(dateReleve)) {
			showWarning("Date de relev\u00E9 de banque incorrecte (Ecritures jusqu'au)");
			return false;
		}

	  if (!isDateInterval(dateDebutExercice, dateReleve)) {
	  	showWarning("La date de relev\u00E9 ne peut pas \u00EAtre ant\u00E9rieure \u00E0 la date de d\u00E9but de l'exercice");
	  	return false;
	  }
	  if (!isDateInterval(dateRappro, dateFinExercice)) {
	  	showWarning("La date de rapprochement ne peut pas \u00EAtre sup\u00E9rieure \u00E0 la date de fin de l'exercice");
	  	return false;
	  }
	  if (!isDateInterval(dateReleve, dateFinExercice)) {
	  	showWarning("La date de relev\u00E9 ne peut pas \u00EAtre sup\u00E9rieure \u00E0 la date de fin de l'exercice");
	  	return false;
	  }
	  if (!isStrictDateInterval(dateRappro, dateReleve)) {
	  	showWarning("La date de relev\u00E9 doit \u00EAtre post\u00E9rieure \u00E0 la date de d\u00E9but de rapprochement");
	  	return false;
	  }

		var qCreate = new QueryHttp("Compta/RapprochementBancaire/createRapprochement.tmpl");

		qCreate.setParam("Type_Rappro", typeRappro);
		qCreate.setParam("Compte_Id", compteId);
		qCreate.setParam("Journal_Id", journalId);
		qCreate.setParam("Date_Rappro", dateRappro);
		qCreate.setParam("Date_Releve", dateReleve);
		qCreate.setParam("Solde_Releve", soldeReleve);
		qCreate.setParam("Num_Releve", numReleve);

		result = qCreate.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			window.arguments[0](compteId, journalId);
			window.close();
		}

  } catch (e) {
    recup_erreur(e);
  }
}
