/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aLignesRB = new Arbre("Compta/RapprochementBancaire/list-ligneRB.tmpl", "listeLigneRB");

var rapproId;



function init() {
	try {

    rapproId = window.arguments[1];

		aLignesRB.setParam("Rappro_Id", rapproId);
		aLignesRB.initTree();

	}	catch(e) {
		recup_erreur(e);
	}
}


function selectOnListeLigneRB() {
	try {

		document.getElementById("bSupprimer").disabled = false;
		document.getElementById("bValider").disabled = true;

	} catch(e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		var dateOp = document.getElementById("dateOp").value;
		var montantD = document.getElementById("debit").value;
		var montantC = document.getElementById("credit").value;
		var libelle = document.getElementById("libelle").value;

		var dateRappro = window.arguments[2];
		var dateReleve = window.arguments[3];

		if (!isDate(dateOp)) {
		  showWarning("Date incorrecte (jj/mm/aaaa)");
		}
		else if (!isDateInterval(dateOp, dateReleve) || !isDateInterval(dateRappro, dateOp)){
		  showWarning("La date doit se trouver dans l'intervalle du rapprochement (date de d\u00E9but - date jusqu'au) ");
		}
		else if (!isEmpty(montantD) && !isPositive(montantD)) {
			showWarning("Montant au d\u00E9bit incorrect");
		}
		else if (!isEmpty(montantC) && !isPositive(montantC)) {
			showWarning("Montant au cr\u00E9dit incorrect");
		}
		else if (isEmpty(montantD) && isEmpty(montantC)) {
			showWarning("Montant au d\u00E9bit ou au cr\u00E9dit obligatoire");
		}
		else if (montantD>0 && montantC>0) {
			showWarning("Seul un montant au d\u00E9bit ou au cr\u00E9dit est accept\u00E9");
		}
		else if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 obligatoire");
		}
		else {

			if (isEmpty(montantD)) { montantD = 0; }
			if (isEmpty(montantC)) { montantC = 0; }

			var qCreate = new QueryHttp("Compta/RapprochementBancaire/createLigneRB.tmpl");
			qCreate.setParam("Date_Op", dateOp);
			qCreate.setParam("Montant_D", montantD);
			qCreate.setParam("Montant_C", montantC);
			qCreate.setParam("Libelle", libelle);
			qCreate.setParam("Rappro_Id", rapproId);

			var result = qCreate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.arguments[0]();
			}

    	annuler();
			aLignesRB.initTree();
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function supprimer() {
	try {

		if (aLignesRB.isSelected()) {
			var ligneRBId = aLignesRB.getSelectedCellValue("colLigneRBId");

			var qDelete = new QueryHttp("Compta/RapprochementBancaire/deleteLigneRB.tmpl");
			qDelete.setParam("Ligne_RB_Id", ligneRBId);
		  var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.arguments[0]();
			}

    	annuler();
			aLignesRB.initTree();
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function annuler() {
	try {

		aLignesRB.clearSelection();
		document.getElementById("dateOp").value = "";
		document.getElementById("libelle").value = "";
		document.getElementById("debit").value = "";
		document.getElementById("credit").value = "";
		document.getElementById("bValider").disabled = false;
		document.getElementById("bSupprimer").disabled = true;
		document.getElementById("dateOp").focus();

	}	catch(e) {
		recup_erreur(e);
	}
}
