/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");



function init() {
  try {

		document.getElementById('sousTitre').value = "AU "+ parent.document.getElementById('date_courante').value;

		var qGet = new QueryHttp("Compta/TableauxBord/getTableauxBordGestion.tmpl");
		var result = qGet.execute();

    var contenu = result.responseXML.documentElement;

		document.getElementById('titreN').value = contenu.getAttribute('Titre_N');
		document.getElementById('sousTitreN').value = contenu.getAttribute('Sous_Titre_N');
		document.getElementById('titreN1').value = contenu.getAttribute('Titre_N1');
		document.getElementById('sousTitreN1').value = contenu.getAttribute('Sous_Titre_N1');

		document.getElementById('VM').value = contenu.getAttribute('VM');
		document.getElementById('PE').value = contenu.getAttribute('PE');
		document.getElementById('MBG').value = contenu.getAttribute('MBG');
		document.getElementById('VA').value = contenu.getAttribute('VA');
		document.getElementById('RE').value = contenu.getAttribute('RE');
		document.getElementById('EBE').value = contenu.getAttribute('EBE');
		document.getElementById('VM1').value = contenu.getAttribute('VM1');
		document.getElementById('PE1').value = contenu.getAttribute('PE1');
		document.getElementById('MBG1').value = contenu.getAttribute('MBG1');
		document.getElementById('VA1').value = contenu.getAttribute('VA1');
		document.getElementById('RE1').value = contenu.getAttribute('RE1');
		document.getElementById('EBE1').value = contenu.getAttribute('EBE1');

		document.getElementById('graphEvolCA').setAttribute("src", getDirGraph() + contenu.getAttribute('Graph_Evol_CA'));
		document.getElementById('graphRepSIG').setAttribute("src", getDirGraph() + contenu.getAttribute('Graph_Rep_SIG'));

		var aTableauCA = new Arbre('Compta/TableauxBord/list-tableauCA.tmpl', 'tableauCA');

		aTableauCA.setParam("List_Periode", contenu.getAttribute("List_Periode"));
		aTableauCA.setParam("List_CA_N", contenu.getAttribute("List_CA_N"));
		aTableauCA.setParam("List_CA_N1", contenu.getAttribute("List_CA_N1"));

		aTableauCA.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

  } catch (e) {
    recup_erreur(e);
  }
}
