/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oate_aActions = new Arbre('Config/ct/list-actionTacheEvenement.tmpl', 'oate-listeActions');

var oate_currentActionId = "";



function oate_init() {
	try {

		oate_listerActions();

	} catch (e) {
	  recup_erreur(e);
	}
}


function oate_listerActions() {
	try {

		oate_aActions.setParam("Actif", document.getElementById("oate-filtreActif").checked);
		oate_aActions.initTree();
		oate_nouveauAction();

	} catch (e) {
		recup_erreur(e);
	}
}


function oate_nouveauAction() {
	try {

		oate_currentActionId = "";
		oate_aActions.clearSelection();

		document.getElementById('oate-libelle').value = "";
		document.getElementById('oate-type').value = "C";
		document.getElementById('oate-actif').checked = true;

		document.getElementById('oate-bSupprimer').collapsed = true;
		document.getElementById('oate-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oate_chargerAction() {
	try {

		if (oate_aActions.isSelected()) {
			oate_currentActionId = oate_aActions.getSelectedCellText("oate-colActionId");

			var qLoad = new QueryHttp("Config/ct/loadActionTacheEvenement.tmpl");
			qLoad.setParam("Action_Id", oate_currentActionId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oate-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('oate-type').value = contenu.getAttribute('Type');
				document.getElementById('oate-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('oate-bSupprimer').collapsed = false;
				document.getElementById('oate-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oate_enregistrerAction() {
	try {

		var libelle = document.getElementById('oate-libelle').value;
		var type = document.getElementById('oate-type').value;
		var actif = document.getElementById('oate-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(oate_currentActionId)) {
				qSave = new QueryHttp("Config/ct/updateActionTacheEvenement.tmpl");
				qSave.setParam("Action_Id", oate_currentActionId);
			}
			else {
				qSave = new QueryHttp("Config/ct/createActionTacheEvenement.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Type", type);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oate_listerActions();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oate_supprimerAction() {
	try {

		if (!isEmpty(oate_currentActionId) && window.confirm("Confirmez-vous la suppression de l'action s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/ct/deleteActionTacheEvenement.tmpl");
			qDelete.setParam("Action_Id", oate_currentActionId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oate_listerActions();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
