/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var opac_modified = false;



function opac_init() {
	try {

		var accMWM = getProfil().isAccMWM();

		document.getElementById('opac-boxMWMRangement').collapsed = !accMWM;

		document.getElementById("opac-GCF_Date_Liv_Ligne").collapsed = !adminMode;
		document.getElementById("opac-GCF_Date_Livraison").collapsed = !adminMode;
		document.getElementById("opac-PCF_No_Affect").collapsed = !adminMode;
		document.getElementById("opac-Histo_Avant_Valid_CF").collapsed = !adminMode;
		document.getElementById("opac-gControleFacturation").collapsed = !getConfig().isSpecLHCFF();

		opac_init2();

	} catch (e) {
    recup_erreur(e);
  }
}


function opac_init2() {
	try {

		var aFieldCol1 = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opac-Field_Column_DA_1");
		aFieldCol1.initTree(opac_init3);

	} catch (e) {
    recup_erreur(e);
  }
}


function opac_init3() {
	try {

		var aFieldCol2 = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opac-Field_Column_DA_2");
		aFieldCol2.initTree(opac_loadPreferences);

	} catch (e) {
    recup_erreur(e);
  }
}


function opac_demandeEnregistrement() {
	try {

		if (opac_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			opac_updatePreferences();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opac_loadPreferences() {
	try {

		var qLoad = new QueryHttp("Config/gc/achats/getPreferencesAchat.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("opac-Def_Etat_Rech_Com_Four").value = contenu.getAttribute("Def_Etat_Rech_Com_Four");
		document.getElementById("opac-Fournisseur_Prepa").value = contenu.getAttribute("Fournisseur_Prepa");
		document.getElementById("opac-Repartition_Prepa").checked = contenu.getAttribute("Repartition_Prepa")=="true";
		document.getElementById("opac-PCF_No_Affect").checked = contenu.getAttribute("PCF_No_Affect")=="true";
		document.getElementById("opac-FFA_Classement_PA").checked = contenu.getAttribute("FFA_Classement_PA")=="true";
		document.getElementById("opac-CF_Chiffre").checked = contenu.getAttribute("CF_Chiffre")=="true";
		document.getElementById("opac-RF_Chiffre").checked = contenu.getAttribute("RF_Chiffre")=="true";
		document.getElementById("opac-Show_Ref_Interne_CF").checked = contenu.getAttribute("Show_Ref_Interne_CF")=="true";
		document.getElementById("opac-Show_Num_TVA_Client_CF").checked = contenu.getAttribute("Show_Num_TVA_Client_CF")=="true";
		document.getElementById("opac-Show_NC8_Orig_CF").checked = contenu.getAttribute("Show_NC8_Orig_CF")=="true";
		document.getElementById("opac-BR_Chiffre").checked = contenu.getAttribute("BR_Chiffre")=="true";
		document.getElementById("opac-Col_Ref_Fournisseur_BR").checked = contenu.getAttribute("Col_Ref_Fournisseur_BR")=="true";
		document.getElementById("opac-Act_Dispo_Four").checked = contenu.getAttribute("Act_Dispo_Four")=="true";
		document.getElementById("opac-Marge_Stock_Four").value = contenu.getAttribute("Marge_Stock_Four");
		document.getElementById("opac-Seuil_Stock_Four").value = contenu.getAttribute("Seuil_Stock_Four");
		document.getElementById("opac-Commentaires_CF").value = contenu.getAttribute("Commentaires_CF");
		document.getElementById("opac-Act_Reassort_CC").checked = contenu.getAttribute("Act_Reassort_CC")=="true";
		document.getElementById("opac-GCF_Etiq_Article").checked = contenu.getAttribute("GCF_Etiq_Article")=="true";
		document.getElementById("opac-GCF_Maj_Prix_Achat").checked = contenu.getAttribute("GCF_Maj_Prix_Achat")=="true";
		document.getElementById("opac-GCF_Maj_PA_Article").checked = contenu.getAttribute("GCF_Maj_PA_Article")=="true";
		document.getElementById("opac-GCF_Cde_Art_Fab").checked = contenu.getAttribute("GCF_Cde_Art_Fab")=="true";
		document.getElementById("opac-GCF_Date_Recep_Ligne").checked = contenu.getAttribute("GCF_Date_Recep_Ligne")=="true";
		document.getElementById("opac-Ordre_Tri_BR").value = contenu.getAttribute("Ordre_Tri_BR");
		document.getElementById("opac-Field_Column_DA_1").value = contenu.getAttribute("Field_Column_DA_1");
		document.getElementById("opac-Field_Column_DA_2").value = contenu.getAttribute("Field_Column_DA_2");
		document.getElementById("opac-RCF_Num_BL_Oblig").checked = contenu.getAttribute("RCF_Num_BL_Oblig")=="true";
		document.getElementById("opac-Tracabilite_NL_FF").checked = contenu.getAttribute("Tracabilite_NL_FF")=="true";
		document.getElementById("opac-Tracabilite_NS_FF").checked = contenu.getAttribute("Tracabilite_NS_FF")=="true";
		document.getElementById("opac-GEF_Marge_Prix").value = contenu.getAttribute("GEF_Marge_Prix");
		document.getElementById("opac-GCF_Date_Liv_Ligne").checked = contenu.getAttribute("GCF_Date_Liv_Ligne")=="true";
		document.getElementById("opac-GCF_Date_Livraison").checked = contenu.getAttribute("GCF_Date_Livraison")=="true";
		document.getElementById("opac-Etape_Rangement_CF").checked = contenu.getAttribute("Etape_Rangement_CF")=="true";
		document.getElementById("opac-Etape_Rangement_TS").checked = contenu.getAttribute("Etape_Rangement_TS")=="true";
		document.getElementById("opac-Etape_Rangement_RF").checked = contenu.getAttribute("Etape_Rangement_RF")=="true";
		document.getElementById("opac-Col_Ref_Fournisseur_RG").checked = contenu.getAttribute("Col_Ref_Fournisseur_RG")=="true";
		document.getElementById("opac-Col_Ref_Fabricant_RG").checked = contenu.getAttribute("Col_Ref_Fabricant_RG")=="true";
		document.getElementById("opac-Col_Photo_RG").checked = contenu.getAttribute("Col_Photo_RG")=="true";
		document.getElementById("opac-MWM_RGR_Scan_Emplacement").checked = contenu.getAttribute("MWM_RGR_Scan_Emplacement")=="true";
		document.getElementById("opac-MWM_RGR_Prefill_Scan").checked = contenu.getAttribute("MWM_RGR_Prefill_Scan")=="true";
		document.getElementById("opac-Histo_Avant_Valid_CF").checked = contenu.getAttribute("Histo_Avant_Valid_CF")=="true";
		document.getElementById("opac-GCF_Prefill_Date_Recep").checked = contenu.getAttribute("GCF_Prefill_Date_Recep")=="true";
		document.getElementById("opac-GCF_Prefill_Date_Recep_Ligne").checked = contenu.getAttribute("GCF_Prefill_Date_Recep_Ligne")=="true";
		document.getElementById("opac-GCF_Rech_Integrale").checked = contenu.getAttribute("GCF_Rech_Integrale")=="true";
		document.getElementById("opac-Maj_DPA_FF").checked = contenu.getAttribute("Maj_DPA_FF")=="true";

		opac_checkOptsPrepaCmd();
		opac_checkDateRecepLigne();
		opac_checkGCFMajPrixAchat();

		document.getElementById("opac-bEnregistrer").disabled = false;

		opac_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function opac_updatePreferences() {
	try {

		var defEtatRechComFour = document.getElementById("opac-Def_Etat_Rech_Com_Four").value;
		var fournisseurPrepa = document.getElementById("opac-Fournisseur_Prepa").value;
		var repartitionPrepa = document.getElementById("opac-Repartition_Prepa").checked;
		var pcfNoAffect = document.getElementById("opac-PCF_No_Affect").checked;
		var ffaClassementPA = document.getElementById("opac-FFA_Classement_PA").checked;
		var cfChiffre = document.getElementById("opac-CF_Chiffre").checked;
		var rfChiffre = document.getElementById("opac-RF_Chiffre").checked;
		var showRefInterneCF = document.getElementById("opac-Show_Ref_Interne_CF").checked;
		var showNumTVAClientCF = document.getElementById("opac-Show_Num_TVA_Client_CF").checked;
		var showNC8OrigCF = document.getElementById("opac-Show_NC8_Orig_CF").checked;
		var brChiffre = document.getElementById("opac-BR_Chiffre").checked;
		var colRefFournisseurBR = document.getElementById("opac-Col_Ref_Fournisseur_BR").checked;
		var actDispoFour = document.getElementById("opac-Act_Dispo_Four").checked;
		var margeStockFour = document.getElementById("opac-Marge_Stock_Four").value;
		var seuilStockFour = document.getElementById("opac-Seuil_Stock_Four").value;
		var commentairesCF = document.getElementById("opac-Commentaires_CF").value;
		var actReassortCC = document.getElementById("opac-Act_Reassort_CC").checked;
		var gcfEtiqArticle = document.getElementById("opac-GCF_Etiq_Article").checked;
		var gcfMajPrixAchat = document.getElementById("opac-GCF_Maj_Prix_Achat").checked;
		var gcfMajPAArticle = document.getElementById("opac-GCF_Maj_PA_Article").checked;
		var gcfCdeArtFab = document.getElementById("opac-GCF_Cde_Art_Fab").checked;
		var gcfDateRecepLigne = document.getElementById("opac-GCF_Date_Recep_Ligne").checked;
		var ordreTriBR = document.getElementById("opac-Ordre_Tri_BR").value;
		var fieldColumnDA1 = document.getElementById("opac-Field_Column_DA_1").value;
		var fieldColumnDA2 = document.getElementById("opac-Field_Column_DA_2").value;
		var rcfNumBLOblig = document.getElementById("opac-RCF_Num_BL_Oblig").checked;
		var tracabiliteNLFF = document.getElementById("opac-Tracabilite_NL_FF").checked;
		var tracabiliteNSFF = document.getElementById("opac-Tracabilite_NS_FF").checked;
		var gefMargePrix = document.getElementById("opac-GEF_Marge_Prix").value;
		var gcfDateLivLigne = document.getElementById("opac-GCF_Date_Liv_Ligne").checked;
		var gcfDateLivraison = document.getElementById("opac-GCF_Date_Livraison").checked;
		var etapeRangementCF = document.getElementById("opac-Etape_Rangement_CF").checked;
		var etapeRangementTS = document.getElementById("opac-Etape_Rangement_TS").checked;
		var etapeRangementRF = document.getElementById("opac-Etape_Rangement_RF").checked;
		var colRefFournisseurRG = document.getElementById("opac-Col_Ref_Fournisseur_RG").checked;
		var colRefFabricantRG = document.getElementById("opac-Col_Ref_Fabricant_RG").checked;
		var colPhotoRG = document.getElementById("opac-Col_Photo_RG").checked;
		var mwmRGRScanEmplacement = document.getElementById("opac-MWM_RGR_Scan_Emplacement").checked;
		var mwmRGRPrefillScan = document.getElementById("opac-MWM_RGR_Prefill_Scan").checked;
		var histoAvantValidCF = document.getElementById("opac-Histo_Avant_Valid_CF").checked;
		var gcfPrefillDateRecep = document.getElementById("opac-GCF_Prefill_Date_Recep").checked;
		var gcfPrefillDateRecepLigne = document.getElementById("opac-GCF_Prefill_Date_Recep_Ligne").checked;
		var gcfRechIntegrale = document.getElementById("opac-GCF_Rech_Integrale").checked;
		var majDPAFF = document.getElementById("opac-Maj_DPA_FF").checked;

		if (isEmpty(margeStockFour) || !isPositiveOrNull(margeStockFour)) {
			showWarning("Marge sur stock fournisseur incorrecte");
		}
		else if (isEmpty(seuilStockFour) || !isPositiveOrNull(seuilStockFour)) {
			showWarning("Seuil de stock fournisseur incorrect");
		}
		else if (!isPositiveOrNullInteger(gefMargePrix)) {
			showWarning("Marge de g\u00E9n\u00E9ration des \u00E9carts de prix incorrecte");
		}
		else {
			var qUpdate = new QueryHttp("Config/gc/achats/updatePreferencesAchat.tmpl");

			qUpdate.setParam("Def_Etat_Rech_Com_Four", defEtatRechComFour);
			qUpdate.setParam("Fournisseur_Prepa", fournisseurPrepa);
			qUpdate.setParam("Repartition_Prepa", repartitionPrepa);
			qUpdate.setParam("PCF_No_Affect", pcfNoAffect);
			qUpdate.setParam("FFA_Classement_PA", ffaClassementPA);
			qUpdate.setParam("CF_Chiffre", cfChiffre);
			qUpdate.setParam("RF_Chiffre", rfChiffre);
			qUpdate.setParam("Show_Ref_Interne_CF", showRefInterneCF);
			qUpdate.setParam("Show_Num_TVA_Client_CF", showNumTVAClientCF);
			qUpdate.setParam("Show_NC8_Orig_CF", showNC8OrigCF);
			qUpdate.setParam("BR_Chiffre", brChiffre);
			qUpdate.setParam("Col_Ref_Fournisseur_BR", colRefFournisseurBR);
			qUpdate.setParam("Act_Dispo_Four", actDispoFour);
			qUpdate.setParam("Marge_Stock_Four", margeStockFour);
			qUpdate.setParam("Seuil_Stock_Four", seuilStockFour);
			qUpdate.setParam("Commentaires_CF", commentairesCF);
			qUpdate.setParam("Act_Reassort_CC", actReassortCC);
			qUpdate.setParam("GCF_Etiq_Article", gcfEtiqArticle);
			qUpdate.setParam("GCF_Maj_Prix_Achat", gcfMajPrixAchat);
			qUpdate.setParam("GCF_Maj_PA_Article", gcfMajPAArticle);
			qUpdate.setParam("GCF_Cde_Art_Fab", gcfCdeArtFab);
			qUpdate.setParam("GCF_Date_Recep_Ligne", gcfDateRecepLigne);
			qUpdate.setParam("Ordre_Tri_BR", ordreTriBR);
			qUpdate.setParam("Field_Column_DA_1", fieldColumnDA1);
			qUpdate.setParam("Field_Column_DA_2", fieldColumnDA2);
			qUpdate.setParam("RCF_Num_BL_Oblig", rcfNumBLOblig);
			qUpdate.setParam("Tracabilite_NL_FF", tracabiliteNLFF);
			qUpdate.setParam("Tracabilite_NS_FF", tracabiliteNSFF);
			qUpdate.setParam("GEF_Marge_Prix", gefMargePrix);
			qUpdate.setParam("GCF_Date_Liv_Ligne", gcfDateLivLigne);
			qUpdate.setParam("GCF_Date_Livraison", gcfDateLivraison);
			qUpdate.setParam("Etape_Rangement_CF", etapeRangementCF);
			qUpdate.setParam("Etape_Rangement_TS", etapeRangementTS);
			qUpdate.setParam("Etape_Rangement_RF", etapeRangementRF);
			qUpdate.setParam("Col_Ref_Fournisseur_RG", colRefFournisseurRG);
			qUpdate.setParam("Col_Ref_Fabricant_RG", colRefFabricantRG);
			qUpdate.setParam("Col_Photo_RG", colPhotoRG);
			qUpdate.setParam("MWM_RGR_Scan_Emplacement", mwmRGRScanEmplacement);
			qUpdate.setParam("MWM_RGR_Prefill_Scan", mwmRGRPrefillScan);
			qUpdate.setParam("Histo_Avant_Valid_CF", histoAvantValidCF);
			qUpdate.setParam("GCF_Prefill_Date_Recep", gcfPrefillDateRecep);
			qUpdate.setParam("GCF_Prefill_Date_Recep_Ligne", gcfPrefillDateRecepLigne);
			qUpdate.setParam("GCF_Rech_Integrale", gcfRechIntegrale);
			qUpdate.setParam("Maj_DPA_FF", majDPAFF);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opac_setModified(false);
				showMessage("Pr\u00E9f\u00E9rences d'achat sauvegard\u00E9es");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opac_checkOptsPrepaCmd() {
	try {

		document.getElementById("opac-Repartition_Prepa").disabled = document.getElementById("opac-Fournisseur_Prepa").value=="P";

	} catch (e) {
		recup_erreur(e);
	}
}


function opac_checkDateRecepLigne() {
	try {

		document.getElementById("opac-GCF_Prefill_Date_Recep_Ligne").disabled = !document.getElementById("opac-GCF_Date_Recep_Ligne").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opac_checkGCFMajPrixAchat() {
	try {

		document.getElementById("opac-GCF_Maj_PA_Article").disabled = !document.getElementById("opac-GCF_Maj_Prix_Achat").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opac_setModified(modified) {
	try {

		opac_modified = modified;
		document.getElementById('opac-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}
