/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oa_aGroupesAttribut = new Arbre('Config/gc/articles/list-groupeAttribut.tmpl', 'oa-listeGroupesAttribut');
var oa_aAttributs = new Arbre('Config/gc/articles/list-attribut.tmpl', 'oa-listeAttributs');
var oa_aCirconstanciation = new Arbre('Config/gc/articles/list-circonstanciations.tmpl', 'oa-listeCirconstanciation');

var oa_curGroupeId;
var oa_curAttributId;
var oa_curCirconst;
var oa_curTriAlpha;



function oa_init() {
	try {
	
		if (getConfig().isSpecPCAFT()) {
			document.getElementById("oa-libelle").removeAttribute("maxlength");
		}

		oa_aGroupesAttribut.initTree(oa_nouveauGroupeAttribut);

	} catch (e) {
    recup_erreur(e);
  }
}


function oa_nouveauGroupeAttribut() {
	try {

		oa_curGroupeId = "";
		oa_curCirconst = false;
		oa_curTriAlpha = true;
		oa_aAttributs.deleteTree();
		oa_aCirconstanciation.deleteTree();
		oa_aGroupesAttribut.clearSelection();

		document.getElementById('oa-intitule').value = "";
		document.getElementById('oa-circonst').checked = false;
		document.getElementById('oa-triAlpha').checked = true;
		document.getElementById('oa-concatenable').checked = true;
		document.getElementById('oa-bSupprimer').disabled = true;

		document.getElementById('oa-libelle').value = "";
		document.getElementById('oa-actif').checked = false;
		document.getElementById('oa-listeAttributs').disabled = true;
		document.getElementById('oa-libelle').disabled = true;
		document.getElementById('oa-actif').disabled = true;
		document.getElementById('oa-bNouveauAttribut').disabled = true;
		document.getElementById('oa-bValiderAttribut').disabled = true;
		document.getElementById('oa-bSupprimerAttribut').disabled = true;
		document.getElementById('oa-bFlecheHaut').disabled = true;
		document.getElementById('oa-bFlecheBas').disabled = true;
		document.getElementById('oa-bFlecheHaut').collapsed = true;
		document.getElementById('oa-bFlecheBas').collapsed = true;
		document.getElementById('oa-circonstanciation').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_chargerGroupeAttribut() {
	try {

		if (oa_aGroupesAttribut.isSelected()) {
			var i = oa_aGroupesAttribut.getCurrentIndex();

			oa_curGroupeId = oa_aGroupesAttribut.getCellText(i, 'oa-colGroupeId');
			oa_curCirconst = oa_aGroupesAttribut.getCellText(i, 'oa-colCirconst')=="true";
			oa_curTriAlpha = oa_aGroupesAttribut.getCellText(i, 'oa-colTriAlpha')=="true";

			document.getElementById('oa-intitule').value = oa_aGroupesAttribut.getCellText(i, 'oa-colIntitule');
			document.getElementById('oa-circonst').checked = oa_curCirconst;
			document.getElementById('oa-triAlpha').checked = oa_curTriAlpha;
			document.getElementById('oa-concatenable').checked = oa_aGroupesAttribut.getCellText(i, 'oa-colConcatenable')=="true";
			document.getElementById('oa-intitule').disabled = false;
			document.getElementById('oa-circonst').disabled = false;
			document.getElementById('oa-triAlpha').disabled = false;
			document.getElementById('oa-bSupprimer').disabled = false;
			document.getElementById('oa-listeAttributs').disabled = true;

			oa_aAttributs.setParam("Groupe_Id", oa_curGroupeId);
			oa_aAttributs.initTree(oa_initAttributs);

			if (oa_curCirconst) {
				oa_aCirconstanciation.setParam("Groupe_Id", oa_curGroupeId);
				oa_aCirconstanciation.initTree();
				document.getElementById('oa-circonstanciation').collapsed = false;
			}
			else {
				document.getElementById('oa-circonstanciation').collapsed = true;
				oa_aCirconstanciation.deleteTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_enregistrerGroupeAttribut() {
	try {

		var intitule = document.getElementById('oa-intitule').value;
		var circonst = document.getElementById('oa-circonst').checked;
		var triAlpha = document.getElementById('oa-triAlpha').checked;
		var concatenable = document.getElementById('oa-concatenable').checked;

		if (isEmpty(intitule)) {
			showWarning("Veuillez saisir un intitul\u00E9 d'attribut");
		}
		else {
			var qSave;
			if (isEmpty(oa_curGroupeId)) {
				qSave = new QueryHttp("Config/gc/articles/createGroupeAttribut.tmpl");
			}
			else {
				qSave = new QueryHttp("Config/gc/articles/updateGroupeAttribut.tmpl");
				qSave.setParam("Groupe_Id", oa_curGroupeId);
			}
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Circonst", circonst);
			qSave.setParam("Tri_Alpha", triAlpha);
			qSave.setParam("Concatenable", concatenable);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (isEmpty(oa_curGroupeId)) {
					oa_curGroupeId = result.responseXML.documentElement.getAttribute('Groupe_Id');
				}
				oa_aGroupesAttribut.initTree(oa_refreshSelGroupeAttribut);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_refreshSelGroupeAttribut() {
	try {

		var nbLignes = oa_aGroupesAttribut.nbLignes();
		var trouve = false;
		var i = 0;
		while (!trouve && i<nbLignes) {
			if (oa_aGroupesAttribut.getCellText(i, 'oa-colGroupeId') == oa_curGroupeId) { trouve = true; }
			else { i++; }
		}
		oa_aGroupesAttribut.select(i);
		oa_chargerGroupeAttribut();

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_supprimerGroupeAttribut() {
	try {

		if (window.confirm("Confirmez-vous la suppression de l'attribut ? (Attention : Toutes les valeurs de cet attribut et leurs affectations aux articles seront supprim\u00E9es !)")) {
			var qSupprimer = new QueryHttp("Config/gc/articles/deleteGroupeAttribut.tmpl");
			qSupprimer.setParam("Groupe_Id", oa_curGroupeId);
			var result = qSupprimer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oa_aGroupesAttribut.initTree(oa_nouveauGroupeAttribut);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_initAttributs() {
	try {

		oa_nouvelAttribut();

		document.getElementById('oa-listeAttributs').disabled = false;
		document.getElementById('oa-libelle').disabled = false;
		document.getElementById('oa-actif').disabled = false;
		document.getElementById('oa-bNouveauAttribut').disabled = false;
		document.getElementById('oa-bValiderAttribut').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_nouvelAttribut() {
	try {

		oa_curAttributId = "";
		oa_aAttributs.clearSelection();

		document.getElementById('oa-libelle').value = "";
		document.getElementById('oa-actif').checked = true;
		document.getElementById('oa-bFlecheHaut').disabled = true;
		document.getElementById('oa-bFlecheBas').disabled = true;
		document.getElementById('oa-bFlecheHaut').collapsed = oa_curTriAlpha;
		document.getElementById('oa-bFlecheBas').collapsed = oa_curTriAlpha;
		document.getElementById('oa-bSupprimerAttribut').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_ouvrirAttribut() {
	try {

		if (oa_aAttributs.isSelected()) {
			var i = oa_aAttributs.getCurrentIndex();
			var nbLignes = oa_aAttributs.nbLignes();
			oa_curAttributId = oa_aAttributs.getCellText(i, 'oa-colAttributId');
			document.getElementById('oa-libelle').value = oa_aAttributs.getCellText(i, 'oa-colLibelle');
			document.getElementById('oa-actif').checked = oa_aAttributs.getCellText(i, 'oa-colActif')=="true";
			document.getElementById('oa-bSupprimerAttribut').disabled = false;
			document.getElementById('oa-bFlecheHaut').disabled = (i==0);
			document.getElementById('oa-bFlecheBas').disabled = (i==nbLignes-1);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_deplacerAttribut(moveType) {
	try {

		var qDeplacerLigne = new QueryHttp("Config/gc/articles/moveAttribut.tmpl");
		qDeplacerLigne.setParam("Attribut_Id", oa_curAttributId);
		qDeplacerLigne.setParam("Move_Type", moveType);
		qDeplacerLigne.execute();

		oa_aAttributs.initTree(oa_initAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_enregistrerAttribut() {
	try {

		var libelle = document.getElementById('oa-libelle').value;
		var actif = document.getElementById('oa-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Veuillez saisir le libell\u00E9 de la valeur d'attribut");
		}
		else {
			var qSave;
			if (isEmpty(oa_curAttributId)) {
				qSave = new QueryHttp("Config/gc/articles/createAttribut.tmpl");
				qSave.setParam("Groupe_Id", oa_curGroupeId);
			}
			else {
				qSave = new QueryHttp("Config/gc/articles/updateAttribut.tmpl");
				qSave.setParam("Attribut_Id", oa_curAttributId);
			}
			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oa_aAttributs.initTree(oa_initAttributs);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_supprimerAttribut() {
	try {

		if (window.confirm("Confirmez-vous la suppression de la valeur d'attribut s\u00E9lectionn\u00E9e ?")) {
			var qSupprimer = new QueryHttp("Config/gc/articles/deleteAttribut.tmpl");
			qSupprimer.setParam("Attribut_Id", oa_curAttributId);
			var result = qSupprimer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oa_aAttributs.initTree(oa_initAttributs);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oa_pressOnListeCirconstanciation(event) {
	try {

		var tree = document.getElementById("oa-listeCirconstanciation");
	  var tbo = tree.treeBoxObject;
	  var row = { }, col = { }, child = { };
	  tbo.getCellAt(event.clientX, event.clientY, row, col, child);
	  var numLigne = row.value;
	  var numColImg = col.value.index;
	  var continuer = (col.value.id=="oa-colPictoChecked");

	  if (continuer) {
	  	var numColEtat = tbo.columns.getNamedColumn('oa-colChecked').index;
	  	var numColFamilleId = tbo.columns.getNamedColumn('oa-colFamilleId').index;
	  	var etatCoche = oa_aCirconstanciation.getCellText(numLigne, 'oa-colChecked');
	  	// etatCoche = 0: pas coch; 1: coch; 2: gris donc ne rien faire;
	  	if (etatCoche!="2") {
	  		var curNiveau = parseInt(oa_aCirconstanciation.getCellText(numLigne, 'oa-colNiveau'));
		  	var cocherParent = cocher;
		  	if (curNiveau>1) {
		  		// on va chercher l'tat de la coche du parent, car si on dcoche une case, celle-ci devra prendre l'tat de son parent (dcoche, ou coche en gris)
		  		var i=numLigne-1;
		  		while (i>0 && parseInt(oa_aCirconstanciation.getCellText(i, 'oa-colNiveau'))==curNiveau) { i--; }
		  		cocherParent = (tree.view.getItemAtIndex(i).childNodes[0].childNodes[numColEtat].getAttribute("label")!="0");
		  	}

	  		var familleId = oa_aCirconstanciation.getCellText(numLigne, 'oa-colFamilleId');
	  		var cocher;
		  	var cellImg = tree.view.getItemAtIndex(numLigne).childNodes[0].childNodes[numColImg];
		  	var cellEtat = tree.view.getItemAtIndex(numLigne).childNodes[0].childNodes[numColEtat];
		  	if (etatCoche=="0") {
		  		cocher=true;
		  		cellImg.setAttribute("src","chrome://opensi/content/design/checkbox.png");
		  		cellEtat.setAttribute("label", "1");
		  	}
				else {
		  		cocher=false;
		  		cellImg.setAttribute("src",cocherParent?"chrome://opensi/content/design/checkbox_disabled.png":"chrome://opensi/content/design/checkbox_empty.png");
		  		cellEtat.setAttribute("label", cocherParent?"2":"0");
		  	}

		  	document.getElementById('oa-listeCirconstanciation').disabled = true;
		  	var qEnregistrer = new QueryHttp("Config/gc/articles/saveGroupeAttributFamilleArticle.tmpl");
		  	qEnregistrer.setParam("Groupe_Id", oa_curGroupeId);
		  	qEnregistrer.setParam("Famille_Id", familleId);
		  	qEnregistrer.setParam("Circonstanciation", cocher);
		  	qEnregistrer.execute();

		  	var nbLignes = oa_aCirconstanciation.nbLignes();
		  	var i=numLigne+1;

		  	// on propage en interface l'tat de la coche dans toutes les sous-familles qui ne possdent pas une liaison en base :
		  	// soit on les dcoche, soit on les coche en gris
		  	var peutContinuer = true;
		  	while (i<nbLignes && peutContinuer) {
		  		if (parseInt(oa_aCirconstanciation.getCellText(i, 'oa-colNiveau'))<=curNiveau) { peutContinuer=false; }
		  		else {
		  			if (oa_aCirconstanciation.getCellText(i, 'oa-colChecked')!="1") {
		  				tree.view.getItemAtIndex(i).childNodes[0].childNodes[numColImg].setAttribute("src",cocher || cocherParent?"chrome://opensi/content/design/checkbox_disabled.png":"chrome://opensi/content/design/checkbox_empty.png");
		  				tree.view.getItemAtIndex(i).childNodes[0].childNodes[numColEtat].setAttribute("label",cocher || cocherParent?"2":"0");
		  			}
		  			i++;
		  		}
		  	}

		  	document.getElementById('oa-listeCirconstanciation').disabled = false;
	  	}
	  }

	} catch (e) {
		recup_erreur(e);
	}
}

