/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ofa_aFamillesArticle = new Arbre("Config/gc/articles/list-familleArticle.tmpl", "ofa-listeFamillesArticle");

var ofa_currentFamilleId = "";
var ofa_currentParentId = "";



function ofa_init() {
	try {

		ofa_listerFamillesArticle();

	} catch(e) {
    recup_erreur(e);
  }
}


function ofa_listerFamillesArticle() {
	try {

		ofa_aFamillesArticle.setParam("Actif", document.getElementById("ofa-filtreActif").checked);
		ofa_aFamillesArticle.initTree();
		ofa_nouveauFamilleArticle();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_nouveauFamilleArticle() {
	try {

		ofa_currentFamilleId = "";
		ofa_currentParentId = "";
		ofa_aFamillesArticle.clearSelection();

		document.getElementById('ofa-libelle').value = "";
		document.getElementById('ofa-libelleEN').value = "";
		document.getElementById('ofa-niveau').value = "1";
		document.getElementById('ofa-actif').checked = true;
		document.getElementById('ofa-rowParente').collapsed = true;
		document.getElementById('ofa-grpVentilation').collapsed = true;

		document.getElementById('ofa-bSupprimer').collapsed = true;
		document.getElementById('ofa-bNouveau').collapsed = true;
		document.getElementById('ofa-bNouveauSF').collapsed = true;

	} catch(e) {
    recup_erreur(e);
  }
}


function ofa_nouveauSousFamilleArticle() {
	try {

		ofa_currentParentId = ofa_currentFamilleId;
		ofa_currentFamilleId = "";
		ofa_aFamillesArticle.clearSelection();

		document.getElementById('ofa-parente').value = document.getElementById('ofa-libelle').value;
		document.getElementById('ofa-libelle').value = "";
		document.getElementById('ofa-libelleEN').value = "";
		document.getElementById('ofa-niveau').value = parseIntBis(document.getElementById('ofa-niveau').value) + 1;
		document.getElementById('ofa-actif').checked = true;
		document.getElementById('ofa-rowParente').collapsed = false;
		document.getElementById('ofa-grpVentilation').collapsed = true;

		document.getElementById('ofa-bSupprimer').collapsed = true;
		document.getElementById('ofa-bNouveauSF').collapsed = true;

	} catch(e) {
    recup_erreur(e);
  }
}


function ofa_chargerFamilleArticle() {
	try {

		if (ofa_aFamillesArticle.isSelected()) {
			ofa_currentFamilleId = ofa_aFamillesArticle.getSelectedCellText("ofa-colFamilleId");

			var qLoad = new QueryHttp("Config/gc/articles/loadFamilleArticle.tmpl");
			qLoad.setParam("Famille_Id", ofa_currentFamilleId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ofa-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('ofa-libelleEN').value = contenu.getAttribute('Libelle_EN');
				document.getElementById('ofa-actif').checked = contenu.getAttribute('Actif')=="true";
				var niveau = contenu.getAttribute('Niveau');
				document.getElementById('ofa-niveau').value = niveau;
				document.getElementById('ofa-parente').value = contenu.getAttribute('Parente');
				document.getElementById('ofa-rowParente').collapsed = (niveau=="1");
				document.getElementById('ofa-grpVentilation').collapsed = false;

				document.getElementById('ofa-bSupprimer').collapsed = false;
				document.getElementById('ofa-bNouveau').collapsed = false;
				document.getElementById('ofa-bNouveauSF').collapsed = false;
				document.getElementById('ofa-bNouveauSF').collapsed = (niveau=="3");

				ofa_chargerVentilationComptable();
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_enregistrerFamilleArticle() {
	try {

		var libelle = document.getElementById('ofa-libelle').value;
		var libelleEN = document.getElementById('ofa-libelleEN').value;
		var actif = document.getElementById('ofa-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(ofa_currentFamilleId)) {
				qSave = new QueryHttp("Config/gc/articles/updateFamilleArticle.tmpl");
				qSave.setParam("Famille_Id", ofa_currentFamilleId);
			}
			else {
				qSave = new QueryHttp("Config/gc/articles/createFamilleArticle.tmpl");
				qSave.setParam("Parent_Id", ofa_currentParentId);
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Libelle_EN", libelleEN);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ofa_listerFamillesArticle();
			}
		}

	} catch(e) {
    recup_erreur(e);
  }
}


function ofa_supprimerFamilleArticle() {
	try {

		if (!isEmpty(ofa_currentFamilleId) && window.confirm("Confirmez-vous la suppression de la famille s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/articles/deleteFamilleArticle.tmpl");
			qDelete.setParam("Famille_Id", ofa_currentFamilleId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ofa_listerFamillesArticle();
			}
		}

	} catch(e) {
    recup_erreur(e);
  }
}



// VENTILATION COMPTABLE


var ofa_aComptesFamilleNational = new Arbre("Config/gc/articles/list-compteFamilleArticle.tmpl", "ofa-listeComptesFamilleNational");
var ofa_aComptesFamilleUE = new Arbre("Config/gc/articles/list-compteFamilleArticle.tmpl", "ofa-listeComptesFamilleUE");
var ofa_aComptesFamilleNatUE = new Arbre("Config/gc/articles/list-compteFamilleArticleTVANationalUE.tmpl", "ofa-listeComptesFamilleNatUE");
var ofa_aComptesFamilleInter = new Arbre("Config/gc/articles/list-compteFamilleArticle.tmpl", "ofa-listeComptesFamilleInter");

var ofa_currentChampCompte = "";
var ofa_currentCodeTVAInter = "";
var ofa_currentCodeTVAUE = "";
var ofa_currentCodeTVANat = "";
var ofa_currentCodeTVANatUE = "";
var ofa_currentCodePaysNatUE = "";


function ofa_rechercherCompte(id) {
	try {

		var debCompte = "";
		var titre = "";

    switch (id) {
    	case 'ofa-compteVenteNat':
    		debCompte = "7";
        titre = "VENTE";
        break;
    	case 'ofa-compteVenteUE':
    		debCompte = "7";
        titre = "VENTE UE";
        break;
      case 'ofa-compteVenteNatUE':
    		debCompte = "7";
        titre = "VENTE UE";
        break;
    	case 'ofa-compteVenteInter':
  			debCompte = "7";
        titre = "VENTE INTERNATIONAL";
        break;
      case 'ofa-compteAchatNat':
  			debCompte = "6";
        titre = "ACHAT";
        break;
      case 'ofa-compteAchatUE':
  			debCompte = "6";
        titre = "ACHAT UE";
        break;
      case 'ofa-compteAchatInter':
  			debCompte = "6";
        titre = "ACHAT INTERNATIONAL";
        break;
    }

    ofa_currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourRechercherCompte, debCompte, "G", titre, debCompte, false);

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById(ofa_currentChampCompte).value = numCompte;
		ofa_currentChampCompte = "";

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerVentilationComptable() {
	try {

		ofa_listerComptesFamilleNational();
		ofa_listerComptesFamilleUE();
		ofa_listerComptesFamilleNatUE();
		ofa_listerComptesFamilleInter();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_listerComptesFamilleNational() {
	try {

		ofa_currentCodeTVANat = "";
		document.getElementById("ofa-tauxTVANat").value = "";
		document.getElementById("ofa-compteAchatNat").value = "";
		document.getElementById("ofa-compteVenteNat").value = "";

		document.getElementById("ofa-bRechercherAchatNat").disabled = true;
		document.getElementById("ofa-bRemoveAchatNat").disabled = true;
		document.getElementById("ofa-bRechercherVenteNat").disabled = true;
		document.getElementById("ofa-bRemoveVenteNat").disabled = true;
		document.getElementById("ofa-bValiderNat").disabled = true;

		ofa_aComptesFamilleNational.setParam('Famille_Id', ofa_currentFamilleId);
		ofa_aComptesFamilleNational.setParam('Type_Ventilation', "N");
		ofa_aComptesFamilleNational.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteFamilleNational() {
	try {

		if (ofa_aComptesFamilleNational.isSelected()) {
			ofa_currentCodeTVANat = ofa_aComptesFamilleNational.getSelectedCellText('ofa-colCodeTVANat');
			document.getElementById("ofa-tauxTVANat").value = ofa_aComptesFamilleNational.getSelectedCellText('ofa-colTauxTVANat');
			document.getElementById("ofa-compteAchatNat").value = ofa_aComptesFamilleNational.getSelectedCellText('ofa-colCompteAchatNat');
			document.getElementById("ofa-compteVenteNat").value = ofa_aComptesFamilleNational.getSelectedCellText('ofa-colCompteVenteNat');

			document.getElementById("ofa-bRechercherAchatNat").disabled = false;
			document.getElementById("ofa-bRemoveAchatNat").disabled = false;
			document.getElementById("ofa-bRechercherVenteNat").disabled = false;
			document.getElementById("ofa-bRemoveVenteNat").disabled = false;
			document.getElementById("ofa-bValiderNat").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteFamilleNational() {
	try {

		var compteAchat = document.getElementById("ofa-compteAchatNat").value;
		var compteVente = document.getElementById("ofa-compteVenteNat").value;

		var qSave = new QueryHttp("Config/gc/articles/saveCompteFamilleArticle.tmpl");

		qSave.setParam("Famille_Id", ofa_currentFamilleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVANat);
		qSave.setParam("Compte_Achat", compteAchat);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesFamilleNational();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_affecterCompteFamilleNational() {
	try {

		var url = "chrome://opensi/content/config/gc/articles/popup-affectationCompteFamilleArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_currentFamilleId, "N");

		ofa_listerComptesFamilleNational();

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_listerComptesFamilleUE() {
	try {

		ofa_currentCodeTVAUE = "";
		document.getElementById("ofa-tauxTVAUE").value = "";
		document.getElementById("ofa-paysUE").value = "";
		document.getElementById("ofa-compteAchatUE").value = "";
		document.getElementById("ofa-compteVenteUE").value = "";

		document.getElementById("ofa-bRechercherAchatUE").disabled = true;
		document.getElementById("ofa-bRemoveAchatUE").disabled = true;
		document.getElementById("ofa-bRechercherVenteUE").disabled = true;
		document.getElementById("ofa-bRemoveVenteUE").disabled = true;
		document.getElementById("ofa-bValiderUE").disabled = true;

		ofa_aComptesFamilleUE.setParam('Famille_Id', ofa_currentFamilleId);
		ofa_aComptesFamilleUE.setParam('Type_Ventilation', "U");
		ofa_aComptesFamilleUE.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteFamilleUE() {
	try {

		if (ofa_aComptesFamilleUE.isSelected()) {
			ofa_currentCodeTVAUE = ofa_aComptesFamilleUE.getSelectedCellText('ofa-colCodeTVAUE');
			document.getElementById("ofa-tauxTVAUE").value = ofa_aComptesFamilleUE.getSelectedCellText('ofa-colTauxTVAUE');
			document.getElementById("ofa-paysUE").value = ofa_aComptesFamilleUE.getSelectedCellText('ofa-colPaysUE');
			document.getElementById("ofa-compteAchatUE").value = ofa_aComptesFamilleUE.getSelectedCellText('ofa-colCompteAchatUE');
			document.getElementById("ofa-compteVenteUE").value = ofa_aComptesFamilleUE.getSelectedCellText('ofa-colCompteVenteUE');

			document.getElementById("ofa-bRechercherAchatUE").disabled = false;
			document.getElementById("ofa-bRemoveAchatUE").disabled = false;
			document.getElementById("ofa-bRechercherVenteUE").disabled = false;
			document.getElementById("ofa-bRemoveVenteUE").disabled = false;
			document.getElementById("ofa-bValiderUE").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteFamilleUE() {
	try {

		var compteAchat = document.getElementById("ofa-compteAchatUE").value;
		var compteVente = document.getElementById("ofa-compteVenteUE").value;

		var qSave = new QueryHttp("Config/gc/articles/saveCompteFamilleArticle.tmpl");

		qSave.setParam("Famille_Id", ofa_currentFamilleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVAUE);
		qSave.setParam("Compte_Achat", compteAchat);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesFamilleUE();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_affecterCompteFamilleUE() {
	try {

		var url = "chrome://opensi/content/config/gc/articles/popup-affectationCompteFamilleArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_currentFamilleId, "U");

		ofa_listerComptesFamilleUE();

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_listerComptesFamilleNatUE() {
	try {

		ofa_currentCodeTVANatUE = "";
		ofa_currentCodePaysNatUE = "";
		document.getElementById("ofa-tauxTVANatUE").value = "";
		document.getElementById("ofa-paysNatUE").value = "";
		document.getElementById("ofa-compteVenteNatUE").value = "";

		document.getElementById("ofa-bRechercherVenteNatUE").disabled = true;
		document.getElementById("ofa-bRemoveVenteNatUE").disabled = true;
		document.getElementById("ofa-bValiderNatUE").disabled = true;

		ofa_aComptesFamilleNatUE.setParam('Famille_Id', ofa_currentFamilleId);
		ofa_aComptesFamilleNatUE.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteFamilleNatUE() {
	try {

		if (ofa_aComptesFamilleNatUE.isSelected()) {
			ofa_currentCodeTVANatUE = ofa_aComptesFamilleNatUE.getSelectedCellText('ofa-colCodeTVANatUE');
			ofa_currentCodePaysNatUE = ofa_aComptesFamilleNatUE.getSelectedCellText('ofa-colCodePaysNatUE');
			document.getElementById("ofa-tauxTVANatUE").value = ofa_aComptesFamilleNatUE.getSelectedCellText('ofa-colTauxTVANatUE');
			document.getElementById("ofa-paysNatUE").value = ofa_aComptesFamilleNatUE.getSelectedCellText('ofa-colPaysNatUE');
			document.getElementById("ofa-compteVenteNatUE").value = ofa_aComptesFamilleNatUE.getSelectedCellText('ofa-colCompteVenteNatUE');

			document.getElementById("ofa-bRechercherVenteNatUE").disabled = false;
			document.getElementById("ofa-bRemoveVenteNatUE").disabled = false;
			document.getElementById("ofa-bValiderNatUE").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteFamilleNatUE() {
	try {

		var compteVente = document.getElementById("ofa-compteVenteNatUE").value;

		var qSave = new QueryHttp("Config/gc/articles/saveCompteFamilleArticleTVANationalUE.tmpl");

		qSave.setParam("Famille_Id", ofa_currentFamilleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVANatUE);
		qSave.setParam("Code_Pays", ofa_currentCodePaysNatUE);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesFamilleNatUE();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_affecterCompteFamilleNatUE() {
	try {

		var url = "chrome://opensi/content/config/gc/articles/popup-affectationCompteFamilleArticleTVANationalUE.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_currentFamilleId);

		ofa_listerComptesFamilleNatUE();

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_listerComptesFamilleInter() {
	try {

		ofa_currentCodeTVAInter = "";
		document.getElementById("ofa-paysInter").value = "";
		document.getElementById("ofa-compteAchatInter").value = "";
		document.getElementById("ofa-compteVenteInter").value = "";

		document.getElementById("ofa-bRechercherAchatInter").disabled = true;
		document.getElementById("ofa-bRemoveAchatInter").disabled = true;
		document.getElementById("ofa-bRechercherVenteInter").disabled = true;
		document.getElementById("ofa-bRemoveVenteInter").disabled = true;
		document.getElementById("ofa-bValiderInter").disabled = true;

		ofa_aComptesFamilleInter.setParam('Famille_Id', ofa_currentFamilleId);
		ofa_aComptesFamilleInter.setParam('Type_Ventilation', "I");
		ofa_aComptesFamilleInter.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteFamilleInter() {
	try {

		if (ofa_aComptesFamilleInter.isSelected()) {
			ofa_currentCodeTVAInter = ofa_aComptesFamilleInter.getSelectedCellText('ofa-colCodeTVAInter');
			document.getElementById("ofa-paysInter").value = ofa_aComptesFamilleInter.getSelectedCellText('ofa-colPaysInter');
			document.getElementById("ofa-compteAchatInter").value = ofa_aComptesFamilleInter.getSelectedCellText('ofa-colCompteAchatInter');
			document.getElementById("ofa-compteVenteInter").value = ofa_aComptesFamilleInter.getSelectedCellText('ofa-colCompteVenteInter');

			document.getElementById("ofa-bRechercherAchatInter").disabled = false;
			document.getElementById("ofa-bRemoveAchatInter").disabled = false;
			document.getElementById("ofa-bRechercherVenteInter").disabled = false;
			document.getElementById("ofa-bRemoveVenteInter").disabled = false;
			document.getElementById("ofa-bValiderInter").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteFamilleInter() {
	try {

		var compteAchat = document.getElementById("ofa-compteAchatInter").value;
		var compteVente = document.getElementById("ofa-compteVenteInter").value;

		var qSave = new QueryHttp("Config/gc/articles/saveCompteFamilleArticle.tmpl");

		qSave.setParam("Famille_Id", ofa_currentFamilleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVAInter);
		qSave.setParam("Compte_Achat", compteAchat);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesFamilleInter();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_affecterCompteFamilleInter() {
	try {

		var url = "chrome://opensi/content/config/gc/articles/popup-affectationCompteFamilleArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_currentFamilleId, "I");

		ofa_listerComptesFamilleInter();

	} catch (e) {
    recup_erreur(e);
  }
}
