/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oaec_currentAffectationME = "";
var oaec_aAffectationModesExpe = new Arbre('Config/gc/ecommerce/list-affectationModeExpedition.tmpl', 'oaec-listeAffectationModesExpe');
var oaec_aModesExpeInitial = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oaec-modeExpeInitial_ME');
var oaec_aModesExpeFinal = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oaec-modeExpeFinal_ME');

var oaec_currentAffectationDS = "";
var oaec_aAffectationDepot = new Arbre('Config/gc/ecommerce/list-affectationDepotModeExpedition.tmpl', 'oaec-listeAffectationDepot');
var oaec_aModesExpe = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oaec-modeExpedition_DS');
var oaec_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oaec-depotStock_DS');

var oaec_currentAffectationCNF = "";
var oaec_aAffectationCNF = new Arbre('Config/gc/ecommerce/list-affectationCommandeNonFacturable.tmpl', 'oaec-listeAffectationCNF');
var oaec_aModesReglement = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oaec-modeReglement_CNF');



function oaec_init() {
	try {

		oaec_aDepots.setParam("No_Check_Rights", true);

		var aDepartements = new Arbre('ComboListe/combo-departements.tmpl', 'oaec-departement_ME');
		aDepartements.initTree();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oaec-codePays_ME");
		aPays.initTree();

		oaec_nouvelleAffectationModesExpe();
		oaec_nouvelleAffectationDepot();
		oaec_nouvelleAffectationCNF();

	} catch (e) {
    recup_erreur(e);
  }
}



// AFFECTATIONS MODE EXPEDITION


function oaec_nouvelleAffectationModesExpe() {
	try {

		oaec_aAffectationModesExpe.setParam("Origine", "C");
		oaec_aAffectationModesExpe.initTree();

		document.getElementById('oaec-bSupprimer_ME').collapsed = true;
		oaec_currentAffectationME = "";
		oaec_aModesExpeInitial.clearParams();
		oaec_aModesExpeInitial.initTree();
		oaec_aModesExpeFinal.clearParams();
		oaec_aModesExpeFinal.initTree();

		document.getElementById('oaec-modeExpeInitial_ME').value = "";
		document.getElementById('oaec-modeExpeFinal_ME').value = "";
		document.getElementById('oaec-poidsDeb_ME').value = "";
		document.getElementById('oaec-poidsFin_ME').value = "";
		document.getElementById('oaec-colisageSpe_ME').checked = false;
		document.getElementById('oaec-departement_ME').value = "";
		document.getElementById('oaec-codePays_ME').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationModesExpe() {
	try {

		if (oaec_aAffectationModesExpe.isSelected()) {
			oaec_currentAffectationME = oaec_aAffectationModesExpe.getSelectedCellText('oaec-colAffectationId_ME');
			oaec_aModesExpeInitial.setParam("Selection", oaec_aAffectationModesExpe.getSelectedCellText('oaec-colModeExpeInitId_ME'));
			oaec_aModesExpeInitial.initTree(oaec_ouvrirAffectationModesExpe2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationModesExpe2() {
	try {

		document.getElementById('oaec-modeExpeInitial_ME').value = oaec_aAffectationModesExpe.getSelectedCellText('oaec-colModeExpeInitId_ME');
		oaec_aModesExpeFinal.setParam("Selection", oaec_aAffectationModesExpe.getSelectedCellText('oaec-colModeExpeFinalId_ME'));
		oaec_aModesExpeFinal.initTree(oaec_ouvrirAffectationModesExpe3);

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationModesExpe3() {
	try {

		var i = oaec_aAffectationModesExpe.getCurrentIndex();
		document.getElementById('oaec-modeExpeFinal_ME').value = oaec_aAffectationModesExpe.getCellText(i, 'oaec-colModeExpeFinalId_ME');
		document.getElementById('oaec-poidsDeb_ME').value = oaec_aAffectationModesExpe.getCellText(i, 'oaec-colPoidsDeb_ME');
		document.getElementById('oaec-poidsFin_ME').value = oaec_aAffectationModesExpe.getCellText(i, 'oaec-colPoidsFin_ME');
		document.getElementById('oaec-colisageSpe_ME').checked = oaec_aAffectationModesExpe.getCellText(i, 'oaec-colColisageId_ME')=="true";
		document.getElementById('oaec-codePays_ME').value = oaec_aAffectationModesExpe.getCellText(i, 'oaec-colCodePays_ME');
		document.getElementById('oaec-departement_ME').value = oaec_aAffectationModesExpe.getCellText(i, 'oaec-colDepartementId_ME');
		document.getElementById('oaec-bSupprimer_ME').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_supprimerAffectationModesExpe() {
	try {

		if (!isEmpty(oaec_currentAffectationME) && window.confirm("Voulez-vous supprimer l'affectation s\u00E9lectionn\u00E9e ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteAffectationModeExpedition.tmpl");
			qDelete.setParam("Affectation_Id", oaec_currentAffectationME);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oaec_nouvelleAffectationModesExpe();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_enregistrerAffectationModesExpe() {
	try {

		var modeExpeInitial = document.getElementById('oaec-modeExpeInitial_ME').value;
		var modeExpeFinal = document.getElementById('oaec-modeExpeFinal_ME').value;
		var poidsDeb = document.getElementById('oaec-poidsDeb_ME').value;
		var poidsFin = document.getElementById('oaec-poidsFin_ME').value;
		var colisageSpe = document.getElementById('oaec-colisageSpe_ME').checked;
		var departementId = document.getElementById('oaec-departement_ME').value;
		var codePays = document.getElementById('oaec-codePays_ME').value;

		if (isEmpty(modeExpeInitial)) { showWarning("Veuillez saisir le mode d'exp\u00E9dition initial") }
		else if (isEmpty(modeExpeFinal)) { showWarning("Veuillez saisir le mode d'exp\u00E9dition final") }
		else if (modeExpeInitial==modeExpeFinal) { showWarning("Veuillez saisir un mode d'exp\u00E9dition final diff\u00E9rent de l'initial") }
		else if (isEmpty(poidsDeb)) { showWarning("Veuillez saisir le poids de d\u00E9part.") }
		else if (!isPositiveOrNull(poidsDeb)) { showWarning("Poids de d\u00E9part erron\u00E9") }
		else if (!isEmpty(poidsFin) && !isPositiveOrNull(poidsFin)) { showWarning("Poids de fin erron\u00E9") }
		else if (parseFloat(poidsDeb)>parseFloat(poidsFin)) { showWarning("Poids de fin erron\u00E9") }
		else {

			var qSave;

			if (!isEmpty(oaec_currentAffectationME)) {
				qSave = new QueryHttp("Config/gc/ecommerce/updateAffectationModeExpedition.tmpl");
				qSave.setParam("Affectation_Id", oaec_currentAffectationME);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/createAffectationModeExpedition.tmpl");
				qSave.setParam("Origine", "C");
			}

			qSave.setParam("Mode_Expe_Init", modeExpeInitial);
			qSave.setParam("Mode_Expe_Final", modeExpeFinal);
			qSave.setParam("Poids_Debut", poidsDeb);
			qSave.setParam("Poids_Fin", poidsFin);
			qSave.setParam("Colisage_Spe", colisageSpe);
			qSave.setParam("Departement_Id", departementId);
			qSave.setParam("Code_Pays", codePays);

			var result = qSave.execute();
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oaec_nouvelleAffectationModesExpe();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}



// AFFECTATIONS DEPOTS


function oaec_nouvelleAffectationDepot() {
	try {

		oaec_aAffectationDepot.initTree();

		document.getElementById('oaec-bSupprimer_DS').collapsed = true;
		oaec_currentAffectationDS = "";
		oaec_aModesExpe.clearParams();
		oaec_aModesExpe.initTree();
		oaec_aDepots.clearParams();
		oaec_aDepots.setParam('Depot_Vente', false);
		oaec_aDepots.setParam('Depot_Quarantaine', false);
		oaec_aDepots.initTree();

		document.getElementById('oaec-modeExpedition_DS').value = "";
		document.getElementById('oaec-depotStock_DS').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationDepot() {
	try {

		if (oaec_aAffectationDepot.isSelected()) {
			oaec_currentAffectationDS = oaec_aAffectationDepot.getSelectedCellText('oaec-colAffectationId_DS');
			oaec_aModesExpe.setParam("Selection", oaec_aAffectationDepot.getSelectedCellText('oaec-colModeExpId_DS'));
			oaec_aModesExpe.initTree(oaec_ouvrirAffectationDepot2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationDepot2() {
	try {

		document.getElementById('oaec-modeExpedition_DS').value = oaec_aAffectationDepot.getSelectedCellText('oaec-colModeExpId_DS');
		oaec_aDepots.setParam("Selection", oaec_aAffectationDepot.getSelectedCellText('oaec-colDepotId_DS'));
		oaec_aDepots.initTree(oaec_ouvrirAffectationDepot3);

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationDepot3() {
	try {

		document.getElementById('oaec-depotStock_DS').value = oaec_aAffectationDepot.getSelectedCellText('oaec-colDepotId_DS');
		document.getElementById('oaec-bSupprimer_DS').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_supprimerAffectationDepot() {
	try {

		if (!isEmpty(oaec_currentAffectationDS) && window.confirm("Voulez-vous supprimer l'affectation s\u00E9lectionn\u00E9e ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteAffectationDepotModeExpedition.tmpl");
			qDelete.setParam("Affectation_Id", oaec_currentAffectationDS);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oaec_nouvelleAffectationDepot();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_enregistrerAffectationDepot() {
	try {

		var modeExpedition = document.getElementById('oaec-modeExpedition_DS').value;
		var depotStock = document.getElementById('oaec-depotStock_DS').value;

		if (isEmpty(modeExpedition)) { showWarning("Veuillez saisir le mode d'exp\u00E9dition") }
		else if (isEmpty(depotStock)) { showWarning("Veuillez saisir le d\u00E9pot de stock") }
		else {

			var qSave;

			if (!isEmpty(oaec_currentAffectationDS)) {
				qSave = new QueryHttp("Config/gc/ecommerce/updateAffectationDepotModeExpedition.tmpl");
				qSave.setParam("Affectation_Id", oaec_currentAffectationDS);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/createAffectationDepotModeExpedition.tmpl");
			}

			qSave.setParam("Mode_Exp_Id", modeExpedition);
			qSave.setParam("Depot_Id", depotStock);

			var result = qSave.execute();
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oaec_nouvelleAffectationDepot();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}



// AFFECTATIONS COMMANDE NON FACTURABLE


function oaec_nouvelleAffectationCNF() {
	try {

		oaec_aAffectationCNF.initTree();

		document.getElementById('oaec-bSupprimer_CNF').collapsed = true;
		oaec_currentAffectationCNF = "";
		oaec_aModesReglement.clearParams();
		oaec_aModesReglement.initTree();

		document.getElementById('oaec-modeReglement_CNF').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationCNF() {
	try {

		if (oaec_aAffectationCNF.isSelected()) {
			oaec_currentAffectationCNF = oaec_aAffectationCNF.getSelectedCellText('oaec-colAffectationId_CNF');
			oaec_aModesReglement.setParam("Selection", oaec_aAffectationCNF.getSelectedCellText('oaec-colModeRegId_CNF'));
			oaec_aModesReglement.initTree(oaec_ouvrirAffectationCNF2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_ouvrirAffectationCNF2() {
	try {

		document.getElementById('oaec-modeReglement_CNF').value = oaec_aAffectationCNF.getSelectedCellText('oaec-colModeRegId_CNF');
		document.getElementById('oaec-bSupprimer_CNF').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_supprimerAffectationCNF() {
	try {

		if (!isEmpty(oaec_currentAffectationCNF) && window.confirm("Voulez-vous supprimer l'affectation s\u00E9lectionn\u00E9e ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteAffectationCommandeNonFacturable.tmpl");
			qDelete.setParam("Affectation_Id", oaec_currentAffectationCNF);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oaec_nouvelleAffectationCNF();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oaec_enregistrerAffectationCNF() {
	try {

		var modeReglement = document.getElementById('oaec-modeReglement_CNF').value;

		if (isEmpty(modeReglement)) { showWarning("Veuillez s\u00E9lectionner le mode de r\u00E8glement") }
		else {

			var qSave;

			if (!isEmpty(oaec_currentAffectationCNF)) {
				qSave = new QueryHttp("Config/gc/ecommerce/updateAffectationCommandeNonFacturable.tmpl");
				qSave.setParam("Affectation_Id", oaec_currentAffectationCNF);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/createAffectationCommandeNonFacturable.tmpl");
			}

			qSave.setParam("Mode_Reg_Id", modeReglement);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oaec_nouvelleAffectationCNF();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
