/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ocl_aConfigs = new Arbre('Config/gc/expeditions/list-configExpedition.tmpl', 'ocl-listeConfigsExpedition');
var ocl_aTranchesVolume = new Arbre('Config/gc/expeditions/list-trancheVolumeConfigExpedition.tmpl', 'ocl-listeTrancheVolume');

var ocl_currentConfigId = "";
var ocl_trancheId = "";
var ocl_specEFU;



function ocl_init() {
	try {

		var config = getResetConfig();

		var exlBacPrepa = config.isEXLBacPrepa();

		if (!exlBacPrepa) {
			document.getElementById('ocl-rowBacsMulti').collapsed = true;
			document.getElementById('ocl-rowBacsMono').collapsed = true;
			document.getElementById('ocl-colNbBacMulti').collapsed = true;
			document.getElementById('ocl-colNbBacMono').collapsed = true;
			document.getElementById('ocl-colNbBacMulti').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('ocl-colNbBacMono').setAttribute("ignoreincolumnpicker", true);
		}

		ocl_specEFU = config.isSpecPCEFU();
		document.getElementById('ocl-groupementClient').collapsed = (exlBacPrepa || !config.isEXLGroupementClient());
		document.getElementById('ocl-symboleUniteVolumeTV').value = config.getSymboleUniteVolume();

		ocl_listerConfigsExpedition();

	} catch (e) {
    recup_erreur(e);
  }
}


function ocl_listerConfigsExpedition() {
	try {

		ocl_aConfigs.initTree();
		ocl_nouveauConfigExpedition();

	} catch (e) {
		recup_erreur(e);
	}
}


function ocl_nouveauConfigExpedition() {
	try {

		ocl_currentConfigId = "";
		ocl_aConfigs.clearSelection();

		document.getElementById('ocl-intitule').value = "";
		document.getElementById('ocl-typeConfig').value = "S";
		document.getElementById('ocl-editBP').checked = false;
		document.getElementById('ocl-editPK').checked = false;
		document.getElementById('ocl-editBL').checked = true;
		document.getElementById('ocl-genFC').checked = false;
		document.getElementById('ocl-editFC').checked = false;
		document.getElementById('ocl-editEtiq').checked = false;
		document.getElementById('ocl-editRE').checked = false;
		document.getElementById('ocl-nbBacMulti').value = 1;
		document.getElementById('ocl-nbBacMono').value = 1;
		document.getElementById('ocl-groupementClient').checked = false;

		document.getElementById('ocl-bSupprimer').collapsed = true;
		document.getElementById('ocl-bNouveau').collapsed = true;

		document.getElementById('ocl-boxTrancheVolume').collapsed = true;

		ocl_aTranchesVolume.deleteTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function ocl_chargerConfigExpedition() {
	try {

		if (ocl_aConfigs.isSelected()) {
			ocl_currentConfigId = ocl_aConfigs.getSelectedCellText('ocl-colConfigId');

			var qLoad = new QueryHttp("Config/gc/expeditions/loadConfigExpedition.tmpl");
			qLoad.setParam("Config_Id", ocl_currentConfigId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ocl-intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('ocl-typeConfig').value = contenu.getAttribute('Type_Config');
				document.getElementById('ocl-editBP').checked = contenu.getAttribute('Edit_BP')=="true";
				document.getElementById('ocl-editPK').checked = contenu.getAttribute('Edit_PK')=="true";
				document.getElementById('ocl-editBL').checked = contenu.getAttribute('Edit_BL')=="true";
				document.getElementById('ocl-genFC').checked = contenu.getAttribute('Gen_FC')=="true";
				document.getElementById('ocl-editFC').checked = contenu.getAttribute('Edit_FC')=="true";
				document.getElementById('ocl-editEtiq').checked = contenu.getAttribute('Edit_Etiq')=="true";
				document.getElementById('ocl-editRE').checked = contenu.getAttribute('Edit_RE')=="true";
				document.getElementById('ocl-nbBacMulti').value = contenu.getAttribute('Nb_Bac_Multi');
				document.getElementById('ocl-nbBacMono').value = contenu.getAttribute('Nb_Bac_Mono');
				document.getElementById('ocl-groupementClient').checked = contenu.getAttribute('Groupement_Client')=="true";

				document.getElementById('ocl-bSupprimer').collapsed = false;
				document.getElementById('ocl-bNouveau').collapsed = false;

				ocl_nouveauTrancheVolume();

				if (document.getElementById('ocl-typeConfig').value=="V") {
					document.getElementById('ocl-boxTrancheVolume').collapsed = false;
					ocl_aTranchesVolume.setParam("Config_Id", ocl_currentConfigId);
					ocl_aTranchesVolume.initTree();
				}
				else {
					document.getElementById('ocl-boxTrancheVolume').collapsed = true;
				}

				ocl_checkEXLGenFC();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ocl_enregistrerConfigExpedition() {
	try {

		var intitule = document.getElementById('ocl-intitule').value;
		var typeConfig = document.getElementById('ocl-typeConfig').value;
		var editBP = document.getElementById('ocl-editBP').checked;
		var editPK = document.getElementById('ocl-editPK').checked;
		var editBL = document.getElementById('ocl-editBL').checked;
		var genFC = document.getElementById('ocl-genFC').checked;
		var editFC = document.getElementById('ocl-editFC').checked;
		var editEtiq = document.getElementById('ocl-editEtiq').checked;
		var editRE = document.getElementById('ocl-editRE').checked;
		var nbBacMulti = document.getElementById('ocl-nbBacMulti').value;
		var nbBacMono = document.getElementById('ocl-nbBacMono').value;
		var groupementClient = document.getElementById('ocl-groupementClient').checked;

		if (isEmpty(intitule)) { showWarning("Intitul\u00E9 manquant"); }
		else if (!isPositiveInteger(nbBacMulti)) { showWarning("Nb de bacs par chariot (exp\u00E9dition standard) incorrect"); }
		else if (!isPositiveInteger(nbBacMono)) { showWarning("Nb de bacs par chariot (exp\u00E9dition mono-article) incorrect"); }
		else if (!editBL && !editBP && !editRE && !editPK && !ocl_specEFU) {
			showWarning("Veuillez cocher au moins une des cases 'Editer les bons de pr\u00E9paration' ou 'Editer les bons de livraison'");
		}
		else if (!editBL && !editBP && ocl_specEFU && !editFC) {
			showWarning("Veuillez cocher au moins une des cases 'Editer les bons de pr\u00E9paration' ou 'Editer les bons de livraison' ou 'Editer les factures'");
		}
		else {
			var qSave;

			if (!isEmpty(ocl_currentConfigId)) {
				qSave = new QueryHttp("Config/gc/expeditions/updateConfigExpedition.tmpl");
				qSave.setParam("Config_Id", ocl_currentConfigId);
			}
			else {
				qSave = new QueryHttp("Config/gc/expeditions/createConfigExpedition.tmpl");
			}

			qSave.setParam('Intitule', intitule);
			qSave.setParam('Type_Config', typeConfig);
			qSave.setParam('Edit_BP', editBP);
			qSave.setParam('Edit_PK', editPK);
			qSave.setParam('Edit_BL', editBL);
			qSave.setParam('Gen_FC', genFC);
			qSave.setParam('Edit_FC', editFC);
			qSave.setParam('Edit_Etiq', editEtiq);
			qSave.setParam('Edit_RE', editRE);
			qSave.setParam('Nb_Bac_Multi', nbBacMulti);
			qSave.setParam('Nb_Bac_Mono', nbBacMono);
			qSave.setParam('Groupement_Client', groupementClient);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ocl_listerConfigsExpedition();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ocl_supprimerConfigExpedition() {
	try {

		if (!isEmpty(ocl_currentConfigId) && window.confirm("Confirmez-vous la suppression de la configuration s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/expeditions/deleteConfigExpedition.tmpl");
			qDelete.setParam("Config_Id", ocl_currentConfigId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ocl_listerConfigsExpedition();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ocl_checkEXLGenFC() {
	try {

		var chkCreerFacture = document.getElementById('ocl-genFC').checked;
		document.getElementById('ocl-editFC').disabled = !chkCreerFacture;
		if (!chkCreerFacture) {
			document.getElementById('ocl-editFC').checked = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ocl_nouveauTrancheVolume() {
	try {

		ocl_trancheId = "";
		document.getElementById("ocl-volumeDebutTV").value = "";
		document.getElementById("ocl-volumeFinTV").value = "";
		document.getElementById("ocl-nbBacTV").value = "";
		document.getElementById("ocl-bSupprimerTV").disabled = true;
		ocl_aTranchesVolume.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function ocl_enregistrerTrancheVolume() {
	try {

		var volumeDebut = document.getElementById("ocl-volumeDebutTV").value;
		var volumeFin = document.getElementById("ocl-volumeFinTV").value;
		var nbBac = document.getElementById("ocl-nbBacTV").value;

		if (!isPositiveOrNull(volumeDebut)) { showWarning("Volume d\u00E9but incorrect"); }
		else if (!isEmpty(volumeFin) && !isPositive(volumeFin)) { showWarning("Volume fin incorrect"); }
		else if (!isPositiveInteger(nbBac)) { showWarning("Nombre de bacs incorrect"); }
		else if (!isEmpty(volumeFin) && parseFloat(volumeDebut)>=parseFloat(volumeFin)) { showWarning("Volume de fin incorrect") }
		else {
			var qSave;

			if (isEmpty(ocl_trancheId)) {
				qSave = new QueryHttp("Config/gc/expeditions/createTrancheVolumeConfigExpedition.tmpl");
				qSave.setParam("Config_Id", ocl_currentConfigId);
			}
			else {
				qSave = new QueryHttp("Config/gc/expeditions/updateTrancheVolumeConfigExpedition.tmpl");
				qSave.setParam("Tranche_Id", ocl_trancheId);
			}

			qSave.setParam("Volume_Debut", volumeDebut);
			qSave.setParam("Volume_Fin", volumeFin);
			qSave.setParam("Nb_Bac", nbBac);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ocl_aTranchesVolume.initTree();
			ocl_nouveauTrancheVolume();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ocl_supprimerTrancheVolume() {
	try {

		var qDelete = new QueryHttp("Config/gc/expeditions/deleteTrancheVolumeConfigExpedition.tmpl");
		qDelete.setParam("Tranche_Id", ocl_trancheId);
		qDelete.execute();

		ocl_aTranchesVolume.initTree();
		ocl_nouveauTrancheVolume();

	} catch (e) {
		recup_erreur(e);
	}
}


function ocl_pressOnListeTrancheVolume() {
	try {

		if (ocl_aTranchesVolume.isSelected()) {
			ocl_trancheId = ocl_aTranchesVolume.getSelectedCellText("ocl-colTrancheIdTV");
			document.getElementById("ocl-volumeDebutTV").value = ocl_aTranchesVolume.getSelectedCellText("ocl-colVolumeDebutTV");
			document.getElementById("ocl-volumeFinTV").value = ocl_aTranchesVolume.getSelectedCellText("ocl-colVolumeFinTV");
			document.getElementById("ocl-nbBacTV").value = ocl_aTranchesVolume.getSelectedCellText("ocl-colNbBacTV");
			document.getElementById("ocl-bSupprimerTV").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
