/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var orbt_aMotifsRemboursement = new Arbre("Config/gc/list-motifRemboursement.tmpl", "orbt-listeMotifsRemboursement");

var orbt_currentMotifId = "";



function orbt_init() {
	try {

		orbt_listerMotifsRemboursement();

	} catch (e) {
    recup_erreur(e);
  }
}


function orbt_listerMotifsRemboursement() {
	try {

		orbt_aMotifsRemboursement.setParam("Actif", document.getElementById("orbt-filtreActif").checked);
		orbt_aMotifsRemboursement.initTree();
		orbt_nouveauMotifRemboursement();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_nouveauMotifRemboursement() {
	try {

		orbt_currentMotifId = "";
		orbt_aMotifsRemboursement.clearSelection();

		document.getElementById('orbt-libelle').value = "";
		document.getElementById('orbt-actifC').checked = true;
		document.getElementById('orbt-actifF').checked = true;

		document.getElementById('orbt-bSupprimer').collapsed = true;
		document.getElementById('orbt-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function orbt_chargerMotifRemboursement() {
	try {

		if (orbt_aMotifsRemboursement.isSelected()) {
			orbt_currentMotifId = orbt_aMotifsRemboursement.getSelectedCellText("orbt-colMotifId");

			var qLoad = new QueryHttp("Config/gc/loadMotifRemboursement.tmpl");
			qLoad.setParam("Motif_Id", orbt_currentMotifId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('orbt-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('orbt-actifC').checked = contenu.getAttribute('Actif_C')=="true";
				document.getElementById('orbt-actifF').checked = contenu.getAttribute('Actif_F')=="true";

				document.getElementById('orbt-bSupprimer').collapsed = false;
				document.getElementById('orbt-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_enregistrerMotifRemboursement() {
	try {

		var libelle = document.getElementById('orbt-libelle').value;
		var actifC = document.getElementById('orbt-actifC').checked;
		var actifF = document.getElementById('orbt-actifF').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(orbt_currentMotifId)) {
				qSave = new QueryHttp("Config/gc/updateMotifRemboursement.tmpl");
				qSave.setParam("Motif_Id", orbt_currentMotifId);
			}
			else {
				qSave = new QueryHttp("Config/gc/createMotifRemboursement.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif_C", actifC);
			qSave.setParam("Actif_F", actifF);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				orbt_listerMotifsRemboursement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function orbt_supprimerMotifRemboursement() {
	try {

		if (!isEmpty(orbt_currentMotifId) && window.confirm("Confirmez-vous la suppression du motif de remboursement s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/deleteMotifRemboursement.tmpl");
			qDelete.setParam("Motif_Id", orbt_currentMotifId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				orbt_listerMotifsRemboursement();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
