/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ods_aDepotsStock = new Arbre('Config/globale/list-depotStock.tmpl', 'ods-listeDepotsStock');

var ods_currentDepotId = "";
var ods_actEmplacements;



function ods_init() {
	try {

		var accMWM = getProfil().isAccMWM();

		var config = getResetConfig();
		ods_actEmplacements = config.isActEmplacements();

		document.getElementById('ods-bRechercherEmpArticle').collapsed = !ods_actEmplacements;
		document.getElementById('ods-rowDefEmpRetour').collapsed = !ods_actEmplacements;

		ods_filtrerDepotStock();

		var aConfExp = new Arbre('ComboListe/combo-configExpedition.tmpl', 'ods-exlConfig');
		aConfExp.initTree(ods_chargerPays);

		document.getElementById("ods-rowEtapePickingBLCC").collapsed = !adminMode || !accMWM;
		document.getElementById("ods-rowEtapePickingBLTS").collapsed = !adminMode || !accMWM;

	} catch (e) {
    recup_erreur(e);
  }
}


function ods_chargerPays() {
	try {

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "ods-codePays");
		aPays.initTree(ods_nouveauDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_filtrerDepotStock() {
	try {

		ods_aDepotsStock.setParam("Actif", document.getElementById("ods-filtreActif").checked);
		ods_aDepotsStock.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function ods_nouveauDepot() {
	try {

		ods_aDepotsStock.clearSelection();
		ods_currentDepotId = "";

		document.getElementById('ods-codeDepot').value = "";
		document.getElementById('ods-intitule').value = "";
		document.getElementById('ods-typeDepot').value = "E";
		document.getElementById('ods-logisticien').value = "";
		document.getElementById('ods-revendeur').value = "";
		ods_pressOnTypeDepot();
		document.getElementById('ods-tel').value = "";
		document.getElementById('ods-fax').value = "";
		document.getElementById('ods-email').value = "";
		document.getElementById('ods-actif').checked = true;
		document.getElementById('ods-denomination').value = "";
		document.getElementById('ods-adresse1').value = "";
		document.getElementById('ods-adresse2').value = "";
		document.getElementById('ods-adresse3').value = "";
		document.getElementById('ods-codePostal').value = "";
		document.getElementById('ods-ville').value = "";
		document.getElementById('ods-codePays').value = "FR";
		document.getElementById('ods-exlConfig').value = "";
		document.getElementById('ods-defEmpArticle').value = "";
		document.getElementById('ods-defEmpRetour').value = "";
		document.getElementById('ods-etapeRangementCF').value = "";
		document.getElementById('ods-etapeRangementTS').value = "";
		document.getElementById('ods-etapeRangementRF').value = "";
		document.getElementById('ods-etapePickingBLCC').value = "";
		document.getElementById('ods-etapePickingBLTS').value = "";
		document.getElementById('ods-etapePrepaBLCC').value = "";
		document.getElementById('ods-etapePrepaBLTS').value = "";
		document.getElementById('ods-etapePrepaBLRF').value = "";

		document.getElementById('ods-gridDefEmp').collapsed = true;

		document.getElementById('ods-bSupprimer').collapsed = true;
		document.getElementById('ods-bNouveau').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_chargerDepot() {
	try {

		if (ods_aDepotsStock.isSelected()) {
			ods_currentDepotId = ods_aDepotsStock.getSelectedCellText('ods-colDepotId');

			var qLoad = new QueryHttp("Config/globale/loadDepotStock.tmpl");
			qLoad.setParam("Depot_Id", ods_currentDepotId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ods-codeDepot').value = contenu.getAttribute("Code_Depot");
				document.getElementById('ods-intitule').value = contenu.getAttribute("Intitule");
				document.getElementById('ods-typeDepot').value = contenu.getAttribute("Type_Depot");
				document.getElementById('ods-logisticien').value = contenu.getAttribute("Logisticien");
				document.getElementById('ods-revendeur').value = contenu.getAttribute("Revendeur");
				ods_pressOnTypeDepot();
				document.getElementById('ods-tel').value = contenu.getAttribute("Tel");
				document.getElementById('ods-fax').value = contenu.getAttribute("Fax");
				document.getElementById('ods-email').value = contenu.getAttribute("Email");
				document.getElementById('ods-actif').checked = contenu.getAttribute("Actif")=="true";
				document.getElementById('ods-denomination').value = contenu.getAttribute("Denomination");
				document.getElementById('ods-adresse1').value = contenu.getAttribute("Adresse_1");
				document.getElementById('ods-adresse2').value = contenu.getAttribute("Adresse_2");
				document.getElementById('ods-adresse3').value = contenu.getAttribute("Adresse_3");
				document.getElementById('ods-codePostal').value = contenu.getAttribute("Code_Postal");
				document.getElementById('ods-ville').value = contenu.getAttribute("Ville");
				document.getElementById('ods-codePays').value = contenu.getAttribute("Code_Pays");
				document.getElementById('ods-exlConfig').value = contenu.getAttribute("EXL_Config");
				document.getElementById('ods-defEmpArticle').value = contenu.getAttribute("Def_Emp_Article");
				document.getElementById('ods-defEmpRetour').value = contenu.getAttribute("Def_Emp_Retour");
				document.getElementById('ods-etapeRangementCF').value = contenu.getAttribute("Etape_Rangement_CF");
				document.getElementById('ods-etapeRangementTS').value = contenu.getAttribute("Etape_Rangement_TS");
				document.getElementById('ods-etapeRangementRF').value = contenu.getAttribute("Etape_Rangement_RF");
				document.getElementById('ods-etapePickingBLCC').value = contenu.getAttribute("Etape_Picking_BL_CC");
				document.getElementById('ods-etapePickingBLTS').value = contenu.getAttribute("Etape_Picking_BL_TS");
				document.getElementById('ods-etapePrepaBLCC').value = contenu.getAttribute("Etape_Prepa_BL_CC");
				document.getElementById('ods-etapePrepaBLTS').value = contenu.getAttribute("Etape_Prepa_BL_TS");
				document.getElementById('ods-etapePrepaBLRF').value = contenu.getAttribute("Etape_Prepa_BL_RF");

				document.getElementById('ods-gridDefEmp').collapsed = false;

				document.getElementById('ods-bSupprimer').collapsed = false;
				document.getElementById('ods-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_enregistrerDepot() {
	try {

		var codeDepot = document.getElementById('ods-codeDepot').value;
		var intitule = document.getElementById('ods-intitule').value;
		var typeDepot = document.getElementById('ods-typeDepot').value;
		var tel = document.getElementById('ods-tel').value;
		var fax = document.getElementById('ods-fax').value;
		var email = document.getElementById('ods-email').value;
		var actif = document.getElementById('ods-actif').checked;
		var denomination = document.getElementById('ods-denomination').value;
		var adresse1 = document.getElementById('ods-adresse1').value;
		var adresse2 = document.getElementById('ods-adresse2').value;
		var adresse3 = document.getElementById('ods-adresse3').value;
		var codePostal = document.getElementById('ods-codePostal').value;
		var ville = document.getElementById('ods-ville').value;
		var codePays = document.getElementById('ods-codePays').value;
		var logisticien = document.getElementById('ods-logisticien').value;
		var revendeur = document.getElementById('ods-revendeur').value;
		var exlConfig = document.getElementById('ods-exlConfig').value;
		var defEmpArticle = document.getElementById('ods-defEmpArticle').value;
		var defEmpRetour = document.getElementById('ods-defEmpRetour').value;
		var etapeRangementCF = document.getElementById('ods-etapeRangementCF').value;
		var etapeRangementTS = document.getElementById('ods-etapeRangementTS').value;
		var etapeRangementRF = document.getElementById('ods-etapeRangementRF').value;
		var etapePickingBLCC = document.getElementById('ods-etapePickingBLCC').value;
		var etapePickingBLTS = document.getElementById('ods-etapePickingBLTS').value;
		var etapePrepaBLCC = document.getElementById('ods-etapePrepaBLCC').value;
		var etapePrepaBLTS = document.getElementById('ods-etapePrepaBLTS').value;
		var etapePrepaBLRF = document.getElementById('ods-etapePrepaBLRF').value;

		if (isEmpty(codeDepot)) { showWarning("Veuillez saisir le code d\u00E9p\u00F4t."); }
		else if (!isCleAlpha(codeDepot)) { showWarning("Le code d\u00E9p\u00F4t ne doit pas contenir d'accents ni de caract\u00E8res sp\u00E9ciaux.") }
		else if (isEmpty(intitule)) { showWarning("Veuillez saisir l'intitul\u00E9."); }
		else if (typeDepot=="L" && isEmpty(logisticien)) { showWarning("Veuillez choisir un logisticien."); }
		else if (typeDepot=="V" && isEmpty(revendeur)) { showWarning("Veuillez choisir un revendeur."); }
		else if (!isEmpty(tel) && !isPhone(tel)) { showWarning("Le t\u00E9l\u00E9phone est incorrect."); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le fax est incorrect."); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'e-mail est incorrect."); }
		else if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination."); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez saisir l'adresse."); }
		else if (isEmpty(ville)) { showWarning("Veuillez saisir la ville."); }
		else {

			var qSave;

			if (isEmpty(ods_currentDepotId)) {
				qSave = new QueryHttp("Config/globale/createDepotStock.tmpl");
			}
			else {
				if (ods_actEmplacements && !isEmpty(defEmpArticle)) {
					var emplacementId = ods_getEmplacementId(defEmpArticle);

					if (isEmpty(emplacementId) && window.confirm("L'emplacement pour la cr\u00E9ation d'article n'existe pas, voulez-vous le cr\u00E9er ?")) {
						var url = "chrome://opensi/content/facturation/user/emplacements/popup-creationEmplacement.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', null, ods_currentDepotId, defEmpArticle);
					}
				}

				if (ods_actEmplacements && !isEmpty(defEmpRetour)) {
					var emplacementId = ods_getEmplacementId(defEmpRetour);

					if (isEmpty(emplacementId) && window.confirm("L'emplacement pour la r\u00E9ception de retour client n'existe pas, voulez-vous le cr\u00E9er ?")) {
						var url = "chrome://opensi/content/facturation/user/emplacements/popup-creationEmplacement.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', null, ods_currentDepotId, defEmpRetour);
					}
				}

				qSave = new QueryHttp("Config/globale/updateDepotStock.tmpl");
				qSave.setParam("Depot_Id", ods_currentDepotId);
				qSave.setParam("Def_Emp_Article", defEmpArticle);
				qSave.setParam("Def_Emp_Retour", defEmpRetour);
			}

			qSave.setParam("Code_Depot", codeDepot);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Type_Depot", typeDepot);
			if (typeDepot=="L") { qSave.setParam("Logisticien", logisticien); }
			else if (typeDepot=="V") { qSave.setParam("Revendeur", revendeur); }
			qSave.setParam("Tel", tel);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Actif", actif);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("EXL_Config", exlConfig);
			qSave.setParam("Etape_Rangement_CF", etapeRangementCF);
			qSave.setParam("Etape_Rangement_TS", etapeRangementTS);
			qSave.setParam("Etape_Rangement_RF", etapeRangementRF);
			qSave.setParam("Etape_Picking_BL_CC", etapePickingBLCC);
			qSave.setParam("Etape_Picking_BL_TS", etapePickingBLTS);
			qSave.setParam("Etape_Prepa_BL_CC", etapePrepaBLCC);
			qSave.setParam("Etape_Prepa_BL_TS", etapePrepaBLTS);
			qSave.setParam("Etape_Prepa_BL_RF", etapePrepaBLRF);

			var result = qSave.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var message = result.responseXML.documentElement.getAttribute('Message');
				if (message!=null) {
					showWarning(message);
				}
				ods_filtrerDepotStock();
				ods_nouveauDepot();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_supprimerDepot() {
	try {

		if (window.confirm("Voulez-vous supprimer le d\u00E9p\u00F4t s\u00E9lectionn\u00E9 ?")) {
			var qDelete = new QueryHttp("Config/globale/deleteDepotStock.tmpl");
			qDelete.setParam("Depot_Id", ods_currentDepotId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ods_filtrerDepotStock();
				ods_nouveauDepot();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", ods_currentDepotId);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_reporterAdresse() {
	try {

		var typeDepot = document.getElementById('ods-typeDepot').value;
		var logisticien = document.getElementById('ods-logisticien').value;
		var revendeur = document.getElementById('ods-revendeur').value;

		if (typeDepot=="L" && isEmpty(logisticien)) { showWarning("Veuillez d'abord choisir un logisticien."); }
		else if (typeDepot=="V" && isEmpty(revendeur)) { showWarning("Veuillez d'abord choisir un revendeur."); }
		else {
			var qReporterAdr = new QueryHttp("Config/globale/prefillAdresseDepotStock.tmpl");
			qReporterAdr.setParam("Type_Depot", typeDepot);
			if (typeDepot=="L") { qReporterAdr.setParam("Logisticien", logisticien); }
			else if (typeDepot=="V") { qReporterAdr.setParam("Revendeur", revendeur); }
			var result = qReporterAdr.execute();
			var contenu = result.responseXML.documentElement;

			document.getElementById('ods-denomination').value = contenu.getAttribute("Denomination");
			document.getElementById('ods-adresse1').value = contenu.getAttribute("Adresse_1");
			document.getElementById('ods-adresse2').value = contenu.getAttribute("Adresse_2");
			document.getElementById('ods-adresse3').value = contenu.getAttribute("Adresse_3");
			document.getElementById('ods-codePostal').value = contenu.getAttribute("Code_Postal");
			document.getElementById('ods-ville').value = contenu.getAttribute("Ville");
			document.getElementById('ods-codePays').value = contenu.getAttribute("Code_Pays");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ods_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_retourRechercherClient(numClient, clientId) {
	try {

  	document.getElementById('ods-revendeur').value = numClient;

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ods_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

  	document.getElementById('ods-logisticien').value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_pressOnTypeDepot() {
	try {

		var typeDepot = document.getElementById('ods-typeDepot').value;
		document.getElementById('ods-rowLogisticien').collapsed = (typeDepot!="L");
		document.getElementById('ods-rowRevendeur').collapsed = (typeDepot!="V");
		document.getElementById('ods-lblEtapeCC').collapsed = (typeDepot=="L");
		document.getElementById('ods-lblEtapeOL').collapsed = (typeDepot!="L");

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_rechercherEmpArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ods_retourRechercherEmpArticle, ods_currentDepotId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_retourRechercherEmpArticle(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('ods-defEmpArticle').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_rechercherEmpRetour() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ods_retourRechercherEmpRetour, ods_currentDepotId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ods_retourRechercherEmpRetour(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('ods-defEmpRetour').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}
