/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aCptes = new Arbre('Config/globale/list-ventilTVANationalUE.tmpl','tComptes');
var currentChampCompte;



function init() {
  try {

		aCptes.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function affecterComptes() {
	try {

		var listeVentilId = "";
		var nb = 0;

		for (var i=0; i<aCptes.nbLignes(); i++) {
			if (aCptes.getCellValue(i, "colSelect")=="true") {
				nb++;
				listeVentilId += aCptes.getCellText(i, "ColVentil_Id") +",";
			}
  	}

		var compteVente = document.getElementById('Compte_Vente').value;
		var comptePortVente = document.getElementById('Compte_Port_Vente').value;

		if (nb==0) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (isEmpty(compteVente) && isEmpty(comptePortVente)) {
			showWarning("Veuillez s\u00E9lectionner au moins un compte");
		}
		else {

			var qAss = new QueryHttp("Config/globale/assignCpteNatUE.tmpl");

			qAss.setParam('Compte_Vente', compteVente);
			qAss.setParam('Compte_Port_Vente', comptePortVente);
			qAss.setParam('Liste_Ventil_Id', listeVentilId);

			var result = qAss.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('Compte_Vente').value = "";
				document.getElementById('Compte_Port_Vente').value = "";
				aCptes.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aCptes.nbLignes(); i++) {
			aCptes.setCellValue(i, "colSelect", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changerCompte(id, debCompte, titre) {
  try {

  	currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourChangerCompte, debCompte, "G", titre, debCompte, false);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


