/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aCptes = new Arbre('Config/globale/list-tauxTVA.tmpl','tComptes');
var currentChampCompte;



function init() {
  try {

		aCptes.setParam("Zone_UE", true);
		aCptes.setParam("Actif", true);
		aCptes.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function affecterComptes() {
	try {

		var listeTVA = "";
		var nb = 0;

		for (var i=0; i<aCptes.nbLignes(); i++) {
			if (aCptes.getCellValue(i, "colSelect")=="true") {
				nb++;
				listeTVA += aCptes.getCellText(i, "ColCode_TVA") +",";
			}
  	}

		var compteAchat = document.getElementById('Compte_Achat').value;
		var comptePortAchat = document.getElementById('Compte_Port_Achat').value;
		var compteTVAAchat = document.getElementById('Compte_TVA_Achat').value;
		var compteVente = document.getElementById('Compte_Vente').value;
		var comptePortVente = document.getElementById('Compte_Port_Vente').value;
		var compteTVAVente = document.getElementById('Compte_TVA_Vente').value;

		if (nb==0) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (isEmpty(compteAchat) && isEmpty(comptePortAchat) && isEmpty(compteTVAAchat) && isEmpty(compteVente) && isEmpty(comptePortVente) && isEmpty(compteTVAVente)) {
			showWarning("Veuillez s\u00E9lectionner au moins un compte");
		}
		else {

			var qAss = new QueryHttp("Config/globale/assignCpteUE.tmpl");

			qAss.setParam('Compte_Achat', compteAchat);
			qAss.setParam('Compte_Port_Achat', comptePortAchat);
			qAss.setParam('Compte_TVA_Achat', compteTVAAchat);
			qAss.setParam('Compte_Vente', compteVente);
			qAss.setParam('Compte_Port_Vente', comptePortVente);
			qAss.setParam('Compte_TVA_Vente', compteTVAVente);
			qAss.setParam('Liste_Code_TVA', listeTVA);

			var result = qAss.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('Compte_Achat').value = "";
				document.getElementById('Compte_Port_Achat').value = "";
				document.getElementById('Compte_TVA_Achat').value = "";
				document.getElementById('Compte_Vente').value = "";
				document.getElementById('Compte_Port_Vente').value = "";
				document.getElementById('Compte_TVA_Vente').value = "";
				aCptes.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aCptes.nbLignes(); i++) {
			aCptes.setCellValue(i, "colSelect", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changerCompte(id, debCompte, titre) {
  try {

  	currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourChangerCompte, debCompte, "G", titre, debCompte, false);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		  recup_erreur(e);
	}
}


