/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aEvenements = new Arbre("CRM/list-evenementAVenir.tmpl", "evenementsAVenir");
var aTaches = new Arbre("CRM/list-tacheEnCours.tmpl", "listeTacheCours");



function init() {
  try {

		document.getElementById('news').setAttribute("src", "https://connect.opensi.fr/actus-frame");

		initialiserIndicateurs();

		aEvenements.initTree();
		aTaches.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function goToMenu(m) {
  try {

		switch(m) {
			case 1:	 window.location = "chrome://opensi/content/crm/gestion_compte/gestionComptes.xul";									break;
			case 2:  window.location = "chrome://opensi/content/crm/gestion_contacts/gestionContacts.xul";							break;
			case 3:	 window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul";	break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initialiserIndicateurs() {
	try {

		var qIndicateur = new QueryHttp("CRM/getIndicateursCles.tmpl");
		var result = qIndicateur.execute();
		document.getElementById("nbrProjet").value = result.responseXML.documentElement.getAttribute("nbr_Projet");
		document.getElementById("nbrTacheRetard").value = result.responseXML.documentElement.getAttribute("nbrTacheRetard");
		document.getElementById("nbrTacheCours").value = result.responseXML.documentElement.getAttribute("nbrTache");

	} catch (e) {
	 recup_erreur(e);
	}
}


function retourChoixDossier() {
	try {

    window.location = "chrome://opensi/content/crm/menu.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}


function dbClickListeTacheCours() {
	try {

		if (aTaches.isSelected()) {
			var tacheId = aTaches.getSelectedCellText('colTacheId');
			window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul?tacheId="+ tacheId;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function dbClickListeEventsCours() {
	try {

		if (aEvenements.isSelected()) {
			var evenementId = aEvenements.getSelectedCellText('colEvenementId');
			window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul?eventId="+ evenementId;
		}

	} catch (e) {
    recup_erreur(e);
  }
}
