/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oec_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oec-poleActivite");
var oec_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "Login_Resp");
var oec_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "Mode_Reg");
var oec_aEtablissements = new Arbre("ComboListe/combo-etablissements.tmpl", "etablissement");
var oec_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "depot");
var oec_aLignesContrat = new Arbre("Facturation/Abonnements/list-ligneContratAbonnement.tmpl", "articles");
var oec_aEcheancier = new Arbre("Facturation/Abonnements/list-echeanceContratAbonnement.tmpl", "Echeancier");
var oec_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "tarif");

var oec_contratId;
var oec_etatContrat;
var oec_modeleId;
var oec_clientId = "";
var oec_mode;
var oec_modified = false;
var oec_modeTarif;
var oec_assujettiTVA = false;
var oec_codesTvaInactifs = "";
var oec_depotDefaut;
var oec_zoneUE = false;
var oec_editionTTC = false;

var oec_selPoleActivite;
var oec_selTarifVente;
var oec_selResponsable;
var oec_selModeReglement;
var oec_selEtablissement;
var oec_selDepot;

var oec_codeTVAPort;
var oec_tauxTVAPort;
var oec_montantHT = 0;
var oec_montantTTC = 0;

var oec_modeLigne;
var oec_ligneId;
var oec_articleId;
var oec_prixId = "";
var oec_libelle = "";
var oec_typeRistourne = 'P';
var oec_typeRemise = 'P';
var oec_typeRemiseFP = 'P';



function oec_init() {
  try {

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", gEtablissementDefaut);
		var result = qDepotDefaut.execute();
		oec_depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		// onglet Paramtres
		document.getElementById('rowFax').collapsed = !gConfig.isShowFax();

		var aPaysFact = new Arbre("ComboListe/combo-pays.tmpl", "Code_Pays_Fact");
		aPaysFact.initTree();

		var aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "Code_Pays_Liv");
		aPaysLiv.initTree();

		var aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "Code_Pays_Envoi");
		aPaysEnvoi.initTree();

		var aModalitesReg = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "oec-modaliteReglement");
		aModalitesReg.setParam("Type_Tiers", "C");
		aModalitesReg.initTree();

		// onglet Facture type

		oec_modeTarif = gConfig.getModeTarif();
		if (oec_modeTarif=='Q') {
			document.getElementById('lblTarif').collapsed = true;
			document.getElementById('tarif').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_nouveauContrat() {
  try {

		oec_mode = "C";
		oec_clientId = "";
		oec_etatContrat = "A";

		document.getElementById('oec-tabFactureType').collapsed = true;
		document.getElementById('oec-tabEcheancier').collapsed = true;

		document.getElementById('oec-deckContrat').selectedIndex = 0;

		document.getElementById('oec-creation').setAttribute("label", "");
		document.getElementById('oec-modification').setAttribute("label", "");
		document.getElementById('oec-document').setAttribute("label", "");

		document.getElementById('oec-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById("oec-panneau").selectedIndex = 0;
		document.getElementById("oec-tabAdresses").selectedIndex = 0;

		document.getElementById('labelClientFact').value = "";
		document.getElementById('labelClientLiv').value = "";
		document.getElementById('labelClientEnvoi').value = "";

		document.getElementById('Denomination_Fact').value = "";
		document.getElementById('Adresse_1_Fact').value = "";
		document.getElementById('Adresse_2_Fact').value = "";
		document.getElementById('Adresse_3_Fact').value = "";
		document.getElementById('Code_Postal_Fact').value = "";
		document.getElementById('Ville_Fact').value = "";
		document.getElementById('Code_Pays_Fact').value = "FR";

		document.getElementById('Civ_Inter_Fact').selectedIndex = 0;
		document.getElementById('Nom_Inter_Fact').value = "";
		document.getElementById('Prenom_Inter_Fact').value = "";
		document.getElementById('Tel_Inter_1_Fact').value = "";
		document.getElementById('Tel_Inter_2_Fact').value = "";
		document.getElementById('Fax_Inter_Fact').value = "";
		document.getElementById('Email_Inter_Fact').value = "";

		document.getElementById('Denomination_Liv').value = "";
		document.getElementById('Adresse_1_Liv').value = "";
		document.getElementById('Adresse_2_Liv').value = "";
		document.getElementById('Adresse_3_Liv').value = "";
		document.getElementById('Code_Postal_Liv').value = "";
		document.getElementById('Ville_Liv').value = "";
		document.getElementById('Code_Pays_Liv').value = "FR";
		oec_calculerTvaPort();
		oec_selectPaysLiv();

		document.getElementById('Civ_Inter_Liv').selectedIndex = 0;
		document.getElementById('Nom_Inter_Liv').value = "";
		document.getElementById('Prenom_Inter_Liv').value = "";
		document.getElementById('Tel_Inter_1_Liv').value = "";
		document.getElementById('Tel_Inter_2_Liv').value = "";
		document.getElementById('Fax_Inter_Liv').value = "";
		document.getElementById('Email_Inter_Liv').value = "";

		document.getElementById('Denomination_Envoi').value = "";
		document.getElementById('Adresse_1_Envoi').value = "";
		document.getElementById('Adresse_2_Envoi').value = "";
		document.getElementById('Adresse_3_Envoi').value = "";
		document.getElementById('Code_Postal_Envoi').value = "";
		document.getElementById('Ville_Envoi').value = "";
		document.getElementById('Code_Pays_Envoi').value = "FR";

		document.getElementById('Civ_Inter_Envoi').selectedIndex = 0;
		document.getElementById('Nom_Inter_Envoi').value = "";
		document.getElementById('Prenom_Inter_Envoi').value = "";
		document.getElementById('Tel_Inter_1_Envoi').value = "";
		document.getElementById('Tel_Inter_2_Envoi').value = "";
		document.getElementById('Fax_Inter_Envoi').value = "";
		document.getElementById('Email_Inter_Envoi').value = "";

		document.getElementById('Remise').value = "0.00";
		document.getElementById('Escompte').value = "0.00";
		document.getElementById('Frais_Port').value = "0.00";
		document.getElementById('RemiseFP').value = "0.00";

		document.getElementById('MontantHT').value = "0.00";
		document.getElementById('MontantRemise').value = "0.00";
		document.getElementById('MontantFrais_Port').value = "0.00";
		document.getElementById('MontantRemiseFP').value = "0.00";
		document.getElementById('TotalHT').value = "0.00";
		document.getElementById('TVA').value = "0.00";
		document.getElementById('MontantEscompte').value = "0.00";
		document.getElementById('TotalTTC').value = "0.00";

		document.getElementById('rowRemiseHT').collapsed = true;
		document.getElementById('rowRemiseFPHT').collapsed = true;
		document.getElementById('rowEscompteHT').collapsed = true;

		document.getElementById('pttcMontantRemise').value = "0.00";
		document.getElementById('pttcMontantFrais_Port').value = "0.00";
		document.getElementById('pttcMontantRemiseFP').value = "0.00";
		document.getElementById('pttcTVA').value = "0.00";
		document.getElementById('pttcMontantTTC').value = "0.00";
		document.getElementById('pttcMontantEscompte').value = "0.00";
		document.getElementById('pttcTotalTTC').value = "0.00";
		document.getElementById('pttcNetTTC').value = "0.00";

		document.getElementById('rowRemiseTTC').collapsed = true;
		document.getElementById('rowRemiseFPTTC').collapsed = true;
		document.getElementById('rowEscompteTTC').collapsed = true;

		document.getElementById('rowNetCommercialHT').collapsed = true;
		document.getElementById('rowEscompteTTC').collapsed = true;
		document.getElementById('pttcNetCommercial').value = "0.00";
		document.getElementById('NetCommercial').value = "0.00";

		document.getElementById("oec-numContrat").value = "";
		document.getElementById("oec-dateContrat").value = "";
		document.getElementById("oec-etatContrat").value = "";
		document.getElementById("oec-dateDebutAbt").value = "";
		document.getElementById("oec-dateFinAbt").value = "";
		document.getElementById("oec-assujettiTVA").checked = false;
		document.getElementById("oec-numeroTVA").value = "";

		document.getElementById('oec-intitule').disabled = false;
		document.getElementById('oec-periodicite').disabled = false;
		document.getElementById('oec-typePeriodicite').disabled = false;
		document.getElementById('oec-dureeContrat').disabled = false;
		document.getElementById('oec-typeDureeContrat').disabled = false;
		document.getElementById('oec-dureeReconduction').disabled = false;
		document.getElementById('oec-typeDureeReconduction').disabled = false;
		document.getElementById('oec-dateDebutAbt').disabled = false;
		document.getElementById('oec-poleActivite').disabled = false;
		document.getElementById('oec-typeReconduction').disabled = false;
		document.getElementById('oec-delaiPreavis').disabled = false;
		document.getElementById('oec-delaiGeneration').disabled = false;
		document.getElementById('oec-nbPeriodeOfferte').disabled = false;
		document.getElementById('oec-modaliteReglement').disabled = false;
		document.getElementById('oec-termeFacturation').disabled = false;
		document.getElementById('oec-pEvolRecond').disabled = false;
		document.getElementById('oec-assujettiTVA').disabled = false;
		document.getElementById('oec-numeroTVA').disabled = true;
		document.getElementById("chercher_client").disabled = false;
		document.getElementById("chercher_adrfact").disabled = false;
		document.getElementById("chercher_inter").disabled = false;
		document.getElementById("bCopierFactVersLivEnvoi").disabled = false;
		document.getElementById("chercher_adrliv").disabled = false;
		document.getElementById("chercher_inter_liv").disabled = false;
		document.getElementById("chercher_adrEnvoi").disabled = false;
		document.getElementById("chercher_inter_envoi").disabled = false;

		document.getElementById("Denomination_Fact").removeAttribute('readonly');
		document.getElementById("Adresse_1_Fact").removeAttribute('readonly');
		document.getElementById("Adresse_2_Fact").removeAttribute('readonly');
		document.getElementById("Adresse_3_Fact").removeAttribute('readonly');
		document.getElementById("Code_Postal_Fact").removeAttribute('readonly');
		document.getElementById("Ville_Fact").removeAttribute('readonly');
    document.getElementById("Code_Pays_Fact").disabled = false;
		document.getElementById("Civ_Inter_Fact").disabled = false;
		document.getElementById("Nom_Inter_Fact").removeAttribute('readonly');
		document.getElementById("Prenom_Inter_Fact").removeAttribute('readonly');
		document.getElementById("Tel_Inter_1_Fact").removeAttribute('readonly');
		document.getElementById("Tel_Inter_2_Fact").removeAttribute('readonly');
		document.getElementById("Fax_Inter_Fact").removeAttribute('readonly');
		document.getElementById("Email_Inter_Fact").removeAttribute('readonly');

		document.getElementById("Denomination_Liv").removeAttribute('readonly');
		document.getElementById("Adresse_1_Liv").removeAttribute('readonly');
		document.getElementById("Adresse_2_Liv").removeAttribute('readonly');
		document.getElementById("Adresse_3_Liv").removeAttribute('readonly');
		document.getElementById("Code_Postal_Liv").removeAttribute('readonly');
		document.getElementById("Ville_Liv").removeAttribute('readonly');
		document.getElementById('Code_Pays_Liv').disabled = false;
    document.getElementById("Civ_Inter_Liv").disabled = false;
		document.getElementById("Nom_Inter_Liv").removeAttribute('readonly');
		document.getElementById("Prenom_Inter_Liv").removeAttribute('readonly');
		document.getElementById("Tel_Inter_1_Liv").removeAttribute('readonly');
		document.getElementById("Tel_Inter_2_Liv").removeAttribute('readonly');
		document.getElementById("Fax_Inter_Liv").removeAttribute('readonly');
		document.getElementById("Email_Inter_Liv").removeAttribute('readonly');

		document.getElementById("Denomination_Envoi").removeAttribute('readonly');
		document.getElementById("Adresse_1_Envoi").removeAttribute('readonly');
		document.getElementById("Adresse_2_Envoi").removeAttribute('readonly');
		document.getElementById("Adresse_3_Envoi").removeAttribute('readonly');
		document.getElementById("Code_Postal_Envoi").removeAttribute('readonly');
		document.getElementById("Ville_Envoi").removeAttribute('readonly');
    document.getElementById("Code_Pays_Envoi").disabled = false;
    document.getElementById("Civ_Inter_Envoi").disabled = false;
		document.getElementById("Nom_Inter_Envoi").removeAttribute('readonly');
		document.getElementById("Prenom_Inter_Envoi").removeAttribute('readonly');
		document.getElementById("Tel_Inter_1_Envoi").removeAttribute('readonly');
		document.getElementById("Tel_Inter_2_Envoi").removeAttribute('readonly');
		document.getElementById("Fax_Inter_Envoi").removeAttribute('readonly');
		document.getElementById("Email_Inter_Envoi").removeAttribute('readonly');

		oec_codesTvaInactifs = "";

		var qLoad = new QueryHttp("Facturation/Abonnements/loadModeleAbonnement.tmpl");
		qLoad.setParam("Modele_Id", oec_modeleId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourMenuContrats();
		}
		else {
			var contenu = result.responseXML.documentElement;

			oec_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
			document.getElementById('oec-refModele').value = contenu.getAttribute('Ref_Modele');
			document.getElementById('oec-intitule').value = contenu.getAttribute('Intitule');
			document.getElementById('oec-periodicite').value = contenu.getAttribute('Periodicite');
			document.getElementById('oec-typePeriodicite').value = contenu.getAttribute('Type_Periodicite');
			document.getElementById('oec-dureeContrat').value = contenu.getAttribute('Duree_Contrat');
			document.getElementById('oec-typeDureeContrat').value = contenu.getAttribute('Type_Duree_Contrat');
			document.getElementById('oec-dureeReconduction').value = contenu.getAttribute('Duree_Reconduction');
 			document.getElementById('oec-typeDureeReconduction').value = contenu.getAttribute('Type_Duree_Reconduction');
			document.getElementById('oec-typeReconduction').value = contenu.getAttribute('Type_Reconduction');
			document.getElementById('reconduireAbonnement').collapsed = (document.getElementById('oec-typeReconduction').value=="T");

			document.getElementById('oec-delaiPreavis').value = contenu.getAttribute('Delai_Preavis');
			document.getElementById('oec-pEvolRecond').value = contenu.getAttribute('PEvol_Recond');
			document.getElementById('oec-delaiGeneration').value = contenu.getAttribute('Delai_Generation');
			document.getElementById('oec-nbPeriodeOfferte').value = contenu.getAttribute('Nb_Periode_Offerte');

			oec_editionTTC = contenu.getAttribute('Edition_TTC')=="true";

			document.getElementById('oec-termeFacturation').value = contenu.getAttribute('Terme_Facturation');
			document.getElementById('oec-modaliteReglement').value = contenu.getAttribute('Modalite_Id');

			document.getElementById('chercher_client').disabled = false;

			oec_chargerResponsables(contenu.getAttribute('Util_R'));
			oec_chargerEtablissements(gEtablissementDefaut);
			oec_chargerDepots(oec_depotDefaut);
			oec_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
			oec_chargerModesReglement(contenu.getAttribute('Mode_reglement'));

			oec_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
			document.getElementById('Remise').value = (oec_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
			document.getElementById('bRemise').setAttribute("class", (oec_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

			oec_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
			document.getElementById('RemiseFP').value = (oec_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
			document.getElementById('bRemiseFP').setAttribute("class", (oec_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

			document.getElementById('Frais_Port').value = contenu.getAttribute('Frais_Port');
			document.getElementById('Escompte').value = contenu.getAttribute('Escompte');

			document.getElementById('oec-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
			document.getElementById('oec-commentairesInt').value = contenu.getAttribute('Commentaires_Int');

			oec_aLignesContrat.deleteTree();

			// insertion des lignes du modle afin que les totaux puissent se calculer et ainsi que les ventuelles remises soient cohrentes pour l'enregistrement du contrat

			var aLignesModele = new Arbre("Facturation/Abonnements/list-ligneModeleAbonnement.tmpl", "articles");
			aLignesModele.setParam("Modele_Id", oec_modeleId);
			aLignesModele.initTree(oec_changerTypeEdition);

			oec_initBoutons(0);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_chargerContrat() {
  try {

		oec_mode = "M";
		document.getElementById('oec-deckContrat').selectedIndex = 0;

		var qLoad = new QueryHttp("Facturation/Abonnements/loadContratAbonnement.tmpl");
		qLoad.setParam("Contrat_Id", oec_contratId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			oec_modeleId = contenu.getAttribute('Modele_Id');
			oec_clientId = contenu.getAttribute('Client_Id');
			oec_etatContrat = contenu.getAttribute('Etat');

			document.getElementById('oec-etatContrat').value = contenu.getAttribute('Lib_Etat');

			document.getElementById('oec-creation').label = "Contrat d'abonnement cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur');
			document.getElementById('oec-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
			document.getElementById('oec-document').label = "Contrat N\u00B0 "+ contenu.getAttribute('Num_Contrat');

			document.getElementById('oec-tabFactureType').collapsed = false;
			document.getElementById('oec-tabEcheancier').collapsed = false;

			document.getElementById('oec-bOuvrirCommentairesCaches').disabled = false;

			oec_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
			document.getElementById('oec-numContrat').value = contenu.getAttribute('Num_Contrat');
			document.getElementById('oec-numContrat').collapsed = false;
			document.getElementById('oec-dateContrat').value = contenu.getAttribute('Date_Contrat');
			document.getElementById('oec-refModele').value = contenu.getAttribute('Ref_Modele');
			document.getElementById('oec-intitule').value = contenu.getAttribute('Intitule');
			document.getElementById('oec-periodicite').value = contenu.getAttribute('Periodicite');
			document.getElementById('oec-typePeriodicite').value = contenu.getAttribute('Type_Periodicite');
			document.getElementById('oec-dureeContrat').value = contenu.getAttribute('Duree_Contrat');
			document.getElementById('oec-typeDureeContrat').value = contenu.getAttribute('Type_Duree_Contrat');
			document.getElementById('oec-dureeReconduction').value = contenu.getAttribute('Duree_Reconduction');
 			document.getElementById('oec-typeDureeReconduction').value=contenu.getAttribute('Type_Duree_Reconduction');
			document.getElementById('oec-dateDebutAbt').value = contenu.getAttribute('Date_Debut_Abt');
			document.getElementById('oec-dateFinAbt').value = contenu.getAttribute('Date_Fin_Abt');
			document.getElementById('oec-typeReconduction').value = contenu.getAttribute('Type_Reconduction');
			document.getElementById('reconduireAbonnement').collapsed = document.getElementById('oec-typeReconduction').value=="T";

			document.getElementById('oec-delaiPreavis').value = contenu.getAttribute('Delai_Preavis');
			document.getElementById('oec-pEvolRecond').value = contenu.getAttribute('PEvol_Recond');
			document.getElementById('oec-delaiGeneration').value = contenu.getAttribute('Delai_Generation');
			document.getElementById('oec-nbPeriodeOfferte').value = contenu.getAttribute('Nb_Periode_Offerte');
			document.getElementById('oec-termeFacturation').value = contenu.getAttribute('Terme_Facturation');
			document.getElementById('oec-modaliteReglement').value = contenu.getAttribute('Modalite_Id');

			document.getElementById('Denomination_Fact').value = contenu.getAttribute('Denomination');
			document.getElementById('Adresse_1_Fact').value = contenu.getAttribute('Adresse_1');
			document.getElementById('Adresse_2_Fact').value = contenu.getAttribute('Adresse_2');
			document.getElementById('Adresse_3_Fact').value = contenu.getAttribute('Adresse_3');
			document.getElementById('Code_Postal_Fact').value = contenu.getAttribute('Code_Postal');
			document.getElementById('Ville_Fact').value = contenu.getAttribute('Ville');
			document.getElementById('Code_Pays_Fact').value = contenu.getAttribute('Code_Pays');

			document.getElementById('Denomination_Liv').value = contenu.getAttribute('Denomination_Liv');
			document.getElementById('Adresse_1_Liv').value = contenu.getAttribute('Adresse_1_Liv');
			document.getElementById('Adresse_2_Liv').value = contenu.getAttribute('Adresse_2_Liv');
			document.getElementById('Adresse_3_Liv').value = contenu.getAttribute('Adresse_3_Liv');
			document.getElementById('Code_Postal_Liv').value = contenu.getAttribute('Code_Postal_Liv');
			document.getElementById('Ville_Liv').value = contenu.getAttribute('Ville_Liv');
			document.getElementById('Code_Pays_Liv').value = contenu.getAttribute('Code_Pays_Liv');

    	oec_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
    	oec_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');
			oec_assujettiTVA = contenu.getAttribute("Assujetti_TVA")=="true";
			oec_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

			oec_calculerTvaPort();
			oec_selectPaysLiv();

			document.getElementById('Civ_Inter_Fact').value = contenu.getAttribute('Civ_Inter');
			document.getElementById('Nom_Inter_Fact').value = contenu.getAttribute('Nom_Inter');
			document.getElementById('Prenom_Inter_Fact').value = contenu.getAttribute('Prenom_Inter');
			document.getElementById('Tel_Inter_1_Fact').value = contenu.getAttribute('Tel_Inter_1');
			document.getElementById('Tel_Inter_2_Fact').value = contenu.getAttribute('Tel_Inter_2');
			document.getElementById('Fax_Inter_Fact').value = contenu.getAttribute('Fax_Inter');
			document.getElementById('Email_Inter_Fact').value = contenu.getAttribute('Email_Inter');

			document.getElementById('Civ_Inter_Liv').value = contenu.getAttribute('Civ_Inter_Liv');
			document.getElementById('Nom_Inter_Liv').value = contenu.getAttribute('Nom_Inter_Liv');
			document.getElementById('Prenom_Inter_Liv').value = contenu.getAttribute('Prenom_Inter_Liv');
			document.getElementById('Tel_Inter_1_Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
			document.getElementById('Tel_Inter_2_Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
			document.getElementById('Fax_Inter_Liv').value = contenu.getAttribute('Fax_Inter_Liv');
			document.getElementById('Email_Inter_Liv').value = contenu.getAttribute('Email_Inter_Liv');

			document.getElementById('Denomination_Envoi').value = contenu.getAttribute('Denomination_Envoi');
			document.getElementById('Adresse_1_Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
			document.getElementById('Adresse_2_Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
			document.getElementById('Adresse_3_Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
			document.getElementById('Code_Postal_Envoi').value = contenu.getAttribute('Code_Postal_Envoi');
			document.getElementById('Ville_Envoi').value = contenu.getAttribute('Ville_Envoi');
			document.getElementById('Code_Pays_Envoi').value = contenu.getAttribute('Code_Pays_Envoi');

			document.getElementById('Civ_Inter_Envoi').value = contenu.getAttribute('Civ_Inter_Envoi');
			document.getElementById('Nom_Inter_Envoi').value = contenu.getAttribute('Nom_Inter_Envoi');
			document.getElementById('Prenom_Inter_Envoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
			document.getElementById('Tel_Inter_1_Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
			document.getElementById('Tel_Inter_2_Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
			document.getElementById('Fax_Inter_Envoi').value = contenu.getAttribute('Fax_Inter_Envoi');
			document.getElementById('Email_Inter_Envoi').value = contenu.getAttribute('Email_Inter_Envoi');

			document.getElementById('oec-assujettiTVA').checked = oec_assujettiTVA;
			document.getElementById('oec-numeroTVA').disabled = !oec_assujettiTVA;
			document.getElementById('oec-numeroTVA').value = contenu.getAttribute("Numero_TVA");

  		var numClient = contenu.getAttribute("Num_Client");

			if (!isEmpty(oec_clientId)) {
				document.getElementById('chercher_client').disabled = true;
				document.getElementById('labelClientFact').value = numClient;
				document.getElementById('labelClientLiv').value = numClient;
				document.getElementById('labelClientEnvoi').value = numClient;
			}
			else {
				document.getElementById('chercher_client').disabled = false;
				document.getElementById('labelClientFact').value = "";
				document.getElementById('labelClientLiv').value = "";
				document.getElementById('labelClientEnvoi').value = "";
			}

			oec_debloquerInterface();

			oec_setModified(false);

			oec_chargerResponsables(contenu.getAttribute('Util_R'));
			oec_chargerEtablissements(contenu.getAttribute('Etab_Id'));
			oec_chargerDepots(contenu.getAttribute('Depot_Id'));
			oec_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
			oec_chargerModesReglement(contenu.getAttribute('Mode_reglement'));

			oec_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
			document.getElementById('Remise').value = (oec_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
			document.getElementById('bRemise').setAttribute("class", (oec_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

			oec_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
			document.getElementById('RemiseFP').value = (oec_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
			document.getElementById('bRemiseFP').setAttribute("class", (oec_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

			document.getElementById('Frais_Port').value = contenu.getAttribute('Frais_Port');
			document.getElementById('Escompte').value = contenu.getAttribute('Escompte');
			document.getElementById('oec-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
			document.getElementById('oec-commentairesInt').value = contenu.getAttribute('Commentaires_Int');

			oec_editionTTC = contenu.getAttribute('Edition_TTC')=="true";
			if (oec_editionTTC) {
				document.getElementById('ColTotal').setAttribute("label", "Total TTC");
				document.getElementById('ColPU').setAttribute("label", "P.U TTC");
				document.getElementById('lblFrais_Port').value = "Frais de port (ttc) :";
				document.getElementById('lblPU').value = "P.U TTC :";
				document.getElementById('piedTTC').collapsed = false;
				document.getElementById('piedHT').collapsed = true;
			}
			else {
				document.getElementById('ColTotal').setAttribute("label", "Total HT");
				document.getElementById('ColPU').setAttribute("label", "P.U HT");
				document.getElementById('lblFrais_Port').value = "Frais de port (ht) :";
				document.getElementById('lblPU').value = "P.U HT :";
				document.getElementById('piedTTC').collapsed = true;
				document.getElementById('piedHT').collapsed = false;
			}

			oec_ajouterLigne("I");

	 		oec_aLignesContrat.setParam("Contrat_Id", oec_contratId);
			oec_aLignesContrat.initTree(oec_calculTotaux);

			oec_initBoutons(document.getElementById("oec-panneau").selectedIndex);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "CA", oec_contratId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oec-commentairesFin').value;
		var commentairesInt = document.getElementById('oec-commentairesInt').value;
		var readOnly = (oec_mode=="V" || oec_etatContrat=="R" || oec_etatContrat=="T");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oec_retourEditerCommentaires, "CA", oec_contratId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oec-commentairesFin').value = commentairesFin;
		document.getElementById('oec-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_initBoutons(page) {
	try {

		if (page==0) {
			document.getElementById('bEnregistrer').collapsed = false;
			document.getElementById('Supprimer').collapsed = (oec_mode=='C');
			document.getElementById('reconduireAbonnement').collapsed=(document.getElementById('oec-typeReconduction').value=="T");
			document.getElementById('ResilierAbonnement').collapsed = (oec_mode=='C');
			document.getElementById('AnnulerResiliation').collapsed = true;
			document.getElementById('oec-bEditerAbonnement').collapsed = (oec_mode=='C');
			oec_disableBouton();
		}
		else if (page==2) {
			document.getElementById('bEnregistrer').collapsed = true;
			document.getElementById('Supprimer').collapsed = true;
			document.getElementById('reconduireAbonnement').collapsed = true;
			document.getElementById('ResilierAbonnement').collapsed = true;
			document.getElementById('AnnulerResiliation').collapsed = true;
			document.getElementById('oec-bEditerAbonnement').collapsed = true;
		}
		else {
			document.getElementById('bEnregistrer').collapsed = false;
			document.getElementById('Supprimer').collapsed = (oec_mode=='C');
			document.getElementById('reconduireAbonnement').collapsed = true;
			document.getElementById('ResilierAbonnement').collapsed = true;
			document.getElementById('AnnulerResiliation').collapsed = true;
			document.getElementById('oec-bEditerAbonnement').collapsed = true;
			oec_disableBouton();
		}

	}	catch(e) {
	  recup_erreur(e);
  }
}


function oec_disableBouton() {
	try {

		if (oec_mode=="C" || (oec_mode=="M" && oec_etatContrat=="A")) {
			document.getElementById('bEnregistrer').disabled = false;
			document.getElementById('Supprimer').disabled = false;
			document.getElementById('reconduireAbonnement').disabled = true;
			document.getElementById('ResilierAbonnement').disabled = true;
			if (oec_mode=="C")
				document.getElementById('oec-bEditerAbonnement').disabled = true;
			else
				document.getElementById('oec-bEditerAbonnement').disabled = false;
		}
		else if (oec_mode=="M" && oec_etatContrat=="R") {
			document.getElementById('bEnregistrer').disabled = true;
			document.getElementById('Supprimer').disabled = true;
			document.getElementById('reconduireAbonnement').disabled = true;
			document.getElementById('ResilierAbonnement').disabled = true;
			document.getElementById('AnnulerResiliation').collapsed = false;
			document.getElementById('oec-bEditerAbonnement').disabled = false;
		}
		else if (oec_mode=="M" && oec_etatContrat=="C") {
			document.getElementById('bEnregistrer').disabled = false;
			document.getElementById('Supprimer').disabled = true;
			document.getElementById('reconduireAbonnement').disabled = false;
			document.getElementById('ResilierAbonnement').disabled = false;
			document.getElementById('oec-bEditerAbonnement').disabled = false;
		}
		else if (oec_mode=="M" && oec_etatContrat=="T") {
			document.getElementById('bEnregistrer').disabled = true;
			document.getElementById('Supprimer').disabled = true;
			document.getElementById('reconduireAbonnement').disabled = false;
			document.getElementById('ResilierAbonnement').disabled = true;
			document.getElementById('oec-bEditerAbonnement').disabled = false;
		}

	}	catch(e) {
	  recup_erreur(e);
  }
}


function oec_setModified(m) {
  try {

		oec_modified = m;

  	if (m) {
			document.getElementById('oec-tabAbonnement').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oec-tabFactureType').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('oec-tabAbonnement').setAttribute('image', null);
			document.getElementById('oec-tabFactureType').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_enregistrerContrat(quit) {
	try {

		var ok = false;

		var intitule = document.getElementById('oec-intitule').value;
		var periodicite = document.getElementById('oec-periodicite').value;
		var typePeriodicite = document.getElementById('oec-typePeriodicite').value;
		var dureeContrat = document.getElementById('oec-dureeContrat').value;
		var typeDureeContrat = document.getElementById('oec-typeDureeContrat').value;
		var dureeReconduction = document.getElementById('oec-dureeReconduction').value;
		var typeDureeReconduction = document.getElementById('oec-typeDureeReconduction').value;
		var dateDebutAbt = document.getElementById('oec-dateDebutAbt').value;
		var typeReconduction = document.getElementById('oec-typeReconduction').value;
		var poleActivite = document.getElementById('oec-poleActivite').value;
		var delaiPreavis = document.getElementById('oec-delaiPreavis').value;
		var pEvolRecond = document.getElementById('oec-pEvolRecond').value;
		var delaiGeneration = document.getElementById('oec-delaiGeneration').value;
		var nbPeriodeOfferte = document.getElementById('oec-nbPeriodeOfferte').value;
		var termeFacturation = document.getElementById('oec-termeFacturation').value;
		var modaliteReglement = document.getElementById('oec-modaliteReglement').value;
		var numeroTVA = document.getElementById('oec-numeroTVA').value;
		var tarifVente = document.getElementById('tarif').value;
		var commentairesFin = document.getElementById('oec-commentairesFin').value;
		var commentairesInt = document.getElementById('oec-commentairesInt').value;
		var modeReglement = document.getElementById('Mode_Reg').value;
		var remise = document.getElementById('Remise').value;
		var remiseFP = document.getElementById('RemiseFP').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var fraisPort = document.getElementById('Frais_Port').value;
		var escompte = document.getElementById('Escompte').value;
		var montantBase = (oec_editionTTC?oec_montantTTC:oec_montantHT);
		var Util_R = document.getElementById('Login_Resp').value;
		var etablissement = document.getElementById('etablissement').value;
		var depot = document.getElementById('depot').value;

		var denomination_fact = document.getElementById('Denomination_Fact').value;
		var adresse_1_fact = document.getElementById('Adresse_1_Fact').value;
		var adresse_2_fact = document.getElementById('Adresse_2_Fact').value;
		var adresse_3_fact = document.getElementById('Adresse_3_Fact').value;
		var code_postal_fact = document.getElementById('Code_Postal_Fact').value;
		var ville_fact = document.getElementById('Ville_Fact').value;
		var code_pays_fact = document.getElementById('Code_Pays_Fact').value;
		var civ_inter_fact = document.getElementById("Civ_Inter_Fact").value;
		var nom_inter_fact = document.getElementById("Nom_Inter_Fact").value;
		var prenom_inter_fact = document.getElementById("Prenom_Inter_Fact").value;
		var telInter1fact = document.getElementById("Tel_Inter_1_Fact").value;
		var telInter2fact = document.getElementById("Tel_Inter_2_Fact").value;
		var fax_inter_fact = document.getElementById('Fax_Inter_Fact').value;
		var email_inter_fact = document.getElementById('Email_Inter_Fact').value;

		var denomination_liv = document.getElementById('Denomination_Liv').value;
		var adresse_1_liv = document.getElementById('Adresse_1_Liv').value;
		var adresse_2_liv = document.getElementById('Adresse_2_Liv').value;
		var adresse_3_liv = document.getElementById('Adresse_3_Liv').value;
		var code_postal_liv = document.getElementById('Code_Postal_Liv').value;
		var ville_liv = document.getElementById('Ville_Liv').value;
		var code_pays_liv = document.getElementById('Code_Pays_Liv').value;
		var civ_inter_liv = document.getElementById("Civ_Inter_Liv").value;
		var nom_inter_liv = document.getElementById("Nom_Inter_Liv").value;
		var prenom_inter_liv = document.getElementById("Prenom_Inter_Liv").value;
		var telInter1liv = document.getElementById("Tel_Inter_1_Liv").value;
		var telInter2liv = document.getElementById("Tel_Inter_2_Liv").value;
		var fax_inter_liv = document.getElementById('Fax_Inter_Liv').value;
		var email_inter_liv = document.getElementById('Email_Inter_Liv').value;

		var denomination_envoi = document.getElementById('Denomination_Envoi').value;
		var adresse_1_envoi = document.getElementById('Adresse_1_Envoi').value;
		var adresse_2_envoi = document.getElementById('Adresse_2_Envoi').value;
		var adresse_3_envoi = document.getElementById('Adresse_3_Envoi').value;
		var code_postal_envoi = document.getElementById('Code_Postal_Envoi').value;
		var ville_envoi = document.getElementById('Ville_Envoi').value;
		var code_pays_envoi = document.getElementById('Code_Pays_Envoi').value;
		var civ_inter_envoi = document.getElementById("Civ_Inter_Envoi").value;
		var nom_inter_envoi = document.getElementById("Nom_Inter_Envoi").value;
		var prenom_inter_envoi = document.getElementById("Prenom_Inter_Envoi").value;
		var telInter1envoi = document.getElementById("Tel_Inter_1_Envoi").value;
		var telInter2envoi = document.getElementById("Tel_Inter_2_Envoi").value;
		var fax_inter_envoi = document.getElementById('Fax_Inter_Envoi').value;
		var email_inter_envoi = document.getElementById('Email_Inter_Envoi').value;

		//oec_codeTVAPort = document.getElementById('oec-codeTVAFraisPort').value;
		oec_tauxTVAPort = getTva(oec_codeTVAPort);

		if (isEmpty(depot)) { showWarning("Veuillez choisir un d\u00E9p\u00F4t de stock."); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement"); }
		else if (isEmpty(remise) || (oec_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects"); }
		else if (isEmpty(remiseFP) || (oec_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect"); }
		else if (isEmpty(intitule)) {showWarning("Vous devez indiquer un intitul\u00E9 avant d'enregistrer l'abonnement (onglet param\u00E8tres abonnement)");}
		else if (isEmpty(periodicite) || !isPositiveOrNull(periodicite)) { showWarning("Vous devez indiquer la p\u00E9riodicit\u00E9 de facturation");}
		else if (isEmpty(dureeContrat) || !isPositiveOrNull(dureeContrat)) { showWarning("Vous devez indiquer la dur\u00E9e du contrat (onglet param\u00E8tres abonnement)");}
		else if (isEmpty(delaiPreavis)|| !isPositiveOrNull(delaiPreavis)) {	showWarning("Vous devez indiquer le d\u00E9lai du pr\u00E9avis (onglet param\u00E8tres abonnement)");}
		else if (isEmpty(pEvolRecond)|| !isTaux(pEvolRecond)) {	showWarning("Vous devez indiquer le pourcentage d'augmentation \u00E0 la reconduction"); }
		else if (isEmpty(delaiGeneration)|| !isPositiveOrNull(delaiGeneration)) {	showWarning("Vous devez indiquer le d\u00E9lai de g\u00E9n\u00E9ration de la facture (onglet param\u00E8tres abonnement)"); }
		else if (isEmpty(denomination_fact)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de facturation"); }
		else if (isEmpty(adresse_1_fact)) { showWarning("Veuillez indiquer l'adresse du client de facturation"); }
		else if (isEmpty(ville_fact)) { showWarning("Veuillez indiquer la ville du client de facturation"); }
		else if (isEmpty(denomination_liv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison"); }
		else if (isEmpty(adresse_1_liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison"); }
		else if (isEmpty(ville_liv)) { showWarning("Veuillez indiquer la ville du client de livraison"); }
		else if (isEmpty(denomination_envoi)) { showWarning("Veuillez indiquer la d\u00E9nomination du client d'envoi"); }
		else if (isEmpty(adresse_1_envoi)) { showWarning("Veuillez indiquer l'adresse du client d'envoi"); }
		else if (isEmpty(ville_envoi)) { showWarning("Veuillez indiquer la ville du client d'envoi"); }
		else if (!isEmpty(telInter1fact) && !isPhone(telInter1fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect"); }
		else if (!isEmpty(telInter2fact) && !isPhone(telInter2fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect"); }
		else if (!isEmpty(fax_inter_fact) && !isPhone(fax_inter_fact)) { showWarning("Num\u00E9ro de fax de facturation incorrect"); }
		else if (!isEmpty(email_inter_fact) && !isEmail(email_inter_fact)) { showWarning("Adresse e-mail de facturation incorrecte"); }
		else if (!isEmpty(telInter1liv) && !isPhone(telInter1liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect"); }
		else if (!isEmpty(telInter2liv) && !isPhone(telInter2liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect"); }
		else if (!isEmpty(fax_inter_liv) && !isPhone(fax_inter_liv)) { showWarning("Num\u00E9ro de fax de livraison incorrect"); }
		else if (!isEmpty(email_inter_liv) && !isEmail(email_inter_liv)) { showWarning("Adresse e-mail de livraison incorrecte"); }
		else if (!isEmpty(telInter1envoi) && !isPhone(telInter1envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi incorrect"); }
		else if (!isEmpty(telInter2envoi) && !isPhone(telInter2envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi incorrect"); }
		else if (!isEmpty(fax_inter_envoi) && !isPhone(fax_inter_envoi)) { showWarning("Num\u00E9ro de fax d'envoi incorrect"); }
		else if (!isEmpty(email_inter_envoi) && !isEmail(email_inter_envoi)) { showWarning("Adresse e-mail d'envoi incorrecte"); }
		else if (isEmpty(dateDebutAbt) || !isDate(dateDebutAbt)) {showWarning("Date de d\u00E9but incorrecte (onglet param\u00E8tres abonnement)");}
		else if ((oec_nbJourTypePeriode(typeDureeContrat)*dureeContrat)<(oec_nbJourTypePeriode(typePeriodicite)*periodicite)) { showWarning("La p\u00E9riodicit\u00E9 de facturation doit \u00EAtre inf\u00E9rieure ou \u00E9gale \u00E0 la dur\u00E9e du contrat");}
		else if ((oec_nbJourTypePeriode(typeDureeReconduction)*dureeReconduction)<(oec_nbJourTypePeriode(typePeriodicite)*periodicite)) { showWarning("La p\u00E9riodicit\u00E9 de facturation doit \u00EAtre inf\u00E9rieure ou \u00E9gale \u00E0 la dur\u00E9e de reconduction");}
		else if (oec_verifCoherenceDateDebutAbt(dateDebutAbt)) {

			fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oec_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oec_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			if (oec_assujettiTVA && code_pays_liv!="FR" && isEmpty(numeroTVA) && oec_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire");
			}

			var qSave;

			if (oec_mode=="C") {
				qSave = new QueryHttp("Facturation/Abonnements/createContratAbonnement.tmpl");
				qSave.setParam("Modele_Id", oec_modeleId);
			}
			else {
				qSave = new QueryHttp("Facturation/Abonnements/updateContratAbonnement.tmpl");
				qSave.setParam("Contrat_Id", oec_contratId);
			}

			qSave.setParam("Intitule", intitule);
			qSave.setParam("Periodicite", periodicite);
			qSave.setParam("Type_Periodicite", typePeriodicite);
			qSave.setParam("Duree_Contrat", dureeContrat);
			qSave.setParam("Type_Duree_Contrat", typeDureeContrat);
			qSave.setParam("Duree_Reconduction", dureeReconduction);
			qSave.setParam("Type_Duree_Reconduction", typeDureeReconduction);
			qSave.setParam("Date_Debut_Abt", dateDebutAbt);
			qSave.setParam("Type_Reconduction", typeReconduction);
			qSave.setParam("Delai_Preavis", delaiPreavis);
			qSave.setParam("PEvol_Recond", pEvolRecond);
			qSave.setParam("Delai_Generation", delaiGeneration);
			qSave.setParam("Modalite_Id", modaliteReglement);
			qSave.setParam("Pole_Activite", poleActivite);
			qSave.setParam("Client_Id", oec_clientId);
			qSave.setParam("Terme_Facturation", termeFacturation);
			qSave.setParam("Nb_Periode_Offerte", nbPeriodeOfferte);
			qSave.setParam("Edition_TTC", oec_editionTTC);
			qSave.setParam("Assujetti_TVA", oec_assujettiTVA);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Frais_Port", fraisPort);
			qSave.setParam("PRemise", tauxRemise);
			qSave.setParam("MRemise", montantRemise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
			qSave.setParam("Escompte", escompte);
			qSave.setParam("modeReglement", modeReglement);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Util_R", Util_R);
			qSave.setParam("Tarif_Id", tarifVente);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Depot_Id", depot);
			qSave.setParam("Code_TVA_Port", oec_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oec_tauxTVAPort);

			qSave.setParam("Denomination", denomination_fact);
			qSave.setParam("Adresse_1", adresse_1_fact);
			qSave.setParam("Adresse_2", adresse_2_fact);
			qSave.setParam("Adresse_3", adresse_3_fact);
			qSave.setParam("Code_Postal", code_postal_fact);
			qSave.setParam("Ville", ville_fact);
			qSave.setParam("Code_Pays", code_pays_fact);
			qSave.setParam("Civ_Inter", civ_inter_fact);
			qSave.setParam("Nom_Inter", nom_inter_fact);
			qSave.setParam("Prenom_Inter", prenom_inter_fact);
			qSave.setParam("Tel_Inter_1", telInter1fact);
			qSave.setParam("Tel_Inter_2", telInter2fact);
			qSave.setParam("Fax_Inter", fax_inter_fact);
			qSave.setParam("Email_Inter", email_inter_fact);
			qSave.setParam("Denomination_Liv", denomination_liv);
			qSave.setParam("Adresse_1_Liv", adresse_1_liv);
			qSave.setParam("Adresse_2_Liv", adresse_2_liv);
			qSave.setParam("Adresse_3_Liv", adresse_3_liv);
			qSave.setParam("Code_Postal_Liv", code_postal_liv);
			qSave.setParam("Ville_Liv", ville_liv);
			qSave.setParam("Code_Pays_Liv", code_pays_liv);
			qSave.setParam("Civ_Inter_Liv", civ_inter_liv);
			qSave.setParam("Nom_Inter_Liv", nom_inter_liv);
			qSave.setParam("Prenom_Inter_Liv", prenom_inter_liv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2liv);
			qSave.setParam("Fax_Inter_Liv", fax_inter_liv);
			qSave.setParam("Email_Inter_Liv", email_inter_liv);
			qSave.setParam("Denomination_Envoi", denomination_envoi);
			qSave.setParam("Adresse_1_Envoi", adresse_1_envoi);
			qSave.setParam("Adresse_2_Envoi", adresse_2_envoi);
			qSave.setParam("Adresse_3_Envoi", adresse_3_envoi);
			qSave.setParam("Code_Postal_Envoi", code_postal_envoi);
			qSave.setParam("Ville_Envoi", ville_envoi);
			qSave.setParam("Code_Pays_Envoi", code_pays_envoi);
			qSave.setParam("Civ_Inter_Envoi", civ_inter_envoi);
			qSave.setParam("Nom_Inter_Envoi", nom_inter_envoi);
			qSave.setParam("Prenom_Inter_Envoi", prenom_inter_envoi);
			qSave.setParam("Tel_Inter_1_Envoi", telInter1envoi);
			qSave.setParam("Tel_Inter_2_Envoi", telInter2envoi);
			qSave.setParam("Fax_Inter_Envoi", fax_inter_envoi);
			qSave.setParam("Email_Inter_Envoi", email_inter_envoi);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oec_mode=="C") {
					oec_contratId = result.responseXML.documentElement.getAttribute("Contrat_Id");
				}
				ok = true;
				if (!quit) {
					oec_chargerContrat();
				}
			}
		}

		return ok;

	}	catch(e) {
	 	recup_erreur(e);
  }
}


function oec_supprimerContrat() {
	try {

		if (window.confirm("Confirmez-vous la suppression de l'abonnement ?")) {

			var qDelete = new QueryHttp("Facturation/Abonnements/deleteContratAbonnement.tmpl");
			qDelete.setParam("Contrat_Id", oec_contratId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le contrat d'abonnement a \u00E9t\u00E9 supprim\u00E9");
				retourMenuContrats()
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_resilierContrat() {
	try {

		if (window.confirm("Confirmez-vous la r\u00E9siliation de l'abonnement ?")) {

			var qUpdate = new QueryHttp("Facturation/Abonnements/validResiliationContratAbonnement.tmpl");
			qUpdate.setParam("Contrat_Id", oec_contratId);
			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_chargerContrat();
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_annulerResiliationContrat() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la r\u00E9siliation de l'abonnement ?")) {

			var qUpdate = new QueryHttp("Facturation/Abonnements/cancelResiliationContratAbonnement.tmpl");
			qUpdate.setParam("Contrat_Id", oec_contratId);
			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_chargerContrat();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oec_demandeEnregistrement() {
	try {

		if (oec_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au contrat d'abonnement ?")) {
				oec_enregistrerContrat(true);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_reconduireAbonnement() {
	try {

		if (oec_enregistrerContrat(false)) {
			var qRenew = new QueryHttp("Facturation/Abonnements/renewContratAbonnement.tmpl");
			qRenew.setParam("Contrat_Id", oec_contratId);

			var result = qRenew.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_chargerContrat();
			showWarning("Abonnement reconduit jusqu'au "+ document.getElementById('oec-dateFinAbt').value);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_debloquerInterface() {
	try {

		document.getElementById('oec-intitule').disabled = oec_etatContrat!="A";
		document.getElementById('oec-periodicite').disabled = oec_etatContrat!="A";
		document.getElementById('oec-typePeriodicite').disabled = oec_etatContrat!="A";
		document.getElementById('oec-dureeContrat').disabled = oec_etatContrat!="A";
		document.getElementById('oec-typeDureeContrat').disabled = oec_etatContrat!="A";
		document.getElementById('oec-dureeReconduction').disabled = oec_etatContrat!="A";
		document.getElementById('oec-typeDureeReconduction').disabled = oec_etatContrat!="A";
		document.getElementById('oec-dateDebutAbt').disabled = oec_etatContrat!="A";
		document.getElementById('oec-poleActivite').disabled = oec_etatContrat!="A";
		document.getElementById('oec-typeReconduction').disabled = oec_etatContrat!="A";
		document.getElementById('oec-delaiPreavis').disabled = oec_etatContrat!="A";
		document.getElementById('oec-delaiGeneration').disabled = oec_etatContrat!="A";
		document.getElementById('oec-nbPeriodeOfferte').disabled = oec_etatContrat!="A";
		document.getElementById('oec-modaliteReglement').disabled = oec_etatContrat!="A";
		document.getElementById('oec-termeFacturation').disabled = oec_etatContrat!="A";

		document.getElementById('tarif').disabled = oec_etatContrat!="A";

		var valeur = (oec_etatContrat=="R" || oec_etatContrat=="T");

		document.getElementById('oec-ligneArticle').collapsed = valeur;

		document.getElementById('oec-pEvolRecond').disabled = valeur;

		document.getElementById('bArticle').disabled = valeur;
		document.getElementById('bCommentaire').disabled = valeur;
		document.getElementById('bAnnuler').disabled = valeur;
		document.getElementById('bValider').disabled = valeur;
		document.getElementById('bSupprimer').disabled = valeur;

		document.getElementById('oec-commentairesFin').disabled = valeur;
		document.getElementById('oec-commentairesInt').disabled = valeur;
		document.getElementById('Mode_Reg').disabled = valeur;
		document.getElementById('Remise').disabled = valeur;
		document.getElementById('bRemise').disabled = valeur;
		document.getElementById('Frais_Port').disabled = valeur;
		document.getElementById('RemiseFP').disabled = valeur;
		document.getElementById('bRemiseFP').disabled = valeur;
		document.getElementById('Escompte').disabled = valeur;
		document.getElementById('Login_Resp').disabled = valeur;
		document.getElementById('oec-bChoisirMentions').disabled = valeur;
		document.getElementById('oec-assujettiTVA').disabled = valeur;
		document.getElementById('oec-numeroTVA').disabled = (valeur || !oec_assujettiTVA);
		document.getElementById('etablissement').disabled = valeur;
		document.getElementById('depot').disabled = valeur;
		document.getElementById("chercher_client").disabled = valeur || !isEmpty(oec_clientId);
		document.getElementById("chercher_adrfact").disabled = valeur;
		document.getElementById("chercher_inter").disabled = valeur;
		document.getElementById("bCopierFactVersLivEnvoi").disabled = valeur;
		document.getElementById("chercher_adrliv").disabled = valeur;
		document.getElementById("chercher_inter_liv").disabled = valeur;
		document.getElementById("chercher_adrEnvoi").disabled = valeur;
		document.getElementById("chercher_inter_envoi").disabled = valeur;

		if (valeur) {
			document.getElementById("Denomination_Fact").setAttribute('readonly', true);
			document.getElementById("Adresse_1_Fact").setAttribute('readonly', true);
			document.getElementById("Adresse_2_Fact").setAttribute('readonly', true);
			document.getElementById("Adresse_3_Fact").setAttribute('readonly', true);
			document.getElementById("Code_Postal_Fact").setAttribute('readonly', true);
			document.getElementById("Ville_Fact").setAttribute('readonly', true);
    	document.getElementById("Code_Pays_Fact").disabled = true;
			document.getElementById("Civ_Inter_Fact").disabled = true;
			document.getElementById("Nom_Inter_Fact").setAttribute('readonly', true);
			document.getElementById("Prenom_Inter_Fact").setAttribute('readonly', true);
			document.getElementById("Tel_Inter_1_Fact").setAttribute('readonly', true);
			document.getElementById("Tel_Inter_2_Fact").setAttribute('readonly', true);
			document.getElementById("Fax_Inter_Fact").setAttribute('readonly', true);
			document.getElementById("Email_Inter_Fact").setAttribute('readonly', true);

			document.getElementById("Denomination_Liv").setAttribute('readonly', true);
			document.getElementById("Adresse_1_Liv").setAttribute('readonly', true);
			document.getElementById("Adresse_2_Liv").setAttribute('readonly', true);
			document.getElementById("Adresse_3_Liv").setAttribute('readonly', true);
			document.getElementById("Code_Postal_Liv").setAttribute('readonly', true);
			document.getElementById("Ville_Liv").setAttribute('readonly', true);
			document.getElementById('Code_Pays_Liv').disabled = true;
    	document.getElementById("Civ_Inter_Liv").disabled = true;
			document.getElementById("Nom_Inter_Liv").setAttribute('readonly', true);
			document.getElementById("Prenom_Inter_Liv").setAttribute('readonly', true);
			document.getElementById("Tel_Inter_1_Liv").setAttribute('readonly', true);
			document.getElementById("Tel_Inter_2_Liv").setAttribute('readonly', true);
			document.getElementById("Fax_Inter_Liv").setAttribute('readonly', true);
			document.getElementById("Email_Inter_Liv").setAttribute('readonly', true);

			document.getElementById("Denomination_Envoi").setAttribute('readonly', true);
			document.getElementById("Adresse_1_Envoi").setAttribute('readonly', true);
			document.getElementById("Adresse_2_Envoi").setAttribute('readonly', true);
			document.getElementById("Adresse_3_Envoi").setAttribute('readonly', true);
			document.getElementById("Code_Postal_Envoi").setAttribute('readonly', true);
			document.getElementById("Ville_Envoi").setAttribute('readonly', true);
    	document.getElementById("Code_Pays_Envoi").disabled = true;
    	document.getElementById("Civ_Inter_Envoi").disabled = true;
			document.getElementById("Nom_Inter_Envoi").setAttribute('readonly', true);
			document.getElementById("Prenom_Inter_Envoi").setAttribute('readonly', true);
			document.getElementById("Tel_Inter_1_Envoi").setAttribute('readonly', true);
			document.getElementById("Tel_Inter_2_Envoi").setAttribute('readonly', true);
			document.getElementById("Fax_Inter_Envoi").setAttribute('readonly', true);
			document.getElementById("Email_Inter_Envoi").setAttribute('readonly', true);
		}
		else {
			document.getElementById("Denomination_Fact").removeAttribute('readonly');
			document.getElementById("Adresse_1_Fact").removeAttribute('readonly');
			document.getElementById("Adresse_2_Fact").removeAttribute('readonly');
			document.getElementById("Adresse_3_Fact").removeAttribute('readonly');
			document.getElementById("Code_Postal_Fact").removeAttribute('readonly');
			document.getElementById("Ville_Fact").removeAttribute('readonly');
    	document.getElementById("Code_Pays_Fact").disabled = false;
			document.getElementById("Civ_Inter_Fact").disabled = false;
			document.getElementById("Nom_Inter_Fact").removeAttribute('readonly');
			document.getElementById("Prenom_Inter_Fact").removeAttribute('readonly');
			document.getElementById("Tel_Inter_1_Fact").removeAttribute('readonly');
			document.getElementById("Tel_Inter_2_Fact").removeAttribute('readonly');
			document.getElementById("Fax_Inter_Fact").removeAttribute('readonly');
			document.getElementById("Email_Inter_Fact").removeAttribute('readonly');

			document.getElementById("Denomination_Liv").removeAttribute('readonly');
			document.getElementById("Adresse_1_Liv").removeAttribute('readonly');
			document.getElementById("Adresse_2_Liv").removeAttribute('readonly');
			document.getElementById("Adresse_3_Liv").removeAttribute('readonly');
			document.getElementById("Code_Postal_Liv").removeAttribute('readonly');
			document.getElementById("Ville_Liv").removeAttribute('readonly');
			document.getElementById('Code_Pays_Liv').disabled = false;
    	document.getElementById("Civ_Inter_Liv").disabled = false;
			document.getElementById("Nom_Inter_Liv").removeAttribute('readonly');
			document.getElementById("Prenom_Inter_Liv").removeAttribute('readonly');
			document.getElementById("Tel_Inter_1_Liv").removeAttribute('readonly');
			document.getElementById("Tel_Inter_2_Liv").removeAttribute('readonly');
			document.getElementById("Fax_Inter_Liv").removeAttribute('readonly');
			document.getElementById("Email_Inter_Liv").removeAttribute('readonly');

			document.getElementById("Denomination_Envoi").removeAttribute('readonly');
			document.getElementById("Adresse_1_Envoi").removeAttribute('readonly');
			document.getElementById("Adresse_2_Envoi").removeAttribute('readonly');
			document.getElementById("Adresse_3_Envoi").removeAttribute('readonly');
			document.getElementById("Code_Postal_Envoi").removeAttribute('readonly');
			document.getElementById("Ville_Envoi").removeAttribute('readonly');
    	document.getElementById("Code_Pays_Envoi").disabled = false;
    	document.getElementById("Civ_Inter_Envoi").disabled = false;
			document.getElementById("Nom_Inter_Envoi").removeAttribute('readonly');
			document.getElementById("Prenom_Inter_Envoi").removeAttribute('readonly');
			document.getElementById("Tel_Inter_1_Envoi").removeAttribute('readonly');
			document.getElementById("Tel_Inter_2_Envoi").removeAttribute('readonly');
			document.getElementById("Fax_Inter_Envoi").removeAttribute('readonly');
			document.getElementById("Email_Inter_Envoi").removeAttribute('readonly');
		}

		oec_formatLigne();

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_editerAbonnement() {
	try {

		document.getElementById('oec-pdfAbonnement').setAttribute('src', '');
		document.getElementById('oec-deckContrat').selectedIndex = 1;
		document.getElementById('bRetourContrat').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Abonnements/pdfAbonnementFacturation.tmpl");
		qGenPdf.setParam('Contrat_Id', oec_contratId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oec-pdfAbonnement').setAttribute("src", page);

	}	catch(e) {
		recup_erreur(e);
	}
}



// ONGLET PARAMETRES


function oec_selectPaysLiv() {
	try {

		oec_listeTVA();
		oec_changerTypeVente();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerPolesActivite(selection) {
	try {

		oec_selPoleActivite = selection;
		oec_aPolesActivite.setParam("Selection", oec_selPoleActivite);
		oec_aPolesActivite.initTree(oec_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initPoleActivite() {
  try {

		document.getElementById('oec-poleActivite').value = oec_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_rechercherClient() {
  try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_retourRechercherClient, true, true);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oec_retourRechercherClient(numClient, clientId) {
	try {

		oec_clientId = clientId;
  	if (oec_clientId != "") {
			oec_setModified(true);
			oec_chargerCoordClient();
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerCoordClient() {
	try	{

		var qGet = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
		qGet.setParam("Client_Id", oec_clientId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oec_assujettiTVA = contenu.getAttribute("Assujetti_TVA")=="true";
		document.getElementById('oec-assujettiTVA').checked = oec_assujettiTVA;
		document.getElementById('oec-numeroTVA').disabled = !oec_assujettiTVA;
		document.getElementById('oec-numeroTVA').value = contenu.getAttribute("Numero_TVA");

		oec_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		document.getElementById("Denomination_Fact").value = contenu.getAttribute("Denomination_Fact");
		document.getElementById("Adresse_1_Fact").value = contenu.getAttribute("Adresse_1_Fact");
		document.getElementById("Adresse_2_Fact").value = contenu.getAttribute("Adresse_2_Fact");
		document.getElementById("Adresse_3_Fact").value = contenu.getAttribute("Adresse_3_Fact");
		document.getElementById("Code_Postal_Fact").value = contenu.getAttribute("Code_Postal_Fact");
		document.getElementById("Ville_Fact").value = contenu.getAttribute("Ville_Fact");
    document.getElementById("Code_Pays_Fact").value = contenu.getAttribute("Code_Pays_Fact");
		document.getElementById("Civ_Inter_Fact").value = contenu.getAttribute("Civ_Inter_Fact");
		document.getElementById("Nom_Inter_Fact").value = contenu.getAttribute("Nom_Inter_Fact");
		document.getElementById("Prenom_Inter_Fact").value = contenu.getAttribute("Prenom_Inter_Fact");
		document.getElementById("Tel_Inter_1_Fact").value = contenu.getAttribute("Tel_Inter_1_Fact");
		document.getElementById("Tel_Inter_2_Fact").value = contenu.getAttribute("Tel_Inter_2_Fact");
		document.getElementById("Fax_Inter_Fact").value = contenu.getAttribute("Fax_Inter_Fact");
		document.getElementById("Email_Inter_Fact").value = contenu.getAttribute("Email_Inter_Fact");

		document.getElementById("Denomination_Liv").value = contenu.getAttribute("Denomination_Liv");
		document.getElementById("Adresse_1_Liv").value = contenu.getAttribute("Adresse_1_Liv");
		document.getElementById("Adresse_2_Liv").value = contenu.getAttribute("Adresse_2_Liv");
		document.getElementById("Adresse_3_Liv").value = contenu.getAttribute("Adresse_3_Liv");
		document.getElementById("Code_Postal_Liv").value = contenu.getAttribute("Code_Postal_Liv");
		document.getElementById("Ville_Liv").value = contenu.getAttribute("Ville_Liv");
    document.getElementById("Code_Pays_Liv").value = contenu.getAttribute("Code_Pays_Liv");
    document.getElementById("Civ_Inter_Liv").value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById("Nom_Inter_Liv").value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById("Prenom_Inter_Liv").value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById("Tel_Inter_1_Liv").value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById("Tel_Inter_2_Liv").value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById("Fax_Inter_Liv").value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById("Email_Inter_Liv").value = contenu.getAttribute("Email_Inter_Liv");

		document.getElementById("Denomination_Envoi").value = contenu.getAttribute("Denomination_Envoi");
		document.getElementById("Adresse_1_Envoi").value = contenu.getAttribute("Adresse_1_Envoi");
		document.getElementById("Adresse_2_Envoi").value = contenu.getAttribute("Adresse_2_Envoi");
		document.getElementById("Adresse_3_Envoi").value = contenu.getAttribute("Adresse_3_Envoi");
		document.getElementById("Code_Postal_Envoi").value = contenu.getAttribute("Code_Postal_Envoi");
		document.getElementById("Ville_Envoi").value = contenu.getAttribute("Ville_Envoi");
    document.getElementById("Code_Pays_Envoi").value = contenu.getAttribute("Code_Pays_Envoi");
    document.getElementById("Civ_Inter_Envoi").value = contenu.getAttribute("Civ_Inter_Envoi");
		document.getElementById("Nom_Inter_Envoi").value = contenu.getAttribute("Nom_Inter_Envoi");
		document.getElementById("Prenom_Inter_Envoi").value = contenu.getAttribute("Prenom_Inter_Envoi");
		document.getElementById("Tel_Inter_1_Envoi").value = contenu.getAttribute("Tel_Inter_1_Envoi");
		document.getElementById("Tel_Inter_2_Envoi").value = contenu.getAttribute("Tel_Inter_2_Envoi");
		document.getElementById("Fax_Inter_Envoi").value = contenu.getAttribute("Fax_Inter_Envoi");
		document.getElementById("Email_Inter_Envoi").value = contenu.getAttribute("Email_Inter_Envoi");

		oec_calculerTvaPort();
    oec_selectPaysLiv();

		var modeReg = contenu.getAttribute('Mode_Reg_Id');
		if (modeReg!="") { oec_chargerModesReglement(modeReg); }
		oec_chargerTarifsVente(contenu.getAttribute("Tarif_Id"));

		var numClient = contenu.getAttribute("Num_Client");

		document.getElementById('labelClientFact').value = numClient;
		document.getElementById('labelClientLiv').value = numClient;
		document.getElementById('labelClientEnvoi').value = numClient;

		document.getElementById('chercher_adrfact').disabled = false;
		document.getElementById('chercher_inter').disabled = false;
		document.getElementById('chercher_inter_liv').disabled = false;

		var client_connu = !isEmpty(oec_clientId);

   	document.getElementById('chercher_adrliv').disabled = !client_connu;
		document.getElementById('chercher_adrfact').disabled = !client_connu;
		document.getElementById('chercher_inter').disabled = !client_connu;
		document.getElementById('chercher_inter_liv').disabled = !client_connu;
		document.getElementById('chercher_adrEnvoi').disabled = !client_connu;
		document.getElementById('chercher_inter_envoi').disabled = !client_connu;

	}	catch(e) {
		recup_erreur(e);
  }
}


function oec_nbJourTypePeriode(typePeriode) {
	try	{

		var nbJour;

		if (typePeriode=='M') {
			nbJour = 30;
		}
		else if (typePeriode=='A') {
			nbJour = 360;
		}
		else if (typePeriode=='S') {
			nbJour = 7;
		}
		else {
			nbJour = 1;
		}

		return nbJour;

	}	catch(e) {
   	recup_erreur(e);
  }
}


function oec_verifCoherenceDateDebutAbt(dateDebutAbt) {
	try {

		var ok = true;

		if (oec_mode=="C") {
			var dateCourante = new Date();
			var anneeCourante = dateCourante.getFullYear();
			var anneeDebut = parseIntBis(dateDebutAbt.substring(6,10));

			if (anneeDebut<anneeCourante || anneeDebut>anneeCourante+1) {
				if (!window.confirm("L'ann\u00E9e de d\u00E9but d'abonnement est probablement incorrecte : "+ anneeDebut +"\nEtes-vous s\u00FBr de vouloir continuer ?")) {
					ok = false;
				}
			}
		}

		return ok;

	}	catch(e) {
		recup_erreur(e);
  }
}


function oec_calcDateFinAbt() {
	try {

		var dateDebutAbt = document.getElementById('oec-dateDebutAbt').value;
		var dureeContrat = parseIntBis(document.getElementById('oec-dureeContrat').value);
		var typeDureeContrat = document.getElementById('oec-typeDureeContrat').value;

		if (isPositiveInteger(dureeContrat) && isDate(dateDebutAbt)) {
			var qCalc = new QueryHttp("Facturation/Abonnements/calcDateFinAbt.tmpl");
			qCalc.setParam("Date_Debut_Abt", dateDebutAbt);
			qCalc.setParam("Duree_Contrat", dureeContrat);
			qCalc.setParam("Type_Duree_Contrat", typeDureeContrat);
			var result = qCalc.execute();

			var dateFinAbt = result.responseXML.documentElement.getAttribute("Date_Fin_Abt");

			document.getElementById('oec-dateFinAbt').value = dateFinAbt;
		}

	} catch(e) {
   	recup_erreur(e);
  }
}


function oec_pressOnDureeContrat(ev) {
  try {

		if (ev.keyCode==13) {
			oec_calcDateFinAbt();
	  }

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_pressOnDateDebutAbt(ev) {
  try {

		if (ev.keyCode==13) {
			oec_calcDateFinAbt();
	  }

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrFact, oec_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("Denomination_Fact").value = nom;
		document.getElementById("Adresse_1_Fact").value = adr1;
		document.getElementById("Adresse_2_Fact").value = adr2;
		document.getElementById("Adresse_3_Fact").value = adr3;
		document.getElementById("Code_Postal_Fact").value = cp;
		document.getElementById("Ville_Fact").value = ville;
	  document.getElementById("Code_Pays_Fact").value = code_pays;

	  if (!isEmpty(contact_fact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_fact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterFact(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterFact, oec_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("Civ_Inter_Fact").value = civ;
		document.getElementById("Nom_Inter_Fact").value = nom;
		document.getElementById("Prenom_Inter_Fact").value = prenom;
		document.getElementById("Tel_Inter_1_Fact").value = tel1;
		document.getElementById("Tel_Inter_2_Fact").value = tel2;
		document.getElementById("Fax_Inter_Fact").value = fax;
		document.getElementById("Email_Inter_Fact").value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_copierFactVersLivEnvoi() {
	try {

		document.getElementById('Denomination_Liv').value = document.getElementById('Denomination_Fact').value;
		document.getElementById("Adresse_1_Liv").value = document.getElementById("Adresse_1_Fact").value;
		document.getElementById("Adresse_2_Liv").value = document.getElementById("Adresse_2_Fact").value;
		document.getElementById("Adresse_3_Liv").value = document.getElementById("Adresse_3_Fact").value;
		document.getElementById("Code_Postal_Liv").value = document.getElementById("Code_Postal_Fact").value;
		document.getElementById("Ville_Liv").value = document.getElementById("Ville_Fact").value;
	  document.getElementById("Code_Pays_Liv").value = document.getElementById("Code_Pays_Fact").value;
	  oec_calculerTvaPort();
		oec_selectPaysLiv();

	  document.getElementById("Civ_Inter_Liv").value = document.getElementById("Civ_Inter_Fact").value;
		document.getElementById("Nom_Inter_Liv").value = document.getElementById("Nom_Inter_Fact").value;
		document.getElementById("Prenom_Inter_Liv").value = document.getElementById("Prenom_Inter_Fact").value;
		document.getElementById("Tel_Inter_1_Liv").value = document.getElementById("Tel_Inter_1_Fact").value;
		document.getElementById("Tel_Inter_2_Liv").value = document.getElementById("Tel_Inter_2_Fact").value;
		document.getElementById("Fax_Inter_Liv").value = document.getElementById("Fax_Inter_Fact").value;
		document.getElementById("Email_Inter_Liv").value = document.getElementById("Email_Inter_Fact").value;

		document.getElementById('Denomination_Envoi').value = document.getElementById('Denomination_Fact').value;
		document.getElementById("Adresse_1_Envoi").value = document.getElementById("Adresse_1_Fact").value;
		document.getElementById("Adresse_2_Envoi").value = document.getElementById("Adresse_2_Fact").value;
		document.getElementById("Adresse_3_Envoi").value = document.getElementById("Adresse_3_Fact").value;
		document.getElementById("Code_Postal_Envoi").value = document.getElementById("Code_Postal_Fact").value;
		document.getElementById("Ville_Envoi").value = document.getElementById("Ville_Fact").value;
	  document.getElementById("Code_Pays_Envoi").value = document.getElementById("Code_Pays_Fact").value;

	  document.getElementById("Civ_Inter_Envoi").value = document.getElementById("Civ_Inter_Fact").value;
		document.getElementById("Nom_Inter_Envoi").value = document.getElementById("Nom_Inter_Fact").value;
		document.getElementById("Prenom_Inter_Envoi").value = document.getElementById("Prenom_Inter_Fact").value;
		document.getElementById("Tel_Inter_1_Envoi").value = document.getElementById("Tel_Inter_1_Fact").value;
		document.getElementById("Tel_Inter_2_Envoi").value = document.getElementById("Tel_Inter_2_Fact").value;
		document.getElementById("Fax_Inter_Envoi").value = document.getElementById("Fax_Inter_Fact").value;
		document.getElementById("Email_Inter_Envoi").value = document.getElementById("Email_Inter_Fact").value;

		oec_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrLiv, oec_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("Denomination_Liv").value = nom;
		document.getElementById("Adresse_1_Liv").value = adr1;
		document.getElementById("Adresse_2_Liv").value = adr2;
		document.getElementById("Adresse_3_Liv").value = adr3;
		document.getElementById("Code_Postal_Liv").value = cp;
		document.getElementById("Ville_Liv").value = ville;
	  document.getElementById("Code_Pays_Liv").value = code_pays;
	  oec_calculerTvaPort();
	  oec_selectPaysLiv();

		if (!isEmpty(contact_liv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_liv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrEnvoi, oec_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("Denomination_Envoi").value = nom;
		document.getElementById("Adresse_1_Envoi").value = adr1;
		document.getElementById("Adresse_2_Envoi").value = adr2;
		document.getElementById("Adresse_3_Envoi").value = adr3;
		document.getElementById("Code_Postal_Envoi").value = cp;
		document.getElementById("Ville_Envoi").value = ville;
	  document.getElementById("Code_Pays_Envoi").value = code_pays;

	   if (!isEmpty(contact_envoi)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_envoi);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterEnvoi(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterLiv, oec_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("Civ_Inter_Liv").value = civ;
		document.getElementById("Nom_Inter_Liv").value = nom;
		document.getElementById("Prenom_Inter_Liv").value = prenom;
		document.getElementById("Tel_Inter_1_Liv").value = tel1;
		document.getElementById("Tel_Inter_2_Liv").value = tel2;
		document.getElementById("Fax_Inter_Liv").value = fax;
		document.getElementById("Email_Inter_Liv").value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterEnvoi, oec_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("Civ_Inter_Envoi").value = civ;
		document.getElementById("Nom_Inter_Envoi").value = nom;
		document.getElementById("Prenom_Inter_Envoi").value = prenom;
		document.getElementById("Tel_Inter_1_Envoi").value = tel1;
		document.getElementById("Tel_Inter_2_Envoi").value = tel2;
		document.getElementById("Fax_Inter_Envoi").value = fax;
		document.getElementById("Email_Inter_Envoi").value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_changerAssujettiTVA(b) {
	try {

		oec_assujettiTVA = b;
		document.getElementById('oec-numeroTVA').disabled = !oec_assujettiTVA;
		oec_listeTVA();
		oec_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


/*  retourne le nombre de jours dans le mois correspondant  la saisie */
function nb_jours(mois,annee) {
  try {

  	switch (mois) {
    	case 1:
    	case 3:
    	case 5:
    	case 7:
    	case 8:
    	case 10:
    	case 12:	return 31;	break;
    	case 4:
    	case 6:
    	case 9:
    	case 11:	return 30; 	break;
    	case 2:  	return ((annee!=0 && (annee % 4)==0)?29:28);	break;
    	default: 	return false;
  	}

	} catch (e) {
    recup_erreur(e);
  }
}



// ONGLET FACTURE TYPE


function oec_chargerResponsables(selection) {
	try {

		oec_selResponsable = selection;
		oec_aResponsables.setParam("Selection", selection);
		oec_aResponsables.initTree(oec_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initResponsable() {
	try {

		document.getElementById('Login_Resp').value = oec_selResponsable;

	}	catch (e) {
    recup_erreur(e);
  }
}


function oec_chargerModesReglement(selection) {
	try {

		oec_selModeReglement = selection;
		oec_aModesReglement.setParam("Selection", selection);
		oec_aModesReglement.initTree(oec_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initModeReglement() {
	try {

		document.getElementById('Mode_Reg').value = oec_selModeReglement;

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_chargerEtablissements(selection) {
	try {

		oec_selEtablissement = selection;
		oec_aEtablissements.setParam("Selection", selection);
		oec_aEtablissements.initTree(oec_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initEtablissement() {
	try {

		document.getElementById('etablissement').value = oec_selEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerDepots(selection) {
	try {

		oec_selDepot = selection;
		oec_aDepots.setParam("Selection", selection);
		oec_aDepots.setParam("Depot_Vente", false);
		oec_aDepots.setParam("Depot_Logistique", false);
		oec_aDepots.setParam("Depot_Quarantaine", false);
		oec_aDepots.initTree(oec_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initDepot() {
	try {

		document.getElementById('depot').value = oec_selDepot;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_changerTypeVente() {
	try {

	  var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById("Code_Pays_Liv").value);
	  var result = qZoneUE.execute();
	  oec_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");
	  document.getElementById('Code_TVA').disabled = !oec_zoneUE;

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_calculerTvaPort() {
	try {

		oec_codeTVAPort = getCodeTvaNormal(document.getElementById("Code_Pays_Liv").value, oec_assujettiTVA, "G");
		oec_tauxTVAPort = getTva(oec_codeTVAPort);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_listeTVA() {
  try {

  	oec_calculTotaux();

    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "Code_TVA");
    aCode.setParam("Code_Pays", document.getElementById("Code_Pays_Liv").value);
    aCode.setParam("Regime_TVA", "G");
    aCode.setParam("Assujetti_TVA", oec_assujettiTVA);
		aCode.setParam("Selection", oec_codesTvaInactifs);
    aCode.initTree(oec_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_selectTVA() {
  try {

    document.getElementById('Code_TVA').value = getCodeTvaNormal(document.getElementById('Code_Pays_Liv').value, oec_assujettiTVA, "G");

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_evaluer(field, ev) {
	try {
	
		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);		
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_pressOnLineNumberField(field, ev) {
	try {
	
		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {		
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oec_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_switchRistourne() {
	try {

		if (oec_typeRistourne=='P') {
			document.getElementById('bRistourne').setAttribute("class", "bIcoEuro");
			oec_typeRistourne = 'M';
		}
		else {
			document.getElementById('bRistourne').setAttribute("class", "bIcoPourcentage");
			oec_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_switchRemise() {
	try {

		if (oec_typeRemise=='P') {
			document.getElementById('bRemise').setAttribute("class", "bIcoEuro");
			oec_typeRemise = 'M';
		}
		else {
			document.getElementById('bRemise').setAttribute("class", "bIcoPourcentage");
			oec_typeRemise = 'P';
		}
		oec_calculTotaux();
		oec_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_switchRemiseFP() {
	try {

		if (oec_typeRemiseFP=='P') {
			document.getElementById('bRemiseFP').setAttribute("class", "bIcoEuro");
			oec_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oec_typeRemiseFP = 'P';
		}
		oec_calculTotaux();
		oec_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_calculTotaux() {
  try {

		document.getElementById('tarif').disabled = (oec_aLignesContrat.nbLignes()>0);
		var taux_escompte = parseFloat(document.getElementById('Escompte').value);
		var frais_port = parseFloat(document.getElementById('Frais_Port').value);
		var remise = parseFloat(document.getElementById('Remise').value);
		var remiseFP = parseFloat(document.getElementById('RemiseFP').value);

		if ((oec_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oec_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(taux_escompte) && isPositiveOrNull(frais_port)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oec_editionTTC);
			if (oec_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(frais_port);
			if (oec_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setTauxTVAFP(oec_tauxTVAPort);
			calculDocument.setEscompteP(taux_escompte);

			for (var i=0;i<oec_aLignesContrat.nbLignes();i++) {
				if (oec_aLignesContrat.getCellText(i,'colTypeLigne')!="C") {
					var montantLigne = oec_aLignesContrat.getCellText(i,'ColTotal');
					var codeTVA = oec_aLignesContrat.getCellText(i,'ColCode_TVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			if (oec_editionTTC) {
				document.getElementById('pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('pttcMontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('pttcTVA').value = calculDocument.getTotalTVA();
				document.getElementById('pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('pttcNetTTC').value = calculDocument.getNetAPayer();

				oec_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
			}
			else {
				document.getElementById('MontantHT').value = calculDocument.getMontantHT();
				document.getElementById('MontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('MontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('MontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('TotalHT').value = calculDocument.getTotalHT();
				document.getElementById('TVA').value = calculDocument.getTotalTVA();
				document.getElementById('MontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('NetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('TotalTTC').value = calculDocument.getTotalTTC();

				oec_montantHT = calculDocument.getMontantHTSansFormat();

				document.getElementById('rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_changerTypeEdition() {
	try {

		if (oec_editionTTC) {
			document.getElementById('ColTotal').setAttribute("label", "Total TTC");
			document.getElementById('ColPU').setAttribute("label", "P.U TTC");
			document.getElementById('lblFrais_Port').value = "Frais de port (ttc) :";
			document.getElementById('lblPU').value = "P.U TTC :";
			document.getElementById('piedTTC').collapsed = false;
			document.getElementById('piedHT').collapsed = true;
		}
		else {
			document.getElementById('ColTotal').setAttribute("label", "Total HT");
			document.getElementById('ColPU').setAttribute("label", "P.U HT");
			document.getElementById('lblFrais_Port').value = "Frais de port (ht) :";
			document.getElementById('lblPU').value = "P.U HT :";
			document.getElementById('piedTTC').collapsed = true;
			document.getElementById('piedHT').collapsed = false;
		}

		oec_calculTotaux();

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_validerLigne() {
  try	{

		if (oec_mode=="C") {
			oec_enregistrerContrat(false);
		}

		if (oec_contratId!="") {

			var reference = document.getElementById("Reference").value;
			var designation = document.getElementById("Designation").value;
			var quantite = document.getElementById("Quantite").value;
			var prixUnitaire = document.getElementById("PU").value;
			var ristourne = document.getElementById("Ristourne").value;
			var codeTVA = document.getElementById("Code_TVA").value;

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !");	}
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect");	}
			else if (isEmpty(ristourne) || (oec_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else {

				var qSave;

				if (oec_modeLigne=="C") {
					qSave = new QueryHttp("Facturation/Abonnements/createLigneContratAbonnement.tmpl");
					qSave.setParam("Contrat_Id", oec_contratId);
				}
				else {
					qSave = new QueryHttp("Facturation/Abonnements/updateLigneContratAbonnement.tmpl");
					qSave.setParam("Ligne_Id", oec_ligneId);
				}

				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oec_typeRistourne);
				qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Libelle", oec_libelle);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oec_chargerContrat();
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('bSupprimer').disabled = true;
		oec_modeLigne = "C";
		oec_ligneId = "";
		oec_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById('Code_Pays_Liv').value;

		if (typeLigne=="S") {
			oec_articleId = articleId;

			if (oec_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oec_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oec_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oec_prixId);
					qGet.setParam("TTC", oec_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					document.getElementById("Designation").value = contenu.getAttribute("Designation");
					document.getElementById('Quantite').value = contenu.getAttribute("Quantite");
					document.getElementById("PU").value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('Ristourne').value = "0.00";
					document.getElementById("Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oec_assujettiTVA, "G");
					oec_prixId = "";
					oec_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oec_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('tarif').value);
				qGet.setParam("TTC", oec_editionTTC);
				qGet.setParam("Client_Id", oec_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById("Designation").value = contenu.getAttribute("Designation");
				document.getElementById('Quantite').value = 1;
				document.getElementById("PU").value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('Ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById("Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oec_assujettiTVA, "G");
				oec_libelle = "";
			}
		}
		else {
			oec_articleId = "";
			document.getElementById('Reference').value = "";
			document.getElementById('Designation').value = "";
			document.getElementById('Quantite').value = 1;
			document.getElementById('PU').value = "";
			document.getElementById('Ristourne').value = "0.00";
			document.getElementById('Code_TVA').value = getCodeTvaNormal(codePaysLiv, oec_assujettiTVA, "G");
			oec_libelle = "";
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_retourChoixPrixQuantite(prixId) {
	try {

		oec_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oec_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_retourRechercherStock, "V", reference);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('Reference').value = reference;
		document.getElementById('Quantite').focus();
		oec_ajouterLigne("S", articleId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherReference() {
	try {

		var reference = document.getElementById('Reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('Reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('Quantite').focus();
			oec_ajouterLigne("S", articleId);
		}
		else {
			oec_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('Reference').disabled = true;
				document.getElementById('Designation').disabled = true;
				document.getElementById('Quantite').disabled = false;
				document.getElementById('PU').disabled = false;
				document.getElementById('Ristourne').disabled = false;
				document.getElementById('bRistourne').disabled = false;
				document.getElementById('Code_TVA').disabled = !oec_zoneUE;
				document.getElementById('bValider').disabled = false;
				document.getElementById('bAnnuler').disabled = false;
				break;

			case "I":
				document.getElementById('Reference').disabled = false;
				document.getElementById('Designation').disabled = false;
				document.getElementById('Quantite').disabled = false;
				document.getElementById('PU').disabled = false;
				document.getElementById('Ristourne').disabled = false;
				document.getElementById('bRistourne').disabled = false;
				document.getElementById('Code_TVA').disabled = !oec_zoneUE;
				document.getElementById('bValider').disabled = false;
				document.getElementById('bAnnuler').disabled = false;
				break;

			default:
				document.getElementById('Reference').value = "";
				document.getElementById('Designation').value = "";
				document.getElementById('Quantite').value = "";
				document.getElementById('PU').value = "";
				document.getElementById('Ristourne').value = "";
				oec_libelle = "";
				oec_ligneId = "";
				document.getElementById('Code_TVA').value = getCodeTvaNormal(document.getElementById("Code_Pays_Liv").value, oec_assujettiTVA, "G");
				document.getElementById('Reference').disabled = true;
				document.getElementById('Designation').disabled = true;
				document.getElementById('Quantite').disabled = true;
				document.getElementById('PU').disabled = true;
				document.getElementById('Ristourne').disabled = true;
				document.getElementById('bRistourne').disabled = true;
				document.getElementById('Code_TVA').disabled = true;
				document.getElementById('bSupprimer').disabled = true;
				document.getElementById('bValider').disabled = true;
				document.getElementById('bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_editerCommentaire() {
	try	{

		if (oec_mode=="C") {
			showWarning("Veuillez d'abord enregistrer l'abonnement.");
		}
		else {
			if (oec_aLignesContrat.isSelected()) {
				var ligneId = oec_aLignesContrat.getSelectedCellText('ColLigne_Id');

				var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', "CA", ligneId);

				oec_aLignesContrat.initTree(oec_calculTotaux);
				oec_ajouterLigne("I");
			}
			else {
				showWarning("Aucun article ou commentaire s\u00E9lectionn\u00E9 !");
			}
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function oec_ouvrirLigne() {
  try {

		if (oec_etatContrat!="R" && oec_etatContrat!="T") {
			if (oec_aLignesContrat.isSelected()) {
				if (oec_aLignesContrat.getSelectedCellText('colTypeLigne')=="C") {
					oec_ajouterLigne("I");
				}
				else {
					oec_modeLigne = "M";
					document.getElementById('bSupprimer').disabled = false;
					document.getElementById("Reference").value = oec_aLignesContrat.getSelectedCellText('ColReference');
					document.getElementById("Designation").value = oec_aLignesContrat.getSelectedCellText('ColDesignation');
					document.getElementById("Quantite").value = oec_aLignesContrat.getSelectedCellText('ColQuantite');
					document.getElementById("PU").value = oec_aLignesContrat.getSelectedCellText('ColPU');
					document.getElementById("Code_TVA").value = oec_aLignesContrat.getSelectedCellText('ColCode_TVA');
					document.getElementById("Ristourne").value = oec_aLignesContrat.getSelectedCellValue('ColRistourne');
					oec_typeRistourne = oec_aLignesContrat.getSelectedCellText('colTypeRistourne');
					document.getElementById('bRistourne').setAttribute("class", (oec_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					oec_ligneId = oec_aLignesContrat.getSelectedCellText('ColLigne_Id');
					oec_libelle = oec_aLignesContrat.getSelectedCellText('ColLibelle');
					oec_articleId = oec_aLignesContrat.getSelectedCellText('colArticleId');

					oec_formatLigne(oec_aLignesContrat.getSelectedCellText('colTypeLigne'));
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_ouvrirCommentaire() {
  try {

		if (oec_aLignesContrat.isSelected() && oec_mode=="M") {
			if (oec_aLignesContrat.getSelectedCellText('colTypeLigne')=="C") {
				oec_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_annulerLigne() {
  try {

  	oec_aLignesContrat.clearSelection();
		oec_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_pressOnWindow(ev) {
	try {

		if (ev.altKey && oec_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oec_rechercherStock();
        	break;
    	}
		}
		else if (ev.ctrlKey && oec_mode!="V" && ev.keyCode==46) {
			// ctrl + suppr
			ev.preventDefault();
			oec_supprimerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_supprimerLigne() {
  try {

		if (!isEmpty(oec_ligneId)) {
			var qDelete = new QueryHttp("Facturation/Abonnements/deleteLigneContratAbonnement.tmpl");
			qDelete.setParam("Ligne_Id", oec_ligneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oec_chargerContrat();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_choisirMentions() {
  try {

  	var ok = true;

  	if (oec_mode=="C") {
			ok = oec_enregistrerContrat(false);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CA", oec_contratId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}



// ONGLET ECHEANCIER


function oec_listerEcheancier() {
	try {

		if (oec_mode=="M") {
			document.getElementById('oec-bAnnulerEcheance').disabled = true;
			document.getElementById('oec-bActiverEcheance').disabled = true;
			oec_aEcheancier.setParam("Contrat_Id", oec_contratId);
			oec_aEcheancier.initTree();
		}

	}	catch(e) {
    recup_erreur(e);
  }
}


function oec_selectOnEcheancier() {
	try {

		if (oec_aEcheancier.isSelected()) {
			document.getElementById('oec-bAnnulerEcheance').disabled = oec_etatContrat=="R" || oec_aEcheancier.getSelectedCellValue('oec-colEtatEC')!="E" || oec_modified;
			document.getElementById('oec-bActiverEcheance').disabled = oec_etatContrat=="R" || oec_aEcheancier.getSelectedCellValue('oec-colEtatEC')!="A" || oec_modified;
		}

	}	catch(e) {
    recup_erreur(e);
  }
}


function oec_ouvrirFacture() {
	try {

		if (oec_aEcheancier.isSelected()) {
			var factureId = oec_aEcheancier.getSelectedCellText('oec-colFactureIdEC');
			if (!isEmpty(factureId)) {
				window.location = "chrome://opensi/content/facturation/user/factures_vente/gestionFactures.xul?Facture_Id="+ factureId;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_annulerEcheance() {
	try {

		if (oec_aEcheancier.isSelected()) {
			var echeanceId = oec_aEcheancier.getSelectedCellText('oec-colEcheanceIdEC');

			var qCancel = new QueryHttp("Facturation/Abonnements/cancelEcheanceContratAbonnement.tmpl");
			qCancel.setParam("Echeance_Id", echeanceId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_listerEcheancier();
		}

	}	catch(e) {
    recup_erreur(e);
  }
}


function oec_activerEcheance() {
	try {

		if (oec_aEcheancier.isSelected()) {
			var echeanceId = oec_aEcheancier.getSelectedCellText('oec-colEcheanceIdEC');

			var qActivate = new QueryHttp("Facturation/Abonnements/activateEcheanceContratAbonnement.tmpl");
			qActivate.setParam("Echeance_Id", echeanceId);
			var result = qActivate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_listerEcheancier();
		}

	}	catch(e) {
    recup_erreur(e);
  }
}


function oec_chargerTarifsVente(selection) {
	try {

		oec_selTarifVente = selection;
		oec_aTarifsVente.setParam("Selection", oec_selTarifVente);
		oec_aTarifsVente.initTree(oec_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initTarifVente() {
  try {

		document.getElementById('tarif').value = oec_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
