/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oem_aLignes = new Arbre("Facturation/Abonnements/list-ligneModeleAbonnement.tmpl", "oem-lignesModele");
var oem_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "oem-responsable");
var oem_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "oem-modeReglement");
var oem_aTauxTVA = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oem-codeTVA");
var oem_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oem-poleActivite");
var oem_aModalitesReg = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "oem-modaliteReg");
var oem_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oem-tarifVente");

var oem_modeleId;
var oem_mode;
var oem_modified = false;
var oem_modeTarif;
var oem_codesTvaInactifs = "";
var oem_editionTTC = false;

var oem_selModeReglement;
var oem_selResponsable;
var oem_selPoleActivite;
var oem_selTarifVente;

var oem_codeTVAPort;
var oem_tauxTVAPort;
var oem_montantHT = 0;
var oem_montantTTC = 0;

var oem_ligneId;
var oem_modeLigne;
var oem_articleId;
var oem_prixId = "";
var oem_libelle = "";
var oem_typeRistourne = 'P';
var oem_typeRemise = 'P';
var oem_typeRemiseFP = 'P';



function oem_init() {
  try {

		oem_aTauxTVA.initTree(oem_initModalites);

		oem_modeTarif = gConfig.getModeTarif();
		if (oem_modeTarif=='Q') {
			document.getElementById('oem-rowTarifVente').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_initModalites() {
	try {

    document.getElementById('oem-modaliteReg').selectedIndex = 0;
		oem_aModalitesReg.setParam("Type_Tiers", "C");
    oem_aModalitesReg.initTree(oem_initTVA);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_initTVA() {
	try {

    document.getElementById('oem-codeTVA').value = getCodeTvaNormalFrance();

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_chargerResponsables(selection) {
	try {

		oem_selResponsable = selection;
		oem_aResponsables.setParam("Selection", selection);
		oem_aResponsables.initTree(oem_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_initResponsable() {
	try {

		document.getElementById('oem-responsable').value = oem_selResponsable;

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_chargerPolesActivite(selection) {
	try {

	 oem_selPoleActivite = selection;
	 oem_aPolesActivite.setParam("Selection", oem_selPoleActivite);
	 oem_aPolesActivite.initTree(oem_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_initPoleActivite() {
  try {

		document.getElementById('oem-poleActivite').value = oem_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_chargerModesReglement(selection) {
	try {

		oem_selModeReglement = selection;
		oem_aModesReglement.setParam("Selection", selection);
		oem_aModesReglement.initTree(oem_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_initModeReglement() {
	try {

		document.getElementById('oem-modeReglement').value = oem_selModeReglement;

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_evaluer(field, ev) {
	try {
	
		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);		
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oem_pressOnLineNumberField(field, ev) {
	try {
	
		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {		
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oem_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oem_switchRistourne() {
	try {

		if (oem_typeRistourne=='P') {
			document.getElementById('oem-bRistourne').setAttribute("class", "bIcoEuro");
			oem_typeRistourne = 'M';
		}
		else {
			document.getElementById('oem-bRistourne').setAttribute("class", "bIcoPourcentage");
			oem_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_switchRemise() {
	try {

		if (oem_typeRemise=='P') {
			document.getElementById('oem-bRemise').setAttribute("class", "bIcoEuro");
			oem_typeRemise = 'M';
		}
		else {
			document.getElementById('oem-bRemise').setAttribute("class", "bIcoPourcentage");
			oem_typeRemise = 'P';
		}
		oem_calculTotaux();
		oem_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_switchRemiseFP() {
	try {

		if (oem_typeRemiseFP=='P') {
			document.getElementById('oem-bRemiseFP').setAttribute("class", "bIcoEuro");
			oem_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oem-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oem_typeRemiseFP = 'P';
		}
		oem_calculTotaux();
		oem_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_debloquerInterface() {
	try {

		document.getElementById('oem-responsable').disabled = false;
		document.getElementById('oem-lignesModele').disabled = false;
		document.getElementById('oem-reference').disabled = false;
		document.getElementById('oem-designation').disabled = false;
		document.getElementById('oem-quantite').disabled = false;
		document.getElementById('oem-prixUnitaire').disabled = false;
		document.getElementById('oem-ristourne').disabled = false;
		document.getElementById('oem-bRistourne').disabled = false;
		document.getElementById('oem-codeTVA').disabled = false;
		document.getElementById('oem-bArticle').disabled = false;
		document.getElementById('oem-bCommentaire').disabled = false;
		document.getElementById('oem-bAnnuler').disabled = false;
		document.getElementById('oem-bValider').disabled = false;
		document.getElementById('oem-commentairesFin').disabled = false;
		document.getElementById('oem-commentairesInt').disabled = false;
		document.getElementById('oem-bChoisirMentions').disabled = oem_mode=="C";
		document.getElementById('oem-modeReglement').disabled = false;
		document.getElementById('oem-bRemise').disabled=false;
		document.getElementById('oem-remise').disabled=false;
		document.getElementById('oem-fraisPort').disabled = false;
		document.getElementById('oem-bRemiseFP').disabled = false;
		document.getElementById('oem-remiseFP').disabled = false;
		document.getElementById('oem-escompte').disabled = false;
		document.getElementById('oem-bEnregistrerModele').disabled = false;
		document.getElementById('oem-tarifVente').disabled = false;
		document.getElementById('oem-pEvolRecond').disabled = false;
		document.getElementById('oem-bSupprimerModele').disabled = oem_mode=="C";

		document.getElementById('oem-refModele').disabled = oem_mode=="M";
		document.getElementById('oem-intitule').disabled = oem_mode=="M";
		document.getElementById('oem-periodicite').disabled = oem_mode=="M";
		document.getElementById('oem-typePeriodicite').disabled = oem_mode=="M";
		document.getElementById('oem-dureeContrat').disabled = oem_mode=="M";
		document.getElementById('oem-typeDureeContrat').disabled = oem_mode=="M";
	 	document.getElementById('oem-dureeReconduction').disabled = oem_mode=="M";
		document.getElementById('oem-typeDureeReconduction').disabled = oem_mode=="M";
		document.getElementById('oem-typeReconduction').disabled = oem_mode=="M";
		document.getElementById('oem-delaiPreavis').disabled = oem_mode=="M";
		document.getElementById('oem-delaiGeneration').disabled = oem_mode=="M";
		document.getElementById('oem-modaliteReg').disabled = oem_mode=="M";
		document.getElementById('oem-termeFacturation').disabled = oem_mode=="M";
		document.getElementById('oem-prefixeNumContrat').disabled = oem_mode=="M";
		document.getElementById('oem-nbPeriodeOfferte').disabled = oem_mode=="M";
		document.getElementById('oem-poleActivite').disabled = oem_mode=="M";

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_nouveauModele() {
  try {

		oem_modeleId = "";
		var venteTTC = gConfig.isVenteTTC();

		document.getElementById('oem-editionTTC').checked = venteTTC;

		oem_changerTypeEdition(venteTTC);

		oem_mode = "C";
		oem_chargerModesReglement("");
		oem_chargerResponsables(getProfil().getLoggedUser());
		oem_codesTvaInactifs = "";
		oem_chargerPolesActivite("");
		oem_chargerTarifsVente(gConfig.getTarifDefaut());

		oem_codeTVAPort = getCodeTvaNormalFrance();
		oem_tauxTVAPort = getTva(oem_codeTVAPort);

		document.getElementById('oem-refModele').value = "";
		document.getElementById('oem-intitule').value = "";
		document.getElementById('oem-prefixeNumContrat').value = "";
		document.getElementById('oem-periodicite').value = "";
		document.getElementById('oem-typePeriodicite').value = "M";
		document.getElementById('oem-dureeContrat').value = "";
		document.getElementById('oem-typeDureeContrat').value = "M";
		document.getElementById('oem-dureeReconduction').value = "";
		document.getElementById('oem-typeDureeReconduction').value = "M";
		document.getElementById('oem-delaiPreavis').value = "1";
		document.getElementById('oem-pEvolRecond').value = 0;
		document.getElementById('oem-delaiGeneration').value = "";
		document.getElementById('oem-modaliteReg').selectedIndex = 0;
		document.getElementById('oem-termeFacturation').value = "D";
		document.getElementById('oem-nbPeriodeOfferte').value = 0;

		document.getElementById('oem-remise').value = "0.00";
		document.getElementById('oem-escompte').value = "0.00";
		document.getElementById('oem-fraisPort').value = "0.00";
		document.getElementById('oem-remiseFP').value = "0.00";

		document.getElementById('oem-montantHT').value = "0.00";
		document.getElementById('oem-montantRemise').value = "0.00";
		document.getElementById('oem-montantFraisPort').value = "0.00";
		document.getElementById('oem-montantRemiseFP').value = "0.00";
		document.getElementById('oem-totalHT').value = "0.00";
		document.getElementById('oem-totalTVA').value = "0.00";
		document.getElementById('oem-montantEscompte').value = "0.00";
		document.getElementById('oem-totalTTC').value = "0.00";

		oem_montantHT = 0;
		oem_montantTTC = 0;

		document.getElementById('oem-rowRemiseHT').collapsed = true;
		document.getElementById('oem-rowRemiseFPHT').collapsed = true;
		document.getElementById('oem-rowEscompteHT').collapsed = true;

		document.getElementById('oem-pttcMontantRemise').value = "0.00";
		document.getElementById('oem-pttcMontantFraisPort').value = "0.00";
		document.getElementById('oem-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oem-pttcTotalTVA').value = "0.00";
		document.getElementById('oem-pttcMontantTTC').value = "0.00";
		document.getElementById('oem-pttcMontantEscompte').value = "0.00";
		document.getElementById('oem-pttcTotalTTC').value = "0.00";
		document.getElementById('oem-pttcNetTTC').value = "0.00";

		document.getElementById('oem-rowRemiseTTC').collapsed = true;
		document.getElementById('oem-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oem-rowEscompteTTC').collapsed = true;

		document.getElementById('oem-rowNetCommercialHT').collapsed = true;
		document.getElementById('oem-rowEscompteTTC').collapsed = true;
		document.getElementById('oem-pttcNetCommercial').value = "0.00";
		document.getElementById('oem-netCommercial').value = "0.00";

		document.getElementById('oem-commentairesFin').value = "";
		document.getElementById('oem-commentairesInt').value = "";

		oem_ajouterLigne("I");
		oem_typeRistourne = 'P';
		document.getElementById('oem-bRistourne').setAttribute("class", "bIcoPourcentage");
		oem_aLignes.deleteTree();

		document.getElementById('oem-creation').setAttribute("label", "");
		document.getElementById('oem-modification').setAttribute("label", "");
		document.getElementById('oem-document').setAttribute("label", "");

		document.getElementById('oem-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oem-editionTTC').disabled = false;

		oem_debloquerInterface();

	}	catch (e) {
  	recup_erreur(e);
  }
}


function oem_enregistrerModele(quit) {
	try	{

		var ok = false;

		var reference = document.getElementById('oem-refModele').value;
		var intitule = document.getElementById('oem-intitule').value;
		var prefixeNumContrat = document.getElementById('oem-prefixeNumContrat').value;
		var periodicite = document.getElementById('oem-periodicite').value;
		var typePeriodicite = document.getElementById('oem-typePeriodicite').value;
		var dureeContrat = document.getElementById('oem-dureeContrat').value;
		var typeDureeContrat = document.getElementById('oem-typeDureeContrat').value;
		var dureeReconduction = document.getElementById('oem-dureeReconduction').value;
		var typeDureeReconduction = document.getElementById('oem-typeDureeReconduction').value;
		var typeReconduction = document.getElementById('oem-typeReconduction').value;
 		var delaiPreavis = document.getElementById('oem-delaiPreavis').value;
 		var pEvolRecond = document.getElementById('oem-pEvolRecond').value;
 		var poleActivite = document.getElementById('oem-poleActivite').value;
		var responsable = document.getElementById('oem-responsable').value;
		var tarifVente = document.getElementById('oem-tarifVente').value;
		var delaiGeneration = document.getElementById('oem-delaiGeneration').value;
		var nbPeriodeOfferte = document.getElementById('oem-nbPeriodeOfferte').value;
		var termeFacturation = document.getElementById('oem-termeFacturation').value;
		var modaliteReg = document.getElementById('oem-modaliteReg').value;
		var commentairesFin = document.getElementById('oem-commentairesFin').value;
		var commentairesInt = document.getElementById('oem-commentairesInt').value;
		var modeReglement = document.getElementById('oem-modeReglement').value;
		var remise = document.getElementById('oem-remise').value;
    var remiseFP = document.getElementById('oem-remiseFP').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var fraisPort = document.getElementById('oem-fraisPort').value;
		var escompte = document.getElementById('oem-escompte').value;
		var montantBase = (oem_editionTTC?oem_montantTTC:oem_montantHT);
		var editionTTC = document.getElementById('oem-editionTTC').checked;

		//oem_codeTVAPort = document.getElementById('oem-codeTVAFraisPort').value;
		oem_tauxTVAPort = getTva(oem_codeTVAPort);

		if (isEmpty(reference)) {showWarning("Vous devez indiquer la r\u00E9f\u00E9rence du mod\u00E8le avant de l'enregistrer!");}
		else if (isEmpty(intitule)) {showWarning("Vous devez indiquer un intitul\u00E9 avant d'enregistrer le mod\u00E8le !");}
		else if (isEmpty(periodicite) || !isPositiveOrNull(periodicite)) { showWarning("Vous devez indiquer la p\u00E9riodicit\u00E9 de facturation !"); }
		else if (isEmpty(dureeContrat) || !isPositiveOrNull(dureeContrat)) { showWarning("Vous devez indiquer la dur\u00E9e du contrat !"); }
		else if (isEmpty(dureeReconduction) || !isPositiveOrNull(dureeReconduction)) { showWarning("Vous devez indiquer la dur\u00E9e de reconduction du contrat !"); }
		else if (isEmpty(delaiPreavis)|| !isPositiveOrNull(delaiPreavis)) {	showWarning("Vous devez indiquer le d\u00E9lai du pr\u00E9avis !"); }
		else if (isEmpty(pEvolRecond)|| !isTaux(pEvolRecond)) {	showWarning("Vous devez indiquer le pourcentage d'augmentation \u00E0 la reconduction !"); }
		else if (isEmpty(delaiGeneration)|| !isPositiveOrNull(delaiGeneration)) {	showWarning("Vous devez indiquer le d\u00E9lai de g\u00E9n\u00E9ration de la facture !"); }
		else if (isEmpty(nbPeriodeOfferte)|| !isPositiveOrNull(nbPeriodeOfferte)) {	showWarning("Vous devez indiquer le nombre de p\u00E9riodes offertes"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(remise) || (oem_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oem_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if ((oem_nbJourTypePeriode(typeDureeContrat)*dureeContrat)<(oem_nbJourTypePeriode(typePeriodicite)*periodicite)) { showWarning("La p\u00E9riodicit\u00E9 de facturation doit \u00EAtre inf\u00E9rieure ou \u00E9gale \u00E0 la dur\u00E9e du contrat");}
		else if ((oem_nbJourTypePeriode(typeDureeReconduction)*dureeReconduction)<(oem_nbJourTypePeriode(typePeriodicite)*periodicite)) { showWarning("La p\u00E9riodicit\u00E9 de facturation doit \u00EAtre inf\u00E9rieure ou \u00E9gale \u00E0 la dur\u00E9e de reconduction");}
		else {

			fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oem_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oem_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			var qSave;

			if (oem_mode=="C") {
				qSave = new QueryHttp("Facturation/Abonnements/createModeleAbonnement.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Abonnements/updateModeleAbonnement.tmpl");
				qSave.setParam("Modele_Id", oem_modeleId);
			}

			qSave.setParam("Ref_Modele", reference);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Pole_Activite", poleActivite);
			qSave.setParam("Periodicite", periodicite);
			qSave.setParam("Type_Periodicite", typePeriodicite);
			qSave.setParam("Duree_Contrat", dureeContrat);
			qSave.setParam("Type_Duree_Contrat", typeDureeContrat);
			qSave.setParam("Duree_Reconduction", dureeReconduction);
			qSave.setParam("Type_Duree_Reconduction", typeDureeReconduction);
			qSave.setParam("Type_Reconduction", typeReconduction);
			qSave.setParam("Delai_Preavis", delaiPreavis);
			qSave.setParam("PEvol_Recond", pEvolRecond);
			qSave.setParam("Delai_Generation", delaiGeneration);
			qSave.setParam("Modalite_Id", modaliteReg);
			qSave.setParam("Util_R", responsable);
			qSave.setParam("Tarif_Id", tarifVente);
			qSave.setParam("modeReglement", modeReglement);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("fraisPort", fraisPort);
			qSave.setParam("PRemise", tauxRemise);
			qSave.setParam("MRemise", montantRemise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
			qSave.setParam("escompte", escompte);
			qSave.setParam("Terme_Facturation", termeFacturation);
			qSave.setParam("Prefixe_Num_Contrat", prefixeNumContrat);
			qSave.setParam("Nb_Periode_Offerte", nbPeriodeOfferte);
			qSave.setParam("Edition_TTC", editionTTC);
			qSave.setParam("Code_TVA_Port", oem_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oem_tauxTVAPort);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oem_mode=="C") {
					oem_modeleId = result.responseXML.documentElement.getAttribute("Modele_Id");
					if (!quit) {
						oem_chargerModele();
					}
				}

				oem_setModified(false);
				ok = true;
			}
		}

		return ok;

	}	catch(e) {
   	recup_erreur(e);
  }
}


function oem_validerLigne() {
  try	{

		if (oem_mode=="C") {
			oem_enregistrerModele(false);
		}

		if (!isEmpty(oem_modeleId))	{

			var reference = document.getElementById("oem-reference").value;
			var designation = document.getElementById("oem-designation").value;
			var quantite = document.getElementById("oem-quantite").value;
			var prixUnitaire = document.getElementById("oem-prixUnitaire").value;
			var ristourne = document.getElementById("oem-ristourne").value;
			var codeTVA = document.getElementById("oem-codeTVA").value;

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !");	}
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect !");	}
			else if (isEmpty(ristourne) || (oem_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else {

				var qSave;

				if (oem_modeLigne=="C") {
					qSave = new QueryHttp("Facturation/Abonnements/createLigneModeleAbonnement.tmpl");
					qSave.setParam("Modele_Id", oem_modeleId);
				}
				else {
					qSave = new QueryHttp("Facturation/Abonnements/updateLigneModeleAbonnement.tmpl");
					qSave.setParam("Ligne_Id", oem_ligneId);
				}

				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oem_typeRistourne);
				qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Libelle", oem_libelle);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oem_ajouterLigne("I");
					oem_aLignes.initTree(oem_calculTotaux);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_demandeEnregistrement() {
  try {

		if (oem_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au mod\u00E8le ?")) {
				oem_enregistrerModele(true);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_supprimerModele() {
	try	{

		if (window.confirm("Confirmez-vous la suppression du mod\u00E8le d'abonnement ?"))	{

			if (!isEmpty(oem_modeleId))	{

				var qDelete = new QueryHttp("Facturation/Abonnements/deleteModeleAbonnement.tmpl");
				qDelete.setParam("Modele_Id", oem_modeleId);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showMessage("Le mod\u00E8le a \u00E9t\u00E9 supprim\u00E9");
					retourMenuModeles();
				}
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oem_chargerModele() {
  try {

		oem_mode = "M";

		var qLoad = new QueryHttp("Facturation/Abonnements/loadModeleAbonnement.tmpl");
		qLoad.setParam("Modele_Id", oem_modeleId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			document.getElementById('oem-refModele').value = contenu.getAttribute('Ref_Modele');
			document.getElementById('oem-intitule').value = contenu.getAttribute('Intitule');
			document.getElementById('oem-prefixeNumContrat').value = contenu.getAttribute('Prefixe_Num_Contrat');
			document.getElementById('oem-periodicite').value = contenu.getAttribute('Periodicite');
			document.getElementById('oem-typePeriodicite').value = contenu.getAttribute('Type_Periodicite');
			document.getElementById('oem-dureeContrat').value = contenu.getAttribute('Duree_Contrat');
			document.getElementById('oem-typeDureeContrat').value = contenu.getAttribute('Type_Duree_Contrat');
			document.getElementById('oem-dureeReconduction').value = contenu.getAttribute('Duree_Reconduction');
 			document.getElementById('oem-typeDureeReconduction').value = contenu.getAttribute('Type_Duree_Reconduction');
			document.getElementById('oem-typeReconduction').value = contenu.getAttribute('Type_Reconduction');
			oem_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
			document.getElementById('oem-delaiPreavis').value = contenu.getAttribute('Delai_Preavis');
			document.getElementById('oem-pEvolRecond').value = contenu.getAttribute('PEvol_Recond');

			oem_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
			oem_chargerResponsables(contenu.getAttribute('Util_R'));
			document.getElementById('oem-delaiGeneration').value = contenu.getAttribute('Delai_Generation');
			document.getElementById('oem-nbPeriodeOfferte').value = contenu.getAttribute('Nb_Periode_Offerte');
			document.getElementById('oem-termeFacturation').value = contenu.getAttribute('Terme_Facturation');

			document.getElementById('oem-modaliteReg').value = contenu.getAttribute('Modalite_Id');

			oem_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
    	oem_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');
			oem_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

			oem_aTauxTVA.setParam("Selection", oem_codesTvaInactifs);
			oem_aTauxTVA.initTree();

			document.getElementById('oem-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
			document.getElementById('oem-commentairesInt').value = contenu.getAttribute('Commentaires_Int');

			oem_chargerModesReglement(contenu.getAttribute('Mode_reglement'));
			document.getElementById('oem-escompte').value = contenu.getAttribute('Escompte');
			document.getElementById('oem-fraisPort').value = contenu.getAttribute('Frais_Port');

			oem_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
			document.getElementById('oem-remise').value = (oem_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
			document.getElementById('oem-bRemise').setAttribute("class", (oem_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

			oem_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
			document.getElementById('oem-remiseFP').value = (oem_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
			document.getElementById('oem-bRemiseFP').setAttribute("class", (oem_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

			var typeEdition = contenu.getAttribute('Edition_TTC')=="true";
			document.getElementById('oem-editionTTC').checked = typeEdition;

			document.getElementById('oem-creation').label = "Mod\u00E8le d'abonnement cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur');
			document.getElementById('oem-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
			document.getElementById('oem-document').label = "Mod\u00E8le R\u00E9f. "+ contenu.getAttribute('Ref_Modele');

			document.getElementById('oem-bSupprimerModele').disabled = false;

			document.getElementById('oem-bOuvrirCommentairesCaches').disabled = false;

			oem_setModified(false);
			oem_debloquerInterface();
			oem_changerTypeEdition(typeEdition);

			oem_aLignes.setParam("Modele_Id", oem_modeleId);
    	oem_aLignes.initTree(oem_calculTotaux);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function oem_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "MA", oem_modeleId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oem-commentairesFin').value;
		var commentairesInt = document.getElementById('oem-commentairesInt').value;
		var readOnly = (oem_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oem_retourEditerCommentaires, "MA", oem_modeleId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oem-commentairesFin').value = commentairesFin;
		document.getElementById('oem-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oem-bSupprimer').disabled = true;
		oem_modeLigne = "C";
		oem_ligneId = "";
		oem_formatLigne(typeLigne);

		if (typeLigne=="S") {
			oem_articleId = articleId;

			if (oem_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oem_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oem_prixId))	{
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oem_prixId);
					qGet.setParam("TTC", oem_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					document.getElementById("oem-designation").value = contenu.getAttribute("Designation");
					document.getElementById('oem-quantite').value = contenu.getAttribute("Quantite");
					document.getElementById("oem-prixUnitaire").value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('oem-ristourne').value = "0.00";
					document.getElementById("oem-codeTVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), "FR", false, "G");
					oem_prixId = "";
					oem_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oem_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oem-tarifVente').value);
				qGet.setParam("TTC", oem_editionTTC);
				qGet.setParam("Client_Id", "");
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById("oem-designation").value = contenu.getAttribute("Designation");
				document.getElementById('oem-quantite').value = 1;
				document.getElementById("oem-prixUnitaire").value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('oem-ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById("oem-codeTVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), "FR", false, "G");
				oem_libelle = "";
			}
		}
		else {
			oem_articleId = "";
			document.getElementById('oem-reference').value = "";
			document.getElementById('oem-designation').value = "";
			document.getElementById('oem-quantite').value = 1;
			document.getElementById('oem-prixUnitaire').value = "";
			document.getElementById('oem-ristourne').value = "0.00";
			document.getElementById('oem-codeTVA').value = getCodeTvaNormalFrance();
			oem_libelle = "";
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_retourChoixPrixQuantite(prixId) {
	try {

		oem_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('oem-reference').disabled = true;
				document.getElementById('oem-designation').disabled = true;
				document.getElementById('oem-quantite').disabled = false;
				document.getElementById('oem-prixUnitaire').disabled = false;
				document.getElementById('oem-ristourne').disabled = false;
				document.getElementById('oem-bRistourne').disabled = false;
				document.getElementById('oem-codeTVA').disabled = false;
				document.getElementById('oem-bValider').disabled = false;
				document.getElementById('oem-bAnnuler').disabled = false;
				break;

			case "I":
				document.getElementById('oem-reference').disabled = false;
				document.getElementById('oem-designation').disabled = false;
				document.getElementById('oem-quantite').disabled = false;
				document.getElementById('oem-prixUnitaire').disabled = false;
				document.getElementById('oem-ristourne').disabled = false;
				document.getElementById('oem-bRistourne').disabled = false;
				document.getElementById('oem-codeTVA').disabled = false;
				document.getElementById('oem-bValider').disabled = false;
				document.getElementById('oem-bAnnuler').disabled = false;
				break;

			default:
				document.getElementById('oem-reference').value = "";
				document.getElementById('oem-designation').value = "";
				document.getElementById('oem-quantite').value = "";
				document.getElementById('oem-prixUnitaire').value = "";
				document.getElementById('oem-ristourne').value = "";
				oem_libelle = "";
				oem_ligneId = "";
				document.getElementById('oem-codeTVA').value = getCodeTvaNormalFrance();
				document.getElementById('oem-reference').disabled = true;
				document.getElementById('oem-designation').disabled = true;
				document.getElementById('oem-quantite').disabled = true;
				document.getElementById('oem-prixUnitaire').disabled = true;
				document.getElementById('oem-ristourne').disabled = true;
				document.getElementById('oem-bRistourne').disabled = true;
				document.getElementById('oem-codeTVA').disabled = true;
				document.getElementById('oem-bSupprimer').disabled = true;
				document.getElementById('oem-bValider').disabled = true;
				document.getElementById('oem-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_calculTotaux() {
  try {

		document.getElementById('oem-editionTTC').disabled = (oem_aLignes.nbLignes()>0);
		document.getElementById('oem-tarifVente').disabled = (oem_aLignes.nbLignes()>0);

		var remise = parseFloat(document.getElementById('oem-remise').value);
		var remiseFP = parseFloat(document.getElementById('oem-remiseFP').value);
		var taux_escompte = parseFloat(document.getElementById('oem-escompte').value);
		var frais_port = parseFloat(document.getElementById('oem-fraisPort').value);

		if ((oem_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oem_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(taux_escompte) && isPositiveOrNull(frais_port)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oem_editionTTC);
			if (oem_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(frais_port);
			if (oem_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setTauxTVAFP(oem_tauxTVAPort);
			calculDocument.setEscompteP(taux_escompte);

			for (var i=0;i<oem_aLignes.nbLignes();i++) {
				if (oem_aLignes.getCellText(i,'oem-colTypeLigne')!="C") {
					var montantLigne = oem_aLignes.getCellText(i,'oem-colTotalHT');
					var codeTVA = oem_aLignes.getCellText(i,'oem-colCodeTVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			if (oem_editionTTC) {
				document.getElementById('oem-pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oem-pttcMontantFraisPort').value = calculDocument.getFraisPortBruts();
				document.getElementById('oem-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oem-pttcTotalTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oem-pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('oem-pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oem-pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oem-pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('oem-pttcNetTTC').value = calculDocument.getNetAPayer();

				oem_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
			}
			else {
				document.getElementById('oem-montantHT').value = calculDocument.getMontantHT();
				document.getElementById('oem-montantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oem-montantFraisPort').value = calculDocument.getFraisPortBruts();
				document.getElementById('oem-montantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oem-totalHT').value = calculDocument.getTotalHT();
				document.getElementById('oem-totalTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oem-montantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oem-netCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oem-totalTTC').value = calculDocument.getTotalTTC();

				oem_montantHT = calculDocument.getMontantHTSansFormat();

				document.getElementById('oem-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oem-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oem-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oem-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oem_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oem_retourRechercherStock, "V", reference);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oem-reference').value = reference;
		document.getElementById('oem-quantite').focus();
		oem_ajouterLigne("S", articleId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_rechercherReference() {
	try {

		var reference = document.getElementById('oem-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oem-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oem-quantite').focus();
			oem_ajouterLigne("S", articleId);
		}
		else {
			oem_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_ouvrirLigne() {
  try {

		if (oem_aLignes.isSelected() && oem_mode=="M") {
			if (oem_aLignes.getSelectedCellText('oem-colTypeLigne')=="C") {
				oem_ajouterLigne("I");
			}
			else {
				oem_modeLigne = "M";
				document.getElementById('oem-bSupprimer').disabled = false;

				document.getElementById("oem-reference").value = oem_aLignes.getSelectedCellText('oem-colReference');
				document.getElementById("oem-designation").value = oem_aLignes.getSelectedCellText('oem-colDesignation');
				document.getElementById("oem-quantite").value = oem_aLignes.getSelectedCellText('oem-colQuantite');
				document.getElementById("oem-prixUnitaire").value = oem_aLignes.getSelectedCellText('oem-colPrixUnitaire');
				document.getElementById("oem-codeTVA").value = oem_aLignes.getSelectedCellText('oem-colCodeTVA');
				document.getElementById("oem-ristourne").value = oem_aLignes.getSelectedCellValue('oem-colRistourne');
				oem_typeRistourne = oem_aLignes.getSelectedCellText('oem-colTypeRistourne');
				document.getElementById('oem-bRistourne').setAttribute("class", (oem_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
				oem_ligneId = oem_aLignes.getSelectedCellText('oem-colLigneId');
				oem_libelle = oem_aLignes.getSelectedCellText('oem-colLibelle');
				oem_articleId = oem_aLignes.getSelectedCellText('oem-colArticleId');

				oem_formatLigne(oem_aLignes.getSelectedCellText('oem-colTypeLigne'));
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_annulerLigne() {
  try {

  	oem_aLignes.clearSelection();
		oem_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_pressOnWindow(ev) {
	try {

		if (ev.altKey && oem_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oem_rechercherStock();
        	break;
    	}
		}
		else if (ev.ctrlKey && oem_mode!="V" && ev.keyCode==46) {
			// ctrl + suppr
			ev.preventDefault();
			oem_supprimerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oem_supprimerLigne() {
  try {

		if (!isEmpty(oem_ligneId)) {
			var qDelete = new QueryHttp("Facturation/Abonnements/deleteLigneModeleAbonnement.tmpl");
			qDelete.setParam("Ligne_Id", oem_ligneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oem_ajouterLigne("I");
				oem_aLignes.initTree(oem_calculTotaux);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_editerCommentaire() {
	try	{

		if (oem_aLignes.isSelected())	{
			var ligneId = oem_aLignes.getSelectedCellText('oem-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "MA", ligneId);

			oem_aLignes.initTree(oem_calculTotaux);
			oem_ajouterLigne("I");
		}
		else {
			showWarning("Aucun article ou commentaire s\u00E9lectionn\u00E9 !");
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function oem_ouvrirCommentaire() {
  try {

		if (oem_aLignes.isSelected() && oem_mode=="M") {
			if (oem_aLignes.getSelectedCellText('oem-colTypeLigne')=="C") {
				oem_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_nbJourTypePeriode(typePeriode) {
	try	{

		var nbJour;

		if (typePeriode=='M') {
			nbJour = 30;
		}
		else if (typePeriode=='A') {
			nbJour = 360;
		}
		else if (typePeriode=='S') {
			nbJour = 7;
		}
		else {
			nbJour = 1;
		}

		return nbJour;

	}	catch(e) {
   	recup_erreur(e);
  }
}


function oem_setModified(m) {
  try {

  	oem_modified = m;

		if (m) {
			document.getElementById('Param_modele').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('Param_modele').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oem_changerTypeEdition(chgType) {
	try {

		oem_editionTTC = chgType;

		if (oem_editionTTC) {
			document.getElementById('oem-colTotalHT').setAttribute("label", "Total TTC");
			document.getElementById('oem-colPrixUnitaire').setAttribute("label", "P.U TTC");
			document.getElementById('oem-lblFraisPort').value = "Frais de port (ttc) :";
			document.getElementById('oem-lblPrixUnitaire').value = "P.U TTC :";
			document.getElementById('oem-piedTTC').collapsed = false;
			document.getElementById('oem-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oem-colTotalHT').setAttribute("label", "Total HT");
			document.getElementById('oem-colPrixUnitaire').setAttribute("label", "P.U HT");
			document.getElementById('oem-lblFraisPort').value = "Frais de port (ht) :";
			document.getElementById('oem-lblPrixUnitaire').value = "P.U HT :";
			document.getElementById('oem-piedTTC').collapsed = true;
			document.getElementById('oem-piedHT').collapsed = false;
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oem_choisirMentions() {
  try {

  	var ok = true;

  	if (oem_mode=="C") {
			ok = oem_enregistrerModele(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "MA", oem_modeleId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oem_chargerTarifsVente(selection) {
	try {

		oem_selTarifVente = selection;
		oem_aTarifsVente.setParam("Selection", oem_selTarifVente);
		oem_aTarifsVente.initTree(oem_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oem_initTarifVente() {
  try {

		document.getElementById('oem-tarifVente').value = oem_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
