/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omc_aContrats = new Arbre("Facturation/Abonnements/list-contratAbonnement.tmpl", "omc-listeContrats");
var omc_aApercuContrat = new Arbre("Facturation/Abonnements/list-apercuContratAbonnement.tmpl", "omc-apercu");
var omc_qListCA = new QueryHttp("Facturation/Abonnements/getDataListCA.tmpl");

var omc_pageCourante;
var omc_nbPages;

var omc_restrictedPoleActivite = "";



function omc_init() {
  try {

		if (gProfil.isRestricAccCDVPA() && !isEmpty(gProfil.getPoleActivite())) {
			omc_restrictedPoleActivite = gProfil.getPoleActivite();
			document.getElementById('omc-poleActivite').disabled = true;
		}

		var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "omc-responsable");
		aResponsables.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "omc-poleActivite");
		if (!isEmpty(omc_restrictedPoleActivite)) {
			aPolesActivite.setParam("Selection", omc_restrictedPoleActivite);
		}
		aPolesActivite.initTree(omc_initEtablissement);

		omc_loadChiffresCles();

  } catch (e) {
  	recup_erreur(e);
  }
}


function omc_initEtablissement() {
	try {

		var aEtablissements = new Arbre("ComboListe/combo-etablissements.tmpl", "omc-etablissement");
		aEtablissements.setParam('Selection', gEtablissementDefaut);
		aEtablissements.initTree(omc_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_initCriteres() {
	try {

		document.getElementById('omc-numContrat').value = "";
		document.getElementById('omc-numClient').value = "";
		document.getElementById('omc-denomination').value = "";
		document.getElementById('omc-etatContrat').value = "C";
		document.getElementById('omc-dateContratDebut').value = "";
		document.getElementById('omc-dateContratFin').value = "";
		document.getElementById('omc-refArticle').value = "";
		document.getElementById('omc-intitule').value = "";
		document.getElementById('omc-etablissement').value = gEtablissementDefaut;
		document.getElementById('omc-poleActivite').value = omc_restrictedPoleActivite;
		document.getElementById('omc-responsable').selectedIndex = 0;
		document.getElementById('omc-refModele').value = "";
		document.getElementById('omc-typeReconduction').value = "";
		document.getElementById('omc-dateAbonnementDebut').value = "";
		document.getElementById('omc-dateAbonnementFin').value = "";

		omc_listerContrats();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_listerContrats() {
	try {

		var numContrat = document.getElementById('omc-numContrat').value;
		var numClient = document.getElementById('omc-numClient').value;
		var denomination = document.getElementById('omc-denomination').value;
		var etatContrat = document.getElementById('omc-etatContrat').value;
		var dateContratDebut = document.getElementById('omc-dateContratDebut').value;
		var dateContratFin = document.getElementById('omc-dateContratFin').value;
		var refArticle = document.getElementById('omc-refArticle').value;
		var poleActivite = document.getElementById('omc-poleActivite').value;
		var etablissement = document.getElementById('omc-etablissement').value;
		var intitule = document.getElementById('omc-intitule').value;
		var responsable = document.getElementById('omc-responsable').value;
		var refModele = document.getElementById('omc-refModele').value;
		var typeReconduction = document.getElementById('omc-typeReconduction').value;
		var dateAbonnementDebut = document.getElementById('omc-dateAbonnementDebut').value;
		var dateAbonnementFin = document.getElementById('omc-dateAbonnementFin').value;
		var nbLignesParPage = document.getElementById('omc-nbLignesParPage').value;

		if (!isEmpty(dateContratDebut) && !isDate(dateContratDebut)) { showWarning("Date de d\u00E9but contrat incorrecte"); }
		else if (!isEmpty(dateContratFin) && !isDate(dateContratFin)) { showWarning("Date de fin contrat incorrecte"); }
		else if (!isEmpty(dateContratDebut) && !isEmpty(dateContratFin) && !isDateInterval(dateContratDebut, dateContratFin)) { showWarning("Plage de dates contrat incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isDate(dateAbonnementDebut)) { showWarning("Date de d\u00E9but abonnement incorrecte"); }
		else if (!isEmpty(dateAbonnementFin) && !isDate(dateAbonnementFin)) { showWarning("Date de fin abonnement incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isEmpty(dateAbonnementFin) && !isDateInterval(dateAbonnementDebut, dateAbonnementFin)) { showWarning("Plage de dates abonnement incorrecte"); }
		else {

			omc_pageCourante = 1;
			omc_nbPages = 1;
			document.getElementById('omc-pageDeb').value = 1;
			document.getElementById('omc-pageFin').value = 1;
			document.getElementById('omc-bPrec').disabled = true;
			document.getElementById('omc-bSuiv').disabled = true;

			document.getElementById('omc-listeContrats').disabled = true;
			document.getElementById('omc-bEditionCsv').disabled = true;
			document.getElementById('omc-bEditerContrats').disabled = true;
			document.getElementById('omc-numContratSelect').value = "";
			omc_aApercuContrat.deleteTree();
			omc_aContrats.deleteTree();

			omc_qListCA.setParam("Num_Contrat", numContrat);
			omc_qListCA.setParam("Num_Client", numClient);
			omc_qListCA.setParam("Denomination", denomination);
			omc_qListCA.setParam("Etat_Contrat", etatContrat);
			omc_qListCA.setParam("Date_Contrat_Debut", dateContratDebut);
			omc_qListCA.setParam("Date_Contrat_Fin", dateContratFin);
			omc_qListCA.setParam("Ref_Article", refArticle);
			omc_qListCA.setParam("Intitule", intitule);
			omc_qListCA.setParam("Responsable", responsable);
			omc_qListCA.setParam("Pole_Activite", poleActivite);
			omc_qListCA.setParam("Etablissement", etablissement);
			omc_qListCA.setParam("Ref_Modele", refModele);
			omc_qListCA.setParam("Type_Reconduction", typeReconduction);
			omc_qListCA.setParam("Date_Abonnement_Debut", dateAbonnementDebut);
			omc_qListCA.setParam("Date_Abonnement_Fin", dateAbonnementFin);
			omc_qListCA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omc_qListCA.setParam("Current_Page", omc_pageCourante);

			var result = omc_qListCA.execute();

			var contenu = result.responseXML.documentElement;

			omc_nbPages = contenu.getAttribute("Nb_Pages");
			var listContratId = contenu.getAttribute("List_Contrat_Id");

			omc_aContrats.setParam("List_Contrat_Id", listContratId);
			omc_aContrats.initTree(omc_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_initPagination() {
	try {

		document.getElementById('omc-pageDeb').value = omc_pageCourante;
		document.getElementById('omc-pageFin').value = (omc_nbPages>0?omc_nbPages:1);
		document.getElementById('omc-bPrec').disabled = (omc_pageCourante==1);
		document.getElementById('omc-bSuiv').disabled = (omc_pageCourante>=omc_nbPages); // peut se produire si omc_nbPages=0

		omc_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnPagePrec() {
	try {

		omc_pageCourante--;
		omc_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnPageSuiv() {
	try {

		omc_pageCourante++;
		omc_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_majPagination() {
	try {
		document.getElementById('omc-pageDeb').value = omc_pageCourante;
		document.getElementById('omc-bPrec').disabled = (omc_pageCourante==1);
		document.getElementById('omc-bSuiv').disabled = (omc_pageCourante==omc_nbPages);

		document.getElementById('omc-numContratSelect').value = "";

		document.getElementById('omc-listeContrats').disabled = true;
		document.getElementById('omc-bEditionCsv').disabled = true;
		document.getElementById('omc-bEditerContrats').disabled = true;
		omc_aApercuContrat.deleteTree();

		omc_qListCA.setParam("Current_Page", omc_pageCourante);
		var result = omc_qListCA.execute();
		var listContratId = result.responseXML.documentElement.getAttribute("List_Contrat_Id");

		omc_aContrats.setParam("List_Contrat_Id", listContratId);
		omc_aContrats.initTree(omc_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_afterMajPagination() {
	try {

		document.getElementById('omc-listeContrats').disabled = false;
		document.getElementById('omc-bEditionCsv').disabled=(omc_aContrats.nbLignes()==0);
		document.getElementById('omc-bEditerContrats').disabled=(omc_aContrats.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_selectOnListeContrats() {
	try {

		if (omc_aContrats.isSelected()) {
			document.getElementById("omc-deckApercu").selectedIndex = 1;
			var contratId = omc_aContrats.getSelectedCellText('omc-colContratId');
			document.getElementById('omc-numContratSelect').value = omc_aContrats.getSelectedCellText('omc-colNumContrat');
			omc_aApercuContrat.setParam("Contrat_Id", contratId);
			omc_aApercuContrat.initTree();

			var editionTTC = (omc_aContrats.getSelectedCellText("omc-colEditionTTC")=="true");
			document.getElementById('omc-acColMontant').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnNouveauContrat() {
	try {

		var url = "chrome://opensi/content/facturation/user/abonnements/popup-rechercheModele.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omc_pressOnNouveauContrat_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnNouveauContrat_2(refModele, modeleId) {
	try {

		oec_modeleId = modeleId;
		oec_nouveauContrat();
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuContrats').collapsed = false;
		document.getElementById('bMenuModeles').collapsed = true;
		document.getElementById('bMenuFacturation').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omc_listerContrats();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_pressOnListeContrats(ev) {
  try {

		if (ev.keyCode==13) {
			omc_ouvrirContrat();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_ouvrirContrat() {
  try {

  	if (omc_aContrats.isSelected()) {
			oec_contratId = omc_aContrats.getSelectedCellText('omc-colContratId');
			document.getElementById("oec-panneau").selectedIndex = 0;
			oec_chargerContrat();
			document.getElementById('bMenuContrats').collapsed = false;
			document.getElementById('bMenuModeles').collapsed = true;
			document.getElementById('bMenuFacturation').collapsed = true;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_pressOnEditionCsv() {
	try {

		var numContrat = document.getElementById('omc-numContrat').value;
		var numClient = document.getElementById('omc-numClient').value;
		var denomination = document.getElementById('omc-denomination').value;
		var etatContrat = document.getElementById('omc-etatContrat').value;
		var dateContratDebut = document.getElementById('omc-dateContratDebut').value;
		var dateContratFin = document.getElementById('omc-dateContratFin').value;
		var refArticle = document.getElementById('omc-refArticle').value;
		var poleActivite = document.getElementById('omc-poleActivite').value;
		var etablissement = document.getElementById('omc-etablissement').value;
		var intitule = document.getElementById('omc-intitule').value;
		var responsable = document.getElementById('omc-responsable').value;
		var refModele = document.getElementById('omc-refModele').value;
		var typeReconduction = document.getElementById('omc-typeReconduction').value;
		var dateAbonnementDebut = document.getElementById('omc-dateAbonnementDebut').value;
		var dateAbonnementFin = document.getElementById('omc-dateAbonnementFin').value;

		if (!isEmpty(dateContratDebut) && !isDate(dateContratDebut)) { showWarning("Date de d\u00E9but contrat incorrecte"); }
		else if (!isEmpty(dateContratFin) && !isDate(dateContratFin)) { showWarning("Date de fin contrat incorrecte"); }
		else if (!isEmpty(dateContratDebut) && !isEmpty(dateContratFin) && !isDateInterval(dateContratDebut, dateContratFin)) { showWarning("Plage de dates contrat incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isDate(dateAbonnementDebut)) { showWarning("Date de d\u00E9but abonnement incorrecte"); }
		else if (!isEmpty(dateAbonnementFin) && !isDate(dateAbonnementFin)) { showWarning("Date de fin abonnement incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isEmpty(dateAbonnementFin) && !isDateInterval(dateAbonnementDebut, dateAbonnementFin)) { showWarning("Plage de dates abonnement incorrecte"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Abonnements/csvContratAbonnement.tmpl");

			qEditionCsv.setParam("Num_Contrat", numContrat);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat_Contrat", etatContrat);
			qEditionCsv.setParam("Date_Contrat_Debut", dateContratDebut);
			qEditionCsv.setParam("Date_Contrat_Fin", dateContratFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Intitule", intitule);
			qEditionCsv.setParam("Responsable", responsable);
			qEditionCsv.setParam("Pole_Activite", poleActivite);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Ref_Modele", refModele);
			qEditionCsv.setParam("Type_Reconduction", typeReconduction);
			qEditionCsv.setParam("Date_Abonnement_Debut", dateAbonnementDebut);
			qEditionCsv.setParam("Date_Abonnement_Fin", dateAbonnementFin);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnEditerContrats() {
	try {

		var numContrat = document.getElementById('omc-numContrat').value;
		var numClient = document.getElementById('omc-numClient').value;
		var denomination = document.getElementById('omc-denomination').value;
		var etatContrat = document.getElementById('omc-etatContrat').value;
		var dateContratDebut = document.getElementById('omc-dateContratDebut').value;
		var dateContratFin = document.getElementById('omc-dateContratFin').value;
		var refArticle = document.getElementById('omc-refArticle').value;
		var poleActivite = document.getElementById('omc-poleActivite').value;
		var etablissement = document.getElementById('omc-etablissement').value;
		var intitule = document.getElementById('omc-intitule').value;
		var responsable = document.getElementById('omc-responsable').value;
		var refModele = document.getElementById('omc-refModele').value;
		var typeReconduction = document.getElementById('omc-typeReconduction').value;
		var dateAbonnementDebut = document.getElementById('omc-dateAbonnementDebut').value;
		var dateAbonnementFin = document.getElementById('omc-dateAbonnementFin').value;

		if (!isEmpty(dateContratDebut) && !isDate(dateContratDebut)) { showWarning("Date de d\u00E9but contrat incorrecte"); }
		else if (!isEmpty(dateContratFin) && !isDate(dateContratFin)) { showWarning("Date de fin contrat incorrecte"); }
		else if (!isEmpty(dateContratDebut) && !isEmpty(dateContratFin) && !isDateInterval(dateContratDebut, dateContratFin)) { showWarning("Plage de dates contrat incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isDate(dateAbonnementDebut)) { showWarning("Date de d\u00E9but abonnement incorrecte"); }
		else if (!isEmpty(dateAbonnementFin) && !isDate(dateAbonnementFin)) { showWarning("Date de fin abonnement incorrecte"); }
		else if (!isEmpty(dateAbonnementDebut) && !isEmpty(dateAbonnementFin) && !isDateInterval(dateAbonnementDebut, dateAbonnementFin)) { showWarning("Plage de dates abonnement incorrecte"); }
		else {

			document.getElementById('omc-pdf').setAttribute("src", "");

			var qEditionPdf = new QueryHttp("Facturation/Abonnements/pdfEditionAbonnements.tmpl");

			qEditionPdf.setParam("Num_Contrat", numContrat);
			qEditionPdf.setParam("Num_Client", numClient);
			qEditionPdf.setParam("Denomination", denomination);
			qEditionPdf.setParam("Etat_Contrat", etatContrat);
			qEditionPdf.setParam("Date_Contrat_Debut", dateContratDebut);
			qEditionPdf.setParam("Date_Contrat_Fin", dateContratFin);
			qEditionPdf.setParam("Ref_Article", refArticle);
			qEditionPdf.setParam("Intitule", intitule);
			qEditionPdf.setParam("Responsable", responsable);
			qEditionPdf.setParam("Pole_Activite", poleActivite);
			qEditionPdf.setParam("Etablissement", etablissement);
			qEditionPdf.setParam("Ref_Modele", refModele);
			qEditionPdf.setParam("Type_Reconduction", typeReconduction);
			qEditionPdf.setParam("Date_Abonnement_Debut", dateAbonnementDebut);
			qEditionPdf.setParam("Date_Abonnement_Fin", dateAbonnementFin);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('omc-deckMenu').selectedIndex = 1;
				document.getElementById('bMenuContrats').collapsed = false;
				document.getElementById('bMenuModeles').collapsed = true;
				document.getElementById('bMenuFacturation').collapsed = true;
				document.getElementById('omc-pdf').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Facturation/Abonnements/getStatsContratAbonnement.tmpl");
		qStats.execute(omc_loadChiffresClesFin);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_loadChiffresClesFin(result) {
	try {

		var contenu = result.responseXML.documentElement;

		document.getElementById("omc-nbAbonnes").value = contenu.getAttribute("Nb_Abonnes");
		document.getElementById("omc-nbContrats").value = contenu.getAttribute("Nb_Contrats");

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen',omc_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_retourRechercherClient(numClient) {
	try {

  	document.getElementById('omc-numClient').value = numClient;
  	omc_listerContrats();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omc_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omc-refArticle').value = reference;
  	omc_listerContrats();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_rechercherModele() {
	try {

		var url = "chrome://opensi/content/facturation/user/abonnements/popup-rechercheModele.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omc_retourRechercherModele);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_retourRechercherModele(refModele, modeleId) {
	try {

  	document.getElementById('omc-refModele').value = refModele;
  	omc_listerContrats();

	} catch (e) {
		recup_erreur(e);
	}
}
