/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aApercuModele = new Arbre("Facturation/Abonnements/list-apercuModeleAbonnement.tmpl", "apercuModele");
var aModeles = new Arbre("Facturation/Abonnements/list-modeleAbonnement.tmpl", "listeModeles");
var qListMA = new QueryHttp("Facturation/Abonnements/getDataListMA.tmpl");

var pageCourante;
var nbPages;

var restrictedPoleActivite = "";



function init() {
  try {

		var profil = getProfil();

		if (profil.isRestricAccCDVPA() && !isEmpty(profil.getPoleActivite())) {
			restrictedPoleActivite = profil.getPoleActivite();
			document.getElementById('poleActivite').disabled = true;
		}

		var aDurees = new Arbre("ComboListe/combo-dureesModeleAbonnement.tmpl", "duree");
		aDurees.initTree();

		var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "responsable");
		aResponsables.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "poleActivite");
		if (!isEmpty(restrictedPoleActivite)) {
			aPolesActivite.setParam("Selection", restrictedPoleActivite);
		}
		aPolesActivite.initTree(initPoleActivite);

    document.getElementById('refModele').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function initPoleActivite() {
	try {

		document.getElementById('poleActivite').value = restrictedPoleActivite;

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnRefModele(ev) {
  try {

    if (ev.keyCode==13) {
			checkModele(document.getElementById('refModele').value);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerModeles();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function checkModele(refModele) {
  try {

		if (!isEmpty(refModele)) {
			var qSearch = new QueryHttp("Facturation/Abonnements/searchRefModele.tmpl");
			qSearch.setParam('Ref_Modele', refModele);

			var result = qSearch.execute();
			var contenu = result.responseXML.documentElement;

			var modeleId = contenu.getAttribute('Modele_Id');

			if (!isEmpty(modeleId)) {
				ouvrirModele(contenu.getAttribute('Ref_Modele'), modeleId);
			}
			else {
				listerModeles();
			}
		}
		else {
			listerModeles();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixModele();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirModele(refModele, modeleId) {
  try {

		window.arguments[0](refModele, modeleId);
    setTimeout("window.close()", 0); // pour fermeture si fonction appele d'un autre popup

  } catch (e) {
    recup_erreur(e);
  }
}


function choixModele() {
	try {

		if (aModeles.isSelected()) {
			var refModele = aModeles.getSelectedCellText('colRefModele');
			var modeleId = aModeles.getSelectedCellText('colModeleId');
			ouvrirModele(refModele, modeleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('refModele').value = "";
		document.getElementById('duree').value = "";
		document.getElementById('typeReconduction').value = "";
		document.getElementById('refArticle').value = "";
		document.getElementById('intitule').value = "";
		document.getElementById('poleActivite').value = restrictedPoleActivite;
		document.getElementById('responsable').selectedIndex = 0;

		listerModeles();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerModeles() {
	try {

		var refModele = document.getElementById('refModele').value;
		var duree = document.getElementById('duree').value;
		var typeReconduction = document.getElementById('typeReconduction').value;
		var refArticle = document.getElementById('refArticle').value;
		var poleActivite = document.getElementById('poleActivite').value;
		var intitule = document.getElementById('intitule').value;
		var responsable = document.getElementById('responsable').value;

		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeModeles').disabled = true;
		document.getElementById('refModeleSelect').value = "";
		aApercuModele.deleteTree();
		aModeles.deleteTree();

		qListMA.setParam("Ref_Modele", refModele);
		qListMA.setParam("Duree", duree);
		qListMA.setParam("Type_Reconduction", typeReconduction);
		qListMA.setParam("Ref_Article", refArticle);
		qListMA.setParam("Intitule", intitule);
		qListMA.setParam("Responsable", responsable);
		qListMA.setParam("Pole_Activite", poleActivite);
		qListMA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListMA.setParam("Current_Page", pageCourante);

		var result = qListMA.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listModeleId = contenu.getAttribute("List_Modele_Id");

		aModeles.setParam("List_Modele_Id", listModeleId);
		aModeles.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeModeles').disabled = true;

		document.getElementById('refModeleSelect').value = "";
		aApercuModele.deleteTree();

		qListMA.setParam("Current_Page", pageCourante);
		var result = qListMA.execute();
		var listModeleId = result.responseXML.documentElement.getAttribute("List_Modele_Id");

		aModeles.setParam("List_Modele_Id", listModeleId);
		aModeles.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeModeles').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeModeles() {
	try {

		if (aModeles.isSelected()) {
			var modeleId = aModeles.getSelectedCellText("colModeleId");
			document.getElementById('refModeleSelect').value = aModeles.getSelectedCellText("colRefModele");
			aApercuModele.setParam("Modele_Id", modeleId);
			aApercuModele.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle, "V");

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('refArticle').value = reference;
  	listerModeles();

	} catch (e) {
		recup_erreur(e);
	}
}
