/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oeb_aBon = new Arbre('Facturation/Affaires/list-ligneBonLivraison.tmpl', 'oeb-bonLivraison');
var oeb_aCom = new Arbre('Facturation/Affaires/liste-articlesALivrer.tmpl', 'oeb-commande');
var oeb_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oeb-modeExpedition");
var oeb_aLiensColis = new Arbre("Facturation/Affaires/list-colisBL.tmpl","oeb-liensColis");
var oeb_aVersion = new Arbre("Facturation/Affaires/list-versionBonLivraison.tmpl","oeb-listeVersion");
var oeb_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oeb-depot');

var oeb_commandeId;
var oeb_bonLivId;
var oeb_bloquerBLSansStock;
var oeb_mode;
var oeb_etatBon;
var oeb_statutExpedition;
var oeb_currentCodePaysLiv;
var oeb_langueDefaut;
var oeb_bonChiffre;
var oeb_editBP;
var oeb_editLF;
var oeb_editCF;
var oeb_etapePrepaBL;
var oeb_etapePrepaOL;
var oeb_etapePrepaLF;
var oeb_defautEtapePrepaBL;
var oeb_defautEtapePrepaOL;
var oeb_clientId = "";
var oeb_fournisseurId = "";
var oeb_typeExpedition;
var oeb_curDepot;
var oeb_chargerModeExpedition;
var oeb_actSuiviSerie;
var oeb_actSuiviLot;
var oeb_modified = false;
var oeb_envoiTrans;
var oeb_colisageAuto;
var oeb_nonPaye;
var oeb_assujettiTVA;
var oeb_specCMBL;
var oeb_specHMLBP;
var oeb_specHMBEP;
var oeb_listLigneId = "";



function oeb_init() {
	try {

		document.getElementById('oeb-rowFax').collapsed = !gShowFax;

		oeb_bonChiffre = gConfig.isBLChiffre();
		oeb_editBP = gConfig.isGACEditBP();
		oeb_editLF = gConfig.isGACEditLF();
		oeb_editCF = gConfig.isGACEditCF();
		oeb_envoiTrans = gConfig.isGACEnvoiTransFTP();

		oeb_actSuiviLot = gConfig.isActSuiviLot();
		var actNbPieces = gConfig.isActNbPieces();
		oeb_actSuiviSerie = gConfig.isActSuiviSerie();

		oeb_defautEtapePrepaBL = gConfig.isEtapePrepaBLCC();
		oeb_defautEtapePrepaOL = gConfig.isEtapePrepaOL();
		oeb_etapePrepaLF = gConfig.isEtapePrepaLF();

		oeb_bloquerBLSansStock = gConfig.isBloquerBLSansStock();
		oeb_colisageAuto = gConfig.isColisageAuto();
		document.getElementById('oeb-solder').collapsed = gConfig.isSoldeAutoCC();

		oeb_specCMBL = gConfig.isSpecCMBL();
		oeb_specHMLBP = gConfig.isSpecHMLBP();
		oeb_specHMBEP = gConfig.isSpecHMBEP();

		if (!isEmpty(gConfig.getUrlCTCControler())) {
			document.getElementById('oeb-colCTC').collapsed = false;
			document.getElementById('oeb-colCTC').setAttribute("ignoreincolumnpicker", false);
		}

		document.getElementById('oeb-bConsultSerieLigne').collapsed = !oeb_actSuiviSerie;
		document.getElementById('oeb-boxSaisieSerie').collapsed = !oeb_actSuiviSerie || gReadOnly;

		if (!oeb_actSuiviLot) {
			document.getElementById('oeb-colNumLotLiv').collapsed = true;
			document.getElementById('oeb-colNumLotLiv').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oeb-colDatePeremptionLiv').collapsed = true;
			document.getElementById('oeb-colDatePeremptionLiv').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oeb-rowNumLot').collapsed = true;
			document.getElementById('oeb-rowDLC').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oeb-colNbPiecesDev').collapsed = true;
			document.getElementById('oeb-colNbPiecesDev').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oeb-colNbPiecesLiv').collapsed = true;
			document.getElementById('oeb-colNbPiecesLiv').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oeb-rowNbPieces').collapsed = true;
		}

		var aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oeb-codePaysLiv");
		aPaysLiv.initTree(oeb_initPaysLiv);

		if (gReadOnly) {
			document.getElementById('oeb-bGenerateBP').collapsed = true;
			document.getElementById('oeb-bGenerateBL').collapsed = true;
			document.getElementById('oeb-bEnregistrer').collapsed = true;
			document.getElementById('oeb-bAnnulerColis').collapsed = true;
			document.getElementById('oeb-tabBon').setAttribute('tooltiptext', "Lecture seule");
		}

		if (!gAccesCoutAchat) {
			document.getElementById('oeb-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oeb-colPrixAchatCFLiv').setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById("oeb-colVolumeColis").setAttribute("label", "Volume ("+ gConfig.getSymboleUniteVolume() +")");

  } catch (e) {
  	recup_erreur(e);
  }
}


function oeb_initPaysLiv() {
	try {

		document.getElementById('oeb-codePaysLiv').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_initModeExpedition() {
	try {

		document.getElementById('oeb-modeExpedition').value = oeb_chargerModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_chargerModesExpedition(selection) {
	try {
		oeb_chargerModeExpedition = selection;
		oeb_aModesExpedition.setParam("Selection", oeb_chargerModeExpedition);
		oeb_aModesExpedition.initTree(oeb_initModeExpedition);
	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_chargerDepot(selection) {
	try {

		oeb_curDepot = selection;
		oeb_initModePrepa();

		oeb_aDepots.clearParams();
		oeb_aDepots.setParam("Selection", selection);
		oeb_aDepots.setParam("Depot_Vente", false);
		oeb_aDepots.setParam("Depot_Quarantaine", false);
		if (oeb_typeExpedition!="L") {
			oeb_aDepots.setParam("Depot_Logistique", false);
		}
		else {
			oeb_aDepots.setParam("Depot_Expedition", false);
			oeb_aDepots.setParam("Logisticien", oeb_fournisseurId);
		}
		oeb_aDepots.initTree(oeb_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_initDepot() {
	try {

		document.getElementById('oeb-depot').value = oeb_curDepot;
		document.getElementById('oeb-rowDepot').collapsed = (oeb_typeExpedition=="F");

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_reinitialiser() {
	try {

		oeb_mode = "C";
		oeb_etatBon = "N";
		oeb_clientId = "";
		oeb_curDepot = "";
		oeb_initModePrepa();
		oeb_chargerModeExpedition = "";
		oeb_nonPaye = false;

		oeb_aCom.deleteTree();
		oeb_aBon.deleteTree();

		document.getElementById('oeb-deckBonLivraison').selectedIndex = 0;
		document.getElementById('oeb-tabBoxBon').selectedIndex = 0;
		document.getElementById('oeb-labelLogin').value = "";
		document.getElementById('oeb-rowLoginWeb').collapsed = true;
		document.getElementById('oeb-raisonSociale').value = "";
		document.getElementById('oeb-adresseFact').value = "";
		document.getElementById('oeb-adresse2Fact').value = "";
		document.getElementById('oeb-adresse3Fact').value = "";
		document.getElementById('oeb-codePostalFact').value = "";
		document.getElementById('oeb-villeFact').value = "";
		document.getElementById('oeb-affaire').value = "";
		document.getElementById('oeb-numClient').value = "";
		document.getElementById('oeb-denominationLiv').value = "";
		document.getElementById('oeb-adresse1Liv').value = "";
		document.getElementById('oeb-adresse2Liv').value = "";
		document.getElementById('oeb-adresse3Liv').value = "";
		document.getElementById('oeb-codePostalLiv').value = "";
		document.getElementById('oeb-villeLiv').value = "";
		document.getElementById('oeb-codePaysLiv').value = "FR";
		document.getElementById('oeb-civInterLiv').value = "0";
		document.getElementById('oeb-nomInterLiv').value = "";
		document.getElementById('oeb-prenomInterLiv').value = "";
		document.getElementById('oeb-telInter1Liv').value = "";
		document.getElementById('oeb-telInter2Liv').value = "";
		document.getElementById('oeb-faxInterLiv').value = "";
		document.getElementById('oeb-emailInterLiv').value = "";
		document.getElementById('oeb-tabBon').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
		document.getElementById('oeb-lblNumBL').value = "";
		document.getElementById('oeb-lblDateBL').value = "";
		document.getElementById('oeb-indications').value = "";
		document.getElementById('oeb-infoExpeLot').value = "";
		document.getElementById('oeb-infoPrepaExpe').value = "";
		document.getElementById('oeb-infoEnvoiTrans').value = "";
		document.getElementById('oeb-infoExpeLot').collapsed = true;
		document.getElementById('oeb-infoPrepaExpe').collapsed = true;
		document.getElementById('oeb-infoEnvoiTrans').collapsed = true;
		document.getElementById('oeb-dateConfirmation').value = "";
		document.getElementById('oeb-rowDateConfirmation').collapsed = true;

		document.getElementById('oeb-tabVersionDocument').collapsed=true;
		oeb_aVersion.deleteTree();

		document.getElementById('oeb-tabBoxAdresses').selectedIndex = 1;

		document.getElementById('oeb-numFournisseur').value = "";
		document.getElementById('oeb-denominationFournisseur').value = "";
		document.getElementById('oeb-adresse1Fournisseur').value = "";
		document.getElementById('oeb-adresse2Fournisseur').value = "";
		document.getElementById('oeb-adresse3Fournisseur').value = "";
		document.getElementById('oeb-cpFournisseur').value = "";
		document.getElementById('oeb-villeFournisseur').value = "";

		oeb_aLiensColis.deleteTree();
		oeb_aDepots.deleteTree();
		document.getElementById('oeb-depot').value = "";
		document.getElementById('oeb-numero').value = "";
		document.getElementById('oeb-numSerie').value = "";
		document.getElementById('oeb-dateBL').value = "";
		document.getElementById('oeb-numeroBP').value = "";
		document.getElementById('oeb-dateBP').value = "";
		document.getElementById('oeb-etat').value = "";
		document.getElementById('oeb-commentairesFin').value = "";
		document.getElementById('oeb-commentairesInt').value = "";
		document.getElementById('oeb-nbPalettes').value = "";
		document.getElementById('oeb-fraisSup').value = "0.00";
		document.getElementById('oeb-solder').checked = false;
		document.getElementById('oeb-envoiTrans').checked = false;
		document.getElementById('oeb-numLot').value = "";
		document.getElementById('oeb-datePeremption').value = "";
		document.getElementById('oeb-nbPieces').value = "";
		document.getElementById('oeb-quantite').value = "";
		document.getElementById('oeb-creation').value = "";
		document.getElementById('oeb-modification').value = "";
		document.getElementById('oeb-fiche').value = "";
		document.getElementById('oeb-modeExpedition').selectedIndex = 0;
		document.getElementById('oeb-consignesLiv').value = "";
		document.getElementById('oeb-pointRetrait').value = "";
		document.getElementById('oeb-dateExpedition').value = "";
		oeb_modified = false;

		document.getElementById('oeb-chercherAdrLiv').disabled = true;
		document.getElementById('oeb-chercherInterLiv').disabled = true;
		document.getElementById('oeb-chercherRelais').disabled = true;
		document.getElementById('oeb-bChoisirMentions').disabled = true;
		document.getElementById('oeb-bAjouter').disabled = true;
		document.getElementById('oeb-bToutAjouter').disabled = true;
		document.getElementById('oeb-bToutAjouterDispo').disabled = true;
		document.getElementById('oeb-bToutAjouterDispo').collapsed = true;
		document.getElementById('oeb-bEnlever').disabled = true;
		document.getElementById('oeb-bToutEnlever').disabled = true;
		document.getElementById('oeb-bEnregistrer').disabled = true;
		document.getElementById('oeb-bGenerateBP').disabled = true;
		document.getElementById('oeb-bGenerateBL').disabled = true;
		document.getElementById('oeb-bAnnuler').disabled = true;
		document.getElementById('oeb-bConfirmer').collapsed = true;
		document.getElementById('oeb-bSupprimer').disabled = true;
		document.getElementById('oeb-bEditionBL').disabled = true;
		document.getElementById('oeb-bColisage').disabled = true;
		document.getElementById('oeb-bEditionBP').disabled = true;
		document.getElementById('oeb-bAnnulerColis').disabled = true;
		document.getElementById('oeb-bCsvColisage').disabled = true;
		document.getElementById('oeb-bPdfColisage').disabled = true;

    document.getElementById('oeb-solder').disabled = true;
		document.getElementById('oeb-envoiTrans').disabled = true;

    document.getElementById('oeb-depot').disabled = true;
    document.getElementById('oeb-rowDepot').collapsed = true;
		document.getElementById('oeb-modeExpedition').disabled = true;
		document.getElementById('oeb-pointRetrait').disabled = true;
		document.getElementById('oeb-dateExpedition').disabled = true;
		document.getElementById('oeb-consignesLiv').disabled = true;

		document.getElementById('oeb-denominationLiv').setAttribute('readonly', true);
		document.getElementById('oeb-adresse1Liv').setAttribute('readonly', true);
		document.getElementById('oeb-adresse2Liv').setAttribute('readonly', true);
		document.getElementById('oeb-adresse3Liv').setAttribute('readonly', true);
		document.getElementById('oeb-codePostalLiv').setAttribute('readonly', true);
		document.getElementById('oeb-villeLiv').setAttribute('readonly', true);
		document.getElementById('oeb-codePaysLiv').disabled = true;
		document.getElementById('oeb-civInterLiv').disabled = true;
		document.getElementById('oeb-nomInterLiv').setAttribute('readonly', true);
		document.getElementById('oeb-prenomInterLiv').setAttribute('readonly', true);
		document.getElementById('oeb-telInter1Liv').setAttribute('readonly', true);
		document.getElementById('oeb-telInter2Liv').setAttribute('readonly', true);
		document.getElementById('oeb-faxInterLiv').setAttribute('readonly', true);
		document.getElementById('oeb-emailInterLiv').setAttribute('readonly', true);

		document.getElementById('oeb-commentairesFin').disabled = true;
		document.getElementById('oeb-commentairesInt').disabled = true;
		document.getElementById('oeb-nbColis').disabled = true;
		document.getElementById('oeb-nbPalettes').disabled = true;
		document.getElementById('oeb-fraisSup').disabled = true;
		document.getElementById('oeb-numLot').disabled = true;
		document.getElementById('oeb-datePeremption').disabled = true;
		document.getElementById('oeb-nbPieces').disabled = true;
		document.getElementById('oeb-quantite').disabled = true;
		document.getElementById('oeb-commande').disabled = true;
		document.getElementById('oeb-bConsultSerieLigne').disabled = true;

		document.getElementById('oeb-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('oeb-groupboxFournisseur').collapsed = true;
		document.getElementById('oeb-bEditionBL').collapsed = true;
		document.getElementById('oeb-bColisage').collapsed = true;
		document.getElementById('oeb-bEditionBP').collapsed = true;
		document.getElementById('oeb-envoiTrans').collapsed = true;

		document.getElementById('oeb-boxSaisieSerie').collapsed = (!oeb_actSuiviSerie || oeb_etatBon!="N" || gReadOnly);

		document.getElementById('oeb-barEdition').collapsed = true;
		document.getElementById('oeb-chkBonChiffre').collapsed = true;
		document.getElementById('oeb-chkCFChiffre').collapsed = true;
		document.getElementById('oeb-chkEditLF').collapsed = true;
		document.getElementById('oeb-chkEditCF').collapsed = true;
		document.getElementById('oeb-boxLangue').collapsed = true;
		document.getElementById('oeb-chkBonChiffre').checked = oeb_bonChiffre;
		document.getElementById('oeb-chkCFChiffre').checked = true;
		document.getElementById('oeb-chkEditBP').checked = oeb_typeExpedition=="B" && !oeb_etapePrepaBL && oeb_editBP;
		document.getElementById('oeb-chkEditCF').checked = oeb_typeExpedition=="F" && oeb_editCF;
		document.getElementById('oeb-chkEditLF').checked = oeb_typeExpedition=="F" && oeb_editLF;

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_changerDepot() {
	try {

		var depotId = document.getElementById('oeb-depot').value;
		document.getElementById('oeb-bToutAjouterDispo').disabled = isEmpty(depotId);
		document.getElementById('oeb-bAjouter').disabled = true;
		oeb_enregistrerBon(true);
		oeb_aCom.setParam("Depot_Id", depotId);
		oeb_aCom.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function oeb_choisirFournisseur() {
	try {

		if (oeb_typeExpedition=="F") {
			var url = "chrome://opensi/content/facturation/user/affaires/popup-choixFournisseurLivDirecte.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oeb_retourChoisirFournisseur, oeb_commandeId);
		}
		else {
			var url = "chrome://opensi/content/facturation/user/affaires/popup-choixFournisseurLogisticien.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oeb_retourChoisirFournisseur);
		}

    if (isEmpty(oeb_fournisseurId)) {
      retourFicheAffaire();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oeb_retourChoisirFournisseur(fournisseurId, listLigneId) {
	try {

		oeb_fournisseurId = fournisseurId;

		oeb_chargerInfosFournisseur();
		oeb_afficherColonnesFourn();

		oeb_listLigneId = (listLigneId==null?"":listLigneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_chargerInfosFournisseur() {
	try {

		var qGet = new QueryHttp('Facturation/Affaires/getInfosFournisseur.tmpl');
		qGet.setParam("Fournisseur_Id", oeb_fournisseurId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oeb-numFournisseur').value = contenu.getAttribute('Num_Fournisseur');
		document.getElementById('oeb-denominationFournisseur').value = contenu.getAttribute('Denomination');
		document.getElementById('oeb-adresse1Fournisseur').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oeb-adresse2Fournisseur').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oeb-adresse3Fournisseur').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oeb-cpFournisseur').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oeb-villeFournisseur').value = contenu.getAttribute('Ville');
		document.getElementById('oeb-chkCFChiffre').checked = contenu.getAttribute("CF_Chiffre")=="true";

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_afficherColonnesFourn() {
	try {

		var afficher = (oeb_typeExpedition=="F");

		document.getElementById('oeb-colPrixAchat').collapsed = !afficher || !gAccesCoutAchat;
		document.getElementById('oeb-colFournPrincipal').collapsed = !afficher;
		document.getElementById('oeb-colStockFourn').collapsed = !afficher;
		document.getElementById('oeb-colQuantiteDispo').collapsed = afficher || !oma_calculStock;

		if (!afficher) {
			document.getElementById('oeb-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oeb-colFournPrincipal').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oeb-colStockFourn').setAttribute("ignoreincolumnpicker", true);
		}
		else {
			if (gAccesCoutAchat) {
				document.getElementById('oeb-colPrixAchat').removeAttribute("ignoreincolumnpicker");
			}
			document.getElementById('oeb-colFournPrincipal').removeAttribute("ignoreincolumnpicker");
			document.getElementById('oeb-colStockFourn').removeAttribute("ignoreincolumnpicker");
		}

		if (afficher || !oma_calculStock) {
			document.getElementById('oeb-colQuantiteDispo').setAttribute("ignoreincolumnpicker", true);
		}
		else {
			document.getElementById('oeb-colQuantiteDispo').removeAttribute("ignoreincolumnpicker");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_debloquerChamps() {
	try {

		document.getElementById('oeb-chercherAdrLiv').disabled = false;
		document.getElementById('oeb-chercherRelais').disabled = false;
		document.getElementById('oeb-chercherInterLiv').disabled = false;
		document.getElementById('oeb-bChoisirMentions').disabled = false;
		document.getElementById('oeb-bAjouter').disabled = false;
		document.getElementById('oeb-bToutAjouter').disabled = oeb_bloquerBLSansStock && oeb_typeExpedition!="F";
		document.getElementById('oeb-bToutAjouterDispo').disabled = false;
		document.getElementById('oeb-bEnlever').disabled = false;
    document.getElementById('oeb-solder').disabled = false;
    document.getElementById('oeb-depot').disabled = false;
		document.getElementById('oeb-modeExpedition').disabled = false;
		document.getElementById('oeb-pointRetrait').disabled = false;
		document.getElementById('oeb-dateExpedition').disabled = false;
		document.getElementById('oeb-consignesLiv').disabled = false;

		document.getElementById('oeb-denominationLiv').removeAttribute('readonly');
		document.getElementById('oeb-adresse1Liv').removeAttribute('readonly');
		document.getElementById('oeb-adresse2Liv').removeAttribute('readonly');
		document.getElementById('oeb-adresse3Liv').removeAttribute('readonly');
		document.getElementById('oeb-codePostalLiv').removeAttribute('readonly');
		document.getElementById('oeb-villeLiv').removeAttribute('readonly');
		document.getElementById('oeb-codePaysLiv').disabled = false;
		document.getElementById('oeb-civInterLiv').disabled = false;
		document.getElementById('oeb-nomInterLiv').removeAttribute('readonly');
		document.getElementById('oeb-prenomInterLiv').removeAttribute('readonly');
		document.getElementById('oeb-telInter1Liv').removeAttribute('readonly');
		document.getElementById('oeb-telInter2Liv').removeAttribute('readonly');
		document.getElementById('oeb-faxInterLiv').removeAttribute('readonly');
		document.getElementById('oeb-emailInterLiv').removeAttribute('readonly');

		document.getElementById('oeb-commentairesFin').disabled = false;
		document.getElementById('oeb-commentairesInt').disabled = false;
		document.getElementById('oeb-nbColis').disabled = oeb_typeExpedition!="B" || oeb_colisageAuto;
		document.getElementById('oeb-nbPalettes').disabled = false;
		document.getElementById('oeb-fraisSup').disabled = false;
		document.getElementById('oeb-numLot').disabled = false;
		document.getElementById('oeb-datePeremption').disabled = false;
		document.getElementById('oeb-nbPieces').disabled = false;
		document.getElementById('oeb-quantite').disabled = false;
		document.getElementById('oeb-commande').disabled = false;
		document.getElementById('oeb-bEnregistrer').disabled = false;
		document.getElementById('oeb-bSupprimer').disabled = false;

		document.getElementById('oeb-bAjouter').disabled = true;
		document.getElementById('oeb-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_nouveauBon() {
  try {

		oeb_aCom.clearParams();
		oeb_reinitialiser();
		document.getElementById('oeb-nbColis').value = "";
		oeb_aCom.setParam('Fournisseur_Id', "");

		if (oeb_typeExpedition=="B") {
			document.getElementById('oeb-bEditionBL').collapsed = false;
			document.getElementById('oeb-bColisage').collapsed = !oeb_specCMBL;
			document.getElementById('oeb-bEditionBP').collapsed = false;
			document.getElementById("oeb-gNbPalettes").collapsed = false;
			document.getElementById('oeb-lblNumBL').value = "N\u00B0 Bon de livraison :";
			document.getElementById('oeb-lblDateBL').value = "Date BL :";
			document.getElementById('oeb-bEditionBL').setAttribute('label', "Bon de livraison");
			document.getElementById('oeb-bEditionBL').setAttribute('tooltiptext', "visualiser le bon de livraison");
			document.getElementById('oeb-bGenerateBP').setAttribute('label', "G\u00E9n\u00E9rer le bon de pr\u00E9paration");
			document.getElementById('oeb-bGenerateBL').setAttribute('label', "G\u00E9n\u00E9rer le bon de livraison");
			document.getElementById('oeb-bGenerateBP').setAttribute('tooltiptext', "g\u00E9n\u00E9rer le bon de pr\u00E9paration");
			document.getElementById('oeb-bGenerateBL').setAttribute('tooltiptext', "g\u00E9n\u00E9rer le bon de livraison");
			document.getElementById('oeb-colPrixAchatCFLiv').collapsed = true;
			document.getElementById('oeb-colPrixAchatCFLiv').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oeb-rowNumeroBP').collapsed = false;
			document.getElementById('oeb-rowDateBP').collapsed = false;
		}
		else {
			document.getElementById('oeb-groupboxFournisseur').collapsed = false;
			document.getElementById("oeb-gNbPalettes").collapsed = true;
			document.getElementById('oeb-rowNumeroBP').collapsed = true;
			document.getElementById('oeb-rowDateBP').collapsed = true;

			oeb_choisirFournisseur();

			if (oeb_typeExpedition=="L") {
				document.getElementById('oeb-capFournisseur').setAttribute("label", "Logisticien");
				document.getElementById('oeb-lblNumBL').value = "N\u00B0 Ordre de livraison :";
				document.getElementById('oeb-lblDateBL').value = "Date OL :";
				document.getElementById('oeb-bEditionBL').setAttribute('label', "Ordre de livraison");
				document.getElementById('oeb-bEditionBL').setAttribute('tooltiptext', "visualiser l'ordre de livraison");
				document.getElementById('oeb-bGenerateBP').setAttribute('label', "G\u00E9n\u00E9rer l'ordre de livraison");
				document.getElementById('oeb-bGenerateBL').setAttribute('label', "G\u00E9n\u00E9rer l'ordre de livraison");
				document.getElementById('oeb-bGenerateBP').setAttribute('tooltiptext', "g\u00E9n\u00E9rer l'ordre de livraison");
				document.getElementById('oeb-bGenerateBL').setAttribute('tooltiptext', "g\u00E9n\u00E9rer l'ordre de livraison");
				document.getElementById('oeb-colPrixAchatCFLiv').collapsed = true;
				document.getElementById('oeb-colPrixAchatCFLiv').setAttribute("ignoreincolumnpicker", true);
			}
			else {
				oeb_aCom.setParam('Fournisseur_Id', oeb_fournisseurId);
				document.getElementById('oeb-capFournisseur').setAttribute("label", "Fournisseur");
				document.getElementById('oeb-lblNumBL').value = "N\u00B0 Livraison directe :";
				document.getElementById('oeb-lblDateBL').value = "Date LF :";
				document.getElementById('oeb-bEditionBL').setAttribute('label', "Commande fournisseur / BL");
				document.getElementById('oeb-bEditionBL').setAttribute('tooltiptext', "visualiser la commande fournisseur / BL");
				document.getElementById('oeb-bGenerateBP').setAttribute('label', "G\u00E9n\u00E9rer la commande");
				document.getElementById('oeb-bGenerateBL').setAttribute('label', "G\u00E9n\u00E9rer la commande");
				document.getElementById('oeb-bGenerateBP').setAttribute('tooltiptext', "g\u00E9n\u00E9rer la commande");
				document.getElementById('oeb-bGenerateBL').setAttribute('tooltiptext', "g\u00E9n\u00E9rer la commande");
				document.getElementById('oeb-colPrixAchatCFLiv').collapsed = !gAccesCoutAchat;
				if (gAccesCoutAchat) {
					document.getElementById('oeb-colPrixAchatCFLiv').removeAttribute("ignoreincolumnpicker");
				}
			}
		}

		document.getElementById('oeb-bToutAjouterDispo').collapsed = (!oma_calculStock || oeb_typeExpedition=="F");

		if (oeb_typeExpedition=="B" || !isEmpty(oeb_fournisseurId)) {
			oeb_mode = "C";
			oeb_aCom.setParam('Commande_Id', oeb_commandeId);

			var qLoad = new QueryHttp('Facturation/Affaires/loadCommandeClient.tmpl');
			qLoad.setParam("Commande_Id", oeb_commandeId);
			var result = qLoad.execute();

			var contenu = result.responseXML.documentElement;

			oeb_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));

			document.getElementById('oeb-consignesLiv').value = contenu.getAttribute('Consignes_Liv');
			document.getElementById('oeb-pointRetrait').value = contenu.getAttribute('Point_Retrait');
			document.getElementById('oeb-dateExpedition').value = contenu.getAttribute('Date_Expedition');

			oeb_clientId = contenu.getAttribute("Client_Id");
			document.getElementById('oeb-numClient').value = contenu.getAttribute("Num_Client");

			document.getElementById('oeb-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
			document.getElementById('oeb-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
			document.getElementById('oeb-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
			document.getElementById('oeb-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
			document.getElementById('oeb-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
			document.getElementById('oeb-villeLiv').value = contenu.getAttribute('Ville_Liv');
			document.getElementById('oeb-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');

			document.getElementById('oeb-civInterLiv').value = contenu.getAttribute("Civ_Inter_Liv");
			document.getElementById('oeb-nomInterLiv').value = contenu.getAttribute("Nom_Inter_Liv");
			document.getElementById('oeb-prenomInterLiv').value = contenu.getAttribute("Prenom_Inter_Liv");
			document.getElementById('oeb-telInter1Liv').value = contenu.getAttribute("Tel_Inter_1_Liv");
			document.getElementById('oeb-telInter2Liv').value = contenu.getAttribute("Tel_Inter_2_Liv");
			document.getElementById('oeb-faxInterLiv').value = contenu.getAttribute("Fax_Inter_Liv");
			document.getElementById('oeb-emailInterLiv').value = contenu.getAttribute("Email_Inter_Liv");

			document.getElementById('oeb-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
			document.getElementById('oeb-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");

			document.getElementById('oeb-indications').value = contenu.getAttribute("Indications");

			oeb_nonPaye = contenu.getAttribute("Statut_Paiement")!="T";
			oeb_assujettiTVA = contenu.getAttribute("Assujetti_TVA");

			oeb_aBon.deleteTree();

			if (oeb_typeExpedition!="F") {
				var qDepotExp = new QueryHttp("Facturation/Affaires/getDepotCommande.tmpl");
				qDepotExp.setParam("Commande_Id", oeb_commandeId);
				var resDC = qDepotExp.execute();

				var depotCommande = resDC.responseXML.documentElement.getAttribute("Depot_Id");
				var typeDepotCommande = resDC.responseXML.documentElement.getAttribute("Type");
				var tiersDepotCommande = typeDepotCommande=="L"?resDC.responseXML.documentElement.getAttribute("Logisticien"):"";

				var depotDefaut = "";

				if (oeb_typeExpedition=="B" && typeDepotCommande=="E") {
					depotDefaut = depotCommande;
				}
				else if (oeb_typeExpedition=="L") {
					// Si le dpt de la commande a pour logisticien le fournisseur du BL, on le prend
					if (typeDepotCommande=="L" && oeb_fournisseurId==tiersDepotCommande) {
						depotDefaut = depotCommande;
					}
					else {
						// Sinon si le fournisseur du BL est reli  un seul dpt, on prend ce dpt
						var qDepotLogisticien = new QueryHttp("Facturation/Affaires/getDepotLogisticien.tmpl");
						qDepotLogisticien.setParam("Fournisseur_Id", oeb_fournisseurId);
						var resDL = qDepotLogisticien.execute();
						if (resDL.responseXML.documentElement.getAttribute("Nb_Depots")=="1") {
							depotDefaut = resDL.responseXML.documentElement.getAttribute("Depot_Id");
						}
					}
				}

				oeb_chargerDepot(depotDefaut);
				oeb_aCom.setParam("Depot_Id", depotDefaut);
			}
			oeb_aCom.initTree(oeb_debloquerChamps);

			oeb_setModified(false);
			document.getElementById('oeb-bSupprimer').collapsed = true;
			document.getElementById('oeb-bAnnuler').collapsed = true;
			document.getElementById('oeb-bConfirmer').collapsed = true;

			document.getElementById('oeb-bGenerateBP').disabled = true;
			document.getElementById('oeb-bGenerateBL').disabled = true;
			document.getElementById('oeb-bEditionBL').disabled = true;
			document.getElementById('oeb-bColisage').disabled = true;
			document.getElementById('oeb-bEditionBP').disabled = true;
			document.getElementById('oeb-corpsCommande').collapsed = false;
			document.getElementById('oeb-boxActions').collapsed = gReadOnly;

			oeb_afficherColonnesFourn();
			document.getElementById('oeb-affaire').value = ofa_numAffaire;
		}

		if (oeb_typeExpedition=="F" && !isEmpty(oeb_listLigneId)) {
			document.getElementById('oeb-modeExpedition').value = oeb_chargerModeExpedition;	// correction bug redmine 13496 - zen 9994 - Mode d'expdition remis  aucun si slection de lignes
			oeb_ajouterSelection(oeb_listLigneId);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_chargerBon(noRefreshArbres) {
  try {

		var refreshArbres = (noRefreshArbres!=true);

		oeb_reinitialiser();
		oeb_aBon.setParam('Fournisseur_Id', "");
		oeb_aBon.setParam('Bon_Id', oeb_bonLivId);
		oeb_aCom.setParam('Fournisseur_Id', "");
		oeb_aCom.setParam('Bon_Id', oeb_bonLivId);

		if (oeb_typeExpedition=="B") {
			document.getElementById('oeb-bEditionBL').collapsed = false;
			document.getElementById('oeb-bColisage').collapsed = !oeb_specCMBL;
			document.getElementById('oeb-bEditionBP').collapsed = false;
			document.getElementById('oeb-rowNumeroBP').collapsed = false;
			document.getElementById('oeb-rowDateBP').collapsed = false;
		}
		else {
			oeb_chargerInfosFournisseur();
			document.getElementById('oeb-groupboxFournisseur').collapsed = false;
			document.getElementById('oeb-rowNumeroBP').collapsed = true;
			document.getElementById('oeb-rowDateBP').collapsed = true;
		}

		oeb_mode = "M";

		var qLoad = new QueryHttp('Facturation/Affaires/loadBonLivraison.tmpl');
		qLoad.setParam("Bon_Id", oeb_bonLivId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;
		var lblFiche = "";

		oeb_statutExpedition = contenu.getAttribute("Statut_Expedition");

		oeb_typeExpedition = contenu.getAttribute('Type_Liv');
		switch (oeb_typeExpedition) {
			case "B":
				document.getElementById('oeb-lblNumBL').value = "N\u00B0 Bon de livraison :";
				document.getElementById('oeb-lblDateBL').value = "Date BL :";
				document.getElementById('oeb-bEditionBL').setAttribute('label', "Bon de livraison");
				document.getElementById('oeb-bEditionBL').setAttribute('tooltiptext', "visualiser le bon de livraison");
				document.getElementById('oeb-bGenerateBP').setAttribute('label', "G\u00E9n\u00E9rer le bon de pr\u00E9paration");
				document.getElementById('oeb-bGenerateBL').setAttribute('label', "G\u00E9n\u00E9rer le bon de livraison");
				document.getElementById('oeb-bGenerateBP').setAttribute('tooltiptext', "g\u00E9n\u00E9rer le bon de pr\u00E9paration");
				document.getElementById('oeb-bGenerateBL').setAttribute('tooltiptext', "g\u00E9n\u00E9rer le bon de livraison");
				lblFiche = "Bon de livraison";
				document.getElementById('oeb-colPrixAchatCFLiv').collapsed = true;
				document.getElementById('oeb-colPrixAchatCFLiv').setAttribute("ignoreincolumnpicker", true);
			break;
			case "L":
				document.getElementById('oeb-capFournisseur').setAttribute("label", "Logisticien");
				document.getElementById('oeb-lblNumBL').value = "N\u00B0 Ordre de livraison :";
				document.getElementById('oeb-lblDateBL').value = "Date OL :";
				document.getElementById('oeb-bEditionBL').setAttribute('label', "Ordre de livraison");
				document.getElementById('oeb-bEditionBL').setAttribute('tooltiptext', "visualiser l'ordre de livraison");
				document.getElementById('oeb-bGenerateBP').setAttribute('label', "G\u00E9n\u00E9rer l'ordre de livraison");
				document.getElementById('oeb-bGenerateBL').setAttribute('label', (oeb_statutExpedition!="P"?"G\u00E9n\u00E9rer l'ordre de livraison":"Confirmer la pr\u00E9paration"));
				document.getElementById('oeb-bGenerateBP').setAttribute('tooltiptext', "g\u00E9n\u00E9rer l'ordre de livraison");
				document.getElementById('oeb-bGenerateBL').setAttribute('tooltiptext', (oeb_statutExpedition!="P"?"g\u00E9n\u00E9rer l'ordre de livraison":"confirmer la pr\u00E9paration de l'ordre de livraison"));
				lblFiche = "Ordre de livraison";
				document.getElementById('oeb-colPrixAchatCFLiv').collapsed = true;
				document.getElementById('oeb-colPrixAchatCFLiv').setAttribute("ignoreincolumnpicker", true);
			break;
			case "F":
				oeb_aCom.setParam('Fournisseur_Id', oeb_fournisseurId);
				document.getElementById('oeb-capFournisseur').setAttribute("label", "Fournisseur");
				document.getElementById('oeb-lblNumBL').value = "N\u00B0 Livraison directe :";
				document.getElementById('oeb-lblDateBL').value = "Date LF :";
				document.getElementById('oeb-bEditionBL').setAttribute('label', "Commande fournisseur / BL");
				document.getElementById('oeb-bEditionBL').setAttribute('tooltiptext', "visualiser la commande fournisseur / BL");
				document.getElementById('oeb-bGenerateBP').setAttribute('label', "G\u00E9n\u00E9rer la commande");
				document.getElementById('oeb-bGenerateBL').setAttribute('label', (oeb_statutExpedition!="P"?"G\u00E9n\u00E9rer la commande":"Confirmer la pr\u00E9paration"));
				document.getElementById('oeb-bGenerateBP').setAttribute('tooltiptext', "g\u00E9n\u00E9rer la commande");
				document.getElementById('oeb-bGenerateBL').setAttribute('tooltiptext', (oeb_statutExpedition!="P"?"g\u00E9n\u00E9rer la commande":"confirmer la pr\u00E9paration de la commande"));
				lblFiche = "Livraison directe";
				document.getElementById('oeb-colPrixAchatCFLiv').collapsed = !gAccesCoutAchat;
				if (gAccesCoutAchat) {
					document.getElementById('oeb-colPrixAchatCFLiv').removeAttribute("ignoreincolumnpicker");
				}
			break;
		}

		document.getElementById('oeb-bToutAjouterDispo').collapsed = (!oma_calculStock || oeb_typeExpedition=="F");

		oeb_etatBon = contenu.getAttribute("Etat");
		oeb_commandeId = contenu.getAttribute("Commande_Id");
		oeb_nonPaye = contenu.getAttribute("Non_Paye")=="true";
		oeb_assujettiTVA = contenu.getAttribute("Assujetti_TVA");

		oeb_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));
		oeb_chargerDepot(contenu.getAttribute("Depot_Id"));
		var etatCommande = contenu.getAttribute("Etat_Commande");
		document.getElementById('oeb-bConfirmer').collapsed = true;

		if (oeb_etatBon=="V") {
			switch (oeb_statutExpedition) {
				case "P":
					document.getElementById('oeb-etat').value = "A pr\u00E9parer";
					document.getElementById('oeb-bGenerateBL').collapsed = (gReadOnly && !gProfil.isValidationBL());
					document.getElementById('oeb-envoiTrans').collapsed = !(oeb_typeExpedition=="B" && oeb_envoiTrans);
					document.getElementById('oeb-envoiTrans').checked = (oeb_typeExpedition=="B" && oeb_envoiTrans);
					document.getElementById('oeb-envoiTrans').disabled = false;
				break;
				case "E":
					document.getElementById('oeb-etat').value = "Exp\u00E9di\u00E9";
				break;
				case "C":
					document.getElementById('oeb-etat').value = "Pr\u00EAt \u00E0 exp\u00E9dier";
					document.getElementById('oeb-bConfirmer').collapsed = gReadOnly;
				break;
			}

			document.getElementById('oeb-bSupprimer').collapsed = true;
			document.getElementById('oeb-bAnnuler').collapsed = (ofa_etatAffaire=="C" || etatCommande=="C" || (gReadOnly && ((oeb_statutExpedition=="P" && !gProfil.isAnnulationBP()) || (oeb_statutExpedition!="P" && !gProfil.isAnnulationBL()))));
			document.getElementById('oeb-corpsCommande').collapsed = true;
			document.getElementById('oeb-boxActions').collapsed = true;
			document.getElementById('oeb-bAnnuler').disabled = (ofa_etatAffaire=="C" || etatCommande=="C");
		}
		else if (oeb_etatBon=="A") {
			document.getElementById('oeb-etat').value = "Annul\u00E9";
			document.getElementById('oeb-bSupprimer').collapsed = true;
			document.getElementById('oeb-bAnnuler').collapsed = true;
			document.getElementById('oeb-corpsCommande').collapsed = true;
			document.getElementById('oeb-boxActions').collapsed = true;
		}
		else {
			document.getElementById('oeb-etat').value = "Non valid\u00E9";
			document.getElementById('oeb-bAnnuler').collapsed = true;
			document.getElementById('oeb-bSupprimer').collapsed = gReadOnly;
			document.getElementById('oeb-corpsCommande').collapsed = false;
			document.getElementById('oeb-boxActions').collapsed = gReadOnly;
			document.getElementById('oeb-envoiTrans').collapsed = !(oeb_typeExpedition=="B" && oeb_envoiTrans && !oeb_etapePrepaBL);
			document.getElementById('oeb-envoiTrans').checked = (oeb_typeExpedition=="B" && oeb_envoiTrans && !oeb_etapePrepaBL);
			document.getElementById('oeb-envoiTrans').disabled = oeb_etapePrepaBL;
		}

		if (oeb_etatBon!="N") {
			document.getElementById('oeb-bCsvColisage').disabled = false;
			document.getElementById('oeb-bPdfColisage').disabled = false;
			document.getElementById('oeb-tabVersionDocument').collapsed=false;
			oeb_initVersion();
			if (!isEmpty(contenu.getAttribute("Date_Expe_Lot"))) {
				document.getElementById('oeb-infoExpeLot').value = "Exp\u00E9dition en lot n\u00B0 "+ contenu.getAttribute("Num_Expedition") +" r\u00E9alis\u00E9e le "+ contenu.getAttribute("Date_Expe_Lot");
				document.getElementById('oeb-infoExpeLot').collapsed = false;
			}
			if (!isEmpty(contenu.getAttribute("Date_Prepa_Expe"))) {
				document.getElementById('oeb-infoPrepaExpe').value = "Pr\u00E9paration d'exp\u00E9dition valid\u00E9e le "+ contenu.getAttribute("Date_Prepa_Expe");
				document.getElementById('oeb-infoPrepaExpe').collapsed = false;
			}
			if (!isEmpty(contenu.getAttribute("Date_Confirmation"))) {
				document.getElementById('oeb-dateConfirmation').value = contenu.getAttribute("Date_Confirmation");
				document.getElementById('oeb-rowDateConfirmation').collapsed = false;
			}
			if (contenu.getAttribute("Envoi_Trans")=="true") {
				document.getElementById('oeb-infoEnvoiTrans').value = "Export transporteur effectu\u00E9";
				document.getElementById('oeb-infoEnvoiTrans').collapsed = false;
			}
		}
		document.getElementById('oeb-boxSaisieSerie').collapsed = (!oeb_actSuiviSerie || oeb_etatBon!="N" || gReadOnly);
		document.getElementById('oeb-consignesLiv').value = contenu.getAttribute('Consignes_Liv');
		document.getElementById('oeb-pointRetrait').value = contenu.getAttribute('Point_Retrait');
		document.getElementById('oeb-dateExpedition').value = contenu.getAttribute('Date_Expedition');
		document.getElementById('oeb-raisonSociale').value = contenu.getAttribute("Denomination");
		document.getElementById('oeb-adresseFact').value = contenu.getAttribute("Adresse_1");
		document.getElementById('oeb-adresse2Fact').value = contenu.getAttribute("Adresse_2");
		document.getElementById('oeb-adresse3Fact').value = contenu.getAttribute("Adresse_3");
		document.getElementById('oeb-codePostalFact').value = contenu.getAttribute("Code_Postal");
		document.getElementById('oeb-villeFact').value = contenu.getAttribute("Ville");
		oeb_clientId = contenu.getAttribute("Client_Id");
		document.getElementById('oeb-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('oeb-labelLogin').value = contenu.getAttribute("Login_Web");
		document.getElementById('oeb-rowLoginWeb').collapsed = (contenu.getAttribute("Web")=="false");
		document.getElementById('oeb-affaire').value = contenu.getAttribute("Num_Affaire");

		document.getElementById('oeb-dateBL').value = contenu.getAttribute("Date_BL");
		document.getElementById('oeb-denominationLiv').value = contenu.getAttribute("Denomination_Liv");
		document.getElementById('oeb-adresse1Liv').value = contenu.getAttribute("Adresse_1_Liv");
		document.getElementById('oeb-adresse2Liv').value = contenu.getAttribute("Adresse_2_Liv");
		document.getElementById('oeb-adresse3Liv').value = contenu.getAttribute("Adresse_3_Liv");
		document.getElementById('oeb-codePostalLiv').value = contenu.getAttribute("Code_Postal_Liv");
		document.getElementById('oeb-villeLiv').value = contenu.getAttribute("Ville_Liv");
		document.getElementById('oeb-codePaysLiv').value = contenu.getAttribute("Code_Pays_Liv");
		document.getElementById('oeb-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oeb-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oeb-numero').value = contenu.getAttribute("Numero_BL");
		if (oeb_etatBon!="N") {
			document.getElementById('oeb-nbColis').value = contenu.getAttribute("Nb_Colis");
		}
		document.getElementById('oeb-nbPalettes').value = contenu.getAttribute("Nb_Palettes");
		document.getElementById('oeb-fraisSup').value = contenu.getAttribute("Frais_Sup");
		document.getElementById('oeb-numeroBP').value = contenu.getAttribute("Numero_BP");
		document.getElementById('oeb-dateBP').value = contenu.getAttribute("Date_BP");

		document.getElementById('oeb-civInterLiv').value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById('oeb-nomInterLiv').value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById('oeb-prenomInterLiv').value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById('oeb-telInter1Liv').value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById('oeb-telInter2Liv').value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById('oeb-faxInterLiv').value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById('oeb-emailInterLiv').value = contenu.getAttribute("Email_Inter_Liv");

		document.getElementById('oeb-creation').setAttribute("label", "Exp\u00E9dition cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oeb-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oeb-fiche').setAttribute("label", lblFiche +" N\u00B0 "+ contenu.getAttribute('Numero_BL'));
		document.getElementById('oeb-creation').collapsed = false;
		document.getElementById('oeb-modification').collapsed = false;

		document.getElementById('oeb-bOuvrirCommentairesCaches').disabled = false;

		document.getElementById('oeb-chkBonChiffre').checked = (isEmpty(oeb_clientId)?oeb_bonChiffre:contenu.getAttribute("Bon_Chiffre")=="true");
		document.getElementById('oeb-indications').value = contenu.getAttribute("Indications");

		oeb_aLiensColis.setParam("Bon_Id", oeb_bonLivId);
		oeb_aLiensColis.initTree();

		if (refreshArbres) oeb_aBon.initTree();

		oeb_aCom.setParam("Depot_Id", contenu.getAttribute("Depot_Id"));

		oeb_setModified(false);
		if (oeb_etatBon!='V' && oeb_etatBon!='A') {
			oeb_aCom.setParam('Commande_Id', oeb_commandeId);
			if (refreshArbres) {
				oeb_aCom.initTree(oeb_debloquerChamps);
			}
			else {
				oeb_debloquerChamps();
			}
			document.getElementById('oeb-bToutEnlever').disabled = false;
		}
		oeb_afficherColonnesFourn();

		if (oeb_specHMBEP && oeb_etatBon=='V' && (oeb_statutExpedition=='P' || (oeb_statutExpedition=='C' && oeb_typeExpedition=='F'))) {
			document.getElementById('oeb-bEnregistrer').disabled = false;
			document.getElementById('oeb-dateExpedition').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_editerCommentairesInternes()  {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "BL", oeb_bonLivId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oeb-commentairesFin').value;
		var commentairesInt = document.getElementById('oeb-commentairesInt').value;
		var readOnly = (oeb_etatBon!="N" || gReadOnly);

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oeb_retourEditerCommentaires, "BL", oeb_bonLivId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oeb-commentairesFin').value = commentairesFin;
		document.getElementById('oeb-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_enregistrerBon(rafraichir, noRefreshArbres) {
  try {

  	var ok = false;

		var modeExpedition = document.getElementById('oeb-modeExpedition').value;
		var pointRetrait = document.getElementById('oeb-pointRetrait').value;
		var dateExpedition = document.getElementById('oeb-dateExpedition').value;
		var consignesLiv = document.getElementById('oeb-consignesLiv').value;
		var denominationLiv = document.getElementById('oeb-denominationLiv').value;
		var adresse1Liv = document.getElementById('oeb-adresse1Liv').value;
		var adresse2Liv = document.getElementById('oeb-adresse2Liv').value;
		var adresse3Liv = document.getElementById('oeb-adresse3Liv').value;
		var codePostalLiv = document.getElementById('oeb-codePostalLiv').value;
		var villeLiv = document.getElementById('oeb-villeLiv').value;
		var codePaysLiv = document.getElementById('oeb-codePaysLiv').value;
		var civInterLiv = document.getElementById('oeb-civInterLiv').value;
		var nomInterLiv = document.getElementById('oeb-nomInterLiv').value;
		var prenomInterLiv = document.getElementById('oeb-prenomInterLiv').value;
		var telInter1Liv = document.getElementById('oeb-telInter1Liv').value;
		var telInter2Liv = document.getElementById('oeb-telInter2Liv').value;
		var faxInterLiv = document.getElementById('oeb-faxInterLiv').value;
		var emailInterLiv = document.getElementById('oeb-emailInterLiv').value;
		var nbColis = document.getElementById('oeb-nbColis').value;
		var nbPalettes = document.getElementById('oeb-nbPalettes').value;
		var fraisSup = document.getElementById('oeb-fraisSup').value;
		var commentairesFin = document.getElementById('oeb-commentairesFin').value;
		var commentairesInt = document.getElementById('oeb-commentairesInt').value;
		var depot = document.getElementById('oeb-depot').value;

		if (isEmpty(nbPalettes)) nbPalettes = 0;

		if (isEmpty(denominationLiv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison !"); }
		else if (isEmpty(adresse1Liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison !"); }
		else if (isEmpty(villeLiv)) { showWarning("Veuillez indiquer la ville du client de livraison !"); }
		else if (!isEmpty(telInter1Liv) && !isPhone(telInter1Liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect !"); }
		else if (!isEmpty(telInter2Liv) && !isPhone(telInter2Liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterLiv) && !isPhone(faxInterLiv)) { showWarning("Num\u00E9ro de fax de livraison incorrect !"); }
		else if (!isEmpty(emailInterLiv) && !isEmail(emailInterLiv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
		else if (!isEmpty(nbColis) && !isPositiveOrNullInteger(nbColis)) { showWarning("Nombre de colis incorrect !"); }
		else if (!isPositiveOrNullInteger(nbPalettes)) { showWarning("Nombre de palettes incorrect !"); }
		else if (isEmpty(fraisSup) || !isPositiveOrNull(fraisSup)) { showWarning("Frais de port suppl\u00E9mentaires incorrects !"); }
		else if (!isEmpty(consignesLiv) && consignesLiv.length>100) { showWarning("Consignes de livraison incorrectes (longueur max = 100 caract\u00E8res) !"); }
		else if (oeb_typeExpedition!="F" && isEmpty(depot)) { showWarning("Veuillez choisir un d\u00E9p\u00F4t d'exp\u00E9dition."); }
		else if (!isEmpty(dateExpedition) && !isDate(dateExpedition)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else {
			var qSave;

			if (oeb_mode=="C") {
				qSave = new QueryHttp("Facturation/Affaires/creerBonLivraison.tmpl");
				qSave.setParam("Commande_Id", oeb_commandeId);
				qSave.setParam("Type_Liv", oeb_typeExpedition);
			}
			else {
				qSave = new QueryHttp("Facturation/Affaires/modifierBonLivraison.tmpl");
				qSave.setParam("Bon_Id", oeb_bonLivId);
			}

			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Consignes_Liv", consignesLiv);
			qSave.setParam("Point_Retrait", pointRetrait);
			qSave.setParam("Date_Expedition", dateExpedition);
			qSave.setParam("Denomination_Liv", denominationLiv);
			qSave.setParam("Adresse_1_Liv", adresse1Liv);
			qSave.setParam("Adresse_2_Liv", adresse2Liv);
			qSave.setParam("Adresse_3_Liv", adresse3Liv);
			qSave.setParam("Code_Postal_Liv", codePostalLiv);
			qSave.setParam("Ville_Liv", villeLiv);
			qSave.setParam("Code_Pays_Liv", codePaysLiv);
			qSave.setParam("Civ_Inter_Liv", civInterLiv);
			qSave.setParam("Nom_Inter_Liv", nomInterLiv);
			qSave.setParam("Prenom_Inter_Liv", prenomInterLiv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1Liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2Liv);
			qSave.setParam("Fax_Inter_Liv", faxInterLiv);
			qSave.setParam("Email_Inter_Liv", emailInterLiv);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Nb_Palettes", nbPalettes);
			qSave.setParam("Frais_Sup", fraisSup);
			qSave.setParam("Fournisseur_Id", oeb_fournisseurId);
			qSave.setParam("Depot_Id", depot);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oeb_mode=="C") {
					oeb_bonLivId = result.responseXML.documentElement.getAttribute("Bon_Id");
					if (rafraichir) {
						oeb_chargerBon(noRefreshArbres==true);
					}
				}

				oeb_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de cette exp\u00E9dition ?")) {

			var qDelete = new QueryHttp("Facturation/Affaires/supprimerBL.tmpl");
			qDelete.setParam("Bon_Id", oeb_bonLivId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'exp\u00E9dition a \u00E9t\u00E9 supprim\u00E9e avec succ\u00E8s !");
			}

			retourFicheAffaire();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_generateBL() {
  try {

		var msgConfirm = "Confirmez-vous la g\u00E9n\u00E9ration du bon de livraison ?\n(Attention le bon de livraison valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)";
		if (oeb_typeExpedition=="F") {
			msgConfirm = "Confirmez-vous la g\u00E9n\u00E9ration de la commande fournisseur ?\n(Attention la commande valid\u00E9e ne pourra plus \u00EAtre modifi\u00E9e !)";
		}
		else if (oeb_typeExpedition=="L") {
			if (oeb_statutExpedition=="P") {
				msgConfirm = "Confirmez-vous la pr\u00E9paration de l'ordre de livraison ?";
			}
			else {
				msgConfirm = "Confirmez-vous la g\u00E9n\u00E9ration de l'ordre de livraison ?\n(Attention l'ordre de livraison valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)";
			}
		}

		if (oeb_aBon.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient aucune ligne !");
		}
		else if (window.confirm(msgConfirm)) {

			var ok = true;

			if (oeb_actSuiviSerie && oeb_typeExpedition=="B") {
				var qCheck = new QueryHttp("Facturation/Affaires/checkNumSerieBL.tmpl");
				qCheck.setParam("Bon_Id", oeb_bonLivId);
				var result = qCheck.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					ok = false;
				}
			}

			if (oeb_statutExpedition!="P") {

				if (ok && oeb_actSuiviLot) {
					var qCheck = new QueryHttp("Facturation/Affaires/checkNumLotBL.tmpl");
					qCheck.setParam("Bon_Id", oeb_bonLivId);
					var result = qCheck.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
						ok = false;
					}
				}

				if (ok) {
					var qValider = new QueryHttp("Facturation/Affaires/validerBonLivraison.tmpl");
					qValider.setParam('Bon_Id', oeb_bonLivId);
					qValider.setParam('Commande_Id', oeb_commandeId);
					qValider.setParam('Solder', document.getElementById('oeb-solder').checked);
					qValider.setParam('Nb_Colis', document.getElementById('oeb-nbColis').value);
					var result = qValider.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
						ok = false;
					}
				}
			}

			if (ok) {
				var qGenBL = new QueryHttp("Facturation/Affaires/generateBonLivraison.tmpl");
				qGenBL.setParam("Bon_Id", oeb_bonLivId);
				qGenBL.setParam("Envoi_Trans", document.getElementById('oeb-envoiTrans').checked);
				var result = qGenBL.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oeb_chargerBon();
					oeb_chargerPdfBL();
				}
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_confirmerExpedition() {
  try {

  	if (window.confirm("Confirmez-vous l'exp\u00E9dition ?")) {

			var qConfExpe = new QueryHttp("Facturation/Affaires/confirmExpedition.tmpl");
			qConfExpe.setParam("Bon_Id", oeb_bonLivId);
			var result = qConfExpe.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oeb_chargerBon();
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_toutTransferer() {
  try {

  	var ok = true;
		if (oeb_mode=="C") {
			ok = oeb_enregistrerBon(true, true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Affaires/addAllBL.tmpl');
			qAdd.setParam('Fournisseur_Id', oeb_fournisseurId);
			qAdd.setParam("Bon_Id", oeb_bonLivId);
			qAdd.setParam("Commande_Id", oeb_commandeId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeb_aCom.initTree();
			oeb_aBon.initTree();

			document.getElementById('oeb-nbPieces').value = "";
			document.getElementById('oeb-quantite').value = "";
			document.getElementById('oeb-numLot').value = "";
			document.getElementById('oeb-datePeremption').value = "";

			document.getElementById('oeb-bAjouter').disabled = true;
			document.getElementById('oeb-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_toutTransfererDispo() {
  try {

  	var ok = true;
		if (oeb_mode=="C") {
			ok = oeb_enregistrerBon(true, true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Affaires/addAllDispoBL.tmpl');
			qAdd.setParam("Bon_Id", oeb_bonLivId);
			qAdd.setParam("Commande_Id", oeb_commandeId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeb_aCom.initTree();
			oeb_aBon.initTree();

			document.getElementById('oeb-nbPieces').value = "";
			document.getElementById('oeb-quantite').value = "";
			document.getElementById('oeb-numLot').value = "";
			document.getElementById('oeb-datePeremption').value = "";

			document.getElementById('oeb-bAjouter').disabled = true;
			document.getElementById('oeb-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Affaires/removeAllBL.tmpl');
		qRemove.setParam("Bon_Id", oeb_bonLivId);
		var result = qRemove.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		oeb_aCom.initTree();
		oeb_aBon.initTree();

		document.getElementById('oeb-nbPieces').value = "";
		document.getElementById('oeb-quantite').value = "";
		document.getElementById('oeb-numLot').value = "";
		document.getElementById('oeb-datePeremption').value = "";

		document.getElementById('oeb-bAjouter').disabled = true;
		document.getElementById('oeb-bEnlever').disabled = true;

		document.getElementById("oeb-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_ajouter() {
  try {

		if (oeb_aCom.isSelected()) {

			if (oeb_aCom.nbSelection()==1) {

				var articleId = oeb_aCom.getSelectedCellText('oeb-colArticleIdDev');
				var ligneCC = oeb_aCom.getSelectedCellText('oeb-colLigneIdDev');
				var isSuiviLot = oeb_aCom.getSelectedCellText('oeb-colSuiviLotDev')=="true" && !oeb_specHMLBP;
				var isSuiviDLC = oeb_aCom.getSelectedCellText('oeb-colSuiviDLCDev')=="true" && !oeb_specHMLBP;
				var isSuiviSerie = oeb_aCom.getSelectedCellText('oeb-colSuiviSerieDev')=="true";
				var qteRestante = oeb_aCom.getSelectedCellText('oeb-colQuantiteDev');
				var quantiteMax = oeb_aCom.getSelectedCellText('oeb-colQteMaxDev');
				var nbPiecesRestant = oeb_aCom.getSelectedCellText('oeb-colNbPiecesDev');
				if (isEmpty(nbPiecesRestant)) { nbPiecesRestant = 0; }

				var quantite = document.getElementById('oeb-quantite').value;
				var numLot = document.getElementById('oeb-numLot').value;
				var datePeremption = document.getElementById('oeb-datePeremption').value;
				var nbPieces = document.getElementById('oeb-nbPieces').value;
				if (isEmpty(nbPieces)) { nbPieces = 0; }

				if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer !"); }
				else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !"); }
				else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
				else if (oeb_bloquerBLSansStock && oeb_typeExpedition!="F" && !isEmpty(articleId) && parseFloat(quantite)>parseFloat(quantiteMax)) { showWarning("Quantit\u00E9 en stock insuffisante (max: "+ quantiteMax +")"); }
				else if (oeb_checkNumLotLigne(numLot, datePeremption, articleId, isSuiviLot, isSuiviDLC)) {

					var continuer = true;

					if (parseFloat(qteRestante)-parseFloat(quantite)<0) {
						continuer = window.confirm("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 livrer !\n\nVoulez-vous vraiment livrer plus que la quantit\u00E9 command\u00E9e ?");
					}

					if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) {
						continuer = window.confirm("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer d\u00E9passe le nb de pi\u00E8ces restant \u00E0 livrer !\n\nVoulez-vous vraiment livrer plus que le nb de pi\u00E8ces command\u00E9 ?");
					}

					if (continuer) {

						var ok = true;

						if (oeb_mode=="C") {
							ok = oeb_enregistrerBon(true, true);
						}

						if (ok) {
							var qAdd = new QueryHttp('Facturation/Affaires/addLigneBL.tmpl');
							qAdd.setParam("Bon_Id", oeb_bonLivId);
							qAdd.setParam("Ligne_CC", ligneCC);
							qAdd.setParam("Quantite", quantite);
							qAdd.setParam("Num_Lot", numLot);
							qAdd.setParam("Nb_Pieces", nbPieces);
							qAdd.setParam("Date_Peremption", datePeremption);
							var result = qAdd.execute();

							var errors = new Errors(result);
							if (errors.hasNext()) {
								errors.show();
							}
							else {
								var ligneBL = result.responseXML.documentElement.getAttribute('Ligne_Id');
								var quantiteBL = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

								oeb_aCom.initTree();
								oeb_aBon.initTree();
								document.getElementById('oeb-bAjouter').disabled = true;

								document.getElementById('oeb-nbPieces').value = "";
								document.getElementById('oeb-quantite').value = "";
								document.getElementById('oeb-numLot').value = "";
								document.getElementById('oeb-datePeremption').value = "";

								if (!oeb_etapePrepaBL && oeb_typeExpedition=="B") {
									oeb_checkNumSerieLigne(ligneBL, isSuiviSerie, quantiteBL);
								}
							}
						}
					}
				}
			}
			else {
				var listLigneId = "";
				var rangeCount = oeb_aCom.getRangeCount();

				for (var j=0; j<rangeCount; j++) {
					var start = {};
					var end = {};
					oeb_aCom.getRangeAt(j,start,end);

					for (var c=start.value; c<=end.value; c++) {
						listLigneId += oeb_aCom.getCellText(c, "oeb-colLigneIdDev") +",";
					}
				}

				oeb_ajouterSelection(listLigneId);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_ajouterSelection(listLigneId) {
  try {

		var ok = true;
		if (oeb_mode=="C") {
			ok = oeb_enregistrerBon(true, true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Affaires/addAllBL.tmpl');
			qAdd.setParam('Fournisseur_Id', oeb_fournisseurId);
			qAdd.setParam("Bon_Id", oeb_bonLivId);
			qAdd.setParam("Commande_Id", oeb_commandeId);
			qAdd.setParam("List_Ligne_Id", listLigneId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeb_aCom.initTree();
			oeb_aBon.initTree();
			document.getElementById('oeb-bAjouter').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_enlever() {
  try {

		if (oeb_aBon.isSelected()) {
			var ligneId = oeb_aBon.getSelectedCellText('oeb-colLigneIdLiv');
			var qteInit = oeb_aBon.getSelectedCellText('oeb-colQuantiteLiv');
			var quantite = document.getElementById('oeb-quantite').value;
			var nbPiecesInit = oeb_aBon.getSelectedCellText('oeb-colNbPiecesLiv');
			if (isEmpty(nbPiecesInit)) { nbPiecesInit = 0; }
			var nbPieces = document.getElementById('oeb-nbPieces').value;
			if (isEmpty(nbPieces)) {
				nbPieces = 0;
			}

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever !");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteInit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans l'exp\u00E9dition !");
			}
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if (parseFloat(nbPiecesInit)-parseFloat(nbPieces)<0) {
				showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans l'exp\u00E9dition !");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Affaires/removeLigneBL.tmpl');
				qRemove.setParam("Ligne_Id", ligneId);
				qRemove.setParam("Quantite", quantite);
				qRemove.setParam("Nb_Pieces", nbPieces);
				var result = qRemove.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				oeb_aCom.initTree();
				oeb_aBon.initTree();

				document.getElementById('oeb-nbPieces').value = "";
				document.getElementById('oeb-quantite').value = "";
				document.getElementById('oeb-numLot').value = "";
				document.getElementById('oeb-datePeremption').value = "";

				document.getElementById('oeb-bEnlever').disabled = true;
				document.getElementById("oeb-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_demandeEnregistrement() {
  try {

		if (oeb_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'exp\u00E9dition ?")) {
				oeb_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_setModified(m) {
  try {

  	oeb_modified = m && !gReadOnly;

		if (oeb_modified) {
			document.getElementById('oeb-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oeb-bGenerateBP').disabled = true;
			document.getElementById('oeb-bGenerateBL').disabled = true;
			document.getElementById('oeb-bEditionBL').disabled = true;
			document.getElementById('oeb-bColisage').disabled = true;
			document.getElementById('oeb-bEditionBP').disabled = true;
		}
		else {
			document.getElementById('oeb-tabBon').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
			document.getElementById('oeb-bGenerateBP').disabled = (oeb_etatBon=='V');
			document.getElementById('oeb-bGenerateBP').collapsed = oeb_mode=='C' || (!oeb_etapePrepaBL && oeb_typeExpedition=="B") || (!oeb_etapePrepaOL && oeb_typeExpedition=="L") || (!oeb_etapePrepaLF && oeb_typeExpedition=="F") || oeb_etatBon!='N' || (gReadOnly && !gProfil.isValidationBP());
			document.getElementById('oeb-bGenerateBL').disabled = false;
			document.getElementById('oeb-bGenerateBL').collapsed = oeb_mode=='C' || (oeb_statutExpedition!='P' && ((oeb_etapePrepaBL && oeb_typeExpedition=="B") || (oeb_etapePrepaOL && oeb_typeExpedition=="L") || (oeb_etapePrepaLF && oeb_typeExpedition=="F") || oeb_etatBon!='N')) || (gReadOnly && !gProfil.isValidationBL());
			document.getElementById('oeb-bEditionBL').disabled = false;
			document.getElementById('oeb-bEditionBL').collapsed = (oeb_etatBon=='N' || (oeb_typeExpedition=="B" && (oeb_statutExpedition=='P' || isEmpty(document.getElementById('oeb-dateBL').value))));
			document.getElementById('oeb-bColisage').disabled = (oeb_etatBon=='N' || oeb_etatBon=='A');
			document.getElementById('oeb-bEditionBP').disabled = false;
			document.getElementById('oeb-bEditionBP').collapsed = (oeb_etatBon=='N' || oeb_typeExpedition!='B');
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeb_chargerPdfBL() {
  try {

		var qGet = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qGet.setParam("Type_Doc", "BL");
		qGet.setParam("Doc_Id", oeb_bonLivId);
		var result = qGet.execute();
		oeb_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

		var aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oeb-langueDefaut");
		aLangues.setParam("Selection", oeb_langueDefaut);
		aLangues.initTree(oeb_initLangue);

  } catch (e) {
    recup_erreur(e);
  }
}


function oeb_initLangue() {
	try {

		document.getElementById('oeb-langueDefaut').value = oeb_langueDefaut;
		oeb_editerBon();

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_editerBP() {
	try {

		document.getElementById("oeb-barEdition").collapsed = true;
		document.getElementById('oeb-pdfBonLivraison').setAttribute("src", "");
		document.getElementById("bRetourExpedition").collapsed = false;
		document.getElementById("oeb-deckBonLivraison").selectedIndex = 1;
		document.getElementById('oeb-bEnvoyer').collapsed = true;
		document.getElementById('oeb-chkEditBP').collapsed = true;

		var oeb_qGenPdf = new QueryHttp("Facturation/Affaires/pdfBonPreparation.tmpl");
		oeb_qGenPdf.setParam('Bon_Id', oeb_bonLivId);

		var result = oeb_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oeb-pdfBonLivraison').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_editerBon() {
	try {

		document.getElementById("oeb-barEdition").collapsed = (oeb_typeExpedition!="B");
		document.getElementById('oeb-pdfBonLivraison').setAttribute("src", "");
		document.getElementById("bRetourExpedition").collapsed = false;
		document.getElementById("oeb-deckBonLivraison").selectedIndex = 1;
		document.getElementById('oeb-chkBonChiffre').collapsed = (oeb_typeExpedition=="L");
		document.getElementById('oeb-chkCFChiffre').collapsed = (oeb_typeExpedition!="F");
		document.getElementById('oeb-bEnvoyer').collapsed = false;
		document.getElementById('oeb-boxLangue').collapsed = (oeb_typeExpedition!="B");
		document.getElementById('oeb-chkEditBP').collapsed = (oeb_typeExpedition!="B");
		document.getElementById('oeb-chkEditCF').collapsed = (oeb_typeExpedition!="F");
		document.getElementById('oeb-chkEditLF').collapsed = (oeb_typeExpedition!="F");

		var editBP = document.getElementById('oeb-chkEditBP').checked;
		var editCF = document.getElementById('oeb-chkEditCF').checked;
		var editLF = document.getElementById('oeb-chkEditLF').checked;
		var typeDoc = (oeb_typeExpedition=="B"?"BL":oeb_typeExpedition=="L"?"OL":"LF");
		var langue = (oeb_typeExpedition=="F"?"0":document.getElementById('oeb-langueDefaut').value);
		var showTotaux = document.getElementById('oeb-chkBonChiffre').checked;
		var showTotauxCF = document.getElementById('oeb-chkCFChiffre').checked;

		if (oeb_typeExpedition=="F" && !editCF && !editLF) {
			showWarning("Vous devez cocher au moins une des deux cases 'Editer la commande fournisseur' ou 'Editer le bon de livraison'");
		}
		else {
			var oeb_qGenPdf = new QueryHttp("Facturation/Affaires/pdfBonLivraison.tmpl");
			oeb_qGenPdf.setParam('Bon_Id', oeb_bonLivId);
	  	oeb_qGenPdf.setParam("Edit_BP", editBP);
	  	oeb_qGenPdf.setParam("Edit_LF", editLF);
	  	oeb_qGenPdf.setParam("Edit_CF", editCF);
	  	oeb_qGenPdf.setParam('Langue', langue);
			oeb_qGenPdf.setParam('Show_Totaux', showTotaux);
			oeb_qGenPdf.setParam('Show_Totaux_CF', showTotauxCF);
			oeb_qGenPdf.setParam("Type_Doc", typeDoc);

			var result = oeb_qGenPdf.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

			document.getElementById('oeb-pdfBonLivraison').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_validerBon() {
  try {

		if (oeb_aBon.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient aucune ligne !");
		}
		else {
			var ok = true;

			if (oeb_actSuiviLot) {
				var qCheck = new QueryHttp("Facturation/Affaires/checkNumLotBL.tmpl");
				qCheck.setParam("Bon_Id", oeb_bonLivId);
				var result = qCheck.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					ok = false;
				}
			}

			var msgconfirm = "";

			if (gConfig.isGACAlerteNPBP() && oeb_nonPaye) {
				msgconfirm = "ATTENTION : La commande n'est pas pay\u00E9e !\n";
			}

			msgconfirm += "Confirmez-vous la g\u00E9n\u00E9ration du bon de pr\u00E9paration ?";
			if (oeb_typeExpedition=="F") {
				msgconfirm += "Confirmez-vous la g\u00E9n\u00E9ration de la commande fournisseur ?\n(Attention la commande valid\u00E9e ne pourra plus \u00EAtre modifi\u00E9e !)";
			}
			else if (oeb_typeExpedition=="L") {
				msgconfirm += "Confirmez-vous la g\u00E9n\u00E9ration de l'ordre de livraison ?\n(Attention l'ordre de livraison valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)";
			}

			if (ok && window.confirm(msgconfirm)) {

				var qValider = new QueryHttp("Facturation/Affaires/validerBonLivraison.tmpl");
				qValider.setParam('Bon_Id', oeb_bonLivId);
				qValider.setParam('Commande_Id', oeb_commandeId);
				qValider.setParam('Solder', document.getElementById('oeb-solder').checked);
				qValider.setParam('Nb_Colis', document.getElementById('oeb-nbColis').value);
				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oeb_chargerBon();
					if (oeb_typeExpedition=="B") {
						oeb_editerBP();
					}
					else {
						oeb_chargerPdfBL();
					}
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_annulerBon() {
  try {

		document.getElementById('oeb-bAnnuler').disabled = true;

		if (window.confirm("Confirmez-vous l'annulation de l'exp\u00E9dition ?"+ (oeb_typeExpedition=="F"?"\nAttention la commande fournisseur correspondant au LF va \u00E9galement \u00EAtre annul\u00E9e":""))) {

			var qCancel = new QueryHttp("Facturation/Affaires/cancelBonLivraison.tmpl");
			qCancel.setParam('Bon_Id', oeb_bonLivId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'exp\u00E9dition a \u00E9t\u00E9 annul\u00E9e !");
			}
			oeb_chargerBon();
		}
		else {
			document.getElementById('oeb-bAnnuler').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_rechercherAdrLiv() {
  try {

  	oeb_currentCodePaysLiv = document.getElementById('oeb-codePaysLiv').value;

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oeb_reporterAdrLiv, oeb_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

  	if (oeb_currentCodePaysLiv!=code_pays && !oeb_assujettiTVA) {
  		showWarning("L'adresse choisie doit \u00EAtre dans le m\u00EAme pays que le pays de livraison actuel !");
  	}
		else {
			document.getElementById('oeb-denominationLiv').value = nom;
			document.getElementById('oeb-adresse1Liv').value = adr1;
			document.getElementById('oeb-adresse2Liv').value = adr2;
			document.getElementById('oeb-adresse3Liv').value = adr3;
			document.getElementById('oeb-codePostalLiv').value = cp;
			document.getElementById('oeb-villeLiv').value = ville;
		  document.getElementById('oeb-codePaysLiv').value = code_pays;

			if (!isEmpty(contact_liv)) {
				var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
		  	qLoad.setParam("Contact_Id", contact_liv);
		  	var result = qLoad.execute();
		  	var contenu = result.responseXML.documentElement;
		  	oeb_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
		  }
			else {
				oeb_setModified(true);
		  }
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oeb_reporterInterLiv, oeb_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oeb-civInterLiv').value = civ;
		document.getElementById('oeb-nomInterLiv').value = nom;
		document.getElementById('oeb-prenomInterLiv').value = prenom;
		document.getElementById('oeb-telInter1Liv').value = tel1;
		document.getElementById('oeb-telInter2Liv').value = tel2;
		document.getElementById('oeb-faxInterLiv').value = fax;
		document.getElementById('oeb-emailInterLiv').value = email;

		oeb_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}

function oeb_choisirMentions() {
  try {

  	var ok = true;

  	if (oeb_mode=="C") {
			ok = oeb_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "BL", oeb_bonLivId, gReadOnly);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_colisage() {
  try {

		oco_init();
		document.getElementById("oco-deckColisageEtiquettes").selectedIndex = 0;
		document.getElementById('bRetourExpedition').collapsed = false;
		document.getElementById("deck").selectedIndex = 4;

  } catch (e) {
    recup_erreur(e);
  }
}


function oeb_initVersion() {
	try {

		oeb_aVersion.setParam("Bon_Id", oeb_bonLivId);
		oeb_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_selectionLigneBL()  {
	try {

		if (oeb_aBon.isSelected()) {
			document.getElementById('oeb-nbPieces').value = oeb_aBon.getSelectedCellText('oeb-colNbPiecesLiv');
			document.getElementById('oeb-quantite').value = oeb_aBon.getSelectedCellText('oeb-colQuantiteLiv');
			document.getElementById('oeb-nbPieces').disabled = false;
			document.getElementById('oeb-quantite').disabled = false;
			document.getElementById('oeb-numLot').value = "";
			document.getElementById('oeb-datePeremption').value = "";
			document.getElementById('oeb-numLot').disabled = true;
			document.getElementById('oeb-datePeremption').disabled = true;

			document.getElementById('oeb-bEnlever').disabled = false;
			document.getElementById('oeb-bAjouter').disabled = true;

			var articleId = oeb_aBon.getSelectedCellText('oeb-colArticleIdLiv');
			document.getElementById("oeb-bConsultSerieLigne").disabled = isEmpty(articleId);

			oeb_aCom.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (oeb_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Affaires/getNbNumSerieLigneBL.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var depotId = document.getElementById('oeb-depot').value;
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "BL", ligneId, depotId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_consulterNumSerie()  {
	try {

		if (oeb_aBon.isSelected()) {
			var ligneId = oeb_aBon.getSelectedCellText('oeb-colLigneIdLiv');
			var mode = (oeb_etatBon=="A" || oeb_statutExpedition=="E" || oeb_statutExpedition=="C" || gReadOnly?"C":"S");
			var depotId = document.getElementById('oeb-depot').value;
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
   		window.openDialog(url,'','chrome,modal,centerscreen', mode, "BL", ligneId, depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_checkNumLotLigne(numero, datePeremption, articleId, isSuiviLot, isSuiviDLC) {
	try {

		var ok = true;

		if (oeb_actSuiviLot && !isEmpty(articleId)) {

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
	    else if (!isEmpty(numero)) {
				var qLotBloque = new QueryHttp("Facturation/Tracabilite/isLotBloque.tmpl");
				qLotBloque.setParam("Num_Lot", numero);
				qLotBloque.setParam("Article_Id", articleId);
				var resLB = qLotBloque.execute();
				if (resLB.responseXML.documentElement.getAttribute("Bloque")=="true") {
					ok = false;
					showWarning("Impossible de valider la ligne : N\u00B0 Lot bloqu\u00E9");
				}
	    }
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13 && oeb_aCom.isSelected()) {
			var articleId = oeb_aCom.getSelectedCellText('oeb-colArticleIdDev');
			var numero = document.getElementById("oeb-numLot").value;
			var depotId = document.getElementById('oeb-depot').value;

			if (!isEmpty(articleId)) {
				var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', oeb_retourRechercherLot, articleId, numero, depotId, null);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oeb-numLot").value = numero;
		document.getElementById("oeb-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_updateDLC() {
	try {

		if (oeb_aCom.isSelected()) {
			var numero = document.getElementById("oeb-numLot").value;
			var articleId = oeb_aCom.getSelectedCellText('oeb-colArticleIdDev');

			if (!isEmpty(numero) && !isEmpty(articleId)) {
				var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
				qGetDLC.setParam("Article_Id", articleId);
				qGetDLC.setParam("Numero", numero);
				var result = qGetDLC.execute();
				var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
				if (!isEmpty(datePeremption)) {
					document.getElementById("oeb-datePeremption").value = datePeremption;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_selectionArticleCommande() {
	try {

		if (oeb_aCom.isSelected()) {
			if (oeb_aCom.nbSelection()==1) {
				document.getElementById('oeb-nbPieces').value = oeb_aCom.getSelectedCellText('oeb-colNbPiecesDev');
				document.getElementById('oeb-quantite').value = oeb_aCom.getSelectedCellText('oeb-colQuantiteDev');
				document.getElementById('oeb-nbPieces').disabled = false;
				document.getElementById('oeb-quantite').disabled = false;
				document.getElementById('oeb-numLot').value = "";
				document.getElementById('oeb-datePeremption').value = "";
				var articleId = oeb_aCom.getSelectedCellText('oeb-colArticleIdDev');
				document.getElementById('oeb-numLot').disabled = isEmpty(articleId);
				document.getElementById('oeb-datePeremption').disabled = isEmpty(articleId);
			}
			else {
				document.getElementById('oeb-nbPieces').value = "";
				document.getElementById('oeb-nbPieces').disabled = true;
				document.getElementById('oeb-quantite').value = "";
				document.getElementById('oeb-quantite').disabled = true;
				document.getElementById('oeb-numLot').value = "";
				document.getElementById('oeb-numLot').disabled = true;
				document.getElementById('oeb-datePeremption').value = "";
				document.getElementById('oeb-datePeremption').disabled = true;
			}
			document.getElementById('oeb-bAjouter').disabled = false;
			document.getElementById('oeb-bEnlever').disabled = true;
			oeb_aBon.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_onKeyPressNumSerie(event) {
	try {

		if (event.keyCode==13) {
			oeb_validerSaisieBySerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_validerSaisieBySerie(ligneId) {
	try {

		var listLigneCC = ligneId;

		if (listLigneCC==null) {
			listLigneCC = "";
			var nbLignes = oeb_aCom.nbLignes();
			for (i=0; i<nbLignes; i++) {
				if (parseFloat(oeb_aCom.getCellText(i, 'oeb-colQuantiteDev'))>0) {
					listLigneCC += oeb_aCom.getCellText(i, 'oeb-colLigneIdDev') +",";
				}
			}
		}

		var numSerie = document.getElementById("oeb-numSerie").value;

		if (!isEmpty(numSerie)) {

			var ok = true;
			if (oeb_mode=="C") {
				ok = oeb_enregistrerBon(true);
			}
			if (ok) {
				var qAdd = new QueryHttp('Facturation/Affaires/addNumSerieBL.tmpl');
				qAdd.setParam("Bon_Id", oeb_bonLivId);
				qAdd.setParam("Num_Serie", numSerie);
				qAdd.setParam("List_Ligne_CC", listLigneCC);
				var result = qAdd.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit) {
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/affaires/popup-conflitNumSerieCC.xul";
			      window.openDialog(url,'','chrome,modal,centerscreen', listConflit, oeb_retourChoixConflit);
					}
					else {
						oeb_aCom.initTree();
						oeb_aBon.initTree();
						document.getElementById("oeb-numSerie").value = "";
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_retourChoixConflit(ligneId) {
	try {

		oeb_validerSaisieBySerie(ligneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_envoyerMail() {
	try {

		var typeDoc = (oeb_typeExpedition=="B"?"BL":oeb_typeExpedition=="L"?"OL":"LF");
		var langue = (oeb_typeExpedition=="F"?"0":document.getElementById('oeb-langueDefaut').value);
		var showTotaux = document.getElementById('oeb-chkBonChiffre').checked;
		var showTotauxCF = document.getElementById('oeb-chkCFChiffre').checked;
		var editBP = document.getElementById('oeb-chkEditBP').checked;
		var editCF = document.getElementById('oeb-chkEditCF').checked;
		var editLF = document.getElementById('oeb-chkEditLF').checked;

		if (oeb_typeExpedition=="F" && !editCF && !editLF) {
			showWarning("Vous devez cocher au moins une des deux cases 'Editer la commande fournisseur' ou 'Editer le bon de livraison'");
		}
		else {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', typeDoc, oeb_bonLivId, langue, showTotaux, (typeDoc=="LF"?showTotauxCF:editBP), editLF, editCF);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_editerPrixAchat() {
	try {

		if (oeb_typeExpedition=="F" && oeb_etatBon=="N" && !gReadOnly && gAccesCoutAchat && oeb_aBon.isSelected()) {
			var ligneId = oeb_aBon.getSelectedCellText('oeb-colLigneIdLiv');
			var prixAchat = oeb_aBon.getSelectedCellText('oeb-colPrixAchatCFLiv');

			var url = "chrome://opensi/content/facturation/user/affaires/popup-modifierPrixAchatBL.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', ligneId, prixAchat, oeb_retourEditerPrixAchat);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_retourEditerPrixAchat() {
	try {

		oeb_aBon.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_clickOnColis(tree, ev) {

	gClipboardHelper.copyString(oeb_aLiensColis.getSelectedCellText("oeb-colNumColis"));

	var col = oeb_aLiensColis.getClickedCol(ev);

	if (col!=null && col.id=="oeb-colNumColis") {
		var lien = oeb_aLiensColis.getSelectedCellValue("oeb-colNumColis");
		if (!isEmpty(lien)) {
			//window.open(lien);
			openInNavigator(lien);
		}
	}
	else if (col!=null && col.id=="oeb-colCTC") {
		window.open(oeb_aLiensColis.getSelectedCellValue("oeb-colCTC"));
	}
}


function oeb_keypressOnColis(ev) {
  try {

		if ((ev.key=='w' || ev.key=='W') && ev.ctrlKey && oeb_aLiensColis.isSelected()) {
			// ctrl + w pour copier l'adresse du lien
			gClipboardHelper.copyString(oeb_aLiensColis.getSelectedCellValue("oeb-colNumColis"));
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_initModePrepa() {
	try {

		oeb_etapePrepaBL = oeb_defautEtapePrepaBL;
		oeb_etapePrepaOL = oeb_defautEtapePrepaOL;

		if (!isEmpty(oeb_curDepot)) {
			var qDepot = new QueryHttp("Facturation/Commun/getDepotStock.tmpl");
			qDepot.setParam("Depot_Id", oeb_curDepot);
			var result = qDepot.execute();

			var etapePrepaDepotBL = result.responseXML.documentElement.getAttribute("Etape_Prepa_BL_CC");
			if (!isEmpty(etapePrepaDepotBL)) {
				oeb_etapePrepaBL = (etapePrepaDepotBL=="true");
				oeb_etapePrepaOL = (etapePrepaDepotBL=="true");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeb_rechercherPointRelais() {
  try {

		oeb_currentCodePaysLiv = document.getElementById('oeb-codePaysLiv').value;
		var modeExpedition = document.getElementById('oeb-modeExpedition').value;

		if (isEmpty(modeExpedition)) {
			showWarning("Veuillez choisir un mode d'exp\u00E9dition pour acc\u00E9der aux points relais du transporteur");
		}
		else {
			var url = "chrome://opensi/content/facturation/user/commun/popup-recherchePointRelais.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oeb_reporterPointRelais, modeExpedition, oeb_currentCodePaysLiv);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_reporterPointRelais(codeRelais, denomination, adresse1, adresse2, adresse3, codePostal, ville, codePays) {
  try {

		document.getElementById('oeb-pointRetrait').value = codeRelais;
		document.getElementById('oeb-tabBoxAdresses').selectedIndex = 1;
		oeb_reporterAdrLiv(denomination, adresse1, adresse2, adresse3, codePostal, ville, "", codePays, "", "", "", "", "");

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_pressOnColis() {
  try {

		if (oeb_aLiensColis.isSelected()) {
			document.getElementById('oeb-bAnnulerColis').disabled = (oeb_aLiensColis.getSelectedCellText("oeb-colStatut")!="V");
		}
		else {
			document.getElementById('oeb-bAnnulerColis').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeb_annulerColis() {
  try {

		document.getElementById('oeb-bAnnulerColis').disabled = true;

		if (window.confirm("Confirmez-vous l'annulation du colis s\u00E9lectionn\u00E9 ?")) {

			var colisId = oeb_aLiensColis.getSelectedCellText("oeb-colColisId");

			var qCancel = new QueryHttp("Facturation/Affaires/cancelColis.tmpl");
			qCancel.setParam("Colis_Id", colisId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le colis a \u00E9t\u00E9 annul\u00E9");
			}
			oeb_aLiensColis.initTree();
		}
		else {
			document.getElementById('oeb-bAnnulerColis').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_editerColisageCSV() {
  try {

		var qEditionCsv = new QueryHttp("Facturation/Affaires/csvColisageBL.tmpl");
		qEditionCsv.setParam("Bon_Liv_Id", oeb_bonLivId);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oeb_editerColisagePDF() {
  try {

		var qEditionPdf = new QueryHttp("Facturation/Affaires/pdfColisageBL.tmpl");
		qEditionPdf.setParam("Bon_Liv_Id", oeb_bonLivId);

		document.getElementById('oeb-deckBonLivraison').selectedIndex = 2;

		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oeb-pdfEdition').setAttribute("src", page);

			document.getElementById('bRetourExpedition').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}
