/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Commande_Id pour restriction aux fournisseurs livraison directe des articles de la commande client
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aArticles = new Arbre('Facturation/Affaires/liste-articlesALivrer.tmpl', 'listArticles');
var aTarifQte = new Arbre("Facturation/Articles/list-prixFournisseurQuantite.tmpl", "listTarifQte");

var fournisseurId = "";



function init() {
  try {

		var commandeId = window.arguments[1];

		aArticles.setParam('Commande_Id', commandeId);

		var config = getConfig();

		var actNbPieces = config.isActNbPieces();
		var actDispoFour = config.isActDispoFour();

		if (!actNbPieces) {
			document.getElementById('colNbPieces').collapsed = true;
			document.getElementById('colNbPieces').setAttribute('ignoreincolumnpicker', true);
		}

		if (!actDispoFour) {
			document.getElementById('colStockFourn').collapsed = true;
			document.getElementById('colStockFourn').setAttribute('ignoreincolumnpicker', true);
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("colAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("colAttribut"+ i).collapsed = true;
				document.getElementById("colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var aFournisseurs = new Arbre("Facturation/Affaires/combo-fournisseursDS.tmpl", "fournisseurId");
		aFournisseurs.setParam("Commande_Id", commandeId);
		aFournisseurs.initTree(initFournisseur);

		if (!getProfil().isAccesCoutAchat()) {
			document.getElementById('colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colPRemise').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colPrixAchatPFQ').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colPrixAchat').collapsed = true;
			document.getElementById('colPRemise').collapsed = true;
			document.getElementById('colPrixAchatPFQ').collapsed = true;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function initFournisseur() {
	try {

		if (document.getElementById("fournisseurId").itemCount==2) {
			document.getElementById("fournisseurId").selectedIndex = 1;
			changeFournisseur();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function changeFournisseur() {
	try {

		fournisseurId = document.getElementById("fournisseurId").value;

		if (isEmpty(fournisseurId)) {
			aArticles.deleteTree();
		}
		else {
			aArticles.setParam('Fournisseur_Id', fournisseurId);
			aArticles.initTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListArticles() {
	try {

		if (aArticles.isSelected()) {
			var articleId = aArticles.getSelectedCellText("colArticleId");

			aTarifQte.setParam("Article_Id", articleId);
			aTarifQte.setParam("Fournisseur_Id", fournisseurId);
			aTarifQte.initTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function validerFournisseur() {
	try {

		var fournisseurId = document.getElementById("fournisseurId").value;

		if (isEmpty(fournisseurId)) {
			showWarning("Veuillez s\u00E9lectionner un fournisseur");
		}
		else {
			var listLigneId = "";

			for (var i=0; i<aArticles.nbLignes(); i++) {
				if (aArticles.getCellValue(i, "colSelect")=="true") {
					listLigneId += aArticles.getCellText(i, "colLigneId") +",";
				}
  		}

			window.arguments[0](fournisseurId, listLigneId);
			window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(b) {
	try {

		for (var i=0; i<aArticles.nbLignes(); i++) {
			if (aArticles.isEditable(i, "colSelect")) {
				aArticles.setCellValue(i, "colSelect", b);
  		}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
