/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var commandeId;
var pourcentageMax;
var montantMax;



function init() {
  try {

		commandeId = window.arguments[1];

    document.getElementById('typeFacturation').value = "P";

		pressOnTypeFacturation();

		var qGet = new QueryHttp("Facturation/Affaires/getInitSituation.tmpl");
		qGet.setParam("Commande_Id", commandeId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		pourcentageMax = contenu.getAttribute("Pourcentage_Max");
		montantMax = contenu.getAttribute("Montant_Max");

		if (contenu.getAttribute("Edition_TTC")=="true") {
			document.getElementById('itemMontant').setAttribute("label", "Montant TTC");
		}

		document.getElementById('itemFinale').disabled = parseFloat(pourcentageMax)>=100;

  } catch (e) {
    recup_erreur(e);
  }
}


function valider() {
  try {

		var typeFacturation = document.getElementById('typeFacturation').value;
		var montant = document.getElementById('montant').value;
		var pourcentage = document.getElementById('pourcentage').value;

		var fmon = new NumberFormat("0.00", true);
		var ftx = new NumberFormat("0.##", true);

		if (typeFacturation=="P" && (!isTaux(pourcentage) || parseFloat(pourcentage)>=100 || parseFloat(pourcentage)<=0)) { showWarning("Pourcentage incorrect"); }
		else if (typeFacturation=="P" && parseFloat(pourcentage)>=parseFloat(pourcentageMax)) { showWarning("Pourcentage trop \u00E9lev\u00E9 (max < "+ ftx.format(pourcentageMax) +" %)"); }
		else if (typeFacturation=="M" && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else if (typeFacturation=="M" && parseFloat(montant)>=parseFloat(montantMax)) { showWarning("Montant trop \u00E9lev\u00E9 (max < "+ fmon.format(montantMax) +" \u20AC)"); }
		else {

			var pourcentageFS;

			if (typeFacturation=="P") {
				pourcentageFS = pourcentage;
			}
			else if (typeFacturation=="M") {
				pourcentageFS = getPourcentageFS(montant);
			}
			else {
				pourcentageFS = pourcentageMax;
			}

			window.arguments[0](pourcentageFS);
			window.close();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function getPourcentageFS(montant) {
  try {

		var qGet = new QueryHttp("Facturation/Affaires/getPourcentageFSByMontant.tmpl");
		qGet.setParam("Commande_Id", commandeId);
		qGet.setParam("Montant", montant);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			return 0;
		}
		else {
			return result.responseXML.documentElement.getAttribute("Pourcentage_FS");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypeFacturation() {
  try {

    var typeFacturation = document.getElementById('typeFacturation').value;

		document.getElementById('montant').disabled = typeFacturation!="M";
		document.getElementById('pourcentage').disabled = typeFacturation!="P";

  } catch (e) {
    recup_erreur(e);
  }
}

