/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oma_aSites = new Arbre('ComboListe/combo-sitesWeb.tmpl','oma-siteWeb');
var oma_aFamilles1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oma-famille1');
var oma_aFamilles2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oma-famille2');
var oma_aFamilles3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oma-famille3');
var oma_aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'oma-marque');
var oma_aAttributs1 = new Arbre('ComboListe/combo-attributs.tmpl', 'oma-attribut1');
var oma_aAttributs2 = new Arbre('ComboListe/combo-attributs.tmpl', 'oma-attribut2');
var oma_aAttributs3 = new Arbre('ComboListe/combo-attributs.tmpl', 'oma-attribut3');
var oma_aAttributs4 = new Arbre('ComboListe/combo-attributs.tmpl', 'oma-attribut4');
var oma_aAttributs5 = new Arbre('ComboListe/combo-attributs.tmpl', 'oma-attribut5');
var oma_aAttributs6 = new Arbre('ComboListe/combo-attributs.tmpl', 'oma-attribut6');
var oma_aDispoFourn = new Arbre('Facturation/Articles/list-dispoFournisseur.tmpl', 'oma-listeDispoFournisseur');
var oma_aDispoStock = new Arbre('Facturation/Articles/list-dispoStock.tmpl', 'oma-listeDispoStock');
var oma_aPotentiels = new Arbre('Facturation/Articles/list-potentielForfait.tmpl', 'oma-listePotentiels');
var oma_aComposants = new Arbre('Facturation/Articles/list-composantArticle.tmpl', 'oma-listeComposants');
var oma_aArticles = new Arbre("Facturation/Articles/list-ficheArticle.tmpl", "oma-listeArticles");
var oma_qListFA = new QueryHttp("Facturation/Articles/getDataListFA.tmpl");

var oma_pageCourante;
var oma_nbPages;

var oma_circonstAttr1 = false;
var oma_circonstAttr2 = false;
var oma_circonstAttr3 = false;
var oma_circonstAttr4 = false;
var oma_circonstAttr5 = false;
var oma_circonstAttr6 = false;

var oma_groupeAttr1;
var oma_groupeAttr2;
var oma_groupeAttr3;
var oma_groupeAttr4;
var oma_groupeAttr5;
var oma_groupeAttr6;



function oma_init() {
	try {

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		oma_groupeAttr1 = contenu.getAttribute("Groupe_Id_1");
		oma_groupeAttr2 = contenu.getAttribute("Groupe_Id_2");
		oma_groupeAttr3 = contenu.getAttribute("Groupe_Id_3");
		oma_groupeAttr4 = contenu.getAttribute("Groupe_Id_4");
		oma_groupeAttr5 = contenu.getAttribute("Groupe_Id_5");
		oma_groupeAttr6 = contenu.getAttribute("Groupe_Id_6");

		if (!isEmpty(oma_groupeAttr1)) {
			document.getElementById('oma-lblAttribut1').value = contenu.getAttribute('Intitule_1') +" :";
			document.getElementById('oma-colAttribut1').setAttribute("label", contenu.getAttribute('Intitule_1'));
			oma_circonstAttr1 = (contenu.getAttribute('Circonst_1')=="true");
			oma_aAttributs1.setParam("Groupe_Id", oma_groupeAttr1);
			oma_aAttributs1.setParam("Search_Mode", true);
			oma_aAttributs1.initTree();
		}
		else {
			document.getElementById('oma-lblAttribut1').value = "Att. Princ. 1 :";
			document.getElementById('oma-lblAttribut1').disabled = true;
			document.getElementById('oma-attribut1').disabled = true;
			document.getElementById("oma-colAttribut1").collapsed = true;
			document.getElementById("oma-colAttribut1").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oma_groupeAttr2)) {
			document.getElementById('oma-lblAttribut2').value = contenu.getAttribute('Intitule_2') +" :";
			document.getElementById('oma-colAttribut2').setAttribute("label", contenu.getAttribute('Intitule_2'));
			oma_circonstAttr2 = (contenu.getAttribute('Circonst_2')=="true");
			oma_aAttributs2.setParam("Groupe_Id", oma_groupeAttr2);
			oma_aAttributs2.setParam("Search_Mode", true);
			oma_aAttributs2.initTree();
		}
		else {
			document.getElementById('oma-lblAttribut2').value = "Att. Princ. 2 :";
			document.getElementById('oma-lblAttribut2').disabled = true;
			document.getElementById('oma-attribut2').disabled = true;
			document.getElementById("oma-colAttribut2").collapsed = true;
			document.getElementById("oma-colAttribut2").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oma_groupeAttr3)) {
			document.getElementById('oma-lblAttribut3').value = contenu.getAttribute('Intitule_3') +" :";
			document.getElementById('oma-colAttribut3').setAttribute("label", contenu.getAttribute('Intitule_3'));
			oma_circonstAttr3 = (contenu.getAttribute('Circonst_3')=="true");
			oma_aAttributs3.setParam("Groupe_Id", oma_groupeAttr3);
			oma_aAttributs3.setParam("Search_Mode", true);
			oma_aAttributs3.initTree();
		}
		else {
			document.getElementById('oma-lblAttribut3').value = "Att. Princ. 3 :";
			document.getElementById('oma-lblAttribut3').disabled = true;
			document.getElementById('oma-attribut3').disabled = true;
			document.getElementById("oma-colAttribut3").collapsed = true;
			document.getElementById("oma-colAttribut3").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oma_groupeAttr4)) {
			document.getElementById('oma-lblAttribut4').value = contenu.getAttribute('Intitule_4') +" :";
			document.getElementById('oma-colAttribut4').setAttribute("label", contenu.getAttribute('Intitule_4'));
			oma_circonstAttr4 = (contenu.getAttribute('Circonst_4')=="true");
			oma_aAttributs4.setParam("Groupe_Id", oma_groupeAttr4);
			oma_aAttributs4.setParam("Search_Mode", true);
			oma_aAttributs4.initTree();
		}
		else {
			document.getElementById('oma-lblAttribut4').value = "Att. Princ. 4 :";
			document.getElementById('oma-lblAttribut4').disabled = true;
			document.getElementById('oma-attribut4').disabled = true;
			document.getElementById("oma-colAttribut4").collapsed = true;
			document.getElementById("oma-colAttribut4").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oma_groupeAttr5)) {
			document.getElementById('oma-lblAttribut5').value = contenu.getAttribute('Intitule_5') +" :";
			document.getElementById('oma-colAttribut5').setAttribute("label", contenu.getAttribute('Intitule_5'));
			oma_circonstAttr5 = (contenu.getAttribute('Circonst_5')=="true");
			oma_aAttributs5.setParam("Groupe_Id", oma_groupeAttr5);
			oma_aAttributs5.setParam("Search_Mode", true);
			oma_aAttributs5.initTree();
		}
		else {
			document.getElementById('oma-lblAttribut5').value = "Att. Princ. 5 :";
			document.getElementById('oma-lblAttribut5').disabled = true;
			document.getElementById('oma-attribut5').disabled = true;
			document.getElementById("oma-colAttribut5").collapsed = true;
			document.getElementById("oma-colAttribut5").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oma_groupeAttr6)) {
			document.getElementById('oma-lblAttribut6').value = contenu.getAttribute('Intitule_6') +" :";
			document.getElementById('oma-colAttribut6').setAttribute("label", contenu.getAttribute('Intitule_6'));
			oma_circonstAttr6 = (contenu.getAttribute('Circonst_6')=="true");
			oma_aAttributs6.setParam("Groupe_Id", oma_groupeAttr6);
			oma_aAttributs6.setParam("Search_Mode", true);
			oma_aAttributs6.initTree();
		}
		else {
			document.getElementById('oma-lblAttribut6').value = "Att. Princ. 6 :";
			document.getElementById('oma-lblAttribut6').disabled = true;
			document.getElementById('oma-attribut6').disabled = true;
			document.getElementById("oma-colAttribut6").collapsed = true;
			document.getElementById("oma-colAttribut6").setAttribute("ignoreincolumnpicker", true);
		}

		oma_aMarques.setParam("Search_Mode", true);
		oma_aMarques.initTree();

		oma_aFamilles1.setParam("Search_Mode", true);
		oma_aFamilles2.setParam("Search_Mode", true);
		oma_aFamilles3.setParam("Search_Mode", true);

		document.getElementById('oma-famille2').disabled = true;
		document.getElementById('oma-famille3').disabled = true;
		oma_aFamilles1.initTree();

		if (gSiteWeb) {
			document.getElementById('oma-boxSiteWeb').collapsed = false;
			oma_aSites.initTree();
		}

		if (gReadOnly) {
			document.getElementById('oma-bNouveau').collapsed = true;
		}

		setTimeout("document.getElementById('oma-reference').focus()",0);

		oma_loadChiffresCles();

		if (!gAccesCoutAchat) {
			document.getElementById('oma-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oma-colTauxMarque').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oma-colTauxMarge').setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById('oma-bRechEmplacement').collapsed = !gActEmplacements;

		if (!gShowElemFour) {
			document.getElementById('oma-lblFilterNumFournisseur').collapsed = true;
			document.getElementById('oma-boxFilterNumFournisseur').collapsed = true;
			document.getElementById('oma-boxDispoFournisseur').collapsed = true;
		}

		var aEtiquettes = new Arbre("ComboListe/combo-etiquettes.tmpl", "oma-etiquette");
		aEtiquettes.setParam("Type_Etiquette", "A");
		aEtiquettes.initTree(oma_initEtiquette);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('oma-famille1').value;

		document.getElementById('oma-famille2').value = "";
		document.getElementById('oma-famille2').disabled = isEmpty(famille1);

		oma_aFamilles3.deleteTree();
		document.getElementById('oma-famille3').value = "";
		document.getElementById('oma-famille3').disabled = true;

		oma_aFamilles2.setParam('Parent_Id', famille1);
		oma_aFamilles2.initTree(oma_manageCirconstAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('oma-famille2').value;

		document.getElementById('oma-famille3').value = "";
		document.getElementById('oma-famille3').disabled = isEmpty(famille2);

		oma_aFamilles3.setParam('Parent_Id', famille2);
		oma_aFamilles3.initTree(oma_manageCirconstAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_manageCirconstAttributs() {
	try {

		var famille1 = document.getElementById('oma-famille1').value;
		var famille2 = document.getElementById('oma-famille2').value;
		var famille3 = document.getElementById('oma-famille3').value;

		var familleId = !isEmpty(famille3)?famille3:!isEmpty(famille2)?famille2:famille1;

		if (!isEmpty(familleId)) {
			var qCirc = new QueryHttp("Facturation/Commun/existGroupeAttributFamilleArticle.tmpl");
			qCirc.setParam("Famille_Id", familleId);

			if (oma_circonstAttr1 && !isEmpty(oma_groupeAttr1)) {
				qCirc.setParam("Groupe_Id", oma_groupeAttr1);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oma-attribut1').disabled = true;
					document.getElementById('oma-attribut1').value = "";
				}
				else {
					document.getElementById('oma-attribut1').disabled = false;
				}
			}

			if (oma_circonstAttr2 && !isEmpty(oma_groupeAttr2)) {
				qCirc.setParam("Groupe_Id", oma_groupeAttr2);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oma-attribut2').disabled = true;
					document.getElementById('oma-attribut2').value = "";
				}
				else {
					document.getElementById('oma-attribut2').disabled = false;
				}
			}

			if (oma_circonstAttr3 && !isEmpty(oma_groupeAttr3)) {
				qCirc.setParam("Groupe_Id", oma_groupeAttr3);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oma-attribut3').disabled = true;
					document.getElementById('oma-attribut3').value = "";
				}
				else {
					document.getElementById('oma-attribut3').disabled = false;
				}
			}

			if (oma_circonstAttr4 && !isEmpty(oma_groupeAttr4)) {
				qCirc.setParam("Groupe_Id", oma_groupeAttr4);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oma-attribut4').disabled = true;
					document.getElementById('oma-attribut4').value = "";
				}
				else {
					document.getElementById('oma-attribut4').disabled = false;
				}
			}

			if (oma_circonstAttr5 && !isEmpty(oma_groupeAttr5)) {
				qCirc.setParam("Groupe_Id", oma_groupeAttr5);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oma-attribut5').disabled = true;
					document.getElementById('oma-attribut5').value = "";
				}
				else {
					document.getElementById('oma-attribut5').disabled = false;
				}
			}

			if (oma_circonstAttr6 && !isEmpty(oma_groupeAttr6)) {
				qCirc.setParam("Groupe_Id", oma_groupeAttr6);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oma-attribut6').disabled = true;
					document.getElementById('oma-attribut6').value = "";
				}
				else {
					document.getElementById('oma-attribut6').disabled = false;
				}
			}
		}
		else {
			document.getElementById('oma-attribut1').disabled = isEmpty(oma_groupeAttr1);
			document.getElementById('oma-attribut2').disabled = isEmpty(oma_groupeAttr2);
			document.getElementById('oma-attribut3').disabled = isEmpty(oma_groupeAttr3);
			document.getElementById('oma-attribut4').disabled = isEmpty(oma_groupeAttr4);
			document.getElementById('oma-attribut5').disabled = isEmpty(oma_groupeAttr5);
			document.getElementById('oma-attribut6').disabled = isEmpty(oma_groupeAttr6);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnNouveauArticle() {
	try {

		document.getElementById("bMenuArticles").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		ofa_nouveauArticle();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initCriteres() {
	try {

		document.getElementById('oma-famille2').disabled = true;
		document.getElementById('oma-famille3').disabled = true;
		oma_aFamilles2.deleteTree();
		oma_aFamilles3.deleteTree();

		document.getElementById('oma-reference').value = "";
		document.getElementById('oma-refModele').value = "";
		document.getElementById('oma-designation').value = "";
		document.getElementById('oma-marque').value = "";
		document.getElementById('oma-famille1').value = "";
		document.getElementById('oma-famille2').value = "";
		document.getElementById('oma-famille3').value = "";
		document.getElementById('oma-attribut1').value = "";
		document.getElementById('oma-attribut2').value = "";
		document.getElementById('oma-attribut3').value = "";
		document.getElementById('oma-attribut4').value = "";
		document.getElementById('oma-attribut5').value = "";
		document.getElementById('oma-attribut6').value = "";
		document.getElementById('oma-typeArticle').value = "";
		document.getElementById('oma-siteWeb').value = "";
		document.getElementById('oma-actif').checked = true;
		document.getElementById('oma-numFournisseur').value = "";
		document.getElementById('oma-codeEmplacement').value = "";
		document.getElementById('oma-composant').value = "";

		oma_manageCirconstAttributs();

		oma_listerArticles();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_listerArticles() {
	try {

		var reference = document.getElementById('oma-reference').value;
		var refModele = document.getElementById('oma-refModele').value;
		var designation = document.getElementById('oma-designation').value;
		var marque = document.getElementById('oma-marque').value;
		var famille1 = document.getElementById('oma-famille1').value;
		var famille2 = document.getElementById('oma-famille2').value;
		var famille3 = document.getElementById('oma-famille3').value;
		var attribut1 = document.getElementById('oma-attribut1').value;
		var attribut2 = document.getElementById('oma-attribut2').value;
		var attribut3 = document.getElementById('oma-attribut3').value;
		var attribut4 = document.getElementById('oma-attribut4').value;
		var attribut5 = document.getElementById('oma-attribut5').value;
		var attribut6 = document.getElementById('oma-attribut6').value;
		var typeArticle = document.getElementById('oma-typeArticle').value;
		var siteWeb = document.getElementById('oma-siteWeb').value;
		var actif = document.getElementById('oma-actif').checked;
		var numFournisseur = document.getElementById('oma-numFournisseur').value;
		var codeEmplacement = document.getElementById('oma-codeEmplacement').value;
		var composant = document.getElementById('oma-composant').value;
		var nbLignesParPage = document.getElementById('oma-nbLignesParPage').value;

		oma_pageCourante = 1;
		oma_nbPages = 1;
		document.getElementById('oma-pageDeb').value = 1;
		document.getElementById('oma-pageFin').value = 1;
		document.getElementById('oma-bPrec').disabled = true;
		document.getElementById('oma-bSuiv').disabled = true;

		document.getElementById('oma-listeArticles').disabled = true;
		document.getElementById('oma-bEditionCsv').disabled = true;
		document.getElementById('oma-bEtiquettes').disabled = true;
		document.getElementById('oma-referenceSelect').value = "";
		oma_aDispoFourn.deleteTree();
		oma_aDispoStock.deleteTree();
		oma_aPotentiels.deleteTree();
		oma_aComposants.deleteTree();
		oma_aArticles.deleteTree();

		oma_qListFA.setParam("Reference", reference);
		oma_qListFA.setParam("Ref_Modele", refModele);
		oma_qListFA.setParam("Designation", designation);
		oma_qListFA.setParam("Marque", marque);
		oma_qListFA.setParam("Famille_1", famille1);
		oma_qListFA.setParam("Famille_2", famille2);
		oma_qListFA.setParam("Famille_3", famille3);
		oma_qListFA.setParam("Attribut_1", attribut1);
		oma_qListFA.setParam("Attribut_2", attribut2);
		oma_qListFA.setParam("Attribut_3", attribut3);
		oma_qListFA.setParam("Attribut_4", attribut4);
		oma_qListFA.setParam("Attribut_5", attribut5);
		oma_qListFA.setParam("Attribut_6", attribut6);
		oma_qListFA.setParam("Type_Article", typeArticle);
		oma_qListFA.setParam("Site_Web", siteWeb);
		oma_qListFA.setParam("Actif", actif);
		oma_qListFA.setParam("Num_Fournisseur", numFournisseur);
		oma_qListFA.setParam("Code_Emplacement", codeEmplacement);
		oma_qListFA.setParam("Composant", composant);
		oma_qListFA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		oma_qListFA.setParam("Current_Page", oma_pageCourante);

		var result = oma_qListFA.execute();

		var contenu = result.responseXML.documentElement;

		oma_nbPages = contenu.getAttribute("Nb_Pages");
		var listArticleId = contenu.getAttribute("List_Article_Id");

		oma_aArticles.setParam("List_Article_Id", listArticleId);
		oma_aArticles.initTree(oma_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initPagination() {
	try {

		document.getElementById('oma-pageDeb').value = oma_pageCourante;
		document.getElementById('oma-pageFin').value = (oma_nbPages>0?oma_nbPages:1);
		document.getElementById('oma-bPrec').disabled = (oma_pageCourante==1);
		document.getElementById('oma-bSuiv').disabled = (oma_pageCourante>=oma_nbPages); // peut se produire si oma_nbPages=0

		oma_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnPagePrec() {
	try {

		oma_pageCourante--;
		oma_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnPageSuiv() {
	try {

		oma_pageCourante++;
		oma_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_majPagination() {
	try {

		document.getElementById('oma-pageDeb').value = oma_pageCourante;
		document.getElementById('oma-bPrec').disabled = (oma_pageCourante==1);
		document.getElementById('oma-bSuiv').disabled = (oma_pageCourante==oma_nbPages);

		document.getElementById('oma-referenceSelect').value = "";

		document.getElementById('oma-listeArticles').disabled = true;
		document.getElementById('oma-bEditionCsv').disabled = true;
		document.getElementById('oma-bEtiquettes').disabled = true;
		oma_aDispoFourn.deleteTree();
		oma_aDispoStock.deleteTree();
		oma_aPotentiels.deleteTree();
		oma_aComposants.deleteTree();

		oma_qListFA.setParam("Current_Page", oma_pageCourante);
		var result = oma_qListFA.execute();
		var listArticleId = result.responseXML.documentElement.getAttribute("List_Article_Id");

		oma_aArticles.setParam("List_Article_Id", listArticleId);
		oma_aArticles.initTree(oma_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_afterMajPagination() {
	try {

		document.getElementById('oma-listeArticles').disabled = false;
		document.getElementById('oma-bEditionCsv').disabled = (oma_aArticles.nbLignes()==0);
		document.getElementById('oma-bEtiquettes').disabled = (oma_aArticles.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_selectOnListeArticles() {
	try {

		if (oma_aArticles.isSelected()) {
			document.getElementById("oma-deckApercu").selectedIndex = 1;
			var articleId = oma_aArticles.getSelectedCellText("oma-colArticleId");
			document.getElementById('oma-referenceSelect').value = oma_aArticles.getSelectedCellText("oma-colReference");

			if (oma_aArticles.getSelectedCellValue("oma-colTypeArticle")=="F") {
				document.getElementById('oma-apercuSimple').collapsed = true;
				document.getElementById('oma-apercuForfait').collapsed = false;
				oma_aPotentiels.setParam("Article_Id", articleId);
				oma_aPotentiels.initTree();
				oma_aComposants.setParam("Article_Id", articleId);
				oma_aComposants.initTree();
			}
			else {
				document.getElementById('oma-apercuSimple').collapsed = false;
				document.getElementById('oma-apercuForfait').collapsed = true;
				oma_aDispoStock.setParam("Article_Id", articleId);
				oma_aDispoStock.initTree();
				oma_aDispoFourn.setParam("Article_Id", articleId);
				oma_aDispoFourn.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oma_listerArticles();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oma_pressOnListeArticles(ev) {
	try {

		if (ev.keyCode==13) {
			oma_ouvrirArticle();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_ouvrirArticle() {
  try {

  	if (oma_aArticles.isSelected()) {

			ofa_articleId = oma_aArticles.getSelectedCellText('oma-colArticleId');
			document.getElementById('bMenuArticles').collapsed = false;

			ofa_chargerArticle();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oma_pressOnEditionCsv() {
	try {

		var reference = document.getElementById('oma-reference').value;
		var refModele = document.getElementById('oma-refModele').value;
		var designation = document.getElementById('oma-designation').value;
		var marque = document.getElementById('oma-marque').value;
		var famille1 = document.getElementById('oma-famille1').value;
		var famille2 = document.getElementById('oma-famille2').value;
		var famille3 = document.getElementById('oma-famille3').value;
		var attribut1 = document.getElementById('oma-attribut1').value;
		var attribut2 = document.getElementById('oma-attribut2').value;
		var attribut3 = document.getElementById('oma-attribut3').value;
		var attribut4 = document.getElementById('oma-attribut4').value;
		var attribut5 = document.getElementById('oma-attribut5').value;
		var attribut6 = document.getElementById('oma-attribut6').value;
		var typeArticle = document.getElementById('oma-typeArticle').value;
		var siteWeb = document.getElementById('oma-siteWeb').value;
		var actif = document.getElementById('oma-actif').checked;
		var numFournisseur = document.getElementById('oma-numFournisseur').value;
		var codeEmplacement = document.getElementById('oma-codeEmplacement').value;
		var composant = document.getElementById('oma-composant').value;

		var qEditionCsv = new QueryHttp("Facturation/Articles/csvFicheArticle.tmpl");
		qEditionCsv.setParam("Reference", reference);
		qEditionCsv.setParam("Ref_Modele", refModele);
		qEditionCsv.setParam("Designation", designation);
		qEditionCsv.setParam("Marque", marque);
		qEditionCsv.setParam("Famille_1", famille1);
		qEditionCsv.setParam("Famille_2", famille2);
		qEditionCsv.setParam("Famille_3", famille3);
		qEditionCsv.setParam("Attribut_1", attribut1);
		qEditionCsv.setParam("Attribut_2", attribut2);
		qEditionCsv.setParam("Attribut_3", attribut3);
		qEditionCsv.setParam("Attribut_4", attribut4);
		qEditionCsv.setParam("Attribut_5", attribut5);
		qEditionCsv.setParam("Attribut_6", attribut6);
		qEditionCsv.setParam("Type_Article", typeArticle);
		qEditionCsv.setParam("Site_Web", siteWeb);
		qEditionCsv.setParam("Actif", actif);
		qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
		qEditionCsv.setParam("Code_Emplacement", codeEmplacement);
		qEditionCsv.setParam("Composant", composant);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Facturation/Articles/getStatsFicheArticle.tmpl");
		qStats.execute(oma_loadChiffresClesFin);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_loadChiffresClesFin(result) {
	try {

		var contenu = result.responseXML.documentElement;

		document.getElementById("oma-nbFATotal").value = contenu.getAttribute("Nb_FA_Total");
		document.getElementById("oma-nbFATotalActif").value = contenu.getAttribute("Nb_FA_Total_Actif");
		document.getElementById("oma-nbFASimple").value = contenu.getAttribute("Nb_FA_Simple");
		document.getElementById("oma-nbFASimpleActif").value = contenu.getAttribute("Nb_FA_Simple_Actif");
		document.getElementById("oma-nbFAForfait").value = contenu.getAttribute("Nb_FA_Forfait");
		document.getElementById("oma-nbFAForfaitActif").value = contenu.getAttribute("Nb_FA_Forfait_Actif");
		document.getElementById("oma-nbFAFabrique").value = contenu.getAttribute("Nb_FA_Fabrique");
		document.getElementById("oma-nbFAFabriqueActif").value = contenu.getAttribute("Nb_FA_Fabrique_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initEtiquette() {
	try {

		document.getElementById('oma-etiquette').value = gConfig.getEtiquetteArticle();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnEtiquettes() {
	try {

		document.getElementById('oma-pdfEtiquettes').setAttribute("src", "");
		document.getElementById('bMenuArticles').collapsed = false;
		document.getElementById("oma-deckMenuArticles").selectedIndex = 1;

		document.getElementById('oma-nombreEtiq').value = "";
		document.getElementById('oma-depotEtiq').collapsed = true;
		document.getElementById('oma-depotEtiq').value = "";

		var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oma-depotEtiq');
		aDepots.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_changeNombreEtiq() {
	try {

		var nombreEtiq = document.getElementById('oma-nombreEtiq').value;

		if (nombreEtiq=="D") {
			document.getElementById('oma-depotEtiq').collapsed = false;
			document.getElementById('oma-depotEtiq').value = "";
		}
		else {
			document.getElementById('oma-depotEtiq').collapsed = true;
			oma_editerEtiquettes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_editerEtiquettes() {
	try {

		document.getElementById('oma-pdfEtiquettes').setAttribute("src", "");

		var etiquette = document.getElementById('oma-etiquette').value;
		var nombreEtiq = document.getElementById('oma-nombreEtiq').value;
		var depotEtiq = document.getElementById('oma-depotEtiq').value;
		var reference = document.getElementById('oma-reference').value;
		var refModele = document.getElementById('oma-refModele').value;
		var designation = document.getElementById('oma-designation').value;
		var marque = document.getElementById('oma-marque').value;
		var famille1 = document.getElementById('oma-famille1').value;
		var famille2 = document.getElementById('oma-famille2').value;
		var famille3 = document.getElementById('oma-famille3').value;
		var attribut1 = document.getElementById('oma-attribut1').value;
		var attribut2 = document.getElementById('oma-attribut2').value;
		var attribut3 = document.getElementById('oma-attribut3').value;
		var attribut4 = document.getElementById('oma-attribut4').value;
		var attribut5 = document.getElementById('oma-attribut5').value;
		var attribut6 = document.getElementById('oma-attribut6').value;
		var typeArticle = document.getElementById('oma-typeArticle').value;
		var siteWeb = document.getElementById('oma-siteWeb').value;
		var actif = document.getElementById('oma-actif').checked;
		var numFournisseur = document.getElementById('oma-numFournisseur').value;
		var codeEmplacement = document.getElementById('oma-codeEmplacement').value;
		var composant = document.getElementById('oma-composant').value;

		if (isEmpty(nombreEtiq)) {
			showWarning("Veuillez choisir un nombre d'\u00E9tiquettes");
		}
		else if (nombreEtiq=="D" && isEmpty(depotEtiq)) {
			showWarning("Veuillez choisir un d\u00E9p\u00F4t de stock");
		}
		else if (isEmpty(etiquette)) {
			showWarning("Veuillez choisir un format d'\u00E9tiquette");
		}
		else {
			var qGenEtiq = new QueryHttp("Facturation/Articles/pdfEtiquettes.tmpl");

			qGenEtiq.setParam("Etiquette_Id", etiquette);
			qGenEtiq.setParam("Nombre_Etiq", nombreEtiq);
			qGenEtiq.setParam("Depot_Etiq", depotEtiq);
			qGenEtiq.setParam("Reference", reference);
			qGenEtiq.setParam("Ref_Modele", refModele);
			qGenEtiq.setParam("Designation", designation);
			qGenEtiq.setParam("Marque", marque);
			qGenEtiq.setParam("Famille_1", famille1);
			qGenEtiq.setParam("Famille_2", famille2);
			qGenEtiq.setParam("Famille_3", famille3);
			qGenEtiq.setParam("Attribut_1", attribut1);
			qGenEtiq.setParam("Attribut_2", attribut2);
			qGenEtiq.setParam("Attribut_3", attribut3);
			qGenEtiq.setParam("Attribut_4", attribut4);
			qGenEtiq.setParam("Attribut_5", attribut5);
			qGenEtiq.setParam("Attribut_6", attribut6);
			qGenEtiq.setParam("Type_Article", typeArticle);
			qGenEtiq.setParam("Site_Web", siteWeb);
			qGenEtiq.setParam("Actif", actif);
			qGenEtiq.setParam("Num_Fournisseur", numFournisseur);
			qGenEtiq.setParam("Code_Emplacement", codeEmplacement);
			qGenEtiq.setParam("Composant", composant);

			var result = qGenEtiq.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else if (result.responseXML.documentElement.getAttribute('Has_Etiquettes')=="true") {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('oma-pdfEtiquettes').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oma_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('oma-numFournisseur').value = numFournisseur;
  	oma_listerArticles();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_rechercherEmplacement() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oma_retourRechercherEmplacement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oma-codeEmplacement').value = codeEmplacement;
  	oma_listerArticles();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_rechercherComposant() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oma_retourRechercherComposant);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_retourRechercherComposant(reference, articleId) {
	try {

  	document.getElementById('oma-composant').value = reference;
  	oma_listerArticles();

	} catch (e) {
		recup_erreur(e);
	}
}
