/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oos_aDepots = new Arbre('Facturation/Articles/list-stockArticle.tmpl', 'oos-depots');
var oos_aEmplacements = new Arbre('Facturation/Articles/list-emplacementArticle.tmpl', 'oos-listeEmplacementArticle');

var oos_curDepot = "";



function oos_initOngletStocks() {
	try {

		document.getElementById('oos-boxMonoEmp').collapsed = gActEmplacements;
		document.getElementById('oos-boxMultiEmp').collapsed = !gActEmplacements;

		oos_initDepotsStock();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_initDepotsStock() {
	try {

		document.getElementById('oos-bEnregistrerStock').collapsed = gReadOnly;
		document.getElementById('oos-bEnregistrerMono').collapsed = gReadOnly;

		if (isEmpty(ofa_articleId)) {
			oos_aDepots.deleteTree();
			oos_initChampsDepotStock();
		}
		else {
			document.getElementById('oos-depots').disabled = true;
			oos_aDepots.setParam("Article_Id", ofa_articleId);
			oos_aDepots.initTree(oos_initChampsDepotStock);
		}

		document.getElementById('oos-reassortCC').collapsed = !ofa_actReassortCC;

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_initChampsDepotStock() {
	try {

		oos_curDepot = "";
		oos_aDepots.clearSelection();
		oos_desactiverChampsDepotStock(true);
		oos_aEmplacements.deleteTree();

		document.getElementById('oos-intitule').value = "";
		document.getElementById('oos-dateInventaire').value = "";
		document.getElementById('oos-qteInventaire').value = "";
		document.getElementById('oos-valoInit').value = "";
		document.getElementById('oos-fraisInit').value = "";
		document.getElementById('oos-stockInitial').value = "";
		document.getElementById('oos-entrees').value = "";
		document.getElementById('oos-sorties').value = "";
		document.getElementById('oos-stockReel').value = "";
		document.getElementById('oos-stockReserve').value = "";
		document.getElementById('oos-stockDispo').value = "";
		document.getElementById('oos-stockAttendu').value = "";
		document.getElementById('oos-stockVirtuel').value = "";
		document.getElementById('oos-stockPreparation').value = "";
		document.getElementById('oos-reassortCC').checked = false;
		document.getElementById('oos-stockSecurite').value = "";
		document.getElementById('oos-stockMinimum').value = "";
		document.getElementById('oos-stockAlerte').value = "";
		document.getElementById('oos-stockMaximum').value = "";
		document.getElementById('oos-codeEmplacementMono').value = "";

		document.getElementById('oos-rowParam1').collapsed = false;
		document.getElementById('oos-rowParam2').collapsed = false;

		document.getElementById('oos-depots').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_desactiverChampsDepotStock(b) {
	try {

		document.getElementById('oos-intitule').disabled = b;
		document.getElementById('oos-dateInventaire').disabled = b;
		document.getElementById('oos-qteInventaire').disabled = b;
		document.getElementById('oos-valoInit').disabled = b;
		document.getElementById('oos-fraisInit').disabled = b;
		document.getElementById('oos-stockInitial').disabled = b;
		document.getElementById('oos-entrees').disabled = b;
		document.getElementById('oos-sorties').disabled = b;
		document.getElementById('oos-stockReel').disabled = b;
		document.getElementById('oos-stockReserve').disabled = b;
		document.getElementById('oos-stockDispo').disabled = b;
		document.getElementById('oos-stockAttendu').disabled = b;
		document.getElementById('oos-stockVirtuel').disabled = b;
		document.getElementById('oos-stockPreparation').disabled = b;
		document.getElementById('oos-reassortCC').disabled = b;
		document.getElementById('oos-stockSecurite').disabled = b;
		document.getElementById('oos-stockMinimum').disabled = b;
		document.getElementById('oos-stockAlerte').disabled = b;
		document.getElementById('oos-stockMaximum').disabled = b;
		document.getElementById('oos-codeEmplacementMono').disabled = b;
		document.getElementById('oos-bEnregistrerStock').disabled = b;
		document.getElementById('oos-rowEmplacementEA').collapsed = b || gReadOnly;
		document.getElementById('oos-boxFleches').collapsed = b || gReadOnly;
		document.getElementById('oos-bEtiquetteEA').collapsed = b;
		document.getElementById('oos-bEtiquetteMono').collapsed = b;
		document.getElementById('oos-bEnregistrerMono').disabled = b;

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_reporterDepot() {
	try {
		if (oos_aDepots.isSelected()) {
			var i = oos_aDepots.getCurrentIndex();

			oos_curDepot = oos_aDepots.getCellText(i, 'oos-colDepotId');

			document.getElementById('oos-intitule').value = oos_aDepots.getCellText(i, 'oos-colIntitule');
			document.getElementById('oos-dateInventaire').value = oos_aDepots.getCellText(i, 'oos-colDateInventaire');
			document.getElementById('oos-qteInventaire').value = oos_aDepots.getCellText(i, 'oos-colQteInventaire');
			document.getElementById('oos-valoInit').value = oos_aDepots.getCellText(i, 'oos-colValoInit');
			document.getElementById('oos-fraisInit').value = oos_aDepots.getCellText(i, 'oos-colFraisInit');
			document.getElementById('oos-stockInitial').value = oos_aDepots.getCellText(i, 'oos-colStockInit');
			document.getElementById('oos-entrees').value = oos_aDepots.getCellText(i, 'oos-colEntrees');
			document.getElementById('oos-sorties').value = oos_aDepots.getCellText(i, 'oos-colSorties');
			document.getElementById('oos-stockReel').value = oos_aDepots.getCellText(i, 'oos-colStockReel');
			document.getElementById('oos-stockReserve').value = oos_aDepots.getCellText(i, 'oos-colStockReserve');
			document.getElementById('oos-stockDispo').value = oos_aDepots.getCellText(i, 'oos-colStockDisponible');
			document.getElementById('oos-stockAttendu').value = oos_aDepots.getCellText(i, 'oos-colStockAttendu');
			document.getElementById('oos-stockVirtuel').value = oos_aDepots.getCellText(i, 'oos-colStockVirtuel');
			document.getElementById('oos-stockPreparation').value = oos_aDepots.getCellText(i, 'oos-colStockPreparation');
			document.getElementById('oos-reassortCC').checked = (oos_aDepots.getCellText(i, 'oos-colReassortCC')=="true");
			document.getElementById('oos-stockSecurite').value = oos_aDepots.getCellText(i, 'oos-colStockSecurite');
			document.getElementById('oos-stockMinimum').value = oos_aDepots.getCellText(i, 'oos-colStockMinimum');
			document.getElementById('oos-stockAlerte').value = oos_aDepots.getCellText(i, 'oos-colStockAlerte');
			document.getElementById('oos-stockMaximum').value = oos_aDepots.getCellText(i, 'oos-colStockMaximum');

			oos_changeReassortCC();

			if (gActEmplacements) {
				oos_aEmplacements.setParam("Article_Id", ofa_articleId);
				oos_aEmplacements.setParam("Depot_Id", oos_curDepot);
				oos_aEmplacements.initTree();

				oos_nouveauEmplacement();
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getCodeEmplacementPrincipal.tmpl");
				qGet.setParam("Depot_Id", oos_curDepot);
				qGet.setParam("Article_Id", ofa_articleId);

				var result = qGet.execute();

				document.getElementById('oos-codeEmplacementMono').value = result.responseXML.documentElement.getAttribute('Code_Emplacement');
			}

			oos_desactiverChampsDepotStock(false);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oos_calcStockAlerte() {
	try {

		var stockMinimum = document.getElementById('oos-stockMinimum').value;
		var stockSecurite = document.getElementById('oos-stockSecurite').value;

		if (isPositiveOrNull(stockMinimum) && isPositiveOrNull(stockSecurite)) {
			document.getElementById('oos-stockAlerte').value = parseFloat(stockMinimum) + parseFloat(stockSecurite);
		}
		else {
			document.getElementById('oos-stockAlerte').value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_enregistrerStock() {
	try {

		var reassortCC = document.getElementById('oos-reassortCC').checked;
		var stockSecurite = document.getElementById('oos-stockSecurite').value;
		var stockMinimum = document.getElementById('oos-stockMinimum').value;
		var stockMaximum = document.getElementById('oos-stockMaximum').value;
		var stockAlerte = document.getElementById('oos-stockAlerte').value;

		if (isEmpty(stockSecurite) || !isPositiveOrNull(stockSecurite) || !checkDecimal(stockSecurite,3)) { showWarning("Le stock de s\u00E9curit\u00E9 est incorrect."); }
		else if (isEmpty(stockMinimum) || !isPositiveOrNull(stockMinimum) || !checkDecimal(stockMinimum,3)) { showWarning("Le stock minimum est incorrect."); }
		else if (isEmpty(stockMaximum) || !isPositiveOrNull(stockMaximum) || !checkDecimal(stockMaximum,3)) { showWarning("Le stock maximum est incorrect."); }
		else if (parseFloat(stockMaximum)<parseFloat(stockAlerte)) { showWarning("Le stock maximum doit \u00EAtre sup\u00E9rieur ou \u00E9gal au stock d'alerte."); }
		else {
			var qEnregistrer = new QueryHttp("Facturation/Stocks/enregistrerStock.tmpl");
			qEnregistrer.setParam("Depot_Id", oos_curDepot);
			qEnregistrer.setParam("Article_Id", ofa_articleId);
			qEnregistrer.setParam("Stock_Securite", stockSecurite);
			qEnregistrer.setParam("Stock_Minimum", stockMinimum);
			qEnregistrer.setParam("Stock_Maximum", stockMaximum);
			qEnregistrer.setParam("Reassort_CC", reassortCC);
			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oos_initDepotsStock();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_changeReassortCC() {
	try {

		var reassortCC = document.getElementById('oos-reassortCC').checked;
		document.getElementById('oos-rowParam1').collapsed = reassortCC;
		document.getElementById('oos-rowParam2').collapsed = reassortCC;

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_nouveauEmplacement() {
	try {

		document.getElementById("oos-codeEmplacementEA").value = "";
		document.getElementById("oos-seuilReassortEA").value = "0";
		document.getElementById("oos-stockMaximumEA").value = "";
		document.getElementById("oos-codeEmplacementEA").disabled = false;
		document.getElementById("oos-bSupprimerEA").disabled = true;
		document.getElementById("oos-bRechercherEmplacementEA").disabled = false;
		document.getElementById("oos-seuilReassortEA").disabled = false;
		document.getElementById('oos-bEtiquetteEA').disabled = true;
		document.getElementById('oos-bFlecheHaut').disabled = true;
		document.getElementById('oos-bFlecheBas').disabled = true;
		oos_aEmplacements.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_enregistrerEmplacement() {
	try {

		var codeEmplacement = document.getElementById("oos-codeEmplacementEA").value;
		var seuilReassort = document.getElementById("oos-seuilReassortEA").value;
		var stockMaximum = document.getElementById("oos-stockMaximumEA").value;

		if (isEmpty(codeEmplacement)) {
			showWarning("Emplacement incorrect");
		}
		else if (isEmpty(seuilReassort) || !isPositiveOrNull(seuilReassort) || !checkDecimal(seuilReassort,3)) {
			showWarning("Seuil de r\u00E9assort incorrect");
		}
		else if (!isEmpty(stockMaximum) && (!isPositive(stockMaximum) || !checkDecimal(seuilReassort,3))) {
			showWarning("Stock maximum incorrect (>0)");
		}
		else {
			if (oos_aEmplacements.isSelected()) {
				var empArtId = oos_aEmplacements.getSelectedCellText("oos-colEmpArtIdEA");

				var qSave = new QueryHttp("Facturation/Articles/updateEmplacementArticle.tmpl");
				qSave.setParam("Emp_Art_Id", empArtId);
				qSave.setParam("Seuil_Reassort", seuilReassort);
				qSave.setParam("Stock_Maximum", stockMaximum);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				oos_aEmplacements.initTree();
				oos_nouveauEmplacement();
			}
			else {
				var emplacementId = oos_getEmplacementId(codeEmplacement);

				if (isEmpty(emplacementId)) {
					if (window.confirm("L'emplacement n'existe pas, voulez-vous le cr\u00E9er ?")) {
						var url = "chrome://opensi/content/facturation/user/emplacements/popup-creationEmplacement.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', oos_affecterEmplacement, oos_curDepot, codeEmplacement);
					}
				}
				else {
					oos_affecterEmplacement(emplacementId);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_affecterEmplacement(emplacementId) {
	try {

		var seuilReassort = document.getElementById("oos-seuilReassortEA").value;
		var stockMaximum = document.getElementById("oos-stockMaximumEA").value;

		var qAssign = new QueryHttp("Facturation/Articles/assignEmplacementArticle.tmpl");
		qAssign.setParam("Article_Id", ofa_articleId);
		qAssign.setParam("Emplacement_Id", emplacementId);
		qAssign.setParam("Seuil_Reassort", seuilReassort);
		qAssign.setParam("Stock_Maximum", stockMaximum);

		var result = qAssign.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var usedBy = result.responseXML.documentElement.getAttribute("Used_By");
			if (!isEmpty(usedBy)) {
				showWarning("Attention cet emplacement est d\u00E9j\u00E0 utilis\u00E9 par un autre article (R\u00E9f: "+ usedBy +")");
			}
		}

		oos_aEmplacements.initTree();
		oos_nouveauEmplacement();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", oos_curDepot);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_supprimerEmplacement() {
	try {

		if (oos_aEmplacements.isSelected()) {
			var empArtId = oos_aEmplacements.getSelectedCellText("oos-colEmpArtIdEA");

			var qDeactivate = new QueryHttp("Facturation/Articles/deactivateEmplacementArticle.tmpl");
			qDeactivate.setParam("Emp_Art_Id", empArtId);
			var result = qDeactivate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oos_aEmplacements.initTree();
			oos_nouveauEmplacement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_pressOnEmplacements() {
	try {

		if (oos_aEmplacements.isSelected()) {
			var idx = oos_aEmplacements.getCurrentIndex();

			document.getElementById("oos-codeEmplacementEA").value = oos_aEmplacements.getCellText(idx, "oos-colCodeEmplacementEA");
			document.getElementById("oos-seuilReassortEA").value = oos_aEmplacements.getCellText(idx, "oos-colSeuilReassortEA");
			document.getElementById("oos-stockMaximumEA").value = oos_aEmplacements.getCellText(idx, "oos-colStockMaximumEA");
			document.getElementById('oos-bEtiquetteEA').disabled = isEmpty(oos_aEmplacements.getCellText(idx, "oos-colCodeEmplacementEA"));
			document.getElementById("oos-bSupprimerEA").disabled = parseFloat(oos_aEmplacements.getCellText(idx, "oos-colStockReelEA"))!=0 || parseFloat(oos_aEmplacements.getCellText(idx, "oos-colStockPreparationEA"))!=0;
			document.getElementById("oos-codeEmplacementEA").disabled = true;
			document.getElementById("oos-bRechercherEmplacementEA").disabled = true;
			document.getElementById("oos-seuilReassortEA").disabled = oos_aEmplacements.getCellText(idx, "oos-colTypeZoneEA")!="P";

			var firstIndex = 0;
			var lastIndex = oos_aEmplacements.nbLignes()-1;

			document.getElementById('oos-bFlecheHaut').disabled = (idx==firstIndex);
			document.getElementById('oos-bFlecheBas').disabled = (idx==lastIndex);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_deplacerEmplacement(gap) {
	try {

		if (oos_aEmplacements.isSelected()) {
			var empArtId = oos_aEmplacements.getSelectedCellText("oos-colEmpArtIdEA");

			var qMove = new QueryHttp("Facturation/Articles/moveEmplacementArticle.tmpl");
			qMove.setParam("Emp_Art_Id", empArtId);
			qMove.setParam("Gap", gap);
			qMove.execute();

			oos_aEmplacements.initTree();
			oos_nouveauEmplacement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_editerEtiquetteEmplacement(emplacementId) {
	try {

		document.getElementById('ofa-pdfEtiquetteEmplacement').setAttribute("src", "");
		document.getElementById("bRetourArticle").collapsed = false;
		document.getElementById("ofa-deckArticle").selectedIndex = 2;

		var qGenEtiq = new QueryHttp("Facturation/Emplacements/pdfEtiquetteEmplacement.tmpl");
		qGenEtiq.setParam("Emplacement_Id", emplacementId);

		var result = qGenEtiq.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('ofa-pdfEtiquetteEmplacement').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_editerEtiquetteEmplacementMulti() {
	try {

		if (oos_aEmplacements.isSelected()) {
			var emplacementId = oos_aEmplacements.getSelectedCellText("oos-colEmplacementIdEA");
			oos_editerEtiquetteEmplacement(emplacementId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_editerEtiquetteEmplacementMono() {
	try {

		var codeEmplacement = document.getElementById("oos-codeEmplacementMono").value;

		var emplacementId = oos_getEmplacementId(codeEmplacement);

		if (!isEmpty(emplacementId)) {
			oos_editerEtiquetteEmplacement(emplacementId);
		}
		else {
			showWarning("L'emplacement n'existe pas. Vous devez d'abord l'enregistrer avant de pouvoir \u00E9diter l'\u00E9tiquette");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_enregistrerEmplacementMono() {
	try {

		var codeEmplacement = document.getElementById("oos-codeEmplacementMono").value;

		var qSave = new QueryHttp("Facturation/Articles/saveMonoEmplacement.tmpl");
		qSave.setParam("Article_Id", ofa_articleId);
		qSave.setParam("Depot_Id", oos_curDepot);
		qSave.setParam("Code_Emplacement", codeEmplacement);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var usedBy = result.responseXML.documentElement.getAttribute("Used_By");
			if (!isEmpty(usedBy)) {
				showWarning("Attention cet emplacement est d\u00E9j\u00E0 utilis\u00E9 par un autre article (R\u00E9f: "+ usedBy +")");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_rechercherEmplacement() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oos_retourRechercherEmplacement, oos_curDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oos-codeEmplacementEA').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}
