/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oot_aPrixClient = new Arbre("Facturation/Articles/list-prixClient.tmpl", "oot-listeTarifs");

var oot_prixId;
var oot_arrondiHT;
var oot_arrondiTTC;



function oot_initOngletTarifsSpecifiques() {
	try {

		document.getElementById('oot-rowTarifSpecifique').collapsed = gReadOnly;
		document.getElementById('oot-boxRAZ').collapsed = gReadOnly;

		oot_nouveauPrixClient();

		oot_aPrixClient.setParam("Article_Id", ofa_articleId);
		oot_aPrixClient.initTree();

		if (!gAccesCoutAchat) {
			document.getElementById('oot-colTauxMarge').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oot-colTauxMarque').setAttribute("ignoreincolumnpicker", true);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oot_nouveauPrixClient() {
	try {

		oot_prixId = "";

		document.getElementById("oot-numClient").value = "";
		document.getElementById("oot-pourcentagePV").value = "";
		document.getElementById("oot-prixHT").value = "";
		document.getElementById("oot-prixTTC").value = "";
		document.getElementById("oot-tauxMarque").value = "";
		document.getElementById("oot-tauxMarge").value = "";
		document.getElementById("oot-dateFin").value = "";
		document.getElementById("oot-bSupprimerPrixClient").disabled = true;
		document.getElementById("oot-bRechercherClient").disabled = false;
		document.getElementById("oot-pourcentagePV").disabled = true;
		document.getElementById("oot-prixHT").disabled = true;
		document.getElementById("oot-prixTTC").disabled = true;
		document.getElementById("oot-tauxMarque").disabled = true;
		document.getElementById("oot-tauxMarge").disabled = true;
		document.getElementById("oot-dateFin").disabled = true;

		document.getElementById('oot-prixRevient').value = "";
		document.getElementById('oot-tauxTVA').value = "";
		document.getElementById('oot-tarifClient').value = "";
		document.getElementById('oot-basePrixHT').value = "";
		document.getElementById('oot-basePrixTTC').value = "";

		oot_aPrixClient.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_enregistrerPrixClient() {
	try {

		var numClient = document.getElementById("oot-numClient").value;
		var pourcentagePV = document.getElementById("oot-pourcentagePV").value;
		var prixHT = document.getElementById("oot-prixHT").value;
		var prixTTC = document.getElementById("oot-prixTTC").value;
		var tauxMarque = document.getElementById("oot-tauxMarque").value;
		var tauxMarge = document.getElementById("oot-tauxMarge").value;
		var dateFin = document.getElementById("oot-dateFin").value;

		if (isEmpty(numClient)) {
			showWarning("Veuillez sp\u00E9cifier un n\u00B0 client");
		}
		else if (isEmpty(prixHT) || !isPositiveOrNull(prixHT) || !checkNumber(prixHT,14,4)) {
			showWarning("Prix de vente HT incorrect");
		}
		else if (isEmpty(prixTTC) || !isPositiveOrNull(prixTTC) || !checkNumber(prixTTC,14,4)) {
			showWarning("Prix de vente TTC incorrect");
		}
		else if (!isEmpty(pourcentagePV) && (parseFloat(pourcentagePV)<-100 || !checkNumber(pourcentagePV,12,4))) {
			showWarning("Pourcentage sur prix de vente incorrect");
		}
		else if (!isEmpty(tauxMarque) && (parseFloat(tauxMarque)>=100 || !checkNumber(tauxMarque,12,6))) {
			showWarning("Taux de marque incorrect");
		}
		else if (!isEmpty(tauxMarge) && !checkNumber(tauxMarge,12,4)) {
			showWarning("Taux de marge incorrect");
		}
		else if (!isEmpty(dateFin) && !isDate(dateFin)) {
			showWarning("Date de fin de validit\u00E9 incorrecte");
		}
		else {
			var qSave;

			if (isEmpty(oot_prixId)) {
				qSave = new QueryHttp("Facturation/Articles/createPrixClient.tmpl");
				qSave.setParam("Article_Id", ofa_articleId);
				qSave.setParam("Num_Client", numClient);
			}
			else {
				qSave = new QueryHttp("Facturation/Articles/updatePrixClient.tmpl");
				qSave.setParam("Prix_Id", oot_prixId);
			}

			qSave.setParam("Pourcentage_PV", pourcentagePV);
			qSave.setParam("Prix_HT", prixHT);
			qSave.setParam("Prix_TTC", prixTTC);
			qSave.setParam("Taux_Marque", tauxMarque);
			qSave.setParam("Taux_Marge", tauxMarge);
			qSave.setParam("Date_Fin", dateFin);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oot_aPrixClient.initTree();
			oot_nouveauPrixClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_supprimerPrixClient() {
	try {

		var qSup = new QueryHttp("Facturation/Articles/deletePrixClient.tmpl");
		qSup.setParam("Prix_Id", oot_prixId);
		qSup.execute();

		oot_aPrixClient.initTree();
		oot_nouveauPrixClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_pressOnListePrixClient() {
	try {

		if (oot_aPrixClient.isSelected()) {
			oot_prixId = oot_aPrixClient.getSelectedCellText("oot-colPrixId");

			document.getElementById("oot-numClient").value = oot_aPrixClient.getSelectedCellText("oot-colNumClient");
			document.getElementById("oot-pourcentagePV").value = oot_aPrixClient.getSelectedCellText("oot-colPourcentagePV");
			document.getElementById("oot-prixHT").value = oot_aPrixClient.getSelectedCellText("oot-colPrixHT");
			document.getElementById("oot-prixTTC").value = oot_aPrixClient.getSelectedCellText("oot-colPrixTTC");
			document.getElementById("oot-tauxMarque").value = oot_aPrixClient.getSelectedCellText("oot-colTauxMarque");
			document.getElementById("oot-tauxMarge").value = oot_aPrixClient.getSelectedCellText("oot-colTauxMarge");
			document.getElementById("oot-dateFin").value = oot_aPrixClient.getSelectedCellText("oot-colDateFin");

			document.getElementById("oot-bSupprimerPrixClient").disabled = false;
			document.getElementById("oot-bRechercherClient").disabled = true;

			var clientId = oot_aPrixClient.getSelectedCellText("oot-colClientId");
			oot_chargerInfosTarifSpecifique(clientId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_razPrixClient() {
	try {

		if (window.confirm("Confirmez-vous la suppression de tous les tarifs sp\u00E9cifiques li\u00E9s \u00E0 cet article ?")) {
			var qSup = new QueryHttp("Facturation/Articles/deletePrixClientByArticleId.tmpl");
			qSup.setParam("Article_Id", ofa_articleId);
			qSup.execute();

			oot_aPrixClient.initTree();
			oot_nouveauPrixClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oot_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_retourRechercherClient(numClient, clientId) {
	try {

  	document.getElementById('oot-numClient').value = numClient;
		oot_chargerInfosTarifSpecifique(clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_chargerInfosTarifSpecifique(clientId) {
	try {

		var qInfos = new QueryHttp("Facturation/Articles/getInfosTarifSpecifique.tmpl");
		qInfos.setParam("Client_Id", clientId);
		qInfos.setParam("Article_Id", ofa_articleId);
		var result = qInfos.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('oot-prixRevient').value = contenu.getAttribute('Prix_Revient');
		document.getElementById('oot-tauxTVA').value = contenu.getAttribute('Taux_TVA');
		document.getElementById('oot-tarifClient').value = contenu.getAttribute('Tarif_Client');
		document.getElementById('oot-basePrixHT').value = contenu.getAttribute('Base_Prix_HT');
		document.getElementById('oot-basePrixTTC').value = contenu.getAttribute('Base_Prix_TTC');

		document.getElementById("oot-pourcentagePV").disabled = false;
		document.getElementById("oot-prixHT").disabled = false;
		document.getElementById("oot-prixTTC").disabled = false;
		document.getElementById("oot-tauxMarque").disabled = false;
		document.getElementById("oot-tauxMarge").disabled = false;
		document.getElementById("oot-dateFin").disabled = false;

		oot_arrondiHT = contenu.getAttribute('Arrondi_HT');
		oot_arrondiTTC = contenu.getAttribute('Arrondi_TTC');

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_calculerTarif(origine) {
  try {

		var nfHT = new Arrondi(oot_arrondiHT);
		var nfTTC = new Arrondi(oot_arrondiTTC);
		var nf6 = new NumberFormat("0.######", false);
		var nf4 = new NumberFormat("0.####", false);

		var pr = parseFloat(document.getElementById('oot-prixRevient').value);
		var tva = parseFloat(document.getElementById('oot-tauxTVA').value)/100 + 1;
		var baseHT = parseFloat(document.getElementById('oot-basePrixHT').value);

		if (origine=="h" && !isEmpty(document.getElementById('oot-prixHT').value)) {
			var pvht = parseFloat(document.getElementById('oot-prixHT').value);
			document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
			document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="c" && !isEmpty(document.getElementById('oot-pourcentagePV').value)) {
			var pourcPV = parseFloat(document.getElementById('oot-pourcentagePV').value);
			var pvht = nfHT.round(baseHT * (1+pourcPV/100));
			document.getElementById('oot-prixHT').value = nfHT.round(pvht);
			document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="t" && !isEmpty(document.getElementById('oot-prixTTC').value)) {
			var pvht = nfHT.round(parseFloat(document.getElementById('oot-prixTTC').value) / tva);
			document.getElementById('oot-prixHT').value = nfHT.round(pvht);
			document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="g" && !isEmpty(document.getElementById('oot-tauxMarge').value)) {
			var pvht = nfHT.round(pr * (1 + parseFloat(document.getElementById('oot-tauxMarge').value)/100));
			document.getElementById('oot-prixHT').value = nfHT.round(pvht);
			document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
			document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
		}
		else if (!isEmpty(document.getElementById('oot-tauxMarque').value)) {
			if (parseFloat(document.getElementById('oot-tauxMarque').value)>=100) {
				showWarning("Le taux de marque doit \u00EAtre inf\u00E9rieur \u00E0 100 % !");
			}
			else {
				var pvht = nfHT.round(pr / (1 - parseFloat(document.getElementById('oot-tauxMarque').value)/100));
				document.getElementById('oot-prixHT').value = nfHT.round(pvht);
				document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
				document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
				document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}
		else {
			document.getElementById('oot-tauxMarge').value = "";
			document.getElementById('oot-prixHT').value = "";
			document.getElementById('oot-pourcentagePV').value = "";
			document.getElementById('oot-prixTTC').value = "";
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

