/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Vente ou Achat
		- 2 : Rfrence de recherche
		- 3 : Tarif_Id pour tarif affich en rsultat
		- 4 : Si true -> pas d'articles de type forfait
		- 5 : Fournisseur_Id
		- 6 : Si true -> seulement les articles fabriqus
		- 7 : Client_Id
		- 8 : Si true -> Slection multiple
		- 9 : Si true -> autoriser recherche intgrale
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aSites = new Arbre('ComboListe/combo-sitesWeb.tmpl','siteWeb');
var aFamilles1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille1');
var aFamilles2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille2');
var aFamilles3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille3');
var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'marque');
var aAttributs1 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut1');
var aAttributs2 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut2');
var aAttributs3 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut3');
var aAttributs4 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut4');
var aAttributs5 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut5');
var aAttributs6 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut6');

var aDispoFourn = new Arbre('Facturation/Articles/list-dispoFournisseur.tmpl', 'listeDispoFournisseur');
var aDispoStock = new Arbre('Facturation/Articles/list-dispoStock.tmpl', 'listeDispoStock');
var aPotentiels = new Arbre('Facturation/Articles/list-potentielForfait.tmpl', 'listePotentiels');
var aComposants = new Arbre('Facturation/Articles/list-composantArticle.tmpl', 'listeComposants');
var aArticles = new Arbre("Facturation/Articles/list-ficheArticle.tmpl", "listeArticles");
var qListFA = new QueryHttp("Facturation/Articles/getDataListFA.tmpl");

var pageCourante;
var nbPages;

var circonstAttr1 = false;
var circonstAttr2 = false;
var circonstAttr3 = false;
var circonstAttr4 = false;
var circonstAttr5 = false;
var circonstAttr6 = false;

var groupeAttr1;
var groupeAttr2;
var groupeAttr3;
var groupeAttr4;
var groupeAttr5;
var groupeAttr6;

var argTarifId;
var argNoForfait;
var argFournisseurId;
var argNomenclature;
var argVenteAchat;



function init() {
  try {

		argVenteAchat = window.arguments[1];
		var argReference = window.arguments[2];
		argTarifId = window.arguments[3];
		argNoForfait = window.arguments[4];
		argFournisseurId = window.arguments[5];
		argNomenclature = window.arguments[6];
		var argClientId = window.arguments[7];
		var argMultiSel = window.arguments[8];
		var argRechIntegrale = window.arguments[9];

		if (argMultiSel!=null && argMultiSel) {
			document.getElementById('listeArticles').setAttribute("seltype", "multiple");
		}

		if (argRechIntegrale!=null && argRechIntegrale) {
			document.getElementById('rowRechIntegrale').collapsed = false;
		}

		var config = getConfig();

    if (argTarifId!=null || config.isSpecTKVS()) {
    	document.getElementById('colTarifHT').collapsed = false;
    	document.getElementById('colTarifHT').removeAttribute("ignoreincolumnpicker");
			document.getElementById('colTarifTTC').collapsed = false;
    	document.getElementById('colTarifTTC').removeAttribute("ignoreincolumnpicker");
			document.getElementById('colTauxMarque').collapsed = false;
    	document.getElementById('colTauxMarque').removeAttribute("ignoreincolumnpicker");
			document.getElementById('colTauxMarge').collapsed = false;
    	document.getElementById('colTauxMarge').removeAttribute("ignoreincolumnpicker");
    }

		if (argClientId!=null && !isEmpty(argClientId)) {
			document.getElementById('colRefClient').collapsed = false;
    	document.getElementById('colRefClient').removeAttribute("ignoreincolumnpicker");
			aArticles.setParam('Client_Id', argClientId);
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		groupeAttr1 = contenu.getAttribute("Groupe_Id_1");
		groupeAttr2 = contenu.getAttribute("Groupe_Id_2");
		groupeAttr3 = contenu.getAttribute("Groupe_Id_3");
		groupeAttr4 = contenu.getAttribute("Groupe_Id_4");
		groupeAttr5 = contenu.getAttribute("Groupe_Id_5");
		groupeAttr6 = contenu.getAttribute("Groupe_Id_6");

		if (!isEmpty(groupeAttr1)) {
			document.getElementById('lblAttribut1').value = contenu.getAttribute('Intitule_1') +" :";
			document.getElementById('colAttribut1').setAttribute("label", contenu.getAttribute('Intitule_1'));
			circonstAttr1 = (contenu.getAttribute('Circonst_1')=="true");
			aAttributs1.setParam("Groupe_Id", groupeAttr1);
			aAttributs1.setParam("Search_Mode", true);
			aAttributs1.initTree();
		}
		else {
			document.getElementById('lblAttribut1').value = "Att. Princ. 1 :";
			document.getElementById('lblAttribut1').disabled = true;
			document.getElementById('attribut1').disabled = true;
			document.getElementById("colAttribut1").collapsed = true;
			document.getElementById("colAttribut1").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr2)) {
			document.getElementById('lblAttribut2').value = contenu.getAttribute('Intitule_2') +" :";
			document.getElementById('colAttribut2').setAttribute("label", contenu.getAttribute('Intitule_2'));
			circonstAttr2 = (contenu.getAttribute('Circonst_2')=="true");
			aAttributs2.setParam("Groupe_Id", groupeAttr2);
			aAttributs2.setParam("Search_Mode", true);
			aAttributs2.initTree();
		}
		else {
			document.getElementById('lblAttribut2').value = "Att. Princ. 2 :";
			document.getElementById('lblAttribut2').disabled = true;
			document.getElementById('attribut2').disabled = true;
			document.getElementById("colAttribut2").collapsed = true;
			document.getElementById("colAttribut2").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr3)) {
			document.getElementById('lblAttribut3').value = contenu.getAttribute('Intitule_3') +" :";
			document.getElementById('colAttribut3').setAttribute("label", contenu.getAttribute('Intitule_3'));
			circonstAttr3 = (contenu.getAttribute('Circonst_3')=="true");
			aAttributs3.setParam("Groupe_Id", groupeAttr3);
			aAttributs3.setParam("Search_Mode", true);
			aAttributs3.initTree();
		}
		else {
			document.getElementById('lblAttribut3').value = "Att. Princ. 3 :";
			document.getElementById('lblAttribut3').disabled = true;
			document.getElementById('attribut3').disabled = true;
			document.getElementById("colAttribut3").collapsed = true;
			document.getElementById("colAttribut3").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr4)) {
			document.getElementById('lblAttribut4').value = contenu.getAttribute('Intitule_4') +" :";
			document.getElementById('colAttribut4').setAttribute("label", contenu.getAttribute('Intitule_4'));
			circonstAttr4 = (contenu.getAttribute('Circonst_4')=="true");
			aAttributs4.setParam("Groupe_Id", groupeAttr4);
			aAttributs4.setParam("Search_Mode", true);
			aAttributs4.initTree();
		}
		else {
			document.getElementById('lblAttribut4').value = "Att. Princ. 4 :";
			document.getElementById('lblAttribut4').disabled = true;
			document.getElementById('attribut4').disabled = true;
			document.getElementById("colAttribut4").collapsed = true;
			document.getElementById("colAttribut4").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr5)) {
			document.getElementById('lblAttribut5').value = contenu.getAttribute('Intitule_5') +" :";
			document.getElementById('colAttribut5').setAttribute("label", contenu.getAttribute('Intitule_5'));
			circonstAttr5 = (contenu.getAttribute('Circonst_5')=="true");
			aAttributs5.setParam("Groupe_Id", groupeAttr5);
			aAttributs5.setParam("Search_Mode", true);
			aAttributs5.initTree();
		}
		else {
			document.getElementById('lblAttribut5').value = "Att. Princ. 5 :";
			document.getElementById('lblAttribut5').disabled = true;
			document.getElementById('attribut5').disabled = true;
			document.getElementById("colAttribut5").collapsed = true;
			document.getElementById("colAttribut5").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr6)) {
			document.getElementById('lblAttribut6').value = contenu.getAttribute('Intitule_6') +" :";
			document.getElementById('colAttribut6').setAttribute("label", contenu.getAttribute('Intitule_6'));
			circonstAttr6 = (contenu.getAttribute('Circonst_6')=="true");
			aAttributs6.setParam("Groupe_Id", groupeAttr6);
			aAttributs6.setParam("Search_Mode", true);
			aAttributs6.initTree();
		}
		else {
			document.getElementById('lblAttribut6').value = "Att. Princ. 6 :";
			document.getElementById('lblAttribut6').disabled = true;
			document.getElementById('attribut6').disabled = true;
			document.getElementById("colAttribut6").collapsed = true;
			document.getElementById("colAttribut6").setAttribute("ignoreincolumnpicker", true);
		}

		aMarques.setParam("Search_Mode", true);
		aMarques.initTree();

		aFamilles1.setParam("Search_Mode", true);
		aFamilles2.setParam("Search_Mode", true);
		aFamilles3.setParam("Search_Mode", true);

		document.getElementById('famille2').disabled = true;
		document.getElementById('famille3').disabled = true;
		aFamilles1.initTree();

		if (config.isECommerce()) {
	  	aSites.initTree();
			document.getElementById("row-siteWeb").collapsed = false;
		}

		if (argFournisseurId!=null && !isEmpty(argFournisseurId)) {
			qListFA.setParam('Fournisseur_Id', argFournisseurId);
		}

		if (argClientId!=null && !isEmpty(argClientId)) {
			qListFA.setParam('Client_Id', argClientId);
		}

		if (argNoForfait!=null) {
			qListFA.setParam('No_Forfait', true);
		}

		if (argVenteAchat!=null) {
			qListFA.setParam('Vente_Achat', argVenteAchat);
		}

    document.getElementById('reference').focus();

    if (argReference!=null && !isEmpty(argReference)) {
    	document.getElementById('reference').value = argReference;
    	listerArticles();
    }

		var profil = getProfil();

		if (!profil.isAccesCoutAchat()) {
			document.getElementById('colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colTauxMarque').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colTauxMarge').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colPrixAchat').collapsed = true;
			document.getElementById('colTauxMarque').collapsed = true;
			document.getElementById('colTauxMarge').collapsed = true;
		}

		if (!profil.isShowElemFour()) {
			document.getElementById('boxDispoFournisseur').collapsed = true;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerFamilles2() {
	try {

		var famille1 = document.getElementById('famille1').value;

		document.getElementById('famille2').value = "";
		document.getElementById('famille2').disabled = isEmpty(famille1);

		aFamilles3.deleteTree();
		document.getElementById('famille3').value = "";
		document.getElementById('famille3').disabled = true;

		aFamilles2.setParam('Parent_Id', famille1);
		aFamilles2.initTree(manageCirconstAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles3() {
	try {

		var famille2 = document.getElementById('famille2').value;

		document.getElementById('famille3').value = "";
		document.getElementById('famille3').disabled = isEmpty(famille2);

		aFamilles3.setParam('Parent_Id', famille2);
		aFamilles3.initTree(manageCirconstAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnReference(ev) {
  try {

    if (ev.keyCode==13) {
			checkArticle(document.getElementById('reference').value);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerArticles();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function checkArticle(reference) {
  try {

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam('Reference', reference);

    if (argFournisseurId!=null && !isEmpty(argFournisseurId)) {
      qSearch.setParam('Fournisseur_Id', argFournisseurId);
    }
		if (argNomenclature!=null) {
  		qSearch.setParam('Nomenclature', true);
  	}
		if (argNoForfait!=null) {
			qSearch.setParam('No_Forfait', true);
		}
		if (argVenteAchat!=null) {
			qSearch.setParam('Vente_Achat', argVenteAchat);
		}

		var result = qSearch.execute();
		var contenu = result.responseXML.documentElement;

		var articleId = contenu.getAttribute('Article_Id');

		if (!isEmpty(articleId)) {
			ouvrirArticle(contenu.getAttribute('Reference'), articleId, null);
		}
		else {
			listerArticles();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function manageCirconstAttributs() {
	try {

		var famille1 = document.getElementById('famille1').value;
		var famille2 = document.getElementById('famille2').value;
		var famille3 = document.getElementById('famille3').value;

		var familleId = !isEmpty(famille3)?famille3:!isEmpty(famille2)?famille2:famille1;

		if (!isEmpty(familleId)) {
			var qCirc = new QueryHttp("Facturation/Commun/existGroupeAttributFamilleArticle.tmpl");
			qCirc.setParam("Famille_Id", familleId);

			if (circonstAttr1 && !isEmpty(groupeAttr1)) {
				qCirc.setParam("Groupe_Id", groupeAttr1);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut1').disabled = true;
					document.getElementById('attribut1').value = "";
				}
				else {
					document.getElementById('attribut1').disabled = false;
				}
			}

			if (circonstAttr2 && !isEmpty(groupeAttr2)) {
				qCirc.setParam("Groupe_Id", groupeAttr2);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut2').disabled = true;
					document.getElementById('attribut2').value = "";
				}
				else {
					document.getElementById('attribut2').disabled = false;
				}
			}

			if (circonstAttr3 && !isEmpty(groupeAttr3)) {
				qCirc.setParam("Groupe_Id", groupeAttr3);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut3').disabled = true;
					document.getElementById('attribut3').value = "";
				}
				else {
					document.getElementById('attribut3').disabled = false;
				}
			}

			if (circonstAttr4 && !isEmpty(groupeAttr4)) {
				qCirc.setParam("Groupe_Id", groupeAttr4);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut4').disabled = true;
					document.getElementById('attribut4').value = "";
				}
				else {
					document.getElementById('attribut4').disabled = false;
				}
			}

			if (circonstAttr5 && !isEmpty(groupeAttr5)) {
				qCirc.setParam("Groupe_Id", groupeAttr5);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut5').disabled = true;
					document.getElementById('attribut5').value = "";
				}
				else {
					document.getElementById('attribut5').disabled = false;
				}
			}

			if (circonstAttr6 && !isEmpty(groupeAttr6)) {
				qCirc.setParam("Groupe_Id", groupeAttr6);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut6').disabled = true;
					document.getElementById('attribut6').value = "";
				}
				else {
					document.getElementById('attribut6').disabled = false;
				}
			}
		}
		else {
			document.getElementById('attribut1').disabled = isEmpty(groupeAttr1);
			document.getElementById('attribut2').disabled = isEmpty(groupeAttr2);
			document.getElementById('attribut3').disabled = isEmpty(groupeAttr3);
			document.getElementById('attribut4').disabled = isEmpty(groupeAttr4);
			document.getElementById('attribut5').disabled = isEmpty(groupeAttr5);
			document.getElementById('attribut6').disabled = isEmpty(groupeAttr6);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixArticle();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirArticle(reference, articleId, listArticleId) {
  try {

		window.arguments[0](reference, articleId, listArticleId);
    setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup

  } catch (e) {
    recup_erreur(e);
  }
}


function choixArticle() {
	try {

		if (aArticles.isSelected()) {
			if (aArticles.nbSelection()==1) {
				var reference = aArticles.getSelectedCellText('colReference');
				var articleId = aArticles.getSelectedCellText('colArticleId');
				ouvrirArticle(reference, articleId, null);
			}
			else {
				var listArticleId = "";

				var start = new Object();
				var end = new Object();
				var numRanges = aArticles.getRangeCount();

				for (var t=0; t<numRanges; t++){
					aArticles.getRangeAt(t,start,end);
			  	for (var v=start.value; v<=end.value; v++){
		  			listArticleId += aArticles.getCellText(v,'colArticleId') +",";
			  	}
				}
				ouvrirArticle(null, null, listArticleId);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnListeArticles() {
	try {

		if (aArticles.isSelected()) {
			if (aArticles.nbSelection()==1) {
				var articleId = aArticles.getSelectedCellText('colArticleId');

				if (aArticles.getSelectedCellValue("colTypeArticle")=="F") {
					document.getElementById('apercuSimple').collapsed = true;
					document.getElementById('apercuForfait').collapsed = false;
					aPotentiels.setParam("Article_Id", articleId);
					aPotentiels.initTree();
					aComposants.setParam("Article_Id", articleId);
					aComposants.initTree();
				}
				else {
					document.getElementById('apercuSimple').collapsed = false;
					document.getElementById('apercuForfait').collapsed = true;
					aDispoFourn.setParam("Article_Id", articleId);
					aDispoFourn.initTree();
					aDispoStock.setParam("Article_Id", articleId);
					aDispoStock.initTree();
				}
			}
			else {
				document.getElementById('apercuSimple').collapsed = false;
				document.getElementById('apercuForfait').collapsed = true;
				aDispoFourn.deleteTree();
				aDispoStock.deleteTree();
				aPotentiels.deleteTree();
				aComposants.deleteTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById('famille2').disabled = true;
		document.getElementById('famille3').disabled = true;
		aFamilles2.deleteTree();
		aFamilles3.deleteTree();

		document.getElementById('reference').value = "";
		document.getElementById('refModele').value = "";
		document.getElementById('designation').value = "";
		document.getElementById('marque').value = "";
		document.getElementById('famille1').value = "";
		document.getElementById('famille2').value = "";
		document.getElementById('famille3').value = "";
		document.getElementById('attribut1').value = "";
		document.getElementById('attribut2').value = "";
		document.getElementById('attribut3').value = "";
		document.getElementById('attribut4').value = "";
		document.getElementById('attribut5').value = "";
		document.getElementById('attribut6').value = "";
		document.getElementById('siteWeb').value = "";
		document.getElementById('actif').checked = true;
		document.getElementById('rechIntegrale').checked = false;

		manageCirconstAttributs();

		listerArticles();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerArticles() {
	try {

		var reference = document.getElementById('reference').value;
		var refModele = document.getElementById('refModele').value;
		var designation = document.getElementById('designation').value;
		var marque = document.getElementById('marque').value;
		var famille1 = document.getElementById('famille1').value;
		var famille2 = document.getElementById('famille2').value;
		var famille3 = document.getElementById('famille3').value;
		var attribut1 = document.getElementById('attribut1').value;
		var attribut2 = document.getElementById('attribut2').value;
		var attribut3 = document.getElementById('attribut3').value;
		var attribut4 = document.getElementById('attribut4').value;
		var attribut5 = document.getElementById('attribut5').value;
		var attribut6 = document.getElementById('attribut6').value;
		var typeArticle = (argNomenclature!=null?"N":"");
		var siteWeb = document.getElementById('siteWeb').value;
		var actif = document.getElementById('actif').checked;
		var rechIntegrale = document.getElementById('rechIntegrale').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeArticles').disabled = true;
		aDispoFourn.deleteTree();
		aDispoStock.deleteTree();
		aPotentiels.deleteTree();
		aComposants.deleteTree();
		aArticles.deleteTree();

		qListFA.setParam("Reference", reference);
		qListFA.setParam("Ref_Modele", refModele);
		qListFA.setParam("Designation", designation);
		qListFA.setParam("Marque", marque);
		qListFA.setParam("Famille_1", famille1);
		qListFA.setParam("Famille_2", famille2);
		qListFA.setParam("Famille_3", famille3);
		qListFA.setParam("Attribut_1", attribut1);
		qListFA.setParam("Attribut_2", attribut2);
		qListFA.setParam("Attribut_3", attribut3);
		qListFA.setParam("Attribut_4", attribut4);
		qListFA.setParam("Attribut_5", attribut5);
		qListFA.setParam("Attribut_6", attribut6);
		qListFA.setParam("Type_Article", typeArticle);
		qListFA.setParam("Site_Web", siteWeb);
		qListFA.setParam("Actif", actif);
		qListFA.setParam("Rech_Integrale", rechIntegrale);
		qListFA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListFA.setParam("Current_Page", pageCourante);

		if (argTarifId!=null) {
    	aArticles.setParam('Tarif_Id', argTarifId);
    }

		var result = qListFA.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listArticleId = contenu.getAttribute("List_Article_Id");

		aArticles.setParam("List_Article_Id", listArticleId);
		aArticles.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeArticles').disabled = true;
		aDispoFourn.deleteTree();
		aDispoStock.deleteTree();
		aPotentiels.deleteTree();
		aComposants.deleteTree();

		qListFA.setParam("Current_Page", pageCourante);
		var result = qListFA.execute();
		var listArticleId = result.responseXML.documentElement.getAttribute("List_Article_Id");

		aArticles.setParam("List_Article_Id", listArticleId);
		aArticles.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeArticles').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirAttendusFournisseur() {
	try {

		if (aDispoStock.isSelected()) {
			var articleId = aArticles.getSelectedCellText('colArticleId');
			var depotId = aDispoStock.getSelectedCellText('colDepotIdDS');
			var reference = aArticles.getSelectedCellText('colReference');
			var depot = aDispoStock.getSelectedCellText('colDepotStockDS');
			var url = "chrome://opensi/content/facturation/user/articles/popup-attenduFournisseur.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', articleId, depotId, reference, depot);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
