/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oon_alisteArticles = new Arbre("Facturation/Clients/list-articleSerieClient.tmpl", "oon-listeArticles");
var oon_alisteSerieArticle = new Arbre("Facturation/Clients/list-numSerieClient.tmpl", "oon-listeSerieArticle");



function oon_initOngletNumSerie() {
	try {

		if (!gConfig.isActSerieDLC()) {
			document.getElementById("oon-colDatePeremptionNS").collapsed = true;
			document.getElementById("oon-colDatePeremptionNS").setAttribute("ignoreincolumnpicker", true);
		}

		if (!gConfig.isActSuiviLot()) {
			document.getElementById("oon-colNumLot").collapsed = true;
			document.getElementById("oon-colNumLot").setAttribute("ignoreincolumnpicker", true);
			document.getElementById("oon-colDatePeremptionNL").collapsed = true;
			document.getElementById("oon-colDatePeremptionNL").setAttribute("ignoreincolumnpicker", true);
		}

		oon_alisteSerieArticle.deleteTree();
		document.getElementById("oon-lblRef").value = "";
		document.getElementById("oon-lblDesignation").value = "";

		oon_alisteArticles.setParam("Client_Id", ofc_clientId);
		oon_alisteArticles.initTree(oon_calculerTotal);

	} catch (e) {
		recup_erreur(e);
  }
}


function oon_selectionArticle() {
	try {

		if (oon_alisteArticles.isSelected()) {
			document.getElementById("oon-lblRef").value = oon_alisteArticles.getSelectedCellText('oon-colReference');
			document.getElementById("oon-lblDesignation").value = oon_alisteArticles.getSelectedCellText('oon-colDesignation');

			var articleId = oon_alisteArticles.getSelectedCellText('oon-colArticleId');

			oon_alisteSerieArticle.setParam("Article_Id", articleId);
			oon_alisteSerieArticle.setParam("Client_Id", ofc_clientId);
			oon_alisteSerieArticle.initTree();
		}

	}	catch (e) {
		recup_erreur(e);
  }
}


function oon_calculerTotal() {
	try {

		var nbLignes = oon_alisteArticles.nbLignes();
		var total = 0;

		for (var i=0; i<nbLignes; i++){
			total += parseIntBis(oon_alisteArticles.getCellText(i, "oon-colQuantite"));
		}
		var nf = new NumberFormat("0", false);
		document.getElementById("oon-Total_Quantite").value = nf.format(total);

	}	catch (e) {
		recup_erreur(e);
  }
}
