/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oow_aClientsWeb = new Arbre("Facturation/Clients/list-clientWeb.tmpl", "oow-tree-web");
var oow_aSitesWeb = new Arbre("ComboListe/combo-sitesWeb.tmpl","oow-Site_Id");

var oow_currentClientWeb = "";
var oow_currentSiteId = "";



function oow_initOngletWeb() {
	try {

		document.getElementById('oow-rowClientWeb').collapsed = gReadOnly;

    oow_aClientsWeb.setParam("Client_Id", ofc_clientId);
    oow_aClientsWeb.initTree();

    oow_nouveauClientWeb();

	} catch (e) {
		recup_erreur(e);
  }
}


function oow_chargerSiteWeb(selection) {
	try {

		oow_currentSiteId = selection;
		oow_aSitesWeb.setParam("Selection", selection);
		oow_aSitesWeb.initTree(oow_initSiteWeb);

	} catch (e) {
		recup_erreur(e);
  }
}


function oow_initSiteWeb() {
  try {

		document.getElementById('oow-Site_Id').value = oow_currentSiteId;

	} catch (e) {
    recup_erreur(e);
  }
}


function oow_nouveauClientWeb() {
  try {

		oow_aClientsWeb.clearSelection();
		oow_currentClientWeb = "";

		oow_chargerSiteWeb("");

    document.getElementById('oow-Login').value = "";
    document.getElementById('oow-Password').value = "";
		document.getElementById('oow-Actif').checked = true;
    document.getElementById('oow-bNouveauClientWeb').collapsed = true;
    document.getElementById('oow-Site_Id').disabled = false;
    document.getElementById('oow-Login').disabled = false;
		document.getElementById('oow-rowPassword').collapsed = false;

  } catch (e) {
    recup_erreur(e);
  }
}


function oow_enregistrerClientWeb() {
  try {

    var siteId = document.getElementById('oow-Site_Id').value;
    var login = document.getElementById('oow-Login').value;
    var password = document.getElementById('oow-Password').value;
    var actif = document.getElementById('oow-Actif').checked;
		var mode = isEmpty(oow_currentClientWeb)?"C":"M";

		if (isEmpty(siteId)) { showWarning("Veuillez sp\u00E9cifier le site !"); }
    else if (isEmpty(login)) { showWarning("Veuillez sp\u00E9cifier le login"); }
    else if (mode=="C" && isEmpty(password)) { showWarning("Veuillez sp\u00E9cifier le mot de passe !"); }
		else if (mode=="C" && password.length<8) { showWarning("Le mot de passe doit contenir au minimum 8 caract\u00E8res"); }
		else if (mode=="C" && !isValidPassword(password)) { showWarning("Le mot de passe doit contenir au moins 3 des 4 types de caract\u00E8res (minuscule, majuscule, chiffre, car. sp\u00E9cial)"); }
    else {
			var qSave;

    	if (mode=="C") {
    	  qSave = new QueryHttp("Facturation/Clients/createClientWeb.tmpl");
    	}
    	else {
    	  qSave = new QueryHttp("Facturation/Clients/updateClientWeb.tmpl");
				qSave.setParam("Client_Web_Id", oow_currentClientWeb);
    	}

			qSave.setParam("Client_Id", ofc_clientId);
			qSave.setParam("Site_Id", siteId);
			qSave.setParam("Login", login);
			qSave.setParam("Password", password);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
	      oow_aClientsWeb.initTree();
        oow_nouveauClientWeb();
			}
	  }

  } catch (e) {
    recup_erreur(e);
  }
}


function oow_chargerClientWeb() {
  try {

    if (oow_aClientsWeb.isSelected()) {

      oow_currentClientWeb = oow_aClientsWeb.getSelectedCellText("oow-ColClient_Web_Id");
			oow_chargerSiteWeb(oow_aClientsWeb.getSelectedCellText("oow-ColSite_Id"));
      document.getElementById('oow-Login').value = oow_aClientsWeb.getSelectedCellText("oow-ColLogin");
      document.getElementById('oow-Actif').checked = oow_aClientsWeb.getSelectedCellText("oow-ColValActif")=="true";

      document.getElementById('oow-bNouveauClientWeb').collapsed = false;
      document.getElementById('oow-Site_Id').disabled = true;
      document.getElementById('oow-Login').disabled = true;
			document.getElementById('oow-rowPassword').collapsed = true;
    }

  } catch (e) {
    recup_erreur(e);
  }
}
