/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var orcf_aReceptions = new Arbre("Facturation/Commandes/list-bonReception.tmpl", "orcf-tReceptions");
var orcf_aArticlesBR = new Arbre("Facturation/Commandes/list-ligneBonReception.tmpl", "orcf-tArticlesBR");
var orcf_aArticlesCF = new Arbre("Facturation/Commandes/list-articlesNonReceptionnesCF.tmpl", "orcf-tArticlesCF");
var orcf_aVersions = new Arbre("Facturation/Commandes/list-versionBonReception.tmpl", "orcf-tVersions");
var orcf_aRangement = new Arbre("Facturation/Commandes/list-storeLigneBR.tmpl", "orcf-tRangement");

var orcf_commandeId;
var orcf_bonRecId;
var orcf_mode;
var orcf_etatBon;
var orcf_etatCF;
var orcf_soldee;
var orcf_etapeRangement;
var orcf_currentDepotId;
var orcf_statutReception;
var orcf_modified = false;
var orcf_facturable = false;
var orcf_existeFacture = false;
var orcf_actSuiviLot;
var orcf_actSuiviSerie;
var orcf_chiffreDefaut;
var orcf_ordreTriDefaut;
var orcf_dropshipping = false;
var orcf_gcfEtiqArticle;
var orcf_actReassortCC = false;
var orcf_rcfNumBLOblig;
var orcf_scrollLigneBR = "";
var orcf_actEmplacements;



function orcf_init() {
  try {

		orcf_actEmplacements = gConfig.isActEmplacements();
		orcf_actSuiviLot = gConfig.isActSuiviLot();
		var actNbPieces = gConfig.isActNbPieces();
		orcf_actSuiviSerie = gConfig.isActSuiviSerie();
		orcf_chiffreDefaut = gConfig.isBRChiffre();
		orcf_ordreTriDefaut = gConfig.getOrdreTriBR();
		orcf_actReassortCC = gConfig.isActReassortCC();
		orcf_gcfEtiqArticle = gConfig.isGCFEtiqArticle();
		orcf_rcfNumBLOblig = gConfig.isRCFNumBLOblig();
		var specRMLAR = gConfig.isSpecRMLAR();

		document.getElementById('orcf-bConsultSerieLigne').collapsed = !orcf_actSuiviSerie;
		document.getElementById('orcf-boxSaisieCodeBarre').collapsed = orcf_actSuiviSerie;

		document.getElementById('orcf-boxEtiqLot').collapsed = !orcf_actSuiviLot || isEmpty(gConfig.getEtiquetteLot());

		if (!orcf_actSuiviLot || isEmpty(gConfig.getEtiquetteLot())) {
			document.getElementById('orcf-colNbEtiqLotBR').collapsed = true;
			document.getElementById('orcf-colNbEtiqLotBR').setAttribute('ignoreincolumnpicker', true);
		}

		if (!orcf_actSuiviLot) {
			document.getElementById('orcf-colNumLotBR').collapsed = true;
			document.getElementById('orcf-colNumLotBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orcf-colDatePeremptionBR').collapsed = true;
			document.getElementById('orcf-colDatePeremptionBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orcf-rowNumLot').collapsed = true;
			document.getElementById('orcf-rowDLC').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('orcf-colNbPiecesCF').collapsed = true;
			document.getElementById('orcf-colNbPiecesCF').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orcf-colNbPiecesBR').collapsed = true;
			document.getElementById('orcf-colNbPiecesBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orcf-rowNbPieces').collapsed = true;
		}

		if (!specRMLAR) {
			document.getElementById('orcf-colStockReserveBR').collapsed = true;
			document.getElementById('orcf-colStockReserveBR').setAttribute('ignoreincolumnpicker', true);
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("orcf-colAttribut"+ i +"CF").setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("orcf-colAttribut"+ i +"CF").collapsed = true;
				document.getElementById("orcf-colAttribut"+ i +"CF").setAttribute("ignoreincolumnpicker", true);
			}
		}

		if (orcf_actReassortCC) {
			document.getElementById('orcf-bConsulterCommandesClients').collapsed= false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_start() {
	try {

		var qGet = new QueryHttp('Facturation/Commandes/getFirstBRNonValide.tmpl');
		qGet.setParam("Commande_Id", orcf_commandeId);
		var result = qGet.execute();

		if (result.responseXML.documentElement.getAttribute("HasBRNonValide")=="true") {
			orcf_bonRecId = result.responseXML.documentElement.getAttribute("Bon_Id");
			orcf_chargerBon();
		}
		else {
			orcf_nouveauBon();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_reinitialiser() {
	try {

		orcf_mode = "C";
		orcf_etatBon = "N";
		orcf_modified = false;
		orcf_dropshipping = false;
		orcf_etapeRangement = false;
		orcf_currentDepotId = "";

		document.getElementById('orcf-deckBonReception').selectedIndex = 0;
		document.getElementById('orcf-tbBonReception').selectedIndex = 0;
		document.getElementById('orcf-tabBon').setAttribute('image', null);
		document.getElementById('orcf-numeroBR').value = "";
		document.getElementById('orcf-numeroRG').value = "";
		document.getElementById('orcf-tabVersions').collapsed = true;
		document.getElementById('orcf-boxRangement').collapsed = true;

		orcf_aVersions.deleteTree();
		orcf_aReceptions.setParam("Commande_Id", orcf_commandeId);
		orcf_aReceptions.initTree();

		document.getElementById('orcf-rowDateRG').collapsed = false;
		document.getElementById('orcf-rowNumeroRG').collapsed = false;

		document.getElementById('orcf-codeBarre').value = "";
		document.getElementById('orcf-dateBR').value = "";
		document.getElementById('orcf-dateRG').value = "";
		document.getElementById('orcf-etat').value = "";
		document.getElementById('orcf-commentairesFin').value = "";
		document.getElementById('orcf-commentairesInt').value = "";
		document.getElementById('orcf-numBL').value = "";
		document.getElementById('orcf-numLot').value = "";
		document.getElementById('orcf-datePeremption').value = "";
		document.getElementById('orcf-nbPieces').value = "";
		document.getElementById('orcf-quantite').value = "";
		document.getElementById('orcf-creation').value = "";
		document.getElementById('orcf-modification').value = "";
		document.getElementById('orcf-document').value = "";
		document.getElementById('orcf-solder').checked = false;

		document.getElementById('orcf-bChoisirMentions').disabled = true;
		document.getElementById('orcf-bAjouter').disabled = true;
		document.getElementById('orcf-bToutAjouter').disabled = true;
		document.getElementById('orcf-bEnlever').disabled = true;
		document.getElementById('orcf-bToutEnlever').disabled = true;
		document.getElementById('orcf-bEnregistrer').disabled = true;
		document.getElementById('orcf-bGenererBR').disabled = true;
		document.getElementById('orcf-bGenererRG').disabled = true;
		document.getElementById('orcf-bAnnuler').disabled = true;
		document.getElementById('orcf-bSupprimer').disabled = true;
		document.getElementById('orcf-bEditerBR').disabled = true;
		document.getElementById('orcf-bEditerRG').disabled = true;

		document.getElementById('orcf-commentairesFin').disabled = true;
		document.getElementById('orcf-commentairesInt').disabled = true;
		document.getElementById('orcf-numBL').disabled = true;
		document.getElementById('orcf-numLot').disabled = true;
		document.getElementById('orcf-datePeremption').disabled = true;
		document.getElementById('orcf-nbPieces').disabled = true;
		document.getElementById('orcf-quantite').disabled = true;
		document.getElementById('orcf-bConsultSerieLigne').disabled = true;
		document.getElementById('orcf-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('orcf-bEditerBR').collapsed = true;
		document.getElementById('orcf-bTransFacture').collapsed = true;
		document.getElementById('orcf-boxSaisieCodeBarre').collapsed = (orcf_etatBon!="N");

		document.getElementById('orcf-nbEtiqLot').value = "1";
		document.getElementById('orcf-bEtiqLot').disabled = true;
		document.getElementById('orcf-bNbEtiqLot').disabled = true;

		if (orcf_etatBon=="N") {
			document.getElementById('orcf-codeBarre').focus();
		}

		orcf_aArticlesBR.deleteTree();
		orcf_aArticlesCF.deleteTree();
		orcf_aRangement.deleteTree();

		// chargement des infos de la commande

		var qLoad = new QueryHttp("Facturation/Commandes/loadCommandeFournisseur.tmpl");
		qLoad.setParam("Commande_Id", orcf_commandeId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		var numFournisseur = contenu.getAttribute('Num_Fournisseur');

		if (!isEmpty(numFournisseur)) {
			document.getElementById('orcf-rowNumFournisseur').collapsed = false;
			document.getElementById('orcf-numFournisseur').value = contenu.getAttribute('Num_Fournisseur');
		}
		else {
			document.getElementById('orcf-rowNumFournisseur').collapsed = true;
		}
		document.getElementById('orcf-denomination').value = contenu.getAttribute('Denomination');
		document.getElementById("orcf-numCommande").value = contenu.getAttribute('Numero');
		document.getElementById('orcf-loginResp').value = contenu.getAttribute('Login_Resp');
		document.getElementById('orcf-dateCommande').value = contenu.getAttribute('Date_Commande');
		document.getElementById('orcf-depotReception').value = contenu.getAttribute("Lbl_Depot");
		orcf_etatCF = contenu.getAttribute('Etat');
		orcf_soldee = contenu.getAttribute('Soldee')=="true";

		document.getElementById('orcf-bNouveau').disabled = (orcf_etatCF=="C" || orcf_etatCF=="A" || orcf_soldee);
		document.getElementById("orcf-chiffre").checked = orcf_chiffreDefaut;
		document.getElementById("orcf-ordreTri").value = orcf_ordreTriDefaut;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_debloquerChamps() {
	try {

		document.getElementById('orcf-bChoisirMentions').disabled = false;
		document.getElementById('orcf-bToutAjouter').disabled = false;

		document.getElementById('orcf-commentairesFin').disabled = false;
		document.getElementById('orcf-commentairesInt').disabled = false;
		document.getElementById('orcf-numBL').disabled = false;
		document.getElementById('orcf-bEnregistrer').disabled = false;
		document.getElementById('orcf-bSupprimer').disabled = false;

		document.getElementById('orcf-bAjouter').disabled = true;
		document.getElementById('orcf-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function orcf_nouveauBon() {
  try {

		orcf_bonRecId = "";
		orcf_reinitialiser();

		if (orcf_etatCF!="C" && orcf_etatCF!="A" && !orcf_soldee) {
			orcf_aArticlesCF.clearParams();
			orcf_aArticlesCF.setParam('Commande_Id', orcf_commandeId);
			orcf_aArticlesCF.initTree();

			document.getElementById('orcf-bEditerBR').collapsed = false;
			document.getElementById('orcf-bEditerRG').collapsed = false;
			document.getElementById('orcf-bSupprimer').collapsed = true;
			document.getElementById('orcf-bAnnuler').collapsed = true;
			orcf_debloquerChamps();

			document.getElementById('orcf-bEnregistrer').collapsed = false;
			document.getElementById('orcf-bEnregistrer').disabled = false;
			document.getElementById('orcf-bGenererBR').disabled = true;
			document.getElementById('orcf-bEditerBR').disabled = true;
			document.getElementById('orcf-bGenererRG').disabled = true;
			document.getElementById('orcf-bEditerRG').disabled = true;
			document.getElementById('orcf-boxArticlesCF').collapsed = false;
			document.getElementById('orcf-boxActions').collapsed = false;

			orcf_setModified(false);
		}
		else {
			document.getElementById('orcf-boxActions').collapsed = true;
			document.getElementById('orcf-boxArticlesCF').collapsed = true;
			document.getElementById('orcf-boxSaisieCodeBarre').collapsed = true;
			document.getElementById('orcf-bGenererBR').collapsed = true;
			document.getElementById('orcf-bGenererRG').collapsed = true;
			document.getElementById('orcf-bTransFacture').collapsed = true;
			document.getElementById('orcf-bEnregistrer').collapsed = true;
			document.getElementById('orcf-bSupprimer').collapsed = true;
			document.getElementById('orcf-bAnnuler').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_pressOnReceptions(ev) {
  try {

		if (ev.keyCode==13) {
			orcf_bonRecId = orcf_aReceptions.getSelectedCellText('orcf-colBonId');
			orcf_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_dblclickOnReceptions() {
  try {

		if (orcf_aReceptions.isSelected()) {
			orcf_bonRecId = orcf_aReceptions.getSelectedCellText('orcf-colBonId');
			orcf_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_chargerBon() {
	try {

		orcf_reinitialiser();
		orcf_aArticlesBR.setParam('Bon_Id', orcf_bonRecId);
		orcf_aArticlesCF.setParam('Bon_Id', orcf_bonRecId);
		orcf_mode = "M";

		document.getElementById('orcf-bEditerBR').collapsed = false;

		var qLoad = new QueryHttp("Facturation/Commandes/loadBonReception.tmpl");
		qLoad.setParam("Bon_Rec_Id", orcf_bonRecId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;
		var statutFact = contenu.getAttribute("Facture");
		orcf_facturable = (statutFact!="T");
		orcf_existeFacture = (statutFact!="N");
		orcf_etatBon = contenu.getAttribute("Etat");
		orcf_dropshipping = isEmpty(contenu.getAttribute("Depot_Id"));
		orcf_currentDepotId = contenu.getAttribute("Depot_Id");
		orcf_etapeRangement = contenu.getAttribute("Etape_Rangement")=="true";
		orcf_statutReception = contenu.getAttribute("Statut_Reception");

		document.getElementById('orcf-etat').value = contenu.getAttribute("Lib_Etat");

		if (orcf_dropshipping) {
			document.getElementById('orcf-rowDateRG').collapsed = true;
			document.getElementById('orcf-rowNumeroRG').collapsed = true;
		}

		if (orcf_etatBon=="V") {
			document.getElementById('orcf-bSupprimer').collapsed = true;
			document.getElementById('orcf-bAnnuler').collapsed = orcf_existeFacture;
			document.getElementById('orcf-bAnnuler').disabled = false;
			document.getElementById('orcf-boxArticlesCF').collapsed = true;
			document.getElementById('orcf-boxActions').collapsed = true;
			document.getElementById('orcf-bTransFacture').collapsed = !orcf_facturable || orcf_statutReception=="R";
			if (orcf_statutReception=="R" && orcf_actEmplacements) {
				document.getElementById('orcf-boxRangement').collapsed = false;
			}
		}
		else if (orcf_etatBon=="A") {
			document.getElementById('orcf-bSupprimer').collapsed = true;
			document.getElementById('orcf-bAnnuler').collapsed = true;
			document.getElementById('orcf-boxArticlesCF').collapsed = true;
			document.getElementById('orcf-boxActions').collapsed = true;
			document.getElementById('orcf-bTransFacture').collapsed = true;
		}
		else {
			document.getElementById('orcf-bAnnuler').collapsed = true;
			document.getElementById('orcf-bSupprimer').collapsed = false;
			document.getElementById('orcf-boxArticlesCF').collapsed = false;
			document.getElementById('orcf-boxActions').collapsed = false;
			document.getElementById('orcf-bNouveau').disabled = true;
			document.getElementById('orcf-bTransFacture').collapsed = true;
		}


		if (orcf_etatBon!="N") {
			document.getElementById('orcf-tabVersions').collapsed = false;
			orcf_initVersion();
		}
		else {
			document.getElementById('orcf-codeBarre').focus();
		}

		document.getElementById('orcf-boxSaisieCodeBarre').collapsed = (orcf_etatBon!="N");

		document.getElementById('orcf-dateRG').value = contenu.getAttribute("Date_RG");
		document.getElementById('orcf-numeroRG').value = contenu.getAttribute("Numero_RG");
		document.getElementById('orcf-dateBR').value = contenu.getAttribute("Date_BR");
		document.getElementById('orcf-numeroBR').value = contenu.getAttribute("Numero_BR");
		document.getElementById('orcf-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('orcf-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('orcf-numBL').value = contenu.getAttribute("Num_BL");
		document.getElementById('orcf-depotReception').value = contenu.getAttribute("Lbl_Depot");
		document.getElementById('orcf-solder').checked = false;

		document.getElementById('orcf-creation').setAttribute("label", "R\u00E9ception cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('orcf-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('orcf-document').setAttribute("label", "Bon de r\u00E9ception N\u00B0 "+ contenu.getAttribute('Numero_BR'));
		document.getElementById('orcf-creation').collapsed = false;
		document.getElementById('orcf-modification').collapsed = false;
		document.getElementById('orcf-bOuvrirCommentairesCaches').disabled = false;

		orcf_aArticlesBR.initTree();

		orcf_setModified(false);

		if (orcf_etatBon!='V' && orcf_etatBon!='A') {
			orcf_aArticlesCF.setParam('Commande_Id', orcf_commandeId);
			orcf_aArticlesCF.initTree();
			orcf_debloquerChamps();
			document.getElementById('orcf-bToutEnlever').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_enregistrerBon(rafraichir) {
  try {

		var ok = false;

		var commentairesFin = document.getElementById('orcf-commentairesFin').value;
		var commentairesInt = document.getElementById('orcf-commentairesInt').value;
		var numBL = document.getElementById('orcf-numBL').value;

		if (orcf_rcfNumBLOblig && isEmpty(numBL)) {
			showWarning("N\u00B0 Bon de livraison obligatoire");
		}
		else {
			var qSave;

			if (orcf_mode=="C") {
				qSave = new QueryHttp("Facturation/Commandes/createBonReception.tmpl");
				qSave.setParam("Commande_Id", orcf_commandeId);
			}
			else {
				qSave = new QueryHttp("Facturation/Commandes/updateBonReception.tmpl");
				qSave.setParam("Bon_Id", orcf_bonRecId);
			}

			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Num_BL", numBL);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (orcf_mode=="C") {
					orcf_bonRecId = result.responseXML.documentElement.getAttribute("Bon_Id");
					if (rafraichir) {
						orcf_chargerBon();
					}
				}

				orcf_aReceptions.initTree();
				orcf_setModified(false);

				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la r\u00E9ception ?")) {

			var qDelete = new QueryHttp("Facturation/Commandes/deleteBonReception.tmpl");
			qDelete.setParam("Bon_Id", orcf_bonRecId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La r\u00E9ception a \u00E9t\u00E9 supprim\u00E9e avec succ\u00E8s");
			}

			orcf_nouveauBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_toutTransferer() {
  try {

  	var ok = true;
		if (orcf_mode=="C") {
			ok = orcf_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Commandes/addAllBR.tmpl');
			qAdd.setParam("Bon_Id", orcf_bonRecId);
			qAdd.setParam("Commande_Id", orcf_commandeId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			orcf_aArticlesCF.initTree();
			orcf_aArticlesBR.initTree();

			document.getElementById('orcf-nbPieces').value = "";
			document.getElementById('orcf-quantite').value = "";
			document.getElementById('orcf-numLot').value = "";
			document.getElementById('orcf-datePeremption').value = "";

			document.getElementById('orcf-bAjouter').disabled = true;
			document.getElementById('orcf-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Commandes/removeAllBR.tmpl');
		qRemove.setParam("Bon_Id", orcf_bonRecId);
		var result = qRemove.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		orcf_aArticlesCF.initTree();
		orcf_aArticlesBR.initTree();

		document.getElementById('orcf-nbPieces').value = "";
		document.getElementById('orcf-quantite').value = "";
		document.getElementById('orcf-numLot').value = "";
		document.getElementById('orcf-datePeremption').value = "";

		document.getElementById('orcf-bAjouter').disabled = true;
		document.getElementById('orcf-bEnlever').disabled = true;

		document.getElementById("orcf-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_ajouter() {
  try {

		if (orcf_aArticlesCF.isSelected()) {

			if (orcf_aArticlesCF.nbSelection()==1) {

				var articleId = orcf_aArticlesCF.getSelectedCellText('orcf-colArticleIdCF');
				var ligneCF = orcf_aArticlesCF.getSelectedCellText('orcf-colLigneIdCF');
				var isSuiviLot = orcf_aArticlesCF.getSelectedCellText('orcf-colSuiviLotCF')=="true";
				var isSuiviDLC = orcf_aArticlesCF.getSelectedCellText('orcf-colSuiviDLCCF')=="true";
				var isSuiviSerie = orcf_aArticlesCF.getSelectedCellText('orcf-colSuiviSerieCF')=="true";
				var qteRestante = orcf_aArticlesCF.getSelectedCellText('orcf-colQuantiteCF');
				var nbPiecesRestant = orcf_aArticlesCF.getSelectedCellText('orcf-colNbPiecesCF');
				if (isEmpty(nbPiecesRestant)) { nbPiecesRestant = 0; }

				var quantite = document.getElementById('orcf-quantite').value;
				var numLot = document.getElementById('orcf-numLot').value;
				var datePeremption = document.getElementById('orcf-datePeremption').value;
				var nbPieces = document.getElementById('orcf-nbPieces').value;
				if (isEmpty(nbPieces)) { nbPieces = 0; }

				if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer"); }
				else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
				else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
				else if (orcf_checkNumLotLigne(numLot, datePeremption, articleId, isSuiviLot, isSuiviDLC)) {

					var continuer = true;

					if (parseFloat(qteRestante)-parseFloat(quantite)<0) {
						continuer = window.confirm("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 r\u00E9ceptionner !\n\nVoulez-vous vraiment r\u00E9ceptionner plus que la quantit\u00E9 command\u00E9e ?");
					}

					if (!isEmpty(nbPieces)) {
						if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) {
							continuer = window.confirm("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer d\u00E9passe le nb de pi\u00E8ces restant \u00E0 r\u00E9ceptionner !\n\nVoulez-vous vraiment r\u00E9ceptionner plus que le nb de pi\u00E8ces command\u00E9 ?");
						}
					}

					if (continuer) {

						var ok = true;

						if (orcf_mode=="C") {
							ok = orcf_enregistrerBon(true);
						}

						if (ok) {

							var qAdd = new QueryHttp('Facturation/Commandes/addLigneBR.tmpl');
							qAdd.setParam("Bon_Id", orcf_bonRecId);
							qAdd.setParam("Ligne_CF", ligneCF);
							qAdd.setParam("Quantite", quantite);
							qAdd.setParam("Num_Lot", numLot);
							qAdd.setParam("Nb_Pieces", nbPieces);
							qAdd.setParam("Date_Peremption", datePeremption);
							var result = qAdd.execute();

							var errors = new Errors(result);
							if (errors.hasNext()) {
								errors.show();
							}
							else {
								var ligneBR = result.responseXML.documentElement.getAttribute('Ligne_Id');
								var quantiteBR = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

								orcf_scrollLigneBR = ligneBR;

								orcf_aArticlesCF.initTree();
								orcf_aArticlesBR.initTree(orcf_scrollToLigneBR);
								document.getElementById('orcf-bAjouter').disabled = true;

								document.getElementById('orcf-nbPieces').value = "";
								document.getElementById('orcf-quantite').value = "";
								document.getElementById('orcf-numLot').value = "";
								document.getElementById('orcf-datePeremption').value = "";
								orcf_checkNumSerieLigne(ligneBR, isSuiviSerie, quantiteBR);
							}
						}
					}
				}
			}
			else {
				var listLigneId = "";
				var rangeCount = orcf_aArticlesCF.getRangeCount();

				for (var j=0; j<rangeCount; j++) {
					var start = {};
					var end = {};
					orcf_aArticlesCF.getRangeAt(j,start,end);

					for (var c=start.value; c<=end.value; c++) {
						listLigneId += orcf_aArticlesCF.getCellText(c, "orcf-colLigneIdCF") +",";
					}
				}

				var ok = true;
				if (orcf_mode=="C") {
					ok = orcf_enregistrerBon(true);
				}
				if (ok) {
					var qAdd = new QueryHttp('Facturation/Commandes/addAllBR.tmpl');
					qAdd.setParam("Bon_Id", orcf_bonRecId);
					qAdd.setParam("Commande_Id", orcf_commandeId);
					qAdd.setParam("List_Ligne_Id", listLigneId);
					var result = qAdd.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					orcf_aArticlesCF.initTree();
					orcf_aArticlesBR.initTree();
					document.getElementById('orcf-bAjouter').disabled = true;
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_enlever() {
  try {

		if (orcf_aArticlesBR.isSelected()) {

			var ligneId = orcf_aArticlesBR.getSelectedCellText('orcf-colLigneIdBR');
			var qteInit = orcf_aArticlesBR.getSelectedCellText('orcf-colQuantiteBR');
			var quantite = document.getElementById('orcf-quantite').value;
			var nbPiecesInit = orcf_aArticlesBR.getSelectedCellText('orcf-colNbPiecesBR');
			if (isEmpty(nbPiecesInit)) {
				nbPiecesInit = 0;
			}
			var nbPieces = document.getElementById('orcf-nbPieces').value;
			if (isEmpty(nbPieces)) {
				nbPieces = 0;
			}

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteInit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans la r\u00E9ception");
			}
			else if (!isPositiveOrNullInteger(nbPieces)) {
				showWarning("Nombre de pi\u00E8ces incorrect !");
			}
			else if (parseFloat(nbPiecesInit)-parseFloat(nbPieces)<0) {
				showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans la r\u00E9ception");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Commandes/removeLigneBR.tmpl');
				qRemove.setParam("Ligne_Id", ligneId);
				qRemove.setParam("Quantite", quantite);
				qRemove.setParam("Nb_Pieces", nbPieces);
				var result = qRemove.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				orcf_aArticlesCF.initTree();
				orcf_aArticlesBR.initTree();

				document.getElementById('orcf-nbPieces').value = "";
				document.getElementById('orcf-quantite').value = "";
				document.getElementById('orcf-numLot').value = "";
				document.getElementById('orcf-datePeremption').value = "";

				document.getElementById('orcf-bEnlever').disabled = true;

				document.getElementById("orcf-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_demandeEnregistrement() {
  try {

		if (orcf_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la r\u00E9ception ?")) {
				orcf_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_setModified(modified) {
  try {

  	orcf_modified = modified;
		if (modified) {
			document.getElementById('orcf-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('orcf-bGenererBR').disabled = true;
			document.getElementById('orcf-bGenererRG').disabled = true;
			document.getElementById('orcf-bEditerBR').disabled = true;
			document.getElementById('orcf-bEditerRG').disabled = true;
		}
		else {
			document.getElementById('orcf-tabBon').setAttribute('image', null);
			document.getElementById('orcf-bGenererRG').disabled = orcf_etatBon!='N';
			document.getElementById('orcf-bGenererRG').collapsed = orcf_mode=='C' || orcf_etatBon!='N' || !orcf_etapeRangement;
			document.getElementById('orcf-bGenererBR').disabled = false;
			document.getElementById('orcf-bGenererBR').collapsed = orcf_mode=='C' || (orcf_statutReception!='R' && (orcf_etapeRangement || orcf_etatBon!='N'));
			document.getElementById('orcf-bEditerRG').disabled = false;
			document.getElementById('orcf-bEditerRG').collapsed = orcf_etatBon=='N' || orcf_dropshipping;
			document.getElementById('orcf-bEditerBR').disabled = false;
			document.getElementById('orcf-bEditerBR').collapsed = orcf_etatBon=='N' || orcf_statutReception=='R' || isEmpty(document.getElementById('orcf-dateBR').value);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_editerBonRangement() {
	try {

		document.getElementById("orcf-barEdition").collapsed = true;
		document.getElementById('orcf-pdfBonReception').setAttribute("src", "");
		document.getElementById('orcf-pdfEtiquettes').setAttribute("src", "");
		document.getElementById("bRetourBR").collapsed = false;
		document.getElementById("orcf-deckBonReception").selectedIndex = 1;
		document.getElementById('orcf-boxEtiquettes').collapsed = true;

		var qGenPdf = new QueryHttp("Facturation/Commandes/pdfBonRangement.tmpl");
		qGenPdf.setParam('Bon_Rec_Id', orcf_bonRecId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('orcf-pdfBonReception').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_editerBonReception() {
	try {

		document.getElementById("orcf-barEdition").collapsed = false;
		document.getElementById('orcf-pdfBonReception').setAttribute("src", "");
		document.getElementById('orcf-pdfEtiquettes').setAttribute("src", "");
		document.getElementById("bRetourBR").collapsed = false;
		document.getElementById("orcf-deckBonReception").selectedIndex = 1;

		var qGenPdf = new QueryHttp("Facturation/Commandes/pdfBonReception.tmpl");
		qGenPdf.setParam('Bon_Id', orcf_bonRecId);
		qGenPdf.setParam('Chiffre', document.getElementById("orcf-chiffre").checked);
		qGenPdf.setParam('Ordre_Tri', document.getElementById("orcf-ordreTri").value);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('orcf-pdfBonReception').setAttribute("src", page);

		if (orcf_gcfEtiqArticle) {
			document.getElementById('orcf-boxEtiquettes').collapsed = false;

			var qGenEtiq = new QueryHttp("Facturation/Commandes/pdfEtiquettesBR.tmpl");
			qGenEtiq.setParam('Bon_Id', orcf_bonRecId);

			result = qGenEtiq.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else if (result.responseXML.documentElement.getAttribute('Has_Etiquettes')=="true") {
				page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('orcf-pdfEtiquettes').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_checkNumSerie() {
	try {

		var ok = true;

		var qCheck = new QueryHttp("Facturation/Commandes/checkNumSerieBR.tmpl");
		qCheck.setParam("Bon_Id", orcf_bonRecId);
		var result = qCheck.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			ok = false;
			errors.show();
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_checkNumLot() {
	try {

		var ok = true;

		var qCheck = new QueryHttp("Facturation/Commandes/checkNumLotBR.tmpl");
		qCheck.setParam("Bon_Id", orcf_bonRecId);
		var result = qCheck.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			ok = false;
			errors.show();
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_genererRG() {
  try {

		if (orcf_aArticlesBR.nbLignes()<=0) {
			showWarning("La r\u00E9ception ne contient aucune ligne");
		}
		else if ((!orcf_actSuiviSerie || orcf_checkNumSerie()) && (!orcf_actSuiviLot || orcf_checkNumLot())
							&& window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de rangement ?")) {

			var qValid = new QueryHttp("Facturation/Commandes/generateBonRangement.tmpl");
			qValid.setParam('Bon_Rec_Id', orcf_bonRecId);
			qValid.setParam('Commande_Id', orcf_commandeId);
			qValid.setParam('Solder', document.getElementById('orcf-solder').checked);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				orcf_editerBonRangement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_genererBR() {
  try {

		if (orcf_aArticlesBR.nbLignes()<=0) {
			showWarning("La r\u00E9ception ne contient aucune ligne");
		}
		else if ((!orcf_actSuiviSerie || orcf_checkNumSerie()) && (orcf_statutReception=='R' || !orcf_actSuiviLot || orcf_checkNumLot())
							&& window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de r\u00E9ception ?\n(Attention le bon de r\u00E9ception valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {

			var ok = true;

			if (orcf_statutReception!='R') {
				var qValid = new QueryHttp("Facturation/Commandes/generateBonRangement.tmpl");
				qValid.setParam('Bon_Rec_Id', orcf_bonRecId);
				qValid.setParam('Commande_Id', orcf_commandeId);
				qValid.setParam('Solder', document.getElementById('orcf-solder').checked);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					ok = false;
					errors.show();
				}
			}

			if (ok) {
				var qValid = new QueryHttp("Facturation/Commandes/generateBonReception.tmpl");
				qValid.setParam('Bon_Rec_Id', orcf_bonRecId);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					orcf_editerBonReception();
				}
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function orcf_annulerBon() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la r\u00E9ception ?"+ (orcf_dropshipping?"\nAttention la commande fournisseur ainsi que le bon de livraison direct fournisseur (LF) correspondant vont \u00E9galement \u00EAtre annul\u00E9s":""))) {
			var qCancel = new QueryHttp("Facturation/Commandes/cancelBonReception.tmpl");
			qCancel.setParam("Bon_Id", orcf_bonRecId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La r\u00E9ception a \u00E9t\u00E9 annul\u00E9e");
			}
			orcf_chargerBon();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_transFacture() {
  try {

  	if (!orcf_facturable) { showWarning("Erreur : ce bon de r\u00E9ception est d\u00E9j\u00E0 factur\u00E9 enti\u00E8rement !"); }
  	else {
  		var message = (orcf_existeFacture?"Certains articles ont d\u00E9j\u00E0 \u00E9t\u00E9 factur\u00E9s. Voulez-vous facturer les articles restants ?":"Etes-vous s\u00FBr de vouloir transformer le bon de r\u00E9ception en facture ?");
			if (window.confirm(message)) {
				var qTransFacture = new QueryHttp("Facturation/Commandes/transBonReceptionFacture.tmpl");
				qTransFacture.setParam("Bon_Id", orcf_bonRecId);
				var result = qTransFacture.execute();

				var factureId = result.responseXML.documentElement.getAttribute('Facture_Id');
	  		window.location = "chrome://opensi/content/facturation/user/factu_fournisseur/gestionFactures.xul?Facture_Id="+ factureId;
			}
  	}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orcf_choisirMentions() {
  try {

		var ok = true;

		if (orcf_mode=="C") {
			ok = orcf_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "BR", orcf_bonRecId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orcf_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "BR", orcf_bonRecId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function orcf_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('orcf-commentairesFin').value;
		var commentairesInt = document.getElementById('orcf-commentairesInt').value;
		var readOnly = (orcf_etatBon!="N");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', orcf_retourEditerCommentaires, "BR", orcf_bonRecId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function orcf_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('orcf-commentairesFin').value = commentairesFin;
		document.getElementById('orcf-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function orcf_consulterCommandesClients() {
	try {

		if (orcf_aArticlesCF.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commandes/popup-commandesClientsArticle.xul?"+ cookie() +"&Ligne_Id="+ orcf_aArticlesCF.getSelectedCellText('orcf-colLigneIdCF');
		  window.openDialog(url,'','chrome,modal,centerscreen');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_initVersion() {
	try {

		orcf_aVersions.setParam("Bon_Id", orcf_bonRecId);
		orcf_aVersions.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_selectLigneBR()  {
	try {

		if (orcf_aArticlesBR.isSelected()) {
			document.getElementById('orcf-nbPieces').value = orcf_aArticlesBR.getSelectedCellText('orcf-colNbPiecesBR');
			document.getElementById('orcf-quantite').value = orcf_aArticlesBR.getSelectedCellText('orcf-colQuantiteBR');
			document.getElementById('orcf-nbPieces').disabled = false;
			document.getElementById('orcf-quantite').disabled = false;
			document.getElementById('orcf-numLot').value = "";
			document.getElementById('orcf-datePeremption').value = "";
			document.getElementById('orcf-numLot').disabled = true;
			document.getElementById('orcf-datePeremption').disabled = true;
			document.getElementById('orcf-bEnlever').disabled = false;
			document.getElementById('orcf-bAjouter').disabled = true;
			var articleId = orcf_aArticlesBR.getSelectedCellText('orcf-colArticleIdBR');
			document.getElementById('orcf-bConsultSerieLigne').disabled = isEmpty(articleId);
			orcf_aArticlesCF.clearSelection();

			if (orcf_etatBon=="V" && orcf_statutReception=="R") {
				orcf_aRangement.setParam("Ligne_Id", orcf_aArticlesBR.getSelectedCellText('orcf-colLigneIdBR'));
				orcf_aRangement.initTree();
				orcf_resetTransfertRangement();
			}

			var nbEtiquettes = orcf_aArticlesBR.getSelectedCellText("orcf-colNbEtiqLotBR");
			document.getElementById('orcf-nbEtiqLot').value = isEmpty(nbEtiquettes) || parseIntBis(nbEtiquettes)<=0?"1":nbEtiquettes;
			document.getElementById('orcf-bEtiqLot').disabled = isEmpty(orcf_aArticlesBR.getSelectedCellText('orcf-colLotIdBR'));
			document.getElementById('orcf-bNbEtiqLot').disabled = isEmpty(orcf_aArticlesBR.getSelectedCellText('orcf-colLotIdBR'));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_selectLigneCF() {
	try {

		if (orcf_aArticlesCF.isSelected()) {
			if (orcf_aArticlesCF.nbSelection()==1) {
				document.getElementById('orcf-nbPieces').value = orcf_aArticlesCF.getSelectedCellText('orcf-colNbPiecesCF');
				document.getElementById('orcf-quantite').value = orcf_aArticlesCF.getSelectedCellText('orcf-colQuantiteCF');
				document.getElementById('orcf-nbPieces').disabled = false;
				document.getElementById('orcf-quantite').disabled = false;
				var articleId = orcf_aArticlesCF.getSelectedCellText('orcf-colArticleIdCF');
				document.getElementById('orcf-numLot').disabled = isEmpty(articleId);
				document.getElementById('orcf-datePeremption').disabled = isEmpty(articleId);
				if (orcf_actReassortCC) {
					var qGet = new QueryHttp("Facturation/Commandes/getNbLiaisonCommandesClients.tmpl");
					qGet.setParam('Ligne_Id', orcf_aArticlesCF.getSelectedCellText('orcf-colLigneIdCF'));
					var result = qGet.execute();

					var nbLiaisonCommandesClients = result.responseXML.documentElement.getAttribute("NbLiaisonCommandesClients");
					document.getElementById('orcf-bConsulterCommandesClients').disabled = nbLiaisonCommandesClients==0;
				}
			}
			else {
				document.getElementById('orcf-nbPieces').value = "";
				document.getElementById('orcf-nbPieces').disabled = true;
				document.getElementById('orcf-quantite').value = "";
				document.getElementById('orcf-quantite').disabled = true;
				document.getElementById('orcf-numLot').disabled = true;
				document.getElementById('orcf-datePeremption').disabled = true;
				document.getElementById('orcf-bConsulterCommandesClients').disabled = true;
			}

			document.getElementById('orcf-numLot').value = "";
			document.getElementById('orcf-datePeremption').value = "";
			document.getElementById('orcf-bAjouter').disabled = false;
			document.getElementById('orcf-bEnlever').disabled = true;
			orcf_aArticlesBR.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (orcf_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Commandes/getNbNumSerieLigneBR.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "BR", ligneId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_consulterNumSerie()  {
	try {

		if (orcf_aArticlesBR.isSelected()) {
			var ligneId = orcf_aArticlesBR.getSelectedCellText('orcf-colLigneIdBR');
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (orcf_etatBon=="A" || orcf_statutReception=="C"?"C":"S"), "BR", ligneId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_checkNumLotLigne(numero, datePeremption, articleId, isSuiviLot, isSuiviDLC) {
	try {

		var ok = true;

		if (orcf_actSuiviLot && !isEmpty(articleId)) {

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
	    else if (!isEmpty(numero)) {
				var qLotBloque = new QueryHttp("Facturation/Tracabilite/isLotBloque.tmpl");
				qLotBloque.setParam("Num_Lot", numero);
				qLotBloque.setParam("Article_Id", articleId);
				var resLB = qLotBloque.execute();
				if (resLB.responseXML.documentElement.getAttribute("Bloque")=="true") {
					ok = false;
					showWarning("Impossible de valider la ligne : N\u00B0 Lot bloqu\u00E9");
				}
	    }
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13 && orcf_aArticlesCF.isSelected()) {
			var articleId = orcf_aArticlesCF.getSelectedCellText('orcf-colArticleIdCF');
			var numero = document.getElementById("orcf-numLot").value;

			if (!isEmpty(articleId)) {
				var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', orcf_retourRechercherLot, articleId, numero, null, null);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("orcf-numLot").value = numero;
		document.getElementById("orcf-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_updateDLC() {
	try {

		if (orcf_aArticlesCF.isSelected()) {
			var numero = document.getElementById("orcf-numLot").value;
			var articleId = orcf_aArticlesCF.getSelectedCellText('orcf-colArticleIdCF');

			if (!isEmpty(numero) && !isEmpty(articleId)) {
				var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
				qGetDLC.setParam("Article_Id", articleId);
				qGetDLC.setParam("Numero", numero);
				var result = qGetDLC.execute();
				var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
				if (!isEmpty(datePeremption)) {
					document.getElementById("orcf-datePeremption").value = datePeremption;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_pressOnCodeBarre(ev) {
	try {

		if (ev.keyCode==13) {
			orcf_validerSaisieByCodeBarre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_validerSaisieByCodeBarre() {
	try {

		var listLigneCF = "";
		var nbLignes = orcf_aArticlesCF.nbLignes();
		for (i=0; i<nbLignes; i++) {
			if (parseFloat(orcf_aArticlesCF.getCellText(i, 'orcf-colQuantiteCF'))>0) {
				listLigneCF += orcf_aArticlesCF.getCellText(i, 'orcf-colLigneIdCF') +",";
			}
		}

		var codeBarre = document.getElementById("orcf-codeBarre").value;

		if (!isEmpty(codeBarre)) {

			var ok = true;
			if (orcf_mode=="C") {
				ok = orcf_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterCodeBarre = new QueryHttp('Facturation/Commandes/addCodeBarreBR.tmpl');
				qAjouterCodeBarre.setParam("Bon_Id", orcf_bonRecId);
				qAjouterCodeBarre.setParam("Code_Barre", codeBarre);
				qAjouterCodeBarre.setParam("List_Ligne_CF", listLigneCF);
				var result = qAjouterCodeBarre.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					orcf_scrollLigneBR = result.responseXML.documentElement.getAttribute("Ligne_Id");

					orcf_aArticlesCF.initTree();
					orcf_aArticlesBR.initTree(orcf_scrollToLigneBR);
					document.getElementById("orcf-codeBarre").value = "";
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_envoyerMail() {
	try {

		var showTotaux = document.getElementById("orcf-chiffre").checked;
		var ordreTri = document.getElementById("orcf-ordreTri").value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "BR", orcf_bonRecId, "", showTotaux, ordreTri);

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_scrollToLigneBR() {
	try {

		if (!isEmpty(orcf_scrollLigneBR)) {

			var trouve = false;
			var i = 0;

			while (i<orcf_aArticlesBR.nbLignes() && !trouve) {
				if (orcf_aArticlesBR.getCellText(i, "orcf-colLigneIdBR")==orcf_scrollLigneBR) {
					trouve = true;
				}
				else {
					i++;
				}
			}

			if (trouve) {
				orcf_aArticlesBR.ensureRowIsVisible(i);
			}

			orcf_scrollLigneBR = "";
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


// RANGEMENT


function orcf_pressOnRangement() {
	try {

		if (orcf_aRangement.isSelected()) {
			document.getElementById("orcf-quantiteRG").value = orcf_aRangement.getSelectedCellText("orcf-colQuantiteRG");
			document.getElementById("orcf-emplacementInitRG").value = orcf_aRangement.getSelectedCellText("orcf-colCodeEmplacementRG");
			document.getElementById("orcf-bValiderRG").disabled = false;
			document.getElementById("orcf-codeEmplacementRG").disabled = false;
			document.getElementById("orcf-quantiteRG").disabled = false;
			document.getElementById("orcf-bRechercherEmplacementRG").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_resetTransfertRangement() {
	try {

		document.getElementById("orcf-emplacementInitRG").value = "";
		document.getElementById("orcf-codeEmplacementRG").value = "";
		document.getElementById("orcf-quantiteRG").value = "";

		document.getElementById("orcf-bValiderRG").disabled = true;
		document.getElementById("orcf-codeEmplacementRG").disabled = true;
		document.getElementById("orcf-quantiteRG").disabled = true;
		document.getElementById("orcf-bRechercherEmplacementRG").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_validerTransfertRangement() {
	try {

		if (orcf_aRangement.isSelected()) {
			var storeId = orcf_aRangement.getSelectedCellText("orcf-colStoreIdRG");
			var qteInit = orcf_aRangement.getSelectedCellText("orcf-colQuantiteRG");
			var emplacementInit = document.getElementById("orcf-emplacementInitRG").value;
			var codeEmplacement = document.getElementById("orcf-codeEmplacementRG").value;
			var quantite = document.getElementById("orcf-quantiteRG").value;

			if (isEmpty(codeEmplacement)) {
				showWarning("Emplacement incorrect");
			}
			else if (codeEmplacement==emplacementInit) {
				showWarning("Emplacement incorrect");
			}
			else if (!isPositive(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else if (parseFloat(quantite)>parseFloat(qteInit)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else {
				var emplacementId = orcf_getEmplacementId(codeEmplacement);

				if (isEmpty(emplacementId)) {
					showWarning("Emplacement inexistant");
				}
				else {
					var qTransfer = new QueryHttp("Facturation/Commandes/transferStoreLigneBR.tmpl");
					qTransfer.setParam("Store_Id", storeId);
					qTransfer.setParam("Emplacement_Id", emplacementId);
					qTransfer.setParam("Quantite", quantite);

					var result = qTransfer.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					orcf_aRangement.initTree();
					orcf_resetTransfertRangement();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", orcf_currentDepotId);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_rechercherEmplacement() {
	try {

		var reference = null;

		if (orcf_aArticlesBR.isSelected()) {
			reference = orcf_aArticlesBR.getSelectedCellText('orcf-colReferenceBR');
		}

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orcf_retourRechercherEmplacement, orcf_currentDepotId, reference);

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('orcf-codeEmplacementRG').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_setNbEtiquettesLot() {
	try {

		if (orcf_aArticlesBR.isSelected()) {
			var nbEtiquettes = document.getElementById('orcf-nbEtiqLot').value;

			if (!isPositiveOrNullInteger(nbEtiquettes)) {
				showWarning("Nb d'\u00E9tiquettes incorrect");
			}
			else {
				orcf_aArticlesBR.setSelectedCellText('orcf-colNbEtiqLotBR', nbEtiquettes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_pressOnNbEtiqLot(ev) {
	try {

		if (ev.keyCode==13) {
			orcf_setNbEtiquettesLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function orcf_editerAllEtiquettesLot() {
	try {

		var listLotId = "";
		var listNbEtiquettes = "";

		for (var i=0; i<orcf_aArticlesBR.nbLignes(); i++) {
			var lotId = orcf_aArticlesBR.getCellText(i, "orcf-colLotIdBR");
			var nbEtiquettes = orcf_aArticlesBR.getCellText(i, "orcf-colNbEtiqLotBR");

			if (!isEmpty(lotId) && !isEmpty(nbEtiquettes) && parseIntBis(nbEtiquettes)>0) {
				listLotId += lotId +",";
				listNbEtiquettes += nbEtiquettes +",";
			}
  	}

		if (isEmpty(listLotId) || isEmpty(listNbEtiquettes)) {
			showWarning("Aucune \u00E9tiquette \u00E0 \u00E9diter");
		}
		else {
			document.getElementById('orcf-deckBonReception').selectedIndex = 2;

			var qEdit = new QueryHttp("Facturation/Commandes/pdfAllEtiquetteLot.tmpl");
			qEdit.setParam("List_Lot_Id", listLotId);
			qEdit.setParam("List_Nb_Etiquettes", listNbEtiquettes);
			qEdit.execute(orcf_editerAllEtiquettesLot_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_editerAllEtiquettesLot_2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourBonReception();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('orcf-pdfEtiqLot').setAttribute("src", page);

			document.getElementById('bRetourBR').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_editerEtiquettesLot() {
	try {

		if (orcf_aArticlesBR.isSelected()) {
			var nbEtiquettes = document.getElementById('orcf-nbEtiqLot').value;
			var lotId = orcf_aArticlesBR.getSelectedCellText('orcf-colLotIdBR');

			if (!isPositiveInteger(nbEtiquettes)) {
				showWarning("Nb d'\u00E9tiquettes incorrect");
			}
			else {
				document.getElementById('orcf-deckBonReception').selectedIndex = 2;

				var qEdit = new QueryHttp("Facturation/Commandes/pdfEtiquetteLot.tmpl");
				qEdit.setParam("Lot_Id", lotId);
				qEdit.setParam("Nb_Etiquettes", nbEtiquettes);
				qEdit.execute(orcf_editerEtiquettesLot_2);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orcf_editerEtiquettesLot_2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourBonReception();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('orcf-pdfEtiqLot').setAttribute("src", page);

			document.getElementById('bRetourBR').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
