/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var commandeId;
var importFile;



function init() {
	try {

		commandeId = window.arguments[1];
		var resetAllowed = window.arguments[2];

		if (!resetAllowed) {
			document.getElementById('Reset').collapsed = true;
		}

		var config = getConfig();
		document.getElementById('ColDateReception').collapsed = !config.isGCFDateRecepLigne();
		document.getElementById('ColDateLivraison').collapsed = !config.isGCFDateLivraison() || !config.isGCFDateLivLigne();

	} catch (e) {
		recup_erreur(e);
	}
}


function clickOnColPrixUnitaire() {
	try {

		document.getElementById('boxMajPrixAchat').collapsed = !document.getElementById('ColPrixUnitaire').checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function importerFichier() {
	try {

		if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier \u00E0 importer");
		}
		else {
			var extension = getFileExtension(importFile.leafName).toLowerCase();

			if (!isEmpty(extension) && extension!="csv" && extension!="txt") {
				showWarning("Format de fichier incorrect (formats accept\u00E9s : *.csv, *.txt)");
			}
			else if (checkUploadFile(importFile)) {

				uploadFile(importFile);

	   		var qImport = new QueryHttp("Facturation/Commandes/importerLignes.tmpl");
	   		qImport.setParam("Commande_Id", commandeId);
	   		qImport.setParam("Fichier", importFile.leafName);
				qImport.setParam("Format", document.getElementById('Format').value);
				qImport.setParam("ColPRistourne", document.getElementById('ColPRistourne').checked);
				qImport.setParam("ColPrixUnitaire", document.getElementById('ColPrixUnitaire').checked);
				qImport.setParam("ColDateReception", document.getElementById('ColDateReception').checked);
				qImport.setParam("ColDateLivraison", document.getElementById('ColDateLivraison').checked);
				qImport.setParam("Reset", document.getElementById('Reset').checked);
				qImport.setParam("Maj_Prix_Achat", document.getElementById('majPrixAchat').checked);

	   		var result = qImport.execute();

	   		var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var nbLines = result.responseXML.documentElement.getElementsByTagName("erreurs").length;

					if (nbLines==0) {
						showMessage("Import termin\u00E9 avec succ\u00E8s : "+ result.responseXML.documentElement.getAttribute('Nb_Lines_OK') +" lignes import\u00E9es");
					}
					else {
						var rapport = result.responseXML.documentElement.getAttribute('Fichier_Rapport');

						var messages = new Array();
						var lines = new Array();
						var cells = new Array();

						for (var j=0; j<nbLines; j++) {
							var erreur = result.responseXML.documentElement.getElementsByTagName('erreurs')[j];
							messages[j] = erreur.getAttribute("Message");
							lines[j] = erreur.getAttribute("Ligne");
							cells[j] = erreur.getAttribute("Cellule");
						}

						window.openDialog("chrome://opensi/content/facturation/user/csv/popup-rapportErreurs.xul",'','chrome,modal,centerscreen', lines, cells, messages, rapport);
					}
				}

		   	window.arguments[0]();
		   	window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
