/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofc_aUtilisateurs = new Arbre("ComboListe/combo-responsables.tmpl", "ofc-utilisateurId");

var ofc_commercialId;
var ofc_modified = false;
var ofc_mode;
var ofc_curUtilisateur = "";



function ofc_init() {
  try {

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "ofc-codePays");
		aPays.initTree(ofc_initPays);

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_initPays() {
	try {

    document.getElementById('ofc-codePays').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_chargerUtilisateurs(selection) {
	try {

		ofc_curUtilisateur = selection;

		if (ofc_mode=="C") {
			ofc_aUtilisateurs.setParam("Exclude_Commercial", true);
		}
		else {
			ofc_aUtilisateurs.setParam("Selection", ofc_curUtilisateur);
		}

		ofc_aUtilisateurs.initTree(ofc_initUtilisateur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initUtilisateur() {
  try {

		document.getElementById('ofc-utilisateurId').value = ofc_curUtilisateur;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_initIHM() {
	try {

		document.getElementById('ofc-panneau').selectedIndex = 0;
		ofc_hideButtons(false);

		if (ofc_mode=="M") {
			document.getElementById('ofc-codeCommercial').setAttribute('readonly', true);
		}
		else {
			document.getElementById('ofc-codeCommercial').removeAttribute('readonly');
		}

		document.getElementById('ofc-tabRegles').collapsed = ofc_mode=="C";
		document.getElementById('ofc-tabStatistiques').collapsed = ofc_mode=="C";
		document.getElementById('ofc-tabHistorique').collapsed = ofc_mode=="C";

		document.getElementById('ofc-bSupprimer').collapsed = ofc_mode=="C";
		document.getElementById('ofc-bEnregistrer').collapsed = false;
		document.getElementById('ofc-utilisateurId').disabled = ofc_mode!="C";

		ofc_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_nouveauCommercial() {
  try {

		document.getElementById('ofc-deckCommercial').selectedIndex = 0;

		ofc_mode = "C";
		ofc_commercialId = "";

		// onglet fiche signaltique
		document.getElementById('ofc-lblCommercial').value = "Fiche commercial";

		document.getElementById('ofc-codeCommercial').value = "";
		document.getElementById('ofc-civilite').value = "0";
		document.getElementById('ofc-nom').value = "";
		document.getElementById('ofc-prenom').value = "";
		document.getElementById('ofc-adresse1').value = "";
		document.getElementById('ofc-adresse2').value = "";
		document.getElementById('ofc-adresse3').value = "";
		document.getElementById('ofc-codePostal').value = "";
		document.getElementById('ofc-ville').value = "";
		document.getElementById('ofc-codePays').value = "FR";
		document.getElementById('ofc-tel1').value = "";
		document.getElementById('ofc-tel2').value = "";
		document.getElementById('ofc-tel3').value = "";
		document.getElementById('ofc-fax1').value = "";
		document.getElementById('ofc-fax2').value = "";
		document.getElementById('ofc-email1').value = "";
		document.getElementById('ofc-email2').value = "";
		document.getElementById('ofc-secteur').value = "";
		document.getElementById('ofc-actif').checked = true;
		ofc_chargerUtilisateurs("");

		document.getElementById('ofc-creation').setAttribute("label", "");
		document.getElementById('ofc-modification').setAttribute("label", "");
		document.getElementById('ofc-document').setAttribute("label", "");

		ofc_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_chargerCommercial() {
  try {

		document.getElementById('ofc-deckCommercial').selectedIndex = 0;

		ofc_mode = "M";

		var qLoad = new QueryHttp("Facturation/Commerciaux/loadFicheCommercial.tmpl");
		qLoad.setParam('Commercial_Id', ofc_commercialId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		// onglet fiche signaltique
		document.getElementById('ofc-lblCommercial').value = "Fiche commercial "+ contenu.getAttribute('Code_Commercial');

		document.getElementById('ofc-codeCommercial').value = contenu.getAttribute('Code_Commercial');
		document.getElementById('ofc-civilite').value = contenu.getAttribute('Civilite');
		document.getElementById('ofc-nom').value = contenu.getAttribute('Nom');
		document.getElementById('ofc-prenom').value = contenu.getAttribute('Prenom');
		document.getElementById('ofc-adresse1').value = contenu.getAttribute('Adresse_1');
		document.getElementById('ofc-adresse2').value = contenu.getAttribute('Adresse_2');
		document.getElementById('ofc-adresse3').value = contenu.getAttribute('Adresse_3');
		document.getElementById('ofc-codePostal').value = contenu.getAttribute('Code_Postal');
		document.getElementById('ofc-ville').value = contenu.getAttribute('Ville');
		document.getElementById('ofc-codePays').value = contenu.getAttribute('Code_Pays');
		document.getElementById('ofc-tel1').value = contenu.getAttribute('Tel_1');
		document.getElementById('ofc-tel2').value = contenu.getAttribute('Tel_2');
		document.getElementById('ofc-tel3').value = contenu.getAttribute('Tel_3');
		document.getElementById('ofc-fax1').value = contenu.getAttribute('Fax_1');
		document.getElementById('ofc-fax2').value = contenu.getAttribute('Fax_2');
		document.getElementById('ofc-email1').value = contenu.getAttribute('Email_1');
		document.getElementById('ofc-email2').value = contenu.getAttribute('Email_2');
		document.getElementById('ofc-secteur').value = contenu.getAttribute('Secteur');
		document.getElementById('ofc-actif').checked = contenu.getAttribute('Actif')=="true";

		ofc_chargerUtilisateurs(contenu.getAttribute('Utilisateur_Id'));

		oor_initOngletRegles();
		oos_initOngletStatistiques();
		ooh_initOngletHistorique();

		document.getElementById('ofc-creation').setAttribute("label", "Commercial cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('ofc-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('ofc-document').setAttribute("label", "Commercial "+ contenu.getAttribute('Code_Commercial') +" - "+ contenu.getAttribute('Nom'));

		ofc_initIHM();

		document.getElementById('ofc-tabStatistiques').collapsed = !document.getElementById('ofc-actif').checked;

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_enregistrerCommercial() {
	try {

		// champs onglet fiche signaltique

		var codeCommercial = document.getElementById('ofc-codeCommercial').value;
		var utilisateurId = document.getElementById('ofc-utilisateurId').value;
		var civilite = document.getElementById('ofc-civilite').value;
		var nom = document.getElementById('ofc-nom').value;
		var prenom = document.getElementById('ofc-prenom').value;
		var adresse1 = document.getElementById('ofc-adresse1').value;
		var adresse2 = document.getElementById('ofc-adresse2').value;
		var adresse3 = document.getElementById('ofc-adresse3').value;
		var codePostal = document.getElementById('ofc-codePostal').value;
		var ville = document.getElementById('ofc-ville').value;
		var codePays = document.getElementById('ofc-codePays').value;
		var tel1 = document.getElementById('ofc-tel1').value;
		var tel2 = document.getElementById('ofc-tel2').value;
		var tel3 = document.getElementById('ofc-tel3').value;
		var fax1 = document.getElementById('ofc-fax1').value;
		var fax2 = document.getElementById('ofc-fax2').value;
		var email1 = document.getElementById('ofc-email1').value;
		var email2 = document.getElementById('ofc-email2').value;
		var secteur = document.getElementById('ofc-secteur').value;
		var actif = document.getElementById('ofc-actif').checked;

		if (ofc_mode=="C" && isEmpty(codeCommercial)) { showWarning("Veuillez sp\u00E9cifier un code commercial (Onglet fiche signal\u00E9tique)"); }
		else if (ofc_mode=="C" && !isCleAlpha(codeCommercial)) { showWarning("Code commercial invalide (Onglet fiche signal\u00E9tique)"); }
		else if (ofc_mode=="C" && isEmpty(utilisateurId)) { showWarning("Veuillez sp\u00E9cifier l'utilisateur correspondant au commercial (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(nom)) { showWarning("Veuillez sp\u00E9cifier le nom du commercial (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez sp\u00E9cifier l'adresse du commercial (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville du commercial (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(tel1)) { showWarning("Veuillez sp\u00E9cifier le t\u00E9l\u00E9phone 1 du commercial (Onglet fiche signal\u00E9tique)"); }
		else if (!isPhone(tel1)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 1 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 2 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel3) && !isPhone(tel3)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 3 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(fax1) && !isPhone(fax1)) { showWarning("Num\u00E9ro de fax 1 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(fax2) && !isPhone(fax2)) { showWarning("Num\u00E9ro de fax 2 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(email1) && !isEmail(email1)) { showWarning("Adresse e-mail 1 incorrecte (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(email2) && !isEmail(email2)) { showWarning("Adresse e-mail 2 incorrecte (Onglet fiche signal\u00E9tique)"); }
		else {

			var qSave;

			if (ofc_mode=="C") {
				qSave = new QueryHttp("Facturation/Commerciaux/createFicheCommercial.tmpl");
				qSave.setParam("Code_Commercial", codeCommercial);
				qSave.setParam("Utilisateur_Id", utilisateurId);
			}
			else {
				qSave = new QueryHttp("Facturation/Commerciaux/updateFicheCommercial.tmpl");
				qSave.setParam("Commercial_Id", ofc_commercialId);
			}

			qSave.setParam("Civilite", civilite);
			qSave.setParam("Nom", nom);
			qSave.setParam("Prenom", prenom);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Tel_1", tel1);
			qSave.setParam("Tel_2", tel2);
			qSave.setParam("Tel_3", tel3);
			qSave.setParam("Fax_1", fax1);
			qSave.setParam("Fax_2", fax2);
			qSave.setParam("Email_1", email1);
			qSave.setParam("Email_2", email2);
			qSave.setParam("Secteur", secteur);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (ofc_mode=="C") {
					ofc_commercialId = result.responseXML.documentElement.getAttribute("Commercial_Id");
					ofc_chargerCommercial();
				}
				else {
					ofc_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_supprimerCommercial() {
	try {

		var codeCommercial = document.getElementById('ofc-codeCommercial').value;

		if (window.confirm("Confirmez-vous la suppression du commercial "+ codeCommercial +" ?")) {

			var qDelete = new QueryHttp("Facturation/Commerciaux/deleteFicheCommercial.tmpl");
			qDelete.setParam('Commercial_Id', ofc_commercialId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
    		showMessage("Le commercial a \u00E9t\u00E9 supprim\u00E9");
				retourMenuCommerciaux();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_reporterCoordUtilisateur() {
	try {

		var utilisateurId = document.getElementById("ofc-utilisateurId").value;

		if (!isEmpty(utilisateurId)) {
			var qGet = new QueryHttp("Utilisateurs/Utilisateurs/loadUtilisateur.tmpl");
      qGet.setParam("Utilisateur_Id", utilisateurId);
			var result = qGet.execute();
			var contenu = result.responseXML.documentElement;

			document.getElementById("ofc-civilite").value = contenu.getAttribute("Civilite");
			document.getElementById("ofc-nom").value = contenu.getAttribute("Nom");
			document.getElementById("ofc-prenom").value = contenu.getAttribute("Prenom");
			document.getElementById("ofc-tel1").value = contenu.getAttribute("Telephone");
			document.getElementById("ofc-email1").value = contenu.getAttribute("Email");
		}
		else {
			document.getElementById("ofc-civilite").value = "";
			document.getElementById("ofc-nom").value = "";
			document.getElementById("ofc-prenom").value = "";
			document.getElementById("ofc-tel1").value = "";
			document.getElementById("ofc-email1").value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_hideButtons(b) {
	try {

		document.getElementById('ofc-buttons').collapsed = b || !gDirection;

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_demandeEnregistrement() {
  try {

		if (ofc_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche commercial ?")) {
				ofc_enregistrerCommercial();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_setModified(m) {
  try {

  	ofc_modified = m;

		if (ofc_modified) {
			if (document.getElementById('ofc-panneau').selectedIndex==0) {
				document.getElementById('ofc-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
		}
		else {
			document.getElementById('ofc-tabFiche').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}
