/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oor_aFamilles1 = new Arbre("ComboListe/combo-famillesArticle.tmpl", "oor-famille1");
var oor_aFamilles2 = new Arbre("ComboListe/combo-famillesArticle.tmpl", "oor-famille2");
var oor_aFamilles3 = new Arbre("ComboListe/combo-famillesArticle.tmpl", "oor-famille3");
var oor_aMarques = new Arbre("ComboListe/combo-marquesArticle.tmpl", "oor-marqueId");
var oor_aTranches = new Arbre("Facturation/Commerciaux/list-trancheCommission.tmpl", "oor-listeTrancheCommission");
var oor_aRegles = new Arbre("Facturation/Commerciaux/list-regleCommission.tmpl", "oor-listeRegleCommission");

var oor_currentRegleId = "";
var oor_currentTrancheId = "";
var oor_selFamille1;
var oor_selFamille2;
var oor_selFamille3;
var oor_selMarque;
var oor_typeValeur;



function oor_initOngletRegles() {
	try {

		oor_aRegles.setParam("Commercial_Id", ofc_commercialId);

		oor_listerRegles();
		oor_nouveauRegle();

		if (!gDirection) {
			document.getElementById('oor-boxRAZ').collapsed = true;
			document.getElementById('oor-boxRegle').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oor_listerRegles() {
	try {

		oor_aRegles.initTree(oor_finListerRegles);

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_finListerRegles() {
	try {

		document.getElementById('oor-bRAZ').disabled = oor_aRegles.nbLignes()==0;

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_nouveauRegle() {
	try {

		oor_currentRegleId = "";
		oor_currentTrancheId = "";
		oor_typeValeur = "P";
		oor_aRegles.clearSelection();

		oor_aTranches.deleteTree();

		document.getElementById('oor-typeRegle').value = "G";
		document.getElementById('oor-baseCalcul').value = "C";
		document.getElementById('oor-valeurFixe').value = "";
		document.getElementById('oor-reference').value = "";
		document.getElementById('oor-typeCalcul').value = "F";

		oor_chargerMarques("");

		oor_selFamille1 = "";
		oor_selFamille2 = "";
		oor_selFamille3 = "";
		oor_chargerFamilles1();

		document.getElementById('oor-bSupprimerRegle').collapsed = true;
		document.getElementById('oor-bNouveauRegle').collapsed = true;
		document.getElementById('oor-bCopierRegle').collapsed = true;

		oor_pressOnTypeRegle();

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_pressOnTypeRegle() {
	try {

		var typeRegle = document.getElementById('oor-typeRegle').value;
		var baseCalcul = document.getElementById('oor-baseCalcul').value;

		document.getElementById('oor-baseCalculMarge').disabled = typeRegle=="G" || typeRegle=="H";
		document.getElementById('oor-typeCalculQuantite').disabled = typeRegle=="G" || typeRegle=="H";
		document.getElementById('oor-marqueId').collapsed = typeRegle!="M";
		document.getElementById('oor-boxFamille').collapsed = typeRegle!="F";
		document.getElementById('oor-boxArticle').collapsed = typeRegle!="A";

		if (typeRegle=="G" || typeRegle=="H")	{
			document.getElementById('oor-baseCalcul').value = "C";
		}

		oor_pressOnBaseCalcul();

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_pressOnBaseCalcul() {
	try {

		var baseCalcul = document.getElementById('oor-baseCalcul').value;

		document.getElementById('oor-typeRegleGlobale').disabled = baseCalcul!="C";
		document.getElementById('oor-typeRegleHorsCatalogue').disabled = baseCalcul!="C";

		document.getElementById('oor-typeCalculFixe').setAttribute("label", baseCalcul=='C'?"En part fixe du CA :":"En part fixe de la marge :");
		document.getElementById('oor-typeCalculMontant').setAttribute("label", "Par tranches de "+ (baseCalcul=='C'?"CA":"marge"));

		oor_pressOnTypeCalcul();

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_pressOnTypeCalcul() {
	try {

		var typeCalcul = document.getElementById('oor-typeCalcul').value;

		if (typeCalcul!='F') {
			document.getElementById('oor-valeurFixe').value = "";
		}

		if (typeCalcul!='Q') {
			oor_typeValeur = "P";
		}

		document.getElementById('oor-boxTranches').collapsed = typeCalcul=='F';
		document.getElementById('oor-boxTypeValeur').collapsed = typeCalcul!='Q';

		oor_changeTypeValeur();

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_switchTypeValeur() {
	try {

		if (oor_typeValeur=="P") {
			oor_typeValeur = "M";
		}
		else {
			oor_typeValeur = "P";
		}

		oor_changeTypeValeur();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_changeTypeValeur() {
	try {

		var baseCalcul = document.getElementById('oor-baseCalcul').value;
		var typeCalcul = document.getElementById('oor-typeCalcul').value;

		document.getElementById('oor-bTypeValeur').setAttribute("class", oor_typeValeur=="P"?"bIcoPourcentage":"bIcoEuro");
		document.getElementById('oor-lblBorneTC').value = typeCalcul!='Q'?"\u20AC":"articles";
		document.getElementById("oor-lblValeurTC").value = oor_typeValeur=="P"?(baseCalcul=="C"?"% CA :":"% Marge :"):"Montant :";
		document.getElementById("oor-colValeurTC").setAttribute("label", oor_typeValeur=="P"?(baseCalcul=="C"?"% CA":"% Marge"):"Montant");

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_pressOnRegle() {
	try {

		if (oor_aRegles.isSelected())	{
			oor_currentRegleId = oor_aRegles.getSelectedCellText('oor-colRegleId');
			oor_chargerRegle();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_chargerRegle() {
	try {

		var qLoad = new QueryHttp("Facturation/Commerciaux/loadRegleCommission.tmpl");
		qLoad.setParam("Regle_Id", oor_currentRegleId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			oor_typeValeur = contenu.getAttribute("Type_Valeur");

			document.getElementById('oor-typeRegle').selectedIndex = -1;
			document.getElementById('oor-typeRegle').value = contenu.getAttribute("Type_Regle");
			document.getElementById('oor-reference').value = contenu.getAttribute("Reference");
			document.getElementById('oor-baseCalcul').value = contenu.getAttribute("Base_Calcul");
			document.getElementById('oor-valeurFixe').value = contenu.getAttribute("Valeur_Fixe");
			document.getElementById("oor-typeCalcul").value = contenu.getAttribute("Type_Calcul");

			oor_chargerMarques(contenu.getAttribute("Marque_Id"));

			oor_selFamille1 = contenu.getAttribute("Famille_1");
			oor_selFamille2 = contenu.getAttribute("Famille_2");
			oor_selFamille3 = contenu.getAttribute("Famille_3");
			oor_chargerFamilles1();

			oor_pressOnTypeRegle();

			document.getElementById('oor-bSupprimerRegle').collapsed = false;
			document.getElementById('oor-bNouveauRegle').collapsed = false;
			document.getElementById('oor-bCopierRegle').collapsed = false;

			oor_nouveauTranche();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_enregistrerRegle() {
	try {

		var save = false;

		var typeRegle = document.getElementById("oor-typeRegle").value;
		var baseCalcul = document.getElementById("oor-baseCalcul").value;
		var famille1 = (typeRegle=="F"?document.getElementById("oor-famille1").value:"");
		var famille2 = (typeRegle=="F" && !isEmpty(document.getElementById('oor-famille1').value)?document.getElementById("oor-famille2").value:"");
		var famille3 = (typeRegle=="F" && !isEmpty(document.getElementById('oor-famille2').value)?document.getElementById("oor-famille3").value:"");
		var reference = (typeRegle=="A"?document.getElementById("oor-reference").value:"");
		var marqueId = (typeRegle=="M"?document.getElementById("oor-marqueId").value:"");
		var typeCalcul = document.getElementById("oor-typeCalcul").value;
		var valeurFixe = typeCalcul=="F"?document.getElementById('oor-valeurFixe').value:0;

		if (isEmpty(typeRegle)) { showWarning("Veuillez s\u00E9lectionner les articles concern\u00E9s par la r\u00E8gle"); }
		else if (typeRegle=="F" && isEmpty(famille1)) {	showWarning("Veuillez s\u00E9lectionner une famille 1"); }
		else if (typeRegle=="A" && isEmpty(reference)) { showWarning("Veuillez s\u00E9lectionner un article"); }
		else if (typeRegle=="M" && isEmpty(marqueId)) { showWarning("Veuillez s\u00E9lectionner une marque"); }
		else if (typeCalcul=="F" && isEmpty(valeurFixe)) { showWarning("Veuillez saisir une part fixe en pourcentage") }
		else if (typeCalcul=="F" && !isPositive(valeurFixe) || !checkDecimal(valeurFixe,2)) { showWarning("Part fixe en pourcentage incorrecte"); }
		else if (typeCalcul=="F" && !isTaux(valeurFixe)) { showWarning("Part fixe en pourcentage incorrecte"); }
		else if (typeCalcul!="F" && !isEmpty(oor_currentRegleId) && oor_aTranches.nbLignes()==0) { showWarning("Veuillez ajouter au moins une tranche"); }
		else {

			var qSave;

			if (isEmpty(oor_currentRegleId)) {
				qSave = new QueryHttp("Facturation/Commerciaux/createRegleCommission.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Commerciaux/updateRegleCommission.tmpl");
				qSave.setParam("Regle_Id", oor_currentRegleId);
			}

			qSave.setParam("Commercial_Id", ofc_commercialId);
			qSave.setParam("Type_Regle", typeRegle);
			qSave.setParam("Base_Calcul", baseCalcul);
			qSave.setParam("Reference", reference);
			qSave.setParam("Famille_1", famille1);
			qSave.setParam("Famille_2", famille2);
			qSave.setParam("Famille_3", famille3);
			qSave.setParam("Marque_Id", marqueId);
			qSave.setParam("Valeur_Fixe", valeurFixe);
			qSave.setParam("Type_Valeur", oor_typeValeur);
			qSave.setParam("Type_Calcul", typeCalcul);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (isEmpty(oor_currentRegleId)) {
					oor_currentRegleId = result.responseXML.documentElement.getAttribute("Regle_Id");
				}

				oor_listerRegles();
				oor_chargerRegle();

				save = true;
			}
		}

		return save;

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_supprimerRegle() {
	try {

		if (!isEmpty(oor_currentRegleId) && window.confirm("Confirmez-vous la suppression de la r\u00E8gle ?")) {

			var qDelete = new QueryHttp("Facturation/Commerciaux/deleteRegleCommission.tmpl");
			qDelete.setParam("Regle_Id", oor_currentRegleId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oor_listerRegles();
				oor_nouveauRegle();
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_copierRegle() {
	try {

		if (!isEmpty(oor_currentRegleId) && window.confirm("Voulez-vous copier la r\u00E8gle ?")) {
			var qCopy = new QueryHttp("Facturation/Commerciaux/duplicateRegleCommission.tmpl");
			qCopy.setParam("Regle_Id", oor_currentRegleId);
			var result = qCopy.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oor_currentRegleId = result.responseXML.documentElement.getAttribute('Regle_Id');

				oor_listerRegles();
				oor_chargerRegle();

				showWarning("Copie de r\u00E8gle : N'oubliez pas de s\u00E9lectionner et enregistrer les articles concern\u00E9s par la nouvelle r\u00E8gle");
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oor_razRegles() {
	try {

		if (window.confirm("Etes-vous s\u00FBr de vouloir supprimer toutes les r\u00E8gles ?")) {
			var qDelete = new QueryHttp("Facturation/Commerciaux/deleteRegleCommissionByCommercialId.tmpl");
			qDelete.setParam("Commercial_Id", ofc_commercialId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oor_listerRegles();
			oor_nouveauRegle();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_chargerFamilles1() {
	try {

		oor_aFamilles1.setParam("Selection", oor_selFamille1);
		oor_aFamilles1.initTree(oor_initFamille1);

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_initFamille1() {
	try {

		document.getElementById('oor-famille1').value = oor_selFamille1;

		if (!isEmpty(oor_selFamille1)) {
			oor_selFamille1 = "";
			oor_chargerFamilles2();
		}
		else {
			oor_aFamilles2.deleteTree();
			oor_aFamilles3.deleteTree();
			document.getElementById('oor-famille2').value = "";
			document.getElementById('oor-famille3').value = "";
			document.getElementById('oor-famille2').disabled = true;
			document.getElementById('oor-famille3').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('oor-famille1').value;

		if (isEmpty(famille1)) {
			document.getElementById('oor-famille2').disabled = true;
			document.getElementById('oor-famille3').disabled = true;
		}
		else {
			oor_aFamilles2.setParam('Parent_Id', famille1);
			oor_aFamilles2.setParam("Selection", oor_selFamille2);
			oor_aFamilles2.initTree(oor_initFamille2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_initFamille2() {
	try {

		document.getElementById('oor-famille2').value = oor_selFamille2;

		if (!isEmpty(document.getElementById('oor-famille1').value)) {
			document.getElementById('oor-famille2').disabled = false;
		}

		if (!isEmpty(oor_selFamille2)) {
			oor_selFamille2 = "";
			oor_chargerFamilles3();
		}
		else {
			oor_aFamilles3.deleteTree();
			document.getElementById('oor-famille3').value = "";
			document.getElementById('oor-famille3').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('oor-famille2').value;

		if (isEmpty(famille2)) {
			document.getElementById('oor-famille3').disabled = true;
		}
		else {
			oor_aFamilles3.setParam('Parent_Id', famille2);
			oor_aFamilles3.setParam("Selection", oor_selFamille3);
			oor_aFamilles3.initTree(oor_initFamille3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_initFamille3() {
	try {

		document.getElementById('oor-famille3').value = oor_selFamille3;

		if (!isEmpty(document.getElementById('oor-famille2').value)) {
			document.getElementById('oor-famille3').disabled = false;
		}

		oor_selFamille3 = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_pressOnFamille1() {
	try {

		oor_selFamille1 = document.getElementById('oor-famille1').value;
		oor_selFamille2 = "";
		oor_selFamille3 = "";
		oor_chargerFamilles2();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_pressOnFamille2() {
	try {

		oor_selFamille2 = document.getElementById('oor-famille2').value;
		oor_selFamille3 = "";
		oor_chargerFamilles3();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_chargerMarques(selection) {
	try {

		oor_selMarque = selection;

		oor_aMarques.setParam("Commercial_Id", ofc_commercialId);
		oor_aMarques.setParam("Selection", selection);
		oor_aMarques.initTree(oor_initMarques);

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_initMarques() {
	try {

		document.getElementById('oor-marqueId').value = oor_selMarque;

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oor_retourRechercherArticle, "V");

	} catch (e) {
    recup_erreur(e);
  }
}


function oor_retourRechercherArticle(reference, articleId) {
	try {

		document.getElementById('oor-reference').value = reference;

	} catch (e) {
    recup_erreur(e);
  }
}



// TRANCHES DE COMMISSION


function oor_nouveauTranche() {
	try {

		if (!isEmpty(oor_currentRegleId)) {
			oor_aTranches.setParam("Regle_Id", oor_currentRegleId);
			oor_aTranches.initTree();
		}

		document.getElementById('oor-bSupprimerTC').disabled = true;
		oor_currentTrancheId = "";

		document.getElementById('oor-valeurTC').value = "";
		document.getElementById('oor-borneInfTC').value = "";
		document.getElementById('oor-borneSupTC').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_ouvrirTranche() {
	try {

		if (oor_aTranches.isSelected()) {
			document.getElementById("oor-valeurTC").value = oor_aTranches.getSelectedCellText("oor-colValeurTC");
			document.getElementById("oor-borneInfTC").value = oor_aTranches.getSelectedCellText("oor-colBorneInfTC");
			document.getElementById("oor-borneSupTC").value = oor_aTranches.getSelectedCellText("oor-colBorneSupTC");
			oor_currentTrancheId = oor_aTranches.getSelectedCellText("oor-colTrancheIdTC");

			document.getElementById("oor-bSupprimerTC").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_supprimerTranche() {
	try {

		if (!isEmpty(oor_currentTrancheId)) {
			var qDelete = new QueryHttp("Facturation/Commerciaux/deleteTrancheCommission.tmpl");
			qDelete.setParam("Tranche_Id", oor_currentTrancheId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oor_nouveauTranche();
				oor_listerRegles();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_enregistrerTranche() {
	try {

		var ok = true;

		var valeur = document.getElementById('oor-valeurTC').value;
		var borneInf = document.getElementById('oor-borneInfTC').value;
		var borneSup = document.getElementById('oor-borneSupTC').value;

		if (isEmpty(oor_currentRegleId)) {
			ok = oor_enregistrerRegle();
		}

		if (ok) {

			if (isEmpty(valeur)) { showWarning("Veuillez saisir une valeur") }
			else if (!isPositive(valeur) || !checkNumber(valeur,9,2)) { showWarning("Valeur incorrecte"); }
			else if (oor_typeValeur=="P" && !isTaux(valeur)) { showWarning("Valeur en pourcentage incorrecte"); }
			else if (isEmpty(borneInf)) { showWarning("Veuillez saisir la borne inf\u00E9rieure de la tranche"); }
			else if (!isPositiveOrNull(borneInf) || !checkNumber(borneInf,11,2)) { showWarning("Borne inf\u00E9rieure de la tranche incorrecte"); }
			else if (!isEmpty(borneSup) && (!isPositive(borneSup) || !checkNumber(borneSup,11,2))) { showWarning("Borne sup\u00E9rieure de la tranche incorrecte"); }
			else if (!isEmpty(borneSup) && parseFloat(borneInf)>parseFloat(borneSup)) { showWarning("Intervalle de tranches incorrect"); }
			else {

				var qSave;

				if (isEmpty(oor_currentTrancheId)) {
					qSave = new QueryHttp("Facturation/Commerciaux/createTrancheCommission.tmpl");
					qSave.setParam("Regle_Id", oor_currentRegleId);
				}
				else {
					qSave = new QueryHttp("Facturation/Commerciaux/updateTrancheCommission.tmpl");
					qSave.setParam("Tranche_Id", oor_currentTrancheId);
				}

				qSave.setParam("Valeur", valeur);
				qSave.setParam("Borne_Inf", borneInf);
				qSave.setParam("Borne_Sup", borneSup);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oor_nouveauTranche();
					oor_listerRegles();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
