/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var aAdresses = new Arbre("Facturation/Fournisseurs/list-adresseFournisseur.tmpl", "tree-adresses");
var aContacts = new Arbre("ComboListe/combo-contactsFournisseur.tmpl", "Contact");
var aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "depotStock");

var curDepot;
var fournisseurId;
var currentAdr = -1;


function init() {
  try {

  	fournisseurId = ParamValeur("Fournisseur_Id");

		document.getElementById('Principale').collapsed = (ParamValeur("NoPrinc")=="1");

  	var aPays = new Arbre("ComboListe/combo-pays.tmpl", "Code_Pays");
		aPays.initTree(initContacts);

  } catch (e) {
    recup_erreur(e);
  }
}


function initContacts() {
	try {

    aContacts.setParam("Fournisseur_Id", fournisseurId);
		aContacts.initTree(initAdresses);

	} catch (e) {
    recup_erreur(e);
  }
}


function initAdresses() {
	try {

    aAdresses.setParam("Fournisseur_Id", fournisseurId);
		aAdresses.initTree(nouveauAdr);

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauAdr() {
	try {

		aAdresses.clearSelection();

		currentAdr=-1;

		document.getElementById('Intitule').value = "";
		document.getElementById('Denomination').value = "";
		document.getElementById('Adresse_1').value = "";
		document.getElementById('Adresse_2').value = "";
		document.getElementById('Adresse_3').value = "";
		document.getElementById('Code_Postal').value = "";
		document.getElementById('Ville').value = "";
		document.getElementById('Code_Pays').value = "FR";
		document.getElementById('Defaut').checked = false;
		document.getElementById('Defaut').disabled = false;
		document.getElementById('Contact').value = "";
		document.getElementById('Principale').checked = false;
		document.getElementById('Principale').disabled = false;

		chargerDepots("");

		document.getElementById('bNouveauAdr').collapsed = true;
		document.getElementById('bSupprimerAdr').collapsed = true;
		document.getElementById('bModifierAdr').collapsed = true;
		document.getElementById('bCreerAdr').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}

function supprimerAdr() {
	try {

		var denomination = document.getElementById('Denomination').value;

		if (window.confirm("Confirmez-vous la suppression de l'adresse '"+ denomination +"' ?")) {

			var qDelete = new QueryHttp("Facturation/Fournisseurs/deleteAdresseFournisseur.tmpl");
			qDelete.setParam('Adresse_Id', currentAdr);
			var result = qDelete.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('bSupprimerAdr').collapsed = true;
				document.getElementById('bModifierAdr').collapsed = true;
				document.getElementById('bCreerAdr').collapsed = false;
				document.getElementById('bNouveauAdr').collapsed = true;
				aAdresses.initTree();
				nouveauAdr();
			}
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function chargerAdr() {
	try {

		if (aAdresses.isSelected()) {
			var i = aAdresses.getCurrentIndex();

			currentAdr = aAdresses.getCellValue(i, 'ColDenomination');

			document.getElementById('Intitule').value = aAdresses.getCellText(i, 'ColIntitule');
			document.getElementById('Denomination').value = aAdresses.getCellText(i, 'ColDenomination');
			document.getElementById('Adresse_1').value = aAdresses.getCellText(i, 'ColAdresse_1');
			document.getElementById('Adresse_2').value = aAdresses.getCellText(i, 'ColAdresse_2');
			document.getElementById('Adresse_3').value = aAdresses.getCellText(i, 'ColAdresse_3');
			document.getElementById('Code_Postal').value = aAdresses.getCellText(i, 'ColCode_Postal');
			document.getElementById('Ville').value = aAdresses.getCellText(i, 'ColVille');
			document.getElementById('Code_Pays').value = aAdresses.getCellText(i, 'ColCode_Pays');
			document.getElementById('Defaut').checked = (aAdresses.getCellText(i, 'ColDefaut')=="true");
			document.getElementById('Defaut').disabled = document.getElementById('Defaut').checked;
			document.getElementById('Principale').checked = (aAdresses.getSelectedCellText('ColPrincipale')=="true");
			document.getElementById('Principale').disabled = document.getElementById('Principale').checked;

			chargerDepots(aAdresses.getCellText(i, 'colDepotStock'));

			document.getElementById('Contact').value = aAdresses.getCellText(i, 'ColContact');

			document.getElementById('bSupprimerAdr').collapsed = false;
			document.getElementById('bModifierAdr').collapsed = false;
			document.getElementById('bNouveauAdr').collapsed = false;
			document.getElementById('bCreerAdr').collapsed = true;
		}

 	} catch (e) {
    recup_erreur(e);
  }
}


function changergroupbox(check) {
	try {

		window.resizeTo(1000,check?700:400);
		document.getElementById('Group_Adresse').collapsed=!check;

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirAdresse() {
  try {

		if (currentAdr!=-1) {
			var i = aAdresses.getCurrentIndex();

			var nom = aAdresses.getCellText(i, 'ColDenomination');
   		var adr1 = aAdresses.getCellText(i, 'ColAdresse_1');
			var adr2 = aAdresses.getCellText(i, 'ColAdresse_2');
			var adr3 = aAdresses.getCellText(i, 'ColAdresse_3');
			var cp = aAdresses.getCellText(i, 'ColCode_Postal');
			var ville = aAdresses.getCellText(i, 'ColVille');
			var pays = aAdresses.getCellText(i, 'ColPays');
			var code_pays = aAdresses.getCellText(i, 'ColCode_Pays');
			var contact = aAdresses.getCellText(i, 'ColContact');
			var depotId = aAdresses.getCellText(i, 'colDepotStock');
			var principale = aAdresses.getCellText(i, 'ColPrincipale');

			window.arguments[0](nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact, depotId, currentAdr, principale);
    	window.close();
		} else {
			showWarning("Veuillez s\u00E9lectionner une adresse !");
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
    	ouvrirAdresse();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerAdr(mode) {
  try {

		var intitule = document.getElementById('Intitule').value;
    var denomination = document.getElementById('Denomination').value;
		var adresse_1 = document.getElementById('Adresse_1').value;
		var adresse_2 = document.getElementById('Adresse_2').value;
		var adresse_3 = document.getElementById('Adresse_3').value;
		var code_postal = document.getElementById('Code_Postal').value;
		var ville = document.getElementById('Ville').value;
		var code_pays = document.getElementById('Code_Pays').value;
		var defaut = document.getElementById('Defaut').checked;
		var contact = document.getElementById('Contact').value;
		var depot = document.getElementById('depotStock').value;
		var principale = document.getElementById('Principale').checked;

		if (isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination !"); }
		else if (isEmpty(adresse_1)) { showWarning("Veuillez sp\u00E9cifier l'adresse !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville !"); }
		else {

			var qSaveAdr;

			if (mode=="C") {
				qSaveAdr = new QueryHttp("Facturation/Fournisseurs/createAdresseFournisseur.tmpl");
			}
			else {
				qSaveAdr = new QueryHttp("Facturation/Fournisseurs/updateAdresseFournisseur.tmpl");
				qSaveAdr.setParam('Adresse_Id', currentAdr);
			}

			qSaveAdr.setParam('Fournisseur_Id', fournisseurId);
			qSaveAdr.setParam('Intitule', intitule);
			qSaveAdr.setParam('Denomination', denomination);
			qSaveAdr.setParam('Adresse_1', adresse_1);
			qSaveAdr.setParam('Adresse_2', adresse_2);
			qSaveAdr.setParam('Adresse_3', adresse_3);
			qSaveAdr.setParam('Code_Postal', code_postal);
			qSaveAdr.setParam('Ville', ville);
			qSaveAdr.setParam('Code_Pays', code_pays);
			qSaveAdr.setParam('Defaut', defaut);
			qSaveAdr.setParam('Contact', contact);
			qSaveAdr.setParam('Depot_Defaut', depot);
			qSaveAdr.setParam('Principale', principale);

			var result = qSaveAdr.execute();

			document.getElementById('Defaut').disabled = defaut;
			document.getElementById('Principale').disabled = principale;

			if (mode=="C") {
				currentAdr = result.responseXML.documentElement.getAttribute('Adresse_Id');

				document.getElementById('bCreerAdr').collapsed = true;
				document.getElementById('bModifierAdr').collapsed = false;
				document.getElementById('bNouveauAdr').collapsed = false;
				document.getElementById('bSupprimerAdr').collapsed = false;
			}

			aAdresses.initTree(scrollToNum);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function scrollToNum() {
	try {
		var tree = document.getElementById("tree-adresses");

		if (tree.view!=null && tree.view.rowCount>0 && currentAdr>-1) {

			var i = 0;
			var trouve = false;

			while (!trouve && i<tree.view.rowCount) {
				if (parseIntBis(aAdresses.getCellValue(i,'ColDenomination'))==currentAdr) {
					aAdresses.ensureRowIsVisible(i);
					aAdresses.select(i);
					trouve = true;
				}

				i++;
			}
			if (!trouve) aAdresses.ensureRowIsVisible(tree.view.rowCount-1);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function chargerDepots(selection) {
	try {
		curDepot = selection;
		aDepots.setParam("Selection", selection);
		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Quarantaine", false);
		aDepots.initTree(initDepot);
	} catch (e) {
		recup_erreur(e);
	}
}


function initDepot() {
	try {
		document.getElementById('depotStock').value = curDepot;
	} catch (e) {
		recup_erreur(e);
	}
}

