/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ooe_aEcarts = new Arbre("Facturation/Controle_Achats/list-ecartFacturationFournisseur.tmpl", "ooe-listeEcarts");
var ooe_aMotifs = new Arbre("ComboListe/combo-motifsEcartFacturation.tmpl", "ooe-motifIdFE");

var ooe_qListEFF = new QueryHttp("Facturation/Controle_Achats/getDataListEFF.tmpl");

var ooe_pageCourante;
var ooe_nbPages;

var ooe_currentEcartId = "";
var ooe_selMotifId = "";
var ooe_specLHCNV;



function ooe_initOngletEcartsFacturation() {
	try {

		ooe_specLHCNV = getConfig().isSpecLHCNV();
		if (ooe_specLHCNV) {
			document.getElementById('ooe-etatFacture').collapsed = false;
			document.getElementById('ooe-libEtatFacture').collapsed = false;
			document.getElementById('ooe-colEtatFacture').collapsed = false;
			document.getElementById('ooe-colEtatFacture').removeAttribute("ignoreincolumnpicker");
			document.getElementById('ooe-bValiderFacture').collapsed = false;
		}

		ooe_genererEcartsFacturation();
		ooe_initCriteres();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooe_genererEcartsFacturation() {
	try {

		var qGenEF = new QueryHttp("Facturation/Controle_Achats/generateEcartsFacturation.tmpl");
		qGenEF.execute(ooe_finGenererEcartsFacturation); // lancement asynchrone

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_finGenererEcartsFacturation() {
	try {

		// rien  faire

	} catch (e) {}
}


function ooe_initCriteres() {
	try {

		document.getElementById('ooe-numFacture').value = "";
		document.getElementById('ooe-numFournisseur').value = "";
		document.getElementById('ooe-etat').value = "N";
		document.getElementById('ooe-typeEcart').value = "";
		document.getElementById('ooe-dateFactureDebut').value = "";
		document.getElementById('ooe-dateFactureFin').value = "";
		document.getElementById('ooe-etatFacture').value = ooe_specLHCNV?"":"V";

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_listerEcarts() {
	try {

		var numFacture = document.getElementById('ooe-numFacture').value;
		var numFournisseur = document.getElementById('ooe-numFournisseur').value;
		var etat = document.getElementById('ooe-etat').value;
		var typeEcart = document.getElementById('ooe-typeEcart').value;
		var dateFactureDebut = document.getElementById('ooe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('ooe-dateFactureFin').value;
		var etatFacture = document.getElementById('ooe-etatFacture').value;
		var nbLignesParPage = document.getElementById('ooe-nbLignesParPage').value;

		if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			ooe_pageCourante = 1;
			ooe_nbPages = 1;
			document.getElementById('ooe-pageDeb').value = 1;
			document.getElementById('ooe-pageFin').value = 1;
			document.getElementById('ooe-bPrec').disabled = true;
			document.getElementById('ooe-bSuiv').disabled = true;

			document.getElementById('ooe-listeEcarts').disabled = true;
			document.getElementById('ooe-bEditionCsv').disabled = true;
			ooe_aEcarts.deleteTree();

			ooe_qListEFF.setParam("Num_Facture", numFacture);
			ooe_qListEFF.setParam("Num_Fournisseur", numFournisseur);
			ooe_qListEFF.setParam("Etat", etat);
			ooe_qListEFF.setParam("Type_Ecart", typeEcart);
			ooe_qListEFF.setParam("Date_Facture_Debut", dateFactureDebut);
			ooe_qListEFF.setParam("Date_Facture_Fin", dateFactureFin);
			ooe_qListEFF.setParam("Etat_Facture", etatFacture);
			ooe_qListEFF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			ooe_qListEFF.setParam("Current_Page", ooe_pageCourante);

			var result = ooe_qListEFF.execute();

			var contenu = result.responseXML.documentElement;

			ooe_nbPages = contenu.getAttribute("Nb_Pages");
			var listEcartId = contenu.getAttribute("List_Ecart_Id");

			ooe_aEcarts.setParam("List_Ecart_Id", listEcartId);
			ooe_aEcarts.initTree(ooe_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_initPagination() {
	try {

		document.getElementById('ooe-pageDeb').value = ooe_pageCourante;
		document.getElementById('ooe-pageFin').value = (ooe_nbPages>0?ooe_nbPages:1);
		document.getElementById('ooe-bPrec').disabled = (ooe_pageCourante==1);
		document.getElementById('ooe-bSuiv').disabled = (ooe_pageCourante>=ooe_nbPages); // peut se produire si ooe_nbPages=0

		ooe_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_pressOnPagePrec() {
	try {

		ooe_pageCourante--;
		ooe_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_pressOnPageSuiv() {
	try {

		ooe_pageCourante++;
		ooe_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_majPagination() {
	try {

		document.getElementById('ooe-pageDeb').value = ooe_pageCourante;
		document.getElementById('ooe-bPrec').disabled = (ooe_pageCourante==1);
		document.getElementById('ooe-bSuiv').disabled = (ooe_pageCourante==ooe_nbPages);

		document.getElementById('ooe-listeEcarts').disabled = true;
		document.getElementById('ooe-bEditionCsv').disabled = true;

		ooe_qListEFF.setParam("Current_Page", ooe_pageCourante);
		var result = ooe_qListEFF.execute();
		var listEcartId = result.responseXML.documentElement.getAttribute("List_Ecart_Id");

		ooe_aEcarts.setParam("List_Ecart_Id", listEcartId);
		ooe_aEcarts.initTree(ooe_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_afterMajPagination() {
	try {

		document.getElementById('ooe-listeEcarts').disabled = false;
		document.getElementById('ooe-bEditionCsv').disabled=(ooe_aEcarts.nbLignes()==0);
		ooe_resetEcartFacturation();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_resetEcartFacturation() {
	try {

		ooe_currentEcartId = "";
		document.getElementById("ooe-typeEcartFE").value = "";
		document.getElementById("ooe-etatFE").value = "";
		ooe_chargerMotif("");
		document.getElementById("ooe-valeurCommandeFE").value = "";
		document.getElementById("ooe-valeurFactureFE").value = "";
		document.getElementById("ooe-commentairesFE").value = "";

		document.getElementById("ooe-dateFactureFE").value = "";
		document.getElementById("ooe-numFactureFE").value = "";
		document.getElementById("ooe-numFournisseurFE").value = "";
		document.getElementById("ooe-denominationFE").value = "";
		document.getElementById("ooe-referenceFE").value = "";
		document.getElementById("ooe-refFournisseurFE").value = "";
		document.getElementById("ooe-designationFE").value = "";
		document.getElementById("ooe-bValiderFacture").disabled = true;

		document.getElementById("ooe-groupLigne").collapsed = true;

		document.getElementById("ooe-commentairesFE").disabled = true;
		document.getElementById("ooe-motifIdFE").disabled = true;

		document.getElementById("ooe-bDemandeAvoir").collapsed = true;
		document.getElementById("ooe-bCloturer").disabled = true;
		document.getElementById("ooe-bEnregistrer").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_selectOnListeEcarts() {
	try {

		if (ooe_aEcarts.isSelected()) {
			ooe_currentEcartId = ooe_aEcarts.getSelectedCellText('ooe-colEcartId');
			ooe_chargerEcartFacturation();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_chargerEcartFacturation() {
	try {

		if (!isEmpty(ooe_currentEcartId)) {
			var qLoad = new QueryHttp("Facturation/Controle_Achats/loadEcartFacturationFournisseur.tmpl");
			qLoad.setParam("Ecart_Id", ooe_currentEcartId);

			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById("ooe-typeEcartFE").value = contenu.getAttribute("Lib_Type_Ecart");
				document.getElementById("ooe-etatFE").value = contenu.getAttribute("Lib_Etat");
				ooe_chargerMotif(contenu.getAttribute("Motif_Id"));
				document.getElementById("ooe-valeurCommandeFE").value = contenu.getAttribute("Valeur_Commande");
				document.getElementById("ooe-valeurFactureFE").value = contenu.getAttribute("Valeur_Facture");
				document.getElementById("ooe-commentairesFE").value = contenu.getAttribute("Commentaires");

				document.getElementById("ooe-dateFactureFE").value = contenu.getAttribute("Date_Facture");
				document.getElementById("ooe-numFactureFE").value = contenu.getAttribute("Num_Facture");
				document.getElementById("ooe-numFournisseurFE").value = contenu.getAttribute("Num_Fournisseur");
				document.getElementById("ooe-denominationFE").value = contenu.getAttribute("Denomination");
				document.getElementById("ooe-referenceFE").value = contenu.getAttribute("Reference");
				document.getElementById("ooe-refFournisseurFE").value = contenu.getAttribute("Ref_Fournisseur");
				document.getElementById("ooe-designationFE").value = contenu.getAttribute("Designation");
				document.getElementById("ooe-groupLigne").collapsed = isEmpty(contenu.getAttribute("Reference"));

				var etat = contenu.getAttribute("Etat");
				var avoirPossible = contenu.getAttribute("Avoir_Possible")=="true";

				document.getElementById("ooe-commentairesFE").disabled = etat!="N";
				document.getElementById("ooe-motifIdFE").disabled = etat!="N";

				document.getElementById("ooe-bDemandeAvoir").collapsed = etat!="N" || !avoirPossible;
				document.getElementById("ooe-bCloturer").disabled = etat!="N";
				document.getElementById("ooe-bEnregistrer").disabled = etat!="N";

				document.getElementById("ooe-bValiderFacture").disabled = contenu.getAttribute("Statut_Facture")!="N";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ooe_listerEcarts();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ooe_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ooe_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('ooe-numFournisseur').value = numFournisseur;
  	ooe_listerEcarts();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_demandeAvoirFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/controle_achats/popup-demandeAvoirFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ooe_retourDemandeAvoirFournisseur, ooe_currentEcartId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_retourDemandeAvoirFournisseur(demandeId) {
	try {

		ooe_enregistrerEcartFacturation();
		visualiserDemandeAvoirFournisseur(demandeId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_chargerMotif(selection) {
	try {

		ooe_selMotifId = selection;
		ooe_aMotifs.setParam("Selection", ooe_selMotifId);
		ooe_aMotifs.initTree(ooe_initMotifId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_initMotifId() {
  try {

		document.getElementById('ooe-motifIdFE').value = ooe_selMotifId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ooe_enregistrerEcartFacturation() {
  try {

		var commentaires = document.getElementById("ooe-commentairesFE").value;
		var motifId = document.getElementById("ooe-motifIdFE").value;

		var qSave = new QueryHttp("Facturation/Controle_Achats/updateEcartFacturationFournisseur.tmpl");
		qSave.setParam("Ecart_Id", ooe_currentEcartId);
		qSave.setParam("Motif_Id", motifId);
		qSave.setParam("Commentaires", commentaires);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		ooe_listerEcarts();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ooe_cloturerEcartFacturation() {
  try {

		var commentaires = document.getElementById("ooe-commentairesFE").value;
		var motifId = document.getElementById("ooe-motifIdFE").value;

		if (isEmpty(motifId)) {
			showWarning("Veuillez s\u00E9lectionner un motif");
		}
		else {
			var qClose = new QueryHttp("Facturation/Controle_Achats/closeEcartFacturationFournisseur.tmpl");
			qClose.setParam("Ecart_Id", ooe_currentEcartId);
			qClose.setParam("Motif_Id", motifId);
			qClose.setParam("Commentaires", commentaires);

			var result = qClose.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ooe_listerEcarts();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ooe_pressOnEditionCsv() {
	try {

		var numFacture = document.getElementById('ooe-numFacture').value;
		var numFournisseur = document.getElementById('ooe-numFournisseur').value;
		var etat = document.getElementById('ooe-etat').value;
		var typeEcart = document.getElementById('ooe-typeEcart').value;
		var dateFactureDebut = document.getElementById('ooe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('ooe-dateFactureFin').value;
		var etatFacture = document.getElementById('ooe-etatFacture').value;

		if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Controle_Achats/csvEcartFacturationFournisseur.tmpl");

			qEditionCsv.setParam("Num_Facture", numFacture);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Type_Ecart", typeEcart);
			qEditionCsv.setParam("Date_Facture_Debut", dateFactureDebut);
			qEditionCsv.setParam("Date_Facture_Fin", dateFactureFin);
			qEditionCsv.setParam("Etat_Facture", etatFacture);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_validerFacture() {
  try {

		if (ooe_aEcarts.isSelected() && window.confirm("Confirmez-vous la validation de la facture ?")) {
			var factureId = ooe_aEcarts.getSelectedCellText("ooe-colFactureId");

			var qValid = new QueryHttp("Facturation/Factu_Fournisseur/validFactureFournisseur.tmpl");
			qValid.setParam("Facture_Id", factureId);

			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ooe_listerEcarts();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}
