/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Requte QueryHttp d'enregistrement de la prvision d'cart
		- 1 : Valeur attendue de la prvision
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aLignes = new Arbre("Facturation/Controle_Achats/list-lignesForPrevision.tmpl", "listeLignes");

var fournisseurId = "";
var articleId = "";



function init() {
  try {

		var valeurAttendue = window.arguments[1];
		aLignes.setParam("Valeur_Attendue", valeurAttendue);

  } catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(b) {
	try {

		for (var i=0; i<aLignes.nbLignes(); i++) {
			aLignes.setCellValue(i, "colSelLigne", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function viderRefArticle() {
  try {

		document.getElementById("refArticle").value = "";
		articleId = "";
		listerLignes();

  } catch (e) {
    recup_erreur(e);
  }
}


function viderNumFournisseur() {
  try {

		document.getElementById("numFournisseur").value = "";
		fournisseurId = "";
		listerLignes();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerLignes();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function listerLignes() {
	try {

		var numCommande = document.getElementById("numCommande").value;

		if (!isEmpty(fournisseurId) || !isEmpty(articleId) || !isEmpty(numCommande)) {
			aLignes.setParam("Fournisseur_Id", fournisseurId);
			aLignes.setParam("Num_Commande", numCommande);
			aLignes.setParam("Article_Id", articleId);
			aLignes.initTree();
		}
		else {
			aLignes.deleteTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rattacherLignes() {
	try {

		var listLigneId = "";

		for (var i=0; i<aLignes.nbLignes(); i++) {
			if (aLignes.getCellValue(i, "colSelLigne")=="true") {
				listLigneId += aLignes.getCellText(i, "colLigneId") +",";
			}
		}

		if (isEmpty(listLigneId)) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else {
			window.arguments[0].setParam("List_Ligne_Id", listLigneId);
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherFournisseur(numFournisseur, pFournisseurId) {
	try {

  	document.getElementById('numFournisseur').value = numFournisseur;
		fournisseurId = pFournisseurId;
  	listerLignes();

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle, "A", null, null, null, fournisseurId);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherArticle(reference, pArticleId) {
	try {

  	document.getElementById('refArticle').value = reference;
		articleId = pArticleId;
  	listerLignes();

	} catch (e) {
		recup_erreur(e);
	}
}

