/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var depotDefaut;
var etablissementDefaut;
var config;



function init() {
  try {

		window.parent.addEventListener("close", onCloseWindow, false);

		config = getConfig();

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		var result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		document.getElementById('deck').selectedIndex = 0;

  	omcd_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuCrossDock() {
	try {

		if (checkPrinting()) {
			omcd_listerExpeditions();

			document.getElementById('pdfExpeditions').setAttribute("src", "");
			document.getElementById('deck').selectedIndex = 0;
			document.getElementById('bRetourExpeditions').collapsed = true;

			document.activeElement.blur();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		if (checkPrinting()) {
			window.parent.removeEventListener("close", onCloseWindow, false);
			window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function checkPrinting() {
  try {

		return document.getElementById('deck').selectedIndex!=1 || window.confirm("Avant de quitter ce listing, assurez-vous de l'avoir imprim\u00E9. Voulez-vous continuer ?");

	} catch (e) {
    recup_erreur(e);
		return true;
  }
}


function onCloseWindow(evt) {
  try {

		if (!checkPrinting()) {
			evt.preventDefault();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function quitWithCheck() {
  try {

		if (checkPrinting()) {
			window.parent.removeEventListener("close", onCloseWindow, false);
			quit();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
