/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omcd_aListeExpeditions = new Arbre("Facturation/Crossdock/list-expeditionCrossDock.tmpl", "omcd-listeExpeditions");
var omcd_aApercuCommande = new Arbre("Facturation/Affaires/liste-apercuCommande.tmpl", "omcd-apercuCommande");
var omcd_aProvenances = new Arbre("ComboListe/combo-sitesWeb.tmpl", "omcd-provenance");
var omcd_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl", "omcd-modeExpedition");
var omcd_aEtablissements = new Arbre("ComboListe/combo-etablissements.tmpl", "omcd-etablissement");
var omcd_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "omcd-depot");
var omcd_aTransporteurs = new Arbre("ComboListe/combo-transporteurs.tmpl", "omcd-transporteur");


var omcd_defautProvenance = "";
var omcd_defautEtatPaiement = "";
var omcd_defautExpediable = "T";
var omcd_prefillDateFinLiv;



function omcd_init() {
	try {

		document.getElementById("omcd-bValider").disabled = true;

		var ecommerce = config.isECommerce();
		document.getElementById('omcd-lblProvenance').collapsed = !ecommerce;
		document.getElementById('omcd-provenance').collapsed = !ecommerce;
		document.getElementById('omcd-colProvenance').collapsed = !ecommerce;

		omcd_prefillDateFinLiv = config.isECDPrefillDateExp();

		omcd_aEtablissements.initTree(omcd_initEtablissement);

		document.getElementById('omcd-miProvenanceHL').collapsed = !getProfil().isProvenanceHL();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_initEtablissement() {
	try {

		document.getElementById('omcd-etablissement').value = etablissementDefaut;
		omcd_aDepots.setParam("Depot_Logistique", false);
		omcd_aDepots.setParam("Depot_Vente", false);
		omcd_aDepots.setParam("Depot_Quarantaine", false);
		omcd_aDepots.initTree(omcd_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_initDepot() {
	try {

		document.getElementById('omcd-depot').value = depotDefaut;
		omcd_aProvenances.initTree(omcd_initProvenance);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_initProvenance() {
	try {

		document.getElementById("omcd-provenance").value = omcd_defautProvenance;
		omcd_aModesExpedition.initTree(omcd_initModeExpedition);

	}	catch (e)	{
  	recup_erreur(e);
	}
}


function omcd_initModeExpedition() {
	try {

		document.getElementById('omcd-modeExpedition').selectedIndex = 0;
		omcd_aTransporteurs.initTree(omcd_initTransporteur);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_initTransporteur() {
	try {

		document.getElementById('omcd-transporteur').selectedIndex = 0;
		omcd_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			omcd_listerExpeditions();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_initCriteres() {
	try {

		document.getElementById("omcd-statutPaiement").value = omcd_defautEtatPaiement;
		document.getElementById('omcd-etablissement').value = etablissementDefaut;
		document.getElementById('omcd-depot').value = depotDefaut;
		document.getElementById("omcd-provenance").value = omcd_defautProvenance;
		document.getElementById('omcd-modeExpedition').selectedIndex = 0;
		document.getElementById('omcd-transporteur').selectedIndex = 0;
		document.getElementById("omcd-expediable").value = omcd_defautExpediable;
		document.getElementById('omcd-dateDebut').value = "";
		document.getElementById('omcd-dateFin').value = "";
		document.getElementById('omcd-dateDebutLiv').value = "";
		document.getElementById('omcd-dateFinLiv').value = omcd_prefillDateFinLiv?getDateCourante():"";
		document.getElementById('omcd-zoneLivraison').value = "";
		document.getElementById('omcd-refArticle').value = "";
		document.getElementById('omcd-rupture').checked = false;

		omcd_manageFiltreRupture();
		omcd_listerExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_listerExpeditions() {
	try {

		document.getElementById("omcd-bValider").disabled = true;

		var provenance = document.getElementById("omcd-provenance").value;
		var modeExpedition = document.getElementById("omcd-modeExpedition").value;
		var transporteur = document.getElementById("omcd-transporteur").value;
		var expediable = document.getElementById("omcd-expediable").value;
		var statutPaiement = document.getElementById("omcd-statutPaiement").value;
		var dateDebut = document.getElementById('omcd-dateDebut').value;
		var dateFin = document.getElementById('omcd-dateFin').value;
		var dateDebutLiv = document.getElementById('omcd-dateDebutLiv').value;
		var dateFinLiv = document.getElementById('omcd-dateFinLiv').value;
		var depot = document.getElementById('omcd-depot').value;
		var etablissement = document.getElementById('omcd-etablissement').value;
		var zoneLivraison = document.getElementById('omcd-zoneLivraison').value;
		var refArticle = document.getElementById('omcd-refArticle').value;
		var rupture = document.getElementById('omcd-rupture').checked;

		if (!isEmpty(dateDebut) && !isDateTime(dateDebut)) { showWarning("Date commande de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFin) && !isDateTime(dateFin)) { showWarning("Date commande de fin incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateTimeInterval(dateDebut, dateFin)) { showWarning("Plage de dates de commande incorrecte"); }
		else if (!isEmpty(dateDebutLiv) && !isDate(dateDebutLiv)) { showWarning("Date exp\u00E9dition de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFinLiv) && !isDate(dateFinLiv)) { showWarning("Date exp\u00E9dition de fin incorrecte"); }
		else if (!isEmpty(dateDebutLiv) && !isEmpty(dateFinLiv) && !isDateInterval(dateDebutLiv, dateFinLiv)) { showWarning("Plage de dates d'exp\u00E9dition incorrecte"); }
		else if (isEmpty(depot)) { showWarning("Veuillez s\u00E9lectionner un d\u00E9pot de stock"); }
		else {

			omcd_aApercuCommande.deleteTree();
			document.getElementById('omcd-numCommandeSelect').value = "";

			omcd_aListeExpeditions.setParam("Provenance", provenance);
			omcd_aListeExpeditions.setParam("Mode_Expedition", modeExpedition);
			omcd_aListeExpeditions.setParam("Transporteur", transporteur);
			omcd_aListeExpeditions.setParam("Expediable", expediable);
			omcd_aListeExpeditions.setParam("Statut_Paiement", statutPaiement);
			omcd_aListeExpeditions.setParam("Date_Debut", dateDebut);
			omcd_aListeExpeditions.setParam("Date_Fin", dateFin);
			omcd_aListeExpeditions.setParam("Date_Debut_Liv", dateDebutLiv);
			omcd_aListeExpeditions.setParam("Date_Fin_Liv", dateFinLiv);
			omcd_aListeExpeditions.setParam("Depot_Id", depot);
			omcd_aListeExpeditions.setParam("Etab_Id", etablissement);
			omcd_aListeExpeditions.setParam("Zone_Livraison", zoneLivraison);
			omcd_aListeExpeditions.setParam("Ref_Article", refArticle);
			omcd_aListeExpeditions.setParam("Rupture", rupture);
			omcd_aListeExpeditions.initTree(omcd_afterRefreshExpeditions);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_afterRefreshExpeditions() {
	try {

		omcd_compterLignesCochees();
		document.getElementById("omcd-bValider").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_compterLignesCochees() {
	try {

		var nbCoches = 0;

		for (var i=0; i<omcd_aListeExpeditions.nbLignes(); i++) {
			if (omcd_aListeExpeditions.getCellValue(i, "omcd-colSelect")=="true") {
				nbCoches++;
			}
  	}

		document.getElementById('omcd-lblNbLignesCochees').value = nbCoches;

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_editionCommentairesNonImprimablesCC() {
	try {

		if (omcd_aListeExpeditions.isSelected()) {
			var commandeId = omcd_aListeExpeditions.getSelectedCellText("omcd-colCommandeId");
			var url = "chrome://opensi/content/facturation/user/crossdock/popup-editionCommentairesNonImprimablesCC.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', commandeId, omcd_listerExpeditions);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_selectOnListeExpeditions() {
	try {

		if (omcd_aListeExpeditions.isSelected()) {
			var commandeId = omcd_aListeExpeditions.getSelectedCellText("omcd-colCommandeId");
			var numCommande = omcd_aListeExpeditions.getSelectedCellText("omcd-colNumCommande");
			var editionTTC = omcd_aListeExpeditions.getSelectedCellText("omcd-colEditionTTC")=="true";

			document.getElementById('omcd-colMontantAC').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");

			document.getElementById('omcd-numCommandeSelect').value = "Aper\u00E7u de la commande N\u00B0 "+ numCommande +" :";
			omcd_listerApercuCommande(commandeId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_pressOnListeExpeditions(ev) {
	try {

		if (ev.keyCode==32 && omcd_aListeExpeditions.isSelected()) {
			omcd_aListeExpeditions.setSelectedCellValue("omcd-colSelect", omcd_aListeExpeditions.getSelectedCellValue("omcd-colSelect")=="false");
			omcd_compterLignesCochees();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_listerApercuCommande(commandeId) {
	try {

		omcd_aApercuCommande.setParam("Commande_Id", commandeId);
		omcd_aApercuCommande.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_toutCocher(b) {
	try {

		document.getElementById("omcd-bValider").disabled = true;

		for (var i=0; i<omcd_aListeExpeditions.nbLignes(); i++) {
			if (omcd_aListeExpeditions.isEditable(i, "omcd-colSelect")) {
				omcd_aListeExpeditions.setCellValue(i, "omcd-colSelect", b);
  		}
		}

		omcd_compterLignesCochees();
		document.getElementById("omcd-bValider").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_valider() {
	try {

		document.getElementById("omcd-bValider").disabled = true;

		var listCommandeId = "";

		for (var i=0; i<omcd_aListeExpeditions.nbLignes(); i++) {
			if (omcd_aListeExpeditions.getCellValue(i, "omcd-colSelect")=="true") {
				listCommandeId += omcd_aListeExpeditions.getCellText(i, "omcd-colCommandeId") +",";
			}
  	}

		if (isEmpty(listCommandeId)) {
			showWarning("Veuillez cocher au moins une commande");
		}
		else if (window.confirm("Confirmez-vous la validation des exp\u00E9ditions ?")) {

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			var qGen = new QueryHttp("Facturation/Crossdock/validExpeditionCrossDock.tmpl");
			qGen.setParam('List_Commande_Id', listCommandeId);

			qGen.execute(omcd_valider_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_valider_2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdfExpeditions').setAttribute("src", page);
		}

		document.getElementById('bRetourExpeditions').collapsed = false;

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/crossdock/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function omcd_manageFiltreRupture() {
  try {

		document.getElementById("omcd-rupture").collapsed = (document.getElementById("omcd-expediable").value!="P");

	} catch (e) {
    recup_erreur(e);
  }
}


function omcd_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omcd_retourRechercherArticle, "V");

	} catch (e) {
		recup_erreur(e);
	}
}


function omcd_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omcd-refArticle').value = reference;
  	omcd_listerExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}
