/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omd_aDEB = new Arbre('Facturation/DEB/list-declarationDEB.tmpl', 'omd-listeDEB');
var omd_aApercuDEB = new Arbre('Facturation/DEB/list-apercuDeclarationDEB.tmpl', 'omd-apercu');
var omd_qListDEB = new QueryHttp("Facturation/DEB/getDataListDEB.tmpl");

var omd_pageCourante;
var omd_nbPages;



function omd_init() {
  try {

		omd_initCriteres();

  } catch (e) {
  	recup_erreur(e);
  }
}


function omd_initCriteres() {
	try {

		document.getElementById('omd-numero').value = "";
		document.getElementById('omd-type').value = "";
		document.getElementById('omd-etatDEB').value = "N";
		document.getElementById('omd-periodeDebut').value = "";
		document.getElementById('omd-periodeFin').value = "";

		omd_listerDEB();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_listerDEB() {
	try {

		var numero = document.getElementById('omd-numero').value;
		var typeDeclaration = document.getElementById('omd-type').value;
		var etatDEB = document.getElementById('omd-etatDEB').value;
		var periodeDebut = document.getElementById('omd-periodeDebut').value;
		var periodeFin = document.getElementById('omd-periodeFin').value;
		var nbLignesParPage = document.getElementById('omd-nbLignesParPage').value;

		if (!isEmpty(periodeDebut) && !isPeriode(periodeDebut)) { showWarning("P\u00E9riode de d\u00E9but incorrecte !"); }
		else if (!isEmpty(periodeFin) && !isPeriode(periodeFin)) { showWarning("P\u00E9riode de fin incorrecte !"); }
		else if (!isEmpty(periodeDebut) && !isEmpty(periodeFin) && !isPeriodeInterval(periodeDebut, periodeFin)) { showWarning("Plage de p\u00E9riodes incorrecte !"); }
		else {

			omd_pageCourante = 1;
			omd_nbPages = 1;
			document.getElementById('omd-pageDeb').value = 1;
			document.getElementById('omd-pageFin').value = 1;
			document.getElementById('omd-bPrec').disabled = true;
			document.getElementById('omd-bSuiv').disabled = true;

			document.getElementById('omd-listeDEB').disabled = true;
			document.getElementById('omd-numeroSelect').value = "";
			omd_aApercuDEB.deleteTree();
			omd_aDEB.deleteTree();

			omd_qListDEB.setParam("Num_DEB", numero);
			omd_qListDEB.setParam("Type_Declaration", typeDeclaration);
			omd_qListDEB.setParam("Etat_DEB", etatDEB);
			omd_qListDEB.setParam("Periode_Debut", periodeDebut);
			omd_qListDEB.setParam("Periode_Fin", periodeFin);
			omd_qListDEB.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omd_qListDEB.setParam("Current_Page", omd_pageCourante);

			var result = omd_qListDEB.execute();

			var contenu = result.responseXML.documentElement;

			omd_nbPages = contenu.getAttribute("Nb_Pages");
			var listDeclarationId = contenu.getAttribute("List_Declaration_Id");

			omd_aDEB.setParam("List_Declaration_Id", listDeclarationId);
			omd_aDEB.initTree(omd_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initPagination() {
	try {

		document.getElementById('omd-pageDeb').value = omd_pageCourante;
		document.getElementById('omd-pageFin').value = (omd_nbPages>0?omd_nbPages:1);
		document.getElementById('omd-bPrec').disabled = (omd_pageCourante==1);
		document.getElementById('omd-bSuiv').disabled = (omd_pageCourante>=omd_nbPages); // peut se produire si omd_nbPages=0

		omd_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnPagePrec() {
	try {

		omd_pageCourante--;
		omd_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnPageSuiv() {
	try {

		omd_pageCourante++;
		omd_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_majPagination() {
	try {

		document.getElementById('omd-pageDeb').value = omd_pageCourante;
		document.getElementById('omd-bPrec').disabled = (omd_pageCourante==1);
		document.getElementById('omd-bSuiv').disabled = (omd_pageCourante==omd_nbPages);

		document.getElementById('omd-numeroSelect').value = "";

		document.getElementById('omd-listeDEB').disabled = true;
		omd_aApercuDEB.deleteTree();

		omd_qListDEB.setParam("Current_Page", omd_pageCourante);
		var result = omd_qListDEB.execute();
		var listDeclarationId = result.responseXML.documentElement.getAttribute("List_Declaration_Id");

		omd_aDEB.setParam("List_Declaration_Id", listDeclarationId);
		omd_aDEB.initTree(omd_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_afterMajPagination() {
	try {

		document.getElementById('omd-listeDEB').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_selectOnListeDEB() {
	try {

		if (omd_aDEB.isSelected()) {
			var declarationId = omd_aDEB.getSelectedCellText('omd-colDeclarationId');
			document.getElementById('omd-numeroSelect').value = omd_aDEB.getSelectedCellText('omd-colNumero');
			omd_aApercuDEB.setParam("Declaration_Id", declarationId);
			omd_aApercuDEB.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnNouveauDEB() {
	try {

		var url = "chrome://opensi/content/facturation/user/deb/popup-nouvelleDEB.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen',omd_retourNouvelleDEB);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_retourNouvelleDEB(declarationId) {
	try {

		oed_declarationId = declarationId;
		oed_chargerDEB();
		document.getElementById('bMenuDEB').collapsed = false;
		document.getElementById('deck').selectedIndex = 1;

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omd_listerDEB();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_pressOnListeDEB(ev) {
  try {

		if (ev.keyCode==13) {
			omd_ouvrirDEB();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_ouvrirDEB() {
  try {

  	if (omd_aDEB.isSelected()) {
			oed_declarationId = omd_aDEB.getSelectedCellText('omd-colDeclarationId');
			oed_chargerDEB();
			document.getElementById('bMenuDEB').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}
