/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/calculDocument.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");


var etablissementDefaut;
var gProfil;
var gConfig;
var gAccesCoutAchat;
var gReadOnly;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gProfil = getProfil();
		gAccesCoutAchat = gProfil.isAccesCoutAchat();
		gReadOnly = gProfil.isReadOnlyGC_VDevis();

		gConfig = getConfig();

		etablissementDefaut = gProfil.getEtabId();

  	document.getElementById('deck').selectedIndex = 0;
  	omd_init();
		oed_init();

		if (!isEmpty(ParamValeur("Devis_Id"))) {
			oed_devisId = ParamValeur("Devis_Id");
			oed_chargerDevis();
			document.getElementById('bMenuDevis').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
		}

		document.getElementById('bcAccesCoutAchat').collapsed = !gAccesCoutAchat;

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close",demandeEnregistrement,false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oed_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuDevis() {
	try {

		document.getElementById('omd-pdfDevis').setAttribute("src", "");
		document.getElementById('oed-pdfDevis').setAttribute("src", "");
		document.getElementById('omd-deckMenu').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuDevis').collapsed=true;
		document.getElementById('bRetourDevis').collapsed = true;

		document.activeElement.blur();
		omd_listerDevis();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourDevis() {
  try {

		document.getElementById('oed-pdfDevis').setAttribute("src", "");
		oed_chargerDevis();
		document.getElementById('oed-deckDevis').selectedIndex = 0;
		document.getElementById('bRetourDevis').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		if (currentDeck==1) { oed_demandeEnregistrement(); }

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
