/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omd_aDevis = new Arbre('Facturation/Devis/list-devis.tmpl', 'omd-listeDevis');
var omd_aApercuDevis = new Arbre('Facturation/Devis/list-apercuDevis.tmpl', 'omd-apercu');
var omd_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "omd-poleActivite");
var omd_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omd-etablissement');
var omd_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","omd-responsable");
var omd_qListDC = new QueryHttp("Facturation/Devis/getDataListDC.tmpl");

var omd_pageCourante;
var omd_nbPages;

var omd_restrictedPoleActivite = "";



function omd_init() {
  try {

		if (gProfil.isRestricAccCDVPA() && !isEmpty(gProfil.getPoleActivite())) {
			omd_restrictedPoleActivite = gProfil.getPoleActivite();
			document.getElementById('omd-poleActivite').disabled = true;
		}

  	document.getElementById('omd-boxNouveauDevis').collapsed = gReadOnly;
		document.getElementById('omd-boxArchivage').collapsed = gReadOnly;

		if (!gConfig.isActDevisWeb()) {
			document.getElementById("omd-colSiteWeb").collapsed = true;
			document.getElementById("omd-colSiteWeb").setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById("omd-boxTotaux").collapsed = !gProfil.isShowTotauxDV();

		omd_aResponsables.initTree(omd_initResponsable);

  } catch (e) {
  	recup_erreur(e);
  }
}


function omd_initResponsable() {
	try {

		if (!isEmpty(omd_restrictedPoleActivite)) {
			omd_aPolesActivite.setParam("Selection", omd_restrictedPoleActivite);
		}
		omd_aPolesActivite.initTree(omd_initSecteurActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initSecteurActivite() {
	try {

		omd_aEtablissements.setParam('Selection', etablissementDefaut);
		omd_aEtablissements.initTree(omd_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initEtablissement() {
	try {

		omd_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initCriteres() {
	try {

		document.getElementById('omd-numDevis').value = "";
		document.getElementById('omd-numClient').value = "";
		document.getElementById('omd-denomination').value = "";
		document.getElementById('omd-etatDevis').value = "T";
		document.getElementById('omd-dateDevisDebut').value = "";
		document.getElementById('omd-dateDevisFin').value = "";
		document.getElementById('omd-refArticle').value = "";
		document.getElementById('omd-intitule').value = "";
		document.getElementById('omd-etablissement').value = etablissementDefaut;
		document.getElementById('omd-poleActivite').value = omd_restrictedPoleActivite;
		document.getElementById('omd-responsable').selectedIndex = 0;
		document.getElementById('omd-montantTTC').value = "";
		document.getElementById('omd-devisType').value = "";

		omd_listerDevis();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_listerDevis() {
	try {

		var numDevis = document.getElementById('omd-numDevis').value;
		var numClient = document.getElementById('omd-numClient').value;
		var denomination = document.getElementById('omd-denomination').value;
		var etatDevis = document.getElementById('omd-etatDevis').value;
		var dateDevisDebut = document.getElementById('omd-dateDevisDebut').value;
		var dateDevisFin = document.getElementById('omd-dateDevisFin').value;
		var refArticle = document.getElementById('omd-refArticle').value;
		var poleActivite = document.getElementById('omd-poleActivite').value;
		var etablissement = document.getElementById('omd-etablissement').value;
		var intitule = document.getElementById('omd-intitule').value;
		var responsable = document.getElementById('omd-responsable').value;
		var montantTTC = document.getElementById('omd-montantTTC').value;
		var devisType = document.getElementById('omd-devisType').value;
		var nbLignesParPage = document.getElementById('omd-nbLignesParPage').value;

		if (!isEmpty(dateDevisDebut) && !isDate(dateDevisDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateDevisFin) && !isDate(dateDevisFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDevisDebut) && !isEmpty(dateDevisFin) && !isDateInterval(dateDevisDebut, dateDevisFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(montantTTC) && !isPositive(montantTTC)) { showWarning("Montant TTC incorrect !"); }
		else {

			omd_pageCourante = 1;
			omd_nbPages = 1;
			document.getElementById('omd-pageDeb').value = 1;
			document.getElementById('omd-pageFin').value = 1;
			document.getElementById('omd-bPrec').disabled = true;
			document.getElementById('omd-bSuiv').disabled = true;

			document.getElementById('omd-listeDevis').disabled = true;
			document.getElementById('omd-bEditionCsv').disabled = true;
			document.getElementById('omd-bEditerDevis').disabled = true;
			document.getElementById('omd-numDevisSelect').value = "";
			omd_aApercuDevis.deleteTree();
			omd_aDevis.deleteTree();

			omd_qListDC.setParam("Num_Devis", numDevis);
			omd_qListDC.setParam("Num_Client", numClient);
			omd_qListDC.setParam("Denomination", denomination);
			omd_qListDC.setParam("Etat_Devis", etatDevis);
			omd_qListDC.setParam("Date_Devis_Debut", dateDevisDebut);
			omd_qListDC.setParam("Date_Devis_Fin", dateDevisFin);
			omd_qListDC.setParam("Ref_Article", refArticle);
			omd_qListDC.setParam("Intitule", intitule);
			omd_qListDC.setParam("Responsable", responsable);
			omd_qListDC.setParam("Pole_Activite", poleActivite);
			omd_qListDC.setParam("Etablissement", etablissement);
			omd_qListDC.setParam("Montant_TTC", montantTTC);
			omd_qListDC.setParam("Devis_Type", devisType);
			omd_qListDC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omd_qListDC.setParam("Current_Page", omd_pageCourante);

			var result = omd_qListDC.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('omd-totalHT').value = contenu.getAttribute("Total_HT");
			omd_nbPages = contenu.getAttribute("Nb_Pages");
			var listDevisId = contenu.getAttribute("List_Devis_Id");

			omd_aDevis.setParam("List_Devis_Id", listDevisId);
			omd_aDevis.initTree(omd_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initPagination() {
	try {

		document.getElementById('omd-pageDeb').value = omd_pageCourante;
		document.getElementById('omd-pageFin').value = (omd_nbPages>0?omd_nbPages:1);
		document.getElementById('omd-bPrec').disabled = (omd_pageCourante==1);
		document.getElementById('omd-bSuiv').disabled = (omd_pageCourante>=omd_nbPages); // peut se produire si omd_nbPages=0

		omd_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnPagePrec() {
	try {

		omd_pageCourante--;
		omd_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnPageSuiv() {
	try {

		omd_pageCourante++;
		omd_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_majPagination() {
	try {
		document.getElementById('omd-pageDeb').value = omd_pageCourante;
		document.getElementById('omd-bPrec').disabled = (omd_pageCourante==1);
		document.getElementById('omd-bSuiv').disabled = (omd_pageCourante==omd_nbPages);

		document.getElementById('omd-numDevisSelect').value = "";

		document.getElementById('omd-listeDevis').disabled = true;
		document.getElementById('omd-bEditionCsv').disabled = true;
		document.getElementById('omd-bEditerDevis').disabled = true;
		omd_aApercuDevis.deleteTree();

		omd_qListDC.setParam("Current_Page", omd_pageCourante);
		var result = omd_qListDC.execute();
		var listDevisId = result.responseXML.documentElement.getAttribute("List_Devis_Id");

		omd_aDevis.setParam("List_Devis_Id", listDevisId);
		omd_aDevis.initTree(omd_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_afterMajPagination() {
	try {

		document.getElementById('omd-listeDevis').disabled = false;
		document.getElementById('omd-bEditionCsv').disabled=(omd_aDevis.nbLignes()==0);
		document.getElementById('omd-bEditerDevis').disabled=(omd_aDevis.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_selectOnListeDevis() {
	try {

		if (omd_aDevis.isSelected()) {
			var devisId = omd_aDevis.getSelectedCellText('omd-colDevisId');
			document.getElementById('omd-numDevisSelect').value = omd_aDevis.getSelectedCellText('omd-colNumDevis');
			omd_aApercuDevis.setParam("Devis_Id", devisId);
			omd_aApercuDevis.initTree();

			var editionTTC = (omd_aDevis.getSelectedCellText("omd-colEditionTTC")=="true");
			document.getElementById('omd-adColMontant').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnNouveauDevis() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuDevis').collapsed = false;
		oed_nouveauDevis();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omd_listerDevis();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_pressOnListeDevis(ev) {
  try {

		if (ev.keyCode==13) {
			omd_ouvrirDevis();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_ouvrirDevis() {
  try {

  	if (omd_aDevis.isSelected()) {
			oed_devisId = omd_aDevis.getSelectedCellText('omd-colDevisId');
			oed_chargerDevis();
			document.getElementById('bMenuDevis').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_archiver() {
  try {

		var nbMois = document.getElementById('Nb_Mois').value;

		if (isEmpty(nbMois) || !isPositiveInteger(nbMois)) {
			showWarning("Nombre de mois incorrect !");
		}
		else if (window.confirm("Confirmez-vous l'archivage des devis ?")) {

			var qArchivage = new QueryHttp("Facturation/Devis/archivingDevis.tmpl");
			qArchivage.setParam("Nb_Mois", nbMois);
			qArchivage.execute();

			showMessage("Archivage termin\u00E9");

			omd_listerDevis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omd_pressOnEditionCsv() {
	try {

		var numDevis = document.getElementById('omd-numDevis').value;
		var numClient = document.getElementById('omd-numClient').value;
		var denomination = document.getElementById('omd-denomination').value;
		var etatDevis = document.getElementById('omd-etatDevis').value;
		var dateDevisDebut = document.getElementById('omd-dateDevisDebut').value;
		var dateDevisFin = document.getElementById('omd-dateDevisFin').value;
		var refArticle = document.getElementById('omd-refArticle').value;
		var poleActivite = document.getElementById('omd-poleActivite').value;
		var etablissement = document.getElementById('omd-etablissement').value;
		var intitule = document.getElementById('omd-intitule').value;
		var responsable = document.getElementById('omd-responsable').value;
		var montantTTC = document.getElementById('omd-montantTTC').value;
		var devisType = document.getElementById('omd-devisType').value;

		if (!isEmpty(dateDevisDebut) && !isDate(dateDevisDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateDevisFin) && !isDate(dateDevisFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDevisDebut) && !isEmpty(dateDevisFin) && !isDateInterval(dateDevisDebut, dateDevisFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(montantTTC) && !isPositive(montantTTC)) { showWarning("Montant TTC incorrect !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Devis/csvDevis.tmpl");

			qEditionCsv.setParam("Num_Devis", numDevis);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat_Devis", etatDevis);
			qEditionCsv.setParam("Date_Devis_Debut", dateDevisDebut);
			qEditionCsv.setParam("Date_Devis_Fin", dateDevisFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Intitule", intitule);
			qEditionCsv.setParam("Responsable", responsable);
			qEditionCsv.setParam("Pole_Activite", poleActivite);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Montant_TTC", montantTTC);
			qEditionCsv.setParam("Devis_Type", devisType);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnEditerDevis() {
	try {

		var numDevis = document.getElementById('omd-numDevis').value;
		var numClient = document.getElementById('omd-numClient').value;
		var denomination = document.getElementById('omd-denomination').value;
		var etatDevis = document.getElementById('omd-etatDevis').value;
		var dateDevisDebut = document.getElementById('omd-dateDevisDebut').value;
		var dateDevisFin = document.getElementById('omd-dateDevisFin').value;
		var refArticle = document.getElementById('omd-refArticle').value;
		var poleActivite = document.getElementById('omd-poleActivite').value;
		var etablissement = document.getElementById('omd-etablissement').value;
		var intitule = document.getElementById('omd-intitule').value;
		var responsable = document.getElementById('omd-responsable').value;
		var montantTTC = document.getElementById('omd-montantTTC').value;
		var devisType = document.getElementById('omd-devisType').value;

		if (!isEmpty(dateDevisDebut) && !isDate(dateDevisDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateDevisFin) && !isDate(dateDevisFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDevisDebut) && !isEmpty(dateDevisFin) && !isDateInterval(dateDevisDebut, dateDevisFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(montantTTC) && !isPositive(montantTTC)) { showWarning("Montant TTC incorrect !"); }
		else {

			document.getElementById('omd-pdfDevis').setAttribute("src", "");

			var qEditionPdf = new QueryHttp("Facturation/Devis/pdfEditionDevis.tmpl");

			qEditionPdf.setParam("Num_Devis", numDevis);
			qEditionPdf.setParam("Num_Client", numClient);
			qEditionPdf.setParam("Denomination", denomination);
			qEditionPdf.setParam("Etat_Devis", etatDevis);
			qEditionPdf.setParam("Date_Devis_Debut", dateDevisDebut);
			qEditionPdf.setParam("Date_Devis_Fin", dateDevisFin);
			qEditionPdf.setParam("Ref_Article", refArticle);
			qEditionPdf.setParam("Intitule", intitule);
			qEditionPdf.setParam("Responsable", responsable);
			qEditionPdf.setParam("Pole_Activite", poleActivite);
			qEditionPdf.setParam("Etablissement", etablissement);
			qEditionPdf.setParam("Montant_TTC", montantTTC);
			qEditionPdf.setParam("Devis_Type", devisType);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('omd-deckMenu').selectedIndex = 1;
				document.getElementById('bMenuDevis').collapsed = false;
				document.getElementById('omd-pdfDevis').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen',omd_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_retourRechercherClient(numClient) {
	try {

  	document.getElementById('omd-numClient').value = numClient;
  	omd_listerDevis();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omd_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omd-refArticle').value = reference;
  	omd_listerDevis();

	} catch (e) {
		recup_erreur(e);
	}
}
