/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aListeCommandes = new Arbre("Facturation/Expedition_Lot/liste-commandes-expediables.tmpl", "liste_commandes");
var aSites = new Arbre("ComboListe/combo-sitesWeb.tmpl","Provenance");
var aModeExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","modeExpedition");
var aModifierModeExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","modifierModeExpedition");
var aMarketplaces = new Arbre("ComboListe/combo-marketplaces.tmpl", "marketplace");
var aFamillesClient = new Arbre("ComboListe/combo-famillesClient.tmpl","familleClient");

var aApercuCommande = new Arbre("Facturation/Affaires/liste-apercuCommande.tmpl","apercuCommande");
var aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'etablissement');
var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depot');
var aTransporteurs = new Arbre("ComboListe/combo-transporteurs.tmpl", "transporteur");
var aFormatsExport = new Arbre("ComboListe/combo-formatsTransporteur.tmpl", "Export_Id");
var aFournisseurs = new Arbre("Facturation/Expedition_Lot/combo-fournisseursDS.tmpl", "fournisseurId");
var aTranchesVolume = new Arbre("ComboListe/combo-tranchesVolumeConfigExpedition.tmpl", "trancheId");

var etablissementDefaut;
var depotDefaut;
var defautProvenance;
var defautEtatPaiement;
var defautTypeExpedition;
var defautExpediable;
var lastExpeditionId;
var defautEtapePrepaBLCC;
var defautEtapePickingBLCC;
var etapePrepaBL;
var etapePickingBL;
var forceEtapePrepa;
var bacs;
var confirmation;
var specEFU;
var specCET;
var specCME;
var exlGroupementClient;
var defautEditBP;
var defautEditBL;
var defautGenFC;
var defautEditFC;
var defautEditPK;
var defautEditRE;
var defautEditEtiq;
var defautEditLF;
var defautEditCF;
var defautNbBacMulti;
var defautNbBacMono;
var defautTypeConfig;
var defautGroupementClient;
var defautEXLConfig;
var prefillDateFinLiv;
var nbBacMulti;
var nbBacMono;
var actCrossDock;
var specPO;

// spcifique LH
var dateExpeditionDebutLH = "";
var dateExpeditionFinLH = "";



function init() {
	try {

		window.parent.addEventListener("close", onCloseWindow, false);

		document.getElementById("bValider").disabled = true;

		var config = getConfig();

		defautProvenance = config.getEXLProvenance();
		defautEtatPaiement = config.getEXLEtatPaiement();
		defautExpediable = config.getEXLExpediable();
		defautEtapePrepaBLCC = config.isEtapePrepaBLCC();
		defautEtapePickingBLCC = config.isEtapePickingBLCC();
		defautEditLF = config.isGACEditLF();
		defautEditCF = config.isGACEditCF();
		actCrossDock = config.isActCrossDock();
		specPO = config.isSpecCIMPO();

		document.getElementById("boxEtiqExp").collapsed = !config.isEXLEditEtiqExp();

		if (config.isSpecLHGFC()) {
			document.getElementById('lblFamilleClient').collapsed = false;
			document.getElementById('familleClient').collapsed = false;
		}

		if (!config.isSpecSMCAR()) {
			document.getElementById('colCARestant').setAttribute("hidden", true);
			document.getElementById('colCARestant').setAttribute("ignoreincolumnpicker", true);
		}
		prefillDateFinLiv = config.isEXLPrefillDateExp();

		bacs = config.isEXLBacPrepa();
		confirmation = config.isEXLConfirmation();
		specEFU = config.isSpecPCEFU();
		specCET = config.isSpecPCCET();
		specCME = config.isSpecBECME();
		exlGroupementClient = config.isEXLGroupementClient();

		var exlConfig = config.getEXLConfig();
		defautEXLConfig = exlConfig;

		var qConfExp = new QueryHttp("Config/gc/expeditions/loadConfigExpedition.tmpl");
		qConfExp.setParam('Config_Id', exlConfig);
		var result = qConfExp.execute();

		defautEditBP = result.responseXML.documentElement.getAttribute("Edit_BP")=="true";
		defautEditBL = result.responseXML.documentElement.getAttribute("Edit_BL")=="true";
		defautEditEtiq = result.responseXML.documentElement.getAttribute("Edit_Etiq")=="true";
		defautGenFC = result.responseXML.documentElement.getAttribute("Gen_FC")=="true";
		defautEditFC = result.responseXML.documentElement.getAttribute("Edit_FC")=="true";
		defautEditPK = result.responseXML.documentElement.getAttribute("Edit_PK")=="true";
		defautEditRE = result.responseXML.documentElement.getAttribute("Edit_RE")=="true";
		defautNbBacMulti = result.responseXML.documentElement.getAttribute("Nb_Bac_Multi");
		defautNbBacMono = result.responseXML.documentElement.getAttribute("Nb_Bac_Mono");
		defautTypeConfig = result.responseXML.documentElement.getAttribute("Type_Config");
		defautGroupementClient = result.responseXML.documentElement.getAttribute("Groupement_Client")=="true";

		var existeSite = config.isECommerce();
		document.getElementById('lblProvenance').collapsed = !existeSite;
		document.getElementById('Provenance').collapsed = !existeSite;
		document.getElementById('colProvenance').collapsed = !existeSite;

		document.getElementById('lblMarketplace').collapsed = !existeSite;
		document.getElementById('marketplace').collapsed = !existeSite;

		document.getElementById('bRetourExpeditions').collapsed = true;
		document.getElementById('deck').selectedIndex = 0;

		var profil = getProfil();

		document.getElementById('miProvenanceHL').collapsed = !profil.isProvenanceHL();

		etablissementDefaut = profil.getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		var typeDepotDefaut = result.responseXML.documentElement.getAttribute('Type');
		defautTypeExpedition = (typeDepotDefaut=="L"?"L":"C");

		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Quarantaine", false);

		aEtablissements.initTree(initEtablissement);

		aFormatsExport.setParam("Type_Format", "E");
		aFormatsExport.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function initEtablissement() {
	try {

		document.getElementById('etablissement').value = etablissementDefaut;
		aSites.initTree(initSite);

	} catch (e) {
		recup_erreur(e);
	}
}


function initSite() {
	try {

		document.getElementById("Provenance").value = defautProvenance;
		aModeExpedition.initTree(initMarketplace);

	}	catch (e)	{
  	recup_erreur(e);
	}
}


function initMarketplace() {
	try {

		document.getElementById("marketplace").value = "";
		aMarketplaces.initTree(initFamillesClient);

	}	catch (e)	{
  	recup_erreur(e);
	}
}


function initFamillesClient() {
	try {

		document.getElementById("familleClient").value = "";
		aFamillesClient.initTree(initModesExpedition);

	}	catch (e)	{
  	recup_erreur(e);
	}
}


function initModesExpedition() {
	try {

		document.getElementById('modeExpedition').selectedIndex = 0;
		aModifierModeExpedition.initTree(initModifierModesExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}

function initModifierModesExpedition() {
	try {

		document.getElementById('modifierModeExpedition').selectedIndex = 0;
		aTransporteurs.initTree(initTransporteur);

	} catch (e) {
		recup_erreur(e);
	}
}

function initTransporteur() {
	try {

		document.getElementById('transporteur').selectedIndex = 0;
		aFournisseurs.initTree(initFiltres);

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(event) {
	try {

		if (event.keyCode==13) {
			listerCommandes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTypeExpedition() {
	try {

		initIHM();

	} catch (e) {
		recup_erreur(e);
	}
}


function initIHM() {
	try {

		var typeExpedition = document.getElementById('typeExpedition').value;

		document.getElementById('lblDepot').collapsed = typeExpedition=="F";
		document.getElementById('lblDispo').collapsed = typeExpedition=="F";
		document.getElementById('dispoStock').collapsed = typeExpedition=="F";
		document.getElementById('depot').collapsed = typeExpedition=="F";

		aDepots.setParam("Depot_Expedition", (typeExpedition!="L"));
		aDepots.setParam("Depot_Logistique", (typeExpedition=="L"));
		aDepots.initTree(initDepot);

		document.getElementById('chkEtiquetteExpedition').collapsed = (typeExpedition!="C");
		document.getElementById('chkPK').collapsed = (typeExpedition!="C");
		document.getElementById('chkRE').collapsed = (typeExpedition!="C");
		document.getElementById('rowBPL').collapsed = (typeExpedition!="C");
		document.getElementById('chkLF').collapsed = (typeExpedition!="F");
		document.getElementById('chkCF').collapsed = (typeExpedition!="F");
		document.getElementById('rowBacs').collapsed = (!bacs || typeExpedition!="C");

		document.getElementById('lblNumFournisseur').collapsed = (typeExpedition!="F");
		document.getElementById('fournisseurId').collapsed = (typeExpedition!="F");
		document.getElementById('classeABC').collapsed = typeExpedition=="F";
		document.getElementById('lblClasseABC').collapsed = typeExpedition=="F";

		document.getElementById('precommande').collapsed = document.getElementById("dispoStock").value=="T" || typeExpedition=="F";

	} catch (e) {
		recup_erreur(e);
	}
}


function initDepot() {
	try {

		if (document.getElementById("typeExpedition").value == defautTypeExpedition && document.getElementById('etablissement').value == etablissementDefaut) {
			document.getElementById('depot').value = depotDefaut;
		}
		else {
			document.getElementById('depot').selectedIndex = (document.getElementById('depot').itemCount==2?1:0);
		}

		affecterConfDepot();
		listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function initFiltres() {
	try {

		document.getElementById("etatPaiement").value = defautEtatPaiement;
		document.getElementById('etablissement').value = etablissementDefaut;
		document.getElementById("Provenance").value = defautProvenance;
		document.getElementById("marketplace").value = "";
		document.getElementById('modeExpedition').selectedIndex = 0;
		document.getElementById('transporteur').selectedIndex = 0;
		document.getElementById("dispoStock").value = defautExpediable;
		document.getElementById("typeExpedition").value = defautTypeExpedition;
		document.getElementById('lblDepot').collapsed = false;
		document.getElementById('lblDispo').collapsed = false;
		document.getElementById('dispoStock').collapsed = false;
		document.getElementById('depot').collapsed = false;
		document.getElementById('dateDebut').value = "";
		document.getElementById('dateFin').value = "";
		document.getElementById('dateDebutLiv').value = "";
		document.getElementById('dateFinLiv').value = prefillDateFinLiv?getDateCourante():"";
		document.getElementById('fournisseurId').value = "";
		document.getElementById('typeCommande').value = "";
		document.getElementById('trancheId').value = "";
		document.getElementById('refArticle').value = "";
		document.getElementById('zoneLivraison').value = "";
		document.getElementById('classeABC').value = "";
		document.getElementById('familleClient').value = "";
		document.getElementById('precommande').checked = false;

		initIHM();

	} catch (e) {
		recup_erreur(e);
	}
}


function listerCommandes() {
	try {

		document.getElementById("bValider").disabled = true;

		var provenance = document.getElementById("Provenance").value;
		var marketplace = document.getElementById("marketplace").value;
		var modeExpedition = document.getElementById("modeExpedition").value;
		var transporteur = document.getElementById("transporteur").value;
		var dispoStock = document.getElementById("dispoStock").value;
		var typeExpedition = document.getElementById("typeExpedition").value;
		var statutPaiement = document.getElementById("etatPaiement").value;
		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var dateDebutLiv = document.getElementById('dateDebutLiv').value;
		var dateFinLiv = document.getElementById('dateFinLiv').value;
		var depot = document.getElementById('depot').value;
		var etablissement = document.getElementById('etablissement').value;
		var fournisseurId = document.getElementById('fournisseurId').value;
		var trancheId = document.getElementById('trancheId').value;
		var typeCommande = document.getElementById('typeCommande').value;
		var refArticle = document.getElementById('refArticle').value;
		var zoneLivraison = document.getElementById('zoneLivraison').value;
		var classeABC = document.getElementById('classeABC').value;
		var familleClient = document.getElementById('familleClient').value;
		var precommande = document.getElementById('precommande').checked;

		if (!isEmpty(dateDebut) && !isDateTime(dateDebut)) { showWarning("Date commande de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFin) && !isDateTime(dateFin)) { showWarning("Date commande de fin incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateTimeInterval(dateDebut, dateFin)) { showWarning("Plage de dates de commande incorrecte"); }
		else if (!isEmpty(dateDebutLiv) && !isDate(dateDebutLiv)) { showWarning("Date exp\u00E9dition de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFinLiv) && !isDate(dateFinLiv)) { showWarning("Date exp\u00E9dition de fin incorrecte"); }
		else if (!isEmpty(dateDebutLiv) && !isEmpty(dateFinLiv) && !isDateInterval(dateDebutLiv, dateFinLiv)) { showWarning("Plage de dates d'exp\u00E9dition incorrecte"); }
		else if (isEmpty(depot) && typeExpedition!="F") { showWarning("Veuillez s\u00E9lectionner un d\u00E9pot de stock"); }
		else {

			aApercuCommande.deleteTree();
			document.getElementById('numCommandeSelect').value = "";

			aListeCommandes.setParam("Provenance", provenance);
			aListeCommandes.setParam("Marketplace", marketplace);
			aListeCommandes.setParam("Mode_Expedition", modeExpedition);
			aListeCommandes.setParam("Transporteur", transporteur);
			aListeCommandes.setParam("Dispo_Stock", dispoStock);
			aListeCommandes.setParam("Type_Expedition", typeExpedition);
			aListeCommandes.setParam("Statut_Paiement", statutPaiement);
			aListeCommandes.setParam("Date_Debut", dateDebut);
			aListeCommandes.setParam("Date_Fin", dateFin);
			aListeCommandes.setParam("Date_Debut_Liv", dateDebutLiv);
			aListeCommandes.setParam("Date_Fin_Liv", dateFinLiv);
			aListeCommandes.setParam("Depot_Id", depot);
			aListeCommandes.setParam("Etab_Id", etablissement);
			aListeCommandes.setParam("Fournisseur_Id", fournisseurId);
			aListeCommandes.setParam("Tranche_Id", trancheId);
			aListeCommandes.setParam("Type_Commande", typeCommande);
			aListeCommandes.setParam("Ref_Article", refArticle);
			aListeCommandes.setParam("Zone_Livraison", zoneLivraison);
			aListeCommandes.setParam("Classe_ABC", classeABC);
			aListeCommandes.setParam("Famille_Client", familleClient);
			aListeCommandes.setParam("Precommande", precommande);
			aListeCommandes.initTree(debloquerListe);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function debloquerListe() {
	try {

		// spcifique LH
		dateExpeditionDebutLH = document.getElementById('dateDebutLiv').value;
		dateExpeditionFinLH = document.getElementById('dateFinLiv').value;

		compterLignesCochees();
		document.getElementById("bValider").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function compterLignesCochees() {
	try {

		var nbCoches = 0;

		for (var i=0; i<aListeCommandes.nbLignes(); i++) {
			if (aListeCommandes.getCellValue(i, "colSelect")=="true") {
				nbCoches++;
			}
  	}

		document.getElementById('lblNbLignesCochees').value = nbCoches;

	} catch (e) {
		recup_erreur(e);
	}
}


function editionCommentairesNonImprimablesCC() {
	try {

		if (aListeCommandes.isSelected()) {
			var commandeId = aListeCommandes.getSelectedCellText("colCommandeId");
			var url = "chrome://opensi/content/facturation/user/expedition_lot/popup-editionCommentairesNonImprimablesCC.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', commandeId, listerCommandes);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCommandes() {
	try {

		if (aListeCommandes.isSelected()) {
			var commandeId = aListeCommandes.getSelectedCellText("colCommandeId");
			var numCommande = aListeCommandes.getSelectedCellText("colNumCommande");
			var editionTTC = aListeCommandes.getSelectedCellText("colEditionTTC")=="true";

			document.getElementById('colMontantAC').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");

			document.getElementById('numCommandeSelect').value = "Aper\u00E7u de la commande N\u00B0 "+ numCommande +" :";
			listerApercuCommande(commandeId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeCommandes(ev) {
	try {

		if (ev.keyCode==32 && aListeCommandes.isSelected()) {
			aListeCommandes.setSelectedCellValue("colSelect", aListeCommandes.getSelectedCellValue("colSelect")=="false");
			compterLignesCochees();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function listerApercuCommande(id) {
	try {

		aApercuCommande.setParam("Commande_Id", id);
		aApercuCommande.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDispoStock() {
	try {

		document.getElementById('precommande').collapsed = document.getElementById("dispoStock").value=="T";

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocherBL(b) {
	try {

		document.getElementById("bValider").disabled = true;

		for (var i=0; i<aListeCommandes.nbLignes(); i++) {

			if (aListeCommandes.isEditable(i, "colSelect")) {
				aListeCommandes.setCellValue(i, "colSelect", b);
  		}
		}

		compterLignesCochees();
		document.getElementById("bValider").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterConfDepot() {
	try {

		var editBP = defautEditBP;
		var editBL = defautEditBL;
		var genFC = defautGenFC;
		var editFC = defautEditFC;
		var editPK = defautEditPK;
		var editRE = defautEditRE;
		var editEtiq = defautEditEtiq;
		nbBacMulti = defautNbBacMulti;
		nbBacMono = defautNbBacMono;
		var typeConfig = defautTypeConfig;
		var groupementClient = defautGroupementClient;
		var exlConfig = defautEXLConfig;
		etapePrepaBL = defautEtapePrepaBLCC;
		etapePickingBL = defautEtapePickingBLCC;
		forceEtapePrepa = false;

		var typeExpedition = document.getElementById('typeExpedition').value;

		var depotId = document.getElementById('depot').value;
		if (!isEmpty(depotId)) {
			var qDepot = new QueryHttp("Facturation/Commun/getDepotStock.tmpl");
			qDepot.setParam("Depot_Id", depotId);
			var result = qDepot.execute();

			var etapePrepaDepotBL = result.responseXML.documentElement.getAttribute("Etape_Prepa_BL_CC");
			if (!isEmpty(etapePrepaDepotBL)) {
				etapePrepaBL = (etapePrepaDepotBL=="true");
			}

			var etapePickingDepotBL = result.responseXML.documentElement.getAttribute("Etape_Picking_BL_CC");
			if (!isEmpty(etapePickingDepotBL)) {
				etapePickingBL = (etapePickingDepotBL=="true");
			}

			var exlConfigDepot = result.responseXML.documentElement.getAttribute("EXL_Config");

			if (specCET) {
				var transporteurId = document.getElementById('transporteur').value;
				if (!isEmpty(transporteurId)) {
					var qTrans = new QueryHttp("Facturation/Fournisseurs/getEXLConfig.tmpl");
					qTrans.setParam("Fournisseur_Id", transporteurId);
					result = qTrans.execute();
					var exlConfigTrans = result.responseXML.documentElement.getAttribute("EXL_Config");
					if (!isEmpty(exlConfigTrans)) {
						exlConfigDepot = exlConfigTrans;
					}
				}
			}

			if (!isEmpty(exlConfigDepot)) {
				var qConfExp = new QueryHttp("Config/gc/expeditions/loadConfigExpedition.tmpl");
				qConfExp.setParam('Config_Id', exlConfigDepot);
				result = qConfExp.execute();

				editBP = result.responseXML.documentElement.getAttribute("Edit_BP")=="true";
				editBL = result.responseXML.documentElement.getAttribute("Edit_BL")=="true";
				editEtiq = result.responseXML.documentElement.getAttribute("Edit_Etiq")=="true";
				genFC = result.responseXML.documentElement.getAttribute("Gen_FC")=="true";
				editFC = result.responseXML.documentElement.getAttribute("Edit_FC")=="true";
				editPK = result.responseXML.documentElement.getAttribute("Edit_PK")=="true";
				editRE = result.responseXML.documentElement.getAttribute("Edit_RE")=="true";
				nbBacMulti = result.responseXML.documentElement.getAttribute("Nb_Bac_Multi");
				nbBacMono = result.responseXML.documentElement.getAttribute("Nb_Bac_Mono");
				typeConfig = result.responseXML.documentElement.getAttribute("Type_Config");
				groupementClient = result.responseXML.documentElement.getAttribute("Groupement_Client");
				exlConfig = exlConfigDepot;
			}

			if (specCME && typeExpedition=="C") {
				var modeExpId = document.getElementById('modeExpedition').value;
				if (!isEmpty(modeExpId)) {
					var qConfME = new QueryHttp("Facturation/Expedition_Lot/getEtapePrepaModeExpedition.tmpl");
					qConfME.setParam('Mode_Exp_Id', modeExpId);
					result = qConfME.execute();

					forceEtapePrepa = result.responseXML.documentElement.getAttribute("Etape_Prepa_BL_CC")=="true";

					if (forceEtapePrepa) {
						etapePrepaBL = true;
					}
				}
			}
		}

		document.getElementById('chkBP').checked = ((!etapePickingBL && etapePrepaBL && ((!actCrossDock && !specPO) || !editPK)) || editBP);
		document.getElementById('chkBL').checked = (!etapePickingBL && !etapePrepaBL && editBL);
		document.getElementById('chkBP').collapsed = etapePrepaBL;
		document.getElementById('chkBL').collapsed = etapePrepaBL;
		document.getElementById('chkCreerFacture').checked = genFC;
		document.getElementById('chkFacture').disabled = !genFC;
		document.getElementById('chkFacture').checked = (genFC && editFC);
		document.getElementById('chkPK').checked = editPK;
		document.getElementById('chkRE').checked = editRE;
		document.getElementById('chkEtiquetteExpedition').checked = editEtiq;
		document.getElementById('chkGroupementClient').checked = (exlGroupementClient && etapePrepaBL && !bacs && typeExpedition=="C" && groupementClient);
		document.getElementById('chkGroupementClient').collapsed = (!exlGroupementClient || !etapePrepaBL || bacs || typeExpedition!="C");
		document.getElementById('chkCF').checked = typeExpedition=="F" && defautEditCF;
		document.getElementById('chkLF').checked = typeExpedition=="F" && defautEditLF;

		affecterNbBacs();

		if (bacs && typeExpedition=="C" && typeConfig=="V") {
			document.getElementById('trancheId').value = "";
			document.getElementById('lblVolumeCommande').collapsed = false;
			document.getElementById('trancheId').collapsed = false;
			aTranchesVolume.setParam("Config_Id", exlConfig);
			aTranchesVolume.initTree();
		}
		else {
			document.getElementById('lblVolumeCommande').collapsed = true;
			document.getElementById('trancheId').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterNbBacs() {
	try {

		if (bacs && isEmpty(document.getElementById('trancheId').value)) {
			if (!isEmpty(document.getElementById('typeCommande').value)) {
				document.getElementById('nbBacs').value = nbBacMono;
			}
			else {
				document.getElementById('nbBacs').value = nbBacMulti;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectTrancheVolume() {
	try {

		var trancheId = document.getElementById('trancheId').value;

		if (isEmpty(trancheId)) {
			affecterNbBacs();
		}
		else {
			var qTranche = new QueryHttp("Config/gc/expeditions/loadTrancheVolumeConfigExpedition.tmpl");
			qTranche.setParam('Tranche_Id', trancheId);
			var result = qTranche.execute();

			document.getElementById('nbBacs').value = result.responseXML.documentElement.getAttribute("Nb_Bac");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterConfTrans() {
	try {

		if (specCET) {
			affecterConfDepot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterConfModeExpedition() {
	try {

		if (specCME) {
			affecterConfDepot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		document.getElementById("bValider").disabled = true;

		if (!confirmation || window.confirm("Confirmez-vous la validation des exp\u00E9ditions ?")) {

			var typeExpedition = document.getElementById('typeExpedition').value;
			var nbBacs = document.getElementById('nbBacs').value;
			var listeCC = "";

			for (var i=0; i<aListeCommandes.nbLignes(); i++) {
				if (aListeCommandes.getCellValue(i, "colSelect")=="true") {
					listeCC += aListeCommandes.getCellText(i, "colCommandeId") +",";
				}
  		}

			if (!document.getElementById('chkBL').checked && !document.getElementById('chkBP').checked && !etapePickingBL && ((!actCrossDock && !specPO) || !document.getElementById('chkPK').checked) && !specEFU) {
				if (!actCrossDock && !specPO) {
					showWarning("Veuillez cocher au moins une des deux cases 'Editer les bons de pr\u00E9paration' ou 'Editer les bons de livraison'");
				}
				else {
					showWarning("Veuillez cocher la case 'Editer un bon de picking'");
				}
			}
			else if (typeExpedition=="C" && !document.getElementById('chkPK').checked && !document.getElementById('chkRE').checked && etapePickingBL) {
				showWarning("Veuillez cocher au moins une des deux cases 'Editer un bon de picking' ou 'Editer les r\u00E9capitulatifs d\'exp\u00E9dition'");
			}
			else if (!document.getElementById('chkBL').checked && !document.getElementById('chkBP').checked && specEFU && !document.getElementById('chkFacture').checked) {
				showWarning("Veuillez cocher au moins une des cases 'Editer les bons de pr\u00E9paration' ou 'Editer les bons de livraison' ou 'Editer les factures'");
			}
			else if (typeExpedition=="F" && !document.getElementById('chkCF').checked && !document.getElementById('chkLF').checked) {
				showWarning("Veuillez cocher au moins une des deux cases 'Editer les commandes fournisseur' ou 'Editer les bons de livraison'");
			}
			else if (isEmpty(listeCC)) {
				showWarning("Veuillez cocher au moins une commande");
			}
			else if (bacs && typeExpedition=="C" && !isPositiveInteger(nbBacs)) {
				showWarning("Nombre de bacs incorrect");
			}
			else {
				document.getElementById('deck').selectedIndex = 1;
				document.getElementById('pmbox').collapsed = false;
				document.getElementById('pm').setAttribute('mode', 'undetermined');
				document.getElementById('boxExpTrans').collapsed = true;
				document.getElementById('rappelLoi').collapsed = !document.getElementById('chkFacture').checked;

				var qGenExp = new QueryHttp("Facturation/Expedition_Lot/generateExpedition.tmpl");

				qGenExp.setParam('Gen_FC', document.getElementById('chkCreerFacture').checked);
				qGenExp.setParam('Liste_CC', listeCC);
				qGenExp.setParam('Edit_FC', document.getElementById('chkFacture').checked);
				qGenExp.setParam('Edit_BP', (typeExpedition=='C' && document.getElementById('chkBP').checked));
				qGenExp.setParam('Edit_BL', (typeExpedition=='C' && document.getElementById('chkBL').checked) || (typeExpedition=='F' && document.getElementById('chkLF').checked));
				qGenExp.setParam('Edit_RE', (typeExpedition=='C' && document.getElementById('chkRE').checked));
				qGenExp.setParam('Edit_PK', (typeExpedition=='C' && document.getElementById('chkPK').checked));
				qGenExp.setParam('Edit_EC', (typeExpedition=='C' && document.getElementById('chkEtiquetteExpedition').checked));
				qGenExp.setParam('Edit_CF', (typeExpedition=='F' && document.getElementById('chkCF').checked));
				qGenExp.setParam('Groupement_Client', (exlGroupementClient && !bacs && typeExpedition=='C' && document.getElementById('chkGroupementClient').checked));
				qGenExp.setParam('Depot_Id', document.getElementById('depot').value);
				qGenExp.setParam('Type_Expedition', typeExpedition);
				qGenExp.setParam('Fournisseur_Id', document.getElementById('fournisseurId').value);
				qGenExp.setParam('Nb_Bacs', nbBacs);
				qGenExp.setParam('Force_Etape_Prepa', forceEtapePrepa);

				// spcifique LH
				qGenExp.setParam('Date_Expedition_Debut', dateExpeditionDebutLH);
				qGenExp.setParam('Date_Expedition_Fin', dateExpeditionFinLH);

				var result = qGenExp.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					retour_expedition(true);
				}
				else {
					lastExpeditionId = result.responseXML.documentElement.getAttribute('Expedition_Id');

					var qGenPdf = new QueryHttp("Facturation/Expedition_Lot/pdfExpedition.tmpl");
					qGenPdf.setParam('Expedition_Id', lastExpeditionId);
					qGenPdf.setParam('First_Edit', true);

					var result2 = qGenPdf.execute();

					var errors = new Errors(result2);
					if (errors.hasNext()) {
						errors.show();
					}
					else {
						var page = getDirPdf() + result2.responseXML.documentElement.getAttribute('FichierPDF');
						document.getElementById('expedition').setAttribute("src", page);
					}

					document.getElementById('bExpedition').collapsed = false;

					if (typeExpedition=='C' && document.getElementById('chkEtiquetteExpedition').checked) {
						var qEtiquettes = new QueryHttp("Facturation/Affaires/pdfEtiquettes.tmpl");
						qEtiquettes.setParam("Expedition_Id", lastExpeditionId);
						var res = qEtiquettes.execute();
						var page = getDirPdf() + res.responseXML.documentElement.getAttribute('fichier');
						document.getElementById('bEtiquettes').collapsed = false;
						document.getElementById('etiquettes').setAttribute("src", page);
					}

					document.getElementById('bRetourExpeditions').collapsed = false;
				}

				document.getElementById('pm').setAttribute('mode', 'none');
				document.getElementById('pmbox').collapsed = true;
				document.getElementById('Export_Id').value = "";
				document.getElementById('boxExpTrans').collapsed = etapePrepaBL;
			}
		}

		document.getElementById("bValider").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function validerModificationME() {
	try {

		document.getElementById("bValider").disabled = true;

		var modeExpedition = document.getElementById('modifierModeExpedition').value;
		var listeCC = "";

		for (var i=0; i<aListeCommandes.nbLignes(); i++) {
			if (aListeCommandes.getCellValue(i, "colSelect")=="true") {
				listeCC += aListeCommandes.getCellText(i, "colCommandeId") +",";
			}
  	}

		if (isEmpty(listeCC)) {
			showWarning("Veuillez cocher au moins une commande");
		}
		else if (isEmpty(modeExpedition)) {
			showWarning("Veuillez s\u00E9lectionner un mode d'exp\u00E9dition");
		}
		else if (window.confirm("Confirmez-vous la modification du mode d'exp\u00E9dition pour toutes les commandes s\u00E9lectionn\u00E9es ?")) {

			var qGenModificationME = new QueryHttp("Facturation/Expedition_Lot/modifierModeExpedition.tmpl");
			qGenModificationME.setParam('Mode_Expedition', modeExpedition);
			qGenModificationME.setParam('Liste_CC', listeCC);
			var result = qGenModificationME.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}

			aListeCommandes.initTree(debloquerListe);
		}

		document.getElementById("bValider").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function checkActFacture() {
	try {

		var chkCreerFacture = document.getElementById('chkCreerFacture').checked;
		document.getElementById('chkFacture').disabled = !chkCreerFacture;
		if (!chkCreerFacture) {
			document.getElementById('chkFacture').checked = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retour_expedition(nocheck) {
  try {

		if (nocheck || checkPrinting()) {
			document.getElementById('etiquettes').setAttribute("src", "");
			document.getElementById('expedition').setAttribute("src", "");
			document.getElementById('fournisseurId').value = "";
			aFournisseurs.initTree(listerCommandes);
			document.getElementById('bRetourExpeditions').collapsed = true;
			document.getElementById('bExpedition').collapsed = true;
			document.getElementById('bEtiquettes').collapsed = true;
			document.getElementById('deck').selectedIndex = 0;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

		if (checkPrinting()) {
    	window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";
			window.parent.removeEventListener("close", onCloseWindow, false);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function checkPrinting() {
  try {

		return document.getElementById('deck').selectedIndex!=1 || window.confirm("Avant de quitter ce listing, assurez-vous de l'avoir imprim\u00E9. Voulez-vous continuer ?");

	} catch (e) {
    recup_erreur(e);
		return true;
  }
}


function onCloseWindow(evt) {
  try {

		if (!checkPrinting()) {
			evt.preventDefault();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function quitWithCheck() {
  try {

		if (checkPrinting()) {
			window.parent.removeEventListener("close", onCloseWindow, false);
			quit();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/expedition_lot/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function genererEtiquettesExpedition() {
	try {

		var numBL = document.getElementById('numBL').value;
		var nbColis = document.getElementById('nbColis').value;

		if (numBL=="") {
			showWarning("Veuillez saisir un N\u00B0 de bon de livraison");
		}
		else if (!isPositiveInteger(nbColis))	{
			showWarning("Le nombre de colis est incorrect");
		}
		else {
			var qGetBL = new QueryHttp("Facturation/Expedition_Lot/searchBL.tmpl");
			qGetBL.setParam("Numero_BL", numBL);
			var result = qGetBL.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var bonLivId = result.responseXML.documentElement.getAttribute('Bon_Liv_Id');
				document.getElementById('deck').selectedIndex = 1;
				document.getElementById('boxExpTrans').collapsed = true;

				var qEtiquettes = new QueryHttp("Facturation/Affaires/pdfEtiquettes.tmpl");
				qEtiquettes.setParam("Bon_Liv_Id", bonLivId);
				qEtiquettes.setParam("Nb_Etiquettes", nbColis);
				var res = qEtiquettes.execute();
				var page = getDirPdf() + res.responseXML.documentElement.getAttribute('fichier');
				document.getElementById('bEtiquettes').collapsed = false;
				document.getElementById('etiquettes').setAttribute("src", page);
				document.getElementById('bRetourExpeditions').collapsed = false;
				document.getElementById('numBL').value = "";
				document.getElementById('nbColis').value = "";
			}
		}

	} catch (e) {
	  recup_erreur(e);
	}
}


function exportTransporteur() {
	try {

		var exportId = document.getElementById('Export_Id').value;

		if (isEmpty(exportId)) {
			showWarning("Veuillez s\u00E9lectionner un format d'export transporteur");
		}
		else {
			document.getElementById('bExporter').disabled = true;

			var qGenExport = new QueryHttp("Facturation/Expedition_Lot/genExportTransporteur.tmpl");
			qGenExport.setParam('Export_Id', exportId);
			qGenExport.setParam('Expedition_Id', lastExpeditionId);
			var result = qGenExport.execute();

			var contenu = result.responseXML.documentElement;
			var fichier_export = contenu.getAttribute('FileName');
			var nom_sugg = contenu.getAttribute('SuggestedName');

			document.getElementById('bExporter').disabled = false;

			var file = fileChooser("save", nom_sugg);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier_export, file);
			}
		}

	} catch (e) {
	  recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle, "V");

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('refArticle').value = reference;
  	listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}
