/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oef_aLignes = new Arbre("Facturation/Factu_Fournisseur/list-ligneFactureFournisseur.tmpl", "oef-articles");
var oef_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oef-modeReglement');
var oef_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oef-responsable");
var oef_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oef-secteur");
var oef_aVersion = new Arbre("Facturation/Factu_Fournisseur/list-versionFactureFournisseur.tmpl","oef-listeVersion");
var oef_aAcomptes = new Arbre("Facturation/Factu_Fournisseur/list-acompteFournisseur.tmpl","oef-listeAcomptes");
var oef_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oef-etablissement');
var oef_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oef-codeTVAFraisPort");

var oef_nfmt = new NumberFormat("0.00", true);

var oef_factureId = "";
var oef_modeLigne;
var oef_mode;
var oef_tauxTVAPort;
var oef_codeTVAPort = "";
var oef_chargerModeReg;
var oef_chargerResponsable;
var oef_selPoleActivite;
var oef_modifie = false;
var oef_currentIndex = 0;
var oef_toSelectLigne = null;
var oef_typeRistourne = 'P';
var oef_typeRemise = 'P';
var oef_typeRemiseFP = 'P';
var oef_montantHT = 0;
var oef_bloquerEcheance = false;
var oef_typeLigne;
var oef_ligneId;
var oef_articleId;
var oef_montantAcompte;
var oef_acompteId;
var oef_typeDocPdf = "FF";
var oef_curEtablissement;
var oef_actSuiviLot;
var oef_actSuiviSerie;
var oef_codesTvaInactifs = "";
var oef_defModeReglement;
var oef_insertionLigneId = 0;
var oef_uniteDefaut;
var oef_fournisseurId;
var oef_specLHCNV;
var oef_ecartsGen = false;



function oef_init() {
	try {

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oef-codePays");
		aPays.initTree();

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "oef-unite");
		aUnite.initTree();

		document.getElementById('oef-rowFax').collapsed = !gConfig.isShowFax();

		oef_actSuiviLot = gConfig.isActSuiviLot();
		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();
		oef_actSuiviSerie = gConfig.isActSuiviSerie();
		oef_defModeReglement = gConfig.getDefModeReglementF();
		oef_uniteDefaut = gConfig.getUniteDefaut();
		oef_specLHCNV = gConfig.isSpecLHCNV();

		document.getElementById('oef-bConsultSerieLigne').collapsed = !oef_actSuiviSerie;
		document.getElementById('oef-bConsultSerieLigne').disabled = true;

		if (!oef_actSuiviLot) {
			document.getElementById('oef-colNumLot').collapsed = true;
			document.getElementById('oef-colDatePeremption').collapsed = true;
			document.getElementById('oef-fieldNumLot').collapsed = true;
			document.getElementById('oef-fieldDLC').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oef-colSymboleUnite').collapsed = true;
			document.getElementById('oef-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oef-colNbPieces').collapsed = true;
			document.getElementById('oef-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldNbPieces').collapsed = true;
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("oef-colAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("oef-colAttribut"+ i).collapsed = true;
				document.getElementById("oef-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_rechargerTVA() {
	try {

		oef_codeTVAPort = "";

		oef_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oef-codePays").value);
    oef_aCodesTVAFraisPort.setParam("Selection", oef_codeTVAPort);
    oef_aCodesTVAFraisPort.initTree(oef_initCodeTVAFraisPort);

		oef_listeTVA();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initCodeTVAFraisPort() {
  try {

    document.getElementById('oef-codeTVAFraisPort').value = (document.getElementById("oef-codePays").value=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(document.getElementById("oef-codePays").value));
    oef_codeTVAPort = document.getElementById('oef-codeTVAFraisPort').value;
    oef_tauxTVAPort = getTva(oef_codeTVAPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_listeTVA() {
  try {

  	oef_calculTotaux();
    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oef-codeTVA");
    aCode.setParam("Code_Pays", document.getElementById("oef-codePays").value);
		aCode.setParam("Selection", oef_codesTvaInactifs);
    aCode.initTree(oef_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_selectTVA() {
  try {

  	var codePays = document.getElementById('oef-codePays').value;
    document.getElementById('oef-codeTVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerResponsables(selection) {
	try {

		oef_chargerResponsable = selection;
		oef_aResponsables.setParam("Selection", oef_chargerResponsable);
		oef_aResponsables.initTree(oef_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initResponsable() {
  try {

		document.getElementById('oef-responsable').value = oef_chargerResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_chargerPolesActivite(selection) {
	try {

		oef_selPoleActivite = selection;
		oef_aPolesActivite.setParam("Selection", oef_selPoleActivite);
		oef_aPolesActivite.initTree(oef_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initPoleActivite() {
  try {

		document.getElementById('oef-secteur').value = oef_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_chargerEtablissement(selection) {
	try {

		oef_curEtablissement = selection;
		oef_aEtablissements.setParam("Selection", selection);
		oef_aEtablissements.initTree(oef_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}

function oef_initEtablissement() {
	try {

		document.getElementById('oef-etablissement').value = oef_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_reinitialiser() {
	try {

		oef_fournisseurId = "";
		oef_acompteId = "";
		oef_modeLigne = "C";
		oef_currentIndex = 0;
		oef_typeRemise = "P";
		oef_typeRemiseFP = "P";
		oef_chargerModeReg = oef_defModeReglement;
		oef_chargerResponsable = "";
		oef_selPoleActivite = "";
		oef_curEtablissement = "";
		oef_montantHT = 0;
		oef_bloquerEcheance = false;
		oef_codesTvaInactifs = "";
		oef_codeTVAPort = "";

		document.getElementById('oef-tabBoxFacture').selectedIndex = 0;
		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('oef-boxMail').collapsed=false;
		document.getElementById('oef-tabFacture').setAttribute('image', null);
		document.getElementById('oef-tabAcomptes').collapsed=true;
		document.getElementById('oef-tabAcomptes').disabled=true;
		document.getElementById('oef-bReediterAcompte').disabled=true;
		document.getElementById('oef-bAffecterAcomptes').collapsed=true;
		document.getElementById('oef-bAffecterAcomptes').disabled=true;

		document.getElementById('oef-numFacture').value = "";
		document.getElementById('oef-dateFacture').value = "";

		document.getElementById('oef-rowFrancoPort').collapsed = true;
		document.getElementById('oef-lblFrancoPort').value = "";

		oef_aAcomptes.deleteTree();
		oef_aVersion.deleteTree();

		document.getElementById('oef-numFournisseur').value = "";
		document.getElementById('oef-numInterne').value = "";

		oef_aResponsables.deleteTree();

		document.getElementById('oef-denomination').value = "";
		document.getElementById('oef-adresse1').value = "";
		document.getElementById('oef-adresse2').value = "";
		document.getElementById('oef-adresse3').value = "";
		document.getElementById('oef-codePostal').value = "";
		document.getElementById('oef-ville').value = "";
		document.getElementById('oef-codePays').value = "FR";
		document.getElementById('oef-civInter').selectedIndex = 0;
		document.getElementById('oef-nomInter').value = "";
		document.getElementById('oef-prenomInter').value = "";
		document.getElementById('oef-telInter1').value = "";
		document.getElementById('oef-telInter2').value = "";
		document.getElementById('oef-faxInter').value = "";
		document.getElementById('oef-emailInter').value = "";

		document.getElementById('oef-reference').value = "";
		document.getElementById('oef-designation').value = "";
		document.getElementById('oef-numLot').value = "";
		document.getElementById('oef-nbPieces').value = "";
		document.getElementById('oef-quantite').value = "";
		document.getElementById('oef-unite').value = oef_uniteDefaut;
		document.getElementById('oef-datePeremption').value = "";
		document.getElementById('oef-PU').value = "";
		document.getElementById('oef-ristourne').value = "";

		document.getElementById('oef-commentairesFin').value = "";
		document.getElementById('oef-commentairesInt').value = "";
		document.getElementById('oef-echeance').value = "";
		document.getElementById('oef-modeReglement').value = "";
		document.getElementById('oef-bRemise').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oef-remise').value = "0.00";
		document.getElementById('oef-fraisPort').value = "0.00";
		document.getElementById('oef-codeTVAFraisPort').selectedIndex = 0;
		document.getElementById('oef-bRemiseFP').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oef-remiseFP').value = "0.00";
		document.getElementById('oef-escompte').value = "0.00";
		oef_montantAcompte = 0;

		document.getElementById('oef-montantHT').value = "0.00";
		document.getElementById('oef-montantRemise').value = "0.00";
		document.getElementById('oef-montantFraisPort').value = "0.00";
		document.getElementById('oef-montantRemiseFP').value = "0.00";
		document.getElementById('oef-totalHT').value = "0.00";
		document.getElementById('oef-TVA').value = "0.00";
		document.getElementById('oef-montantEscompte').value = "0.00";
		document.getElementById('oef-totalTTC').value = "0.00";
		document.getElementById('oef-montantAcompte').value = "0.00";

		document.getElementById('oef-rowRemiseHT').collapsed = true;
		document.getElementById('oef-rowRemiseFPHT').collapsed = true;
		document.getElementById('oef-rowEscompteHT').collapsed = true;

		document.getElementById('oef-rowNetCommercialHT').collapsed = true;
		document.getElementById('oef-netCommercial').value = "0.00";

		document.getElementById('oef-creation').setAttribute("label", "");
		document.getElementById('oef-modification').setAttribute("label", "");
		document.getElementById('oef-fiche').setAttribute("label", "");

		oef_typeLigne = "";
		oef_ligneId = "";
		oef_modifie = false;

		document.getElementById('oef-numFacture').disabled = true;
		document.getElementById('oef-dateFacture').disabled = true;
		document.getElementById('oef-etablissement').disabled = true;
		document.getElementById('oef-secteur').disabled = true;
		document.getElementById('oef-responsable').disabled = true;
		document.getElementById('oef-bReception').disabled = true;
		document.getElementById('oef-bAjouterLigne').disabled = true;
		document.getElementById('oef-bVoirFichier').disabled = true;
		document.getElementById('oef-bRechFournisseur').collapsed = true;
		document.getElementById('oef-bChercherAdr').disabled = true;
		document.getElementById('oef-bChercherInter').disabled = true;

		document.getElementById('oef-denomination').setAttribute('readonly', true);
		document.getElementById('oef-adresse1').setAttribute('readonly', true);
		document.getElementById('oef-adresse2').setAttribute('readonly', true);
		document.getElementById('oef-adresse3').setAttribute('readonly', true);
		document.getElementById('oef-codePostal').setAttribute('readonly', true);
		document.getElementById('oef-ville').setAttribute('readonly', true);
		document.getElementById('oef-codePays').disabled = true;
		document.getElementById('oef-civInter').disabled = true;
		document.getElementById('oef-nomInter').setAttribute('readonly', true);
		document.getElementById('oef-prenomInter').setAttribute('readonly', true);
		document.getElementById('oef-telInter1').setAttribute('readonly', true);
		document.getElementById('oef-telInter2').setAttribute('readonly', true);
		document.getElementById('oef-faxInter').setAttribute('readonly', true);
		document.getElementById('oef-emailInter').setAttribute('readonly', true);

		document.getElementById('oef-bMoveUp').disabled = true;
		document.getElementById('oef-bMoveDown').disabled = true;
		document.getElementById('oef-bMoveFirst').disabled = true;
		document.getElementById('oef-bMoveLast').disabled = true;
		document.getElementById('oef-bMultiSuppression').disabled = true;

		document.getElementById('oef-reference').disabled = true;
		document.getElementById('oef-designation').disabled = true;
		document.getElementById('oef-numLot').disabled = true;
		document.getElementById('oef-nbPieces').disabled = true;
		document.getElementById('oef-quantite').disabled = true;
		document.getElementById('oef-unite').disabled = true;
		document.getElementById('oef-datePeremption').disabled = true;
		document.getElementById('oef-PU').disabled = true;
		document.getElementById('oef-ristourne').disabled = true;
		document.getElementById('oef-codeTVA').disabled = true;

		document.getElementById('oef-bArticle').disabled = true;
		document.getElementById('oef-bCommentaire').disabled = true;
		document.getElementById('oef-bAnnuler').disabled = true;
		document.getElementById('oef-bValider').disabled = true;
		document.getElementById('oef-bSupprimer').disabled = true;
		oef_aLignes.deleteTree();

		document.getElementById('oef-commentairesFin').disabled = true;
		document.getElementById('oef-commentairesInt').disabled = true;
		document.getElementById('oef-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oef-bChoisirMentions').disabled = true;
		document.getElementById('oef-echeance').disabled = true;
		document.getElementById('oef-modeReglement').disabled = true;
		document.getElementById('oef-bEchMultiples').disabled = true;
		document.getElementById('oef-bRemise').disabled = true;
		document.getElementById('oef-remise').disabled = true;
		document.getElementById('oef-fraisPort').disabled = true;
		document.getElementById('oef-codeTVAFraisPort').disabled = true;
		document.getElementById('oef-bRemiseFP').disabled = true;
		document.getElementById('oef-remiseFP').disabled = true;
		document.getElementById('oef-escompte').disabled = true;
		document.getElementById('oef-bEnregistrer').disabled = true;
		document.getElementById('oef-bSupFacture').disabled = true;
		document.getElementById('oef-bVisualiser').disabled = true;
		document.getElementById('oef-bValiderFacture').disabled = true;
		document.getElementById('oef-bGenererEcarts').disabled = true;
		document.getElementById('oef-bVisualiser').collapsed = true;
		document.getElementById('oef-bValiderFacture').collapsed = false;
		document.getElementById('oef-bGenererEcarts').collapsed = true;
		document.getElementById('oef-bTransAvoir').collapsed = true;
		document.getElementById('oef-pdfFacture').setAttribute('src', '');

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_majFrancoPort(francoPort, montantFranco) {
	try {

		var lblFrancoPort = "";
		if (!francoPort) { lblFrancoPort = "Non"; }
		else { lblFrancoPort = (parseFloat(montantFranco)==0?"Oui":oef_nfmt.format(montantFranco) +" \u20AC"); }
		document.getElementById('oef-lblFrancoPort').value = lblFrancoPort;
		document.getElementById('oef-rowFrancoPort').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_debloquerChamps() {
	try {
		document.getElementById('oef-numFacture').disabled = false;
		document.getElementById('oef-dateFacture').disabled = false;
		document.getElementById('oef-etablissement').disabled = false;
		document.getElementById('oef-secteur').disabled = false;
		document.getElementById('oef-responsable').disabled = false;

		document.getElementById('oef-denomination').removeAttribute('readonly');
		document.getElementById('oef-adresse1').removeAttribute('readonly');
		document.getElementById('oef-adresse2').removeAttribute('readonly');
		document.getElementById('oef-adresse3').removeAttribute('readonly');
		document.getElementById('oef-codePostal').removeAttribute('readonly');
		document.getElementById('oef-ville').removeAttribute('readonly');
		document.getElementById('oef-codePays').disabled = false;
		document.getElementById('oef-civInter').disabled = false;
		document.getElementById('oef-nomInter').removeAttribute('readonly');
		document.getElementById('oef-prenomInter').removeAttribute('readonly');
		document.getElementById('oef-telInter1').removeAttribute('readonly');
		document.getElementById('oef-telInter2').removeAttribute('readonly');
		document.getElementById('oef-faxInter').removeAttribute('readonly');
		document.getElementById('oef-emailInter').removeAttribute('readonly');

		oef_ajouterLigne("I");
		document.getElementById('oef-bArticle').disabled = false;

		document.getElementById('oef-commentairesFin').disabled = false;
		document.getElementById('oef-commentairesInt').disabled = false;
		document.getElementById('oef-bChoisirMentions').disabled = false;
		document.getElementById('oef-bRemise').disabled = false;
		document.getElementById('oef-remise').disabled = false;
		document.getElementById('oef-fraisPort').disabled = false;
		document.getElementById('oef-codeTVAFraisPort').disabled = false;
		document.getElementById('oef-bRemiseFP').disabled = false;
		document.getElementById('oef-remiseFP').disabled = false;
		document.getElementById('oef-escompte').disabled = false;
		document.getElementById('oef-bEnregistrer').disabled = false;

		if (oef_mode=='C') {
			document.getElementById('oef-bRechFournisseur').collapsed = false;
			document.getElementById('oef-echeance').disabled = false;
  		document.getElementById('oef-modeReglement').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_chargerFacture() {
  try {

		oef_mode = "M";
		oef_reinitialiser();

		var qLoad = new QueryHttp("Facturation/Factu_Fournisseur/loadFactureFournisseur.tmpl");
		qLoad.setParam("Facture_Id", oef_factureId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		var numFacture = contenu.getAttribute('Numero');
		var statut = contenu.getAttribute('Statut');
		var ctrlFact = contenu.getAttribute('Ctrl_Fact')=="true";
		var validOnly = ctrlFact && statut=="N";
		if ((statut=="V" && !isEmpty(numFacture)) || validOnly) { oef_mode = "V"; }

    document.getElementById('oef-escompte').value = contenu.getAttribute('Escompte');
    oef_montantAcompte = contenu.getAttribute('Acompte');
    document.getElementById('oef-fraisPort').value = contenu.getAttribute('Frais_Port');
    document.getElementById('oef-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
    document.getElementById('oef-commentairesInt').value = contenu.getAttribute('Commentaires_Int');
    document.getElementById('oef-dateFacture').value = contenu.getAttribute('Date_Facture');
    document.getElementById('oef-numFacture').value = numFacture;
    document.getElementById('oef-echeance').value = contenu.getAttribute('Echeance');
    oef_chargerEtablissement(contenu.getAttribute('Etab_Id'));
    oef_chargerModesReglements(contenu.getAttribute('Mode_Reg'));
		oef_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		oef_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oef-remise').value = (oef_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oef-bRemise').setAttribute("class", (oef_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oef_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oef-remiseFP').value = (oef_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oef-bRemiseFP').setAttribute("class", (oef_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

    document.getElementById('oef-denomination').value = contenu.getAttribute('Denomination');
    document.getElementById('oef-adresse1').value = contenu.getAttribute('Adresse_1');
    document.getElementById('oef-adresse2').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oef-adresse3').value = contenu.getAttribute('Adresse_3');
    document.getElementById('oef-codePostal').value = contenu.getAttribute('Code_Postal');
    document.getElementById('oef-ville').value = contenu.getAttribute('Ville');
    document.getElementById('oef-codePays').value = contenu.getAttribute('Code_Pays');
		oef_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');
    document.getElementById('oef-civInter').value = contenu.getAttribute('Civ_Inter');
    document.getElementById('oef-nomInter').value = contenu.getAttribute('Nom_Inter');
    document.getElementById('oef-prenomInter').value = contenu.getAttribute('Prenom_Inter');
    document.getElementById('oef-telInter1').value = contenu.getAttribute('Tel_Inter_1');
    document.getElementById('oef-telInter2').value = contenu.getAttribute('Tel_Inter_2');
    document.getElementById('oef-faxInter').value = contenu.getAttribute('Fax_Inter');
    document.getElementById('oef-emailInter').value = contenu.getAttribute('Email_Inter');
    oef_chargerResponsables(contenu.getAttribute('Util_R'));
    oef_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
    oef_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');

    oef_fournisseurId = contenu.getAttribute('Fournisseur_Id');
		var fournisseurConnu = (oef_fournisseurId!="");
		document.getElementById('oef-numFournisseur').value = contenu.getAttribute('Num_Fournisseur');
		document.getElementById('oef-numInterne').value = contenu.getAttribute('Num_Interne');

    document.getElementById('oef-creation').label = "Facture cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') + " par "+ contenu.getAttribute('Login_Createur');
    document.getElementById('oef-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
    document.getElementById('oef-fiche').setAttribute("label","Facture N\u00B0 "+ numFacture);

    document.getElementById('oef-tabVersionDocument').collapsed = false;
    oef_initVersion();
    oef_modifie = false;

    oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);

    if (oef_mode!="V") {
    	oef_debloquerChamps();
   		document.getElementById('oef-bReception').disabled = false;
			document.getElementById('oef-bChercherInter').disabled = !fournisseurConnu;
			document.getElementById('oef-bSupFacture').disabled = false;
			var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
    	document.getElementById('oef-echeance').disabled = !echModifiable;
  		document.getElementById('oef-modeReglement').disabled = !echModifiable;
  		document.getElementById('oef-bAffecterAcomptes').collapsed=false;
    }

    oef_aAcomptes.setParam("Facture_Id", oef_factureId);
    oef_aAcomptes.initTree(oef_initAcomptes);

    document.getElementById('oef-tabAcomptes').collapsed=false;
		document.getElementById('oef-tabAcomptes').disabled=false;

    document.getElementById('oef-bOuvrirCommentairesCaches').disabled = false;
    document.getElementById('oef-bVisualiser').disabled = (oef_mode!="V" || validOnly);
		document.getElementById('oef-bValiderFacture').disabled = (oef_mode=="V" && !validOnly);
		document.getElementById('oef-bGenererEcarts').disabled = (oef_ecartsGen || oef_mode=="V" || ctrlFact || !oef_specLHCNV);
		document.getElementById('oef-bVisualiser').collapsed = (oef_mode!="V" || validOnly);
		document.getElementById('oef-bValiderFacture').collapsed = (oef_mode=="V" && !validOnly);
		document.getElementById('oef-bGenererEcarts').collapsed = (oef_ecartsGen || oef_mode=="V" || ctrlFact || !oef_specLHCNV);
		document.getElementById('oef-bVoirFichier').disabled = (oef_mode!="V" || validOnly);
		document.getElementById('oef-bTransAvoir').collapsed = statut!="V";

		oef_ecartsGen = false;

    document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

		if (fournisseurConnu) {
			var francoPort = (contenu.getAttribute('Franco_Port')=="true");
			var montantFranco = contenu.getAttribute("Montant_Franco");
			oef_majFrancoPort(francoPort, montantFranco);
		}

		oef_aLignes.setParam("Facture_Id", oef_factureId);
		oef_aLignes.initTree(oef_chargerFacture2);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerFacture2() {
  try {

		oef_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oef-codePays").value);
		oef_aCodesTVAFraisPort.setParam("Selection", oef_codeTVAPort);
		oef_aCodesTVAFraisPort.initTree(oef_selectionTvaPort);

 	} catch (e) {
    recup_erreur(e);
  }
}


function oef_selectionTvaPort() {
  try {

		 document.getElementById('oef-codeTVAFraisPort').value = oef_codeTVAPort;
     oef_tauxTVAPort = getTva(oef_codeTVAPort);
     oef_listeTVA();

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRistourne() {
	try {

		if (oef_typeRistourne=='P') {
			document.getElementById('oef-bRistourne').setAttribute("class", "bIcoEuro");
			oef_typeRistourne = 'M';
		}
		else {
			document.getElementById('oef-bRistourne').setAttribute("class", "bIcoPourcentage");
			oef_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRemise() {
	try {

		if (oef_typeRemise=='P') {
			document.getElementById('oef-bRemise').setAttribute("class", "bIcoEuro");
			oef_typeRemise = 'M';
		}
		else {
			document.getElementById('oef-bRemise').setAttribute("class", "bIcoPourcentage");
			oef_typeRemise = 'P';
		}
		oef_calculTotaux();
		oef_setModifie(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRemiseFP() {
	try {

		if (oef_typeRemiseFP=='P') {
			document.getElementById('oef-bRemiseFP').setAttribute("class", "bIcoEuro");
			oef_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oef-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oef_typeRemiseFP = 'P';
		}
		oef_calculTotaux();
		oef_setModifie(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oef_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_chargerModesReglements(selection) {
	try {
		oef_chargerModeReg = selection;
		oef_aModesReglements.setParam("Selection", oef_chargerModeReg);
		oef_aModesReglements.initTree(oef_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initModeReglement() {
	try {

    document.getElementById('oef-modeReglement').value=oef_chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_pressOnEcheancesMultiples() {
	try {

		var url = "chrome://opensi/content/facturation/user/factu_fournisseur/popup-echeancesMultiples.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_refreshEcheance, oef_factureId, (oef_mode!="V"));

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_refreshEcheance() {
	try {

		var qGet = new QueryHttp("Facturation/Factu_Fournisseur/getFirstEcheanceFournisseur.tmpl");
		qGet.setParam("Facture_Id", oef_factureId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;
		document.getElementById('oef-echeance').value = contenu.getAttribute('Date_Echeance');
		oef_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
  	document.getElementById('oef-echeance').disabled = !echModifiable;
		document.getElementById('oef-modeReglement').disabled = !echModifiable;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_calcEcheance() {
	try {

		var dateFacture = document.getElementById('oef-dateFacture').value;

		if (!document.getElementById('oef-echeance').disabled && !isEmpty(oef_fournisseurId) && isDate(dateFacture)) {
			var qCalcEcheance = new QueryHttp("Facturation/Factu_Fournisseur/calcEcheance.tmpl");
			qCalcEcheance.setParam("Date_Facture", dateFacture);
			qCalcEcheance.setParam("Fournisseur_Id", oef_fournisseurId);
			var result = qCalcEcheance.execute();
			document.getElementById('oef-echeance').value = result.responseXML.documentElement.getAttribute('Echeance');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_rechercherFournisseur() {
  try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherFournisseur);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

		oef_fournisseurId = fournisseurId;
		oef_setModifie(true);
		oef_chargerCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_rechercherAdr() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdrCom.xul?"+ cookie() +"&Fournisseur_Id="+ oef_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdr);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdr(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contactId, depotId) {
  try {

		document.getElementById("oef-denomination").value = nom;
		document.getElementById("oef-adresse1").value = adr1;
		document.getElementById("oef-adresse2").value = adr2;
		document.getElementById("oef-adresse3").value = adr3;
		document.getElementById("oef-codePostal").value = cp;
		document.getElementById("oef-ville").value = ville;
	  document.getElementById("oef-codePays").value = code_pays;

		oef_rechargerTVA();

	  if (!isEmpty(contactId)) {
	  	var qLoad = new QueryHttp("Facturation/Fournisseurs/loadContactFournisseur.tmpl");
	  	qLoad.setParam("Contact_Id", contactId);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInter(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oef_setModifie(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteur() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInterFournisseur.xul?"+ cookie() +"&Fournisseur_Id="+ oef_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInter);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInter(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oef-civInter").value = civ;
		document.getElementById("oef-nomInter").value = nom;
		document.getElementById("oef-prenomInter").value = prenom;
		document.getElementById("oef-telInter1").value = tel1;
		document.getElementById("oef-telInter2").value = tel2;
		document.getElementById("oef-faxInter").value = fax;
		document.getElementById("oef-emailInter").value = email;

		oef_setModifie(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_chargerCoord() {
  try {

		var qGet = new QueryHttp("Facturation/Fournisseurs/getDefautDocumentAchat.tmpl");
		qGet.setParam("Fournisseur_Id", oef_fournisseurId);
	  var result = qGet.execute();

	  var contenu = result.responseXML.documentElement;

		document.getElementById('oef-numFournisseur').value = contenu.getAttribute("Num_Fournisseur");

		document.getElementById("oef-denomination").value = contenu.getAttribute("Denomination");
    document.getElementById("oef-adresse1").value = contenu.getAttribute("Adresse_1");
    document.getElementById("oef-adresse2").value = contenu.getAttribute("Adresse_2");
		document.getElementById("oef-adresse3").value = contenu.getAttribute("Adresse_3");
    document.getElementById("oef-codePostal").value = contenu.getAttribute("Code_Postal");
    document.getElementById("oef-ville").value = contenu.getAttribute("Ville");
    document.getElementById("oef-codePays").value = contenu.getAttribute("Code_Pays");

		document.getElementById("oef-civInter").value = contenu.getAttribute("Civ_Inter");
		document.getElementById("oef-nomInter").value = contenu.getAttribute("Nom_Inter");
		document.getElementById("oef-prenomInter").value = contenu.getAttribute("Prenom_Inter");
		document.getElementById("oef-telInter1").value = contenu.getAttribute("Tel_Inter_1");
		document.getElementById("oef-telInter2").value = contenu.getAttribute("Tel_Inter_2");
		document.getElementById("oef-faxInter").value = contenu.getAttribute("Fax_Inter");
		document.getElementById("oef-emailInter").value = contenu.getAttribute("Email_Inter");

		document.getElementById('oef-remise').value = contenu.getAttribute("Taux_Remise");
		document.getElementById('oef-bRemise').setAttribute("class", "bIcoPourcentage");
		oef_typeRemise = 'P';

		oef_rechargerTVA();

		oef_chargerResponsables(contenu.getAttribute('Util_R'));
		oef_chargerPolesActivite(contenu.getAttribute("Pole_Activite"));

		if (!oef_bloquerEcheance) {
			oef_calcEcheance();
	    oef_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		}

		var francoPort = contenu.getAttribute('Franco_Port')=="true";
		var montantFranco = contenu.getAttribute("Montant_Franco");
		oef_majFrancoPort(francoPort, montantFranco);

		oef_ajouterLigne("I");

		document.getElementById('oef-bChercherAdr').disabled = false;
		document.getElementById('oef-bChercherInter').disabled = false;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oef-bSupprimer').disabled = true;
		document.getElementById('oef-bMoveUp').disabled = true;
		document.getElementById('oef-bMoveDown').disabled = true;
		document.getElementById('oef-bMoveFirst').disabled = true;
		document.getElementById('oef-bMoveLast').disabled = true;
		document.getElementById('oef-bMultiSuppression').disabled = true;
		document.getElementById('oef-bCommentaire').disabled = true;

		oef_modeLigne = "C";
		oef_typeLigne = typeLigne;
		oef_ligneId = "";

		oef_formatLigne(typeLigne);
		var codePays = document.getElementById('oef-codePays').value;

		if (typeLigne=="S") {
			oef_articleId = articleId;

			var qInfos = new QueryHttp("Facturation/Articles/getInfosArticleAchat.tmpl");
			qInfos.setParam("Article_Id", articleId);
			qInfos.setParam("Fournisseur_Id", oef_fournisseurId);
			var result = qInfos.execute();

			var contenu = result.responseXML.documentElement;
      document.getElementById("oef-designation").value = contenu.getAttribute("Designation");
      document.getElementById("oef-numLot").value = "";
			document.getElementById("oef-nbPieces").value = "";
			document.getElementById('oef-quantite').value = 1;
			document.getElementById('oef-unite').value = contenu.getAttribute("Unite_Id");
			document.getElementById("oef-datePeremption").value = "";
      document.getElementById("oef-PU").value = contenu.getAttribute("Prix_Unitaire");
      document.getElementById('oef-ristourne').value = "0.00";
      document.getElementById("oef-codeTVA").value = (codePays=="FR"?contenu.getAttribute("Code_TVA"):getCodeTvaZero(codePays));
		}
		else {
			oef_articleId = "";
			document.getElementById("oef-bConsultSerieLigne").disabled = true;
			document.getElementById('oef-reference').value = "";
			document.getElementById('oef-designation').value = "";
			document.getElementById("oef-numLot").value = "";
			document.getElementById("oef-nbPieces").value = "";
			document.getElementById('oef-quantite').value = 1;
			document.getElementById('oef-unite').value = oef_uniteDefaut;
			document.getElementById("oef-datePeremption").value = "";
			document.getElementById('oef-PU').value = "";
			document.getElementById('oef-ristourne').value = "0.00";
			document.getElementById('oef-codeTVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));
			oef_insertionLigneId = 0;
			document.getElementById('oef-bAjouterLigne').disabled = true;
			document.getElementById('oef-actInsert').collapsed = true;
			oef_aLignes.setCellSrc(oef_currentIndex, 'oef-colReference', "");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_ajouterLigneAvant() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {
			var idx = oef_aLignes.getCurrentIndex();
			var ligneId = oef_aLignes.getCellText(idx,'oef-colLigneId');
			oef_annulerLigne();
			oef_aLignes.setCellSrc(idx, 'oef-colReference', "chrome://opensi/content/design/insertbefore.png");
			oef_insertionLigneId = ligneId;
			oef_currentIndex = idx;
			document.getElementById('oef-actInsert').collapsed = false;
			document.getElementById('oef-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_pressOnLigneFacture(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oef_ajouterLigneAvant();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_rechercherLigneBRAFacturer() {
  try {

		if (!isEmpty(oef_factureId)) {
			var url = "chrome://opensi/content/facturation/user/factu_fournisseur/popup-rechArticleAFacturer.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherLigneBRAFacturer, oef_fournisseurId, oef_factureId);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_retourRechercherLigneBRAFacturer() {
  try {

  	oef_ajouterLigne("I");
  	oef_aLignes.initTree(oef_afterRefreshArticles);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_formatLigne(typeLigne) {
  try {
		switch(typeLigne) {
			case "S":
        if (oef_mode != 'V') {
				  document.getElementById('oef-reference').disabled = true;
				  document.getElementById('oef-designation').disabled = true;
				  document.getElementById('oef-numLot').disabled = false;
					document.getElementById('oef-nbPieces').disabled = false;
					document.getElementById('oef-quantite').disabled = false;
					document.getElementById('oef-unite').disabled = false;
					document.getElementById('oef-datePeremption').disabled = false;
				  document.getElementById('oef-PU').disabled = false;
				  document.getElementById('oef-ristourne').disabled = false;
				  document.getElementById('oef-bRistourne').disabled = false;
				  document.getElementById('oef-codeTVA').disabled = false;
				  document.getElementById('oef-bValider').disabled = false;
				  document.getElementById('oef-bAnnuler').disabled = false;
        }
				break;

			case "I":
        if (oef_mode != 'V') {
  				document.getElementById('oef-reference').disabled = false;
	  			document.getElementById('oef-designation').disabled = false;
		  		document.getElementById('oef-numLot').disabled = true;
					document.getElementById('oef-nbPieces').disabled = false;
					document.getElementById('oef-quantite').disabled = false;
					document.getElementById('oef-unite').disabled = false;
					document.getElementById('oef-datePeremption').disabled = true;
			  	document.getElementById('oef-PU').disabled = false;
				  document.getElementById('oef-ristourne').disabled = false;
				  document.getElementById('oef-bRistourne').disabled = false;
				  document.getElementById('oef-codeTVA').disabled = false;
				  document.getElementById('oef-bValider').disabled = false;
				  document.getElementById('oef-bAnnuler').disabled = false;
        }
				break;

			default:
				var codePays = document.getElementById('oef-codePays').value;

				document.getElementById('oef-reference').value = "";
				document.getElementById('oef-designation').value = "";
				document.getElementById('oef-numLot').value = "";
				document.getElementById('oef-nbPieces').value = "";
				document.getElementById('oef-quantite').value = "";
				document.getElementById('oef-unite').value = oef_uniteDefaut;
				document.getElementById('oef-datePeremption').value = "";
				document.getElementById('oef-PU').value = "";
				document.getElementById('oef-ristourne').value = "";
				document.getElementById('oef-codeTVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));
				oef_ligneId = "";
				document.getElementById('oef-reference').disabled = true;
				document.getElementById('oef-designation').disabled = true;
				document.getElementById('oef-numLot').disabled = true;
				document.getElementById('oef-nbPieces').disabled = true;
				document.getElementById('oef-quantite').disabled = true;
				document.getElementById('oef-unite').disabled = true;
				document.getElementById('oef-datePeremption').disabled = true;
				document.getElementById('oef-PU').disabled = true;
				document.getElementById('oef-ristourne').disabled = true;
				document.getElementById('oef-bRistourne').disabled = true;
				document.getElementById('oef-codeTVA').disabled = true;
				document.getElementById('oef-bSupprimer').disabled = true;
				document.getElementById('oef-bMoveUp').disabled = true;
				document.getElementById('oef-bMoveDown').disabled = true;
				document.getElementById('oef-bMoveFirst').disabled = true;
				document.getElementById('oef-bMoveLast').disabled = true;
				document.getElementById('oef-bMultiSuppression').disabled = true;
				document.getElementById('oef-bCommentaire').disabled = true;
				document.getElementById('oef-bValider').disabled = true;
				document.getElementById('oef-bAnnuler').disabled = true;
				break;
		}
	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_pressOnWindow(ev) {
	try {

		if (ev.altKey && oef_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
					oef_rechercherStock();
        	break;
    	}
		}
		else if (ev.ctrlKey && oef_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oef_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();	
				oef_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oef_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherStock, "A", reference, null, null, oef_fournisseurId, null, null, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourRechercherStock(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oef-reference').value = reference;
			document.getElementById('oef-quantite').focus();
			oef_ajouterLigne("S", articleId);
		}
		else {
			oef_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_rechercherReference() {
	try {

		var reference = document.getElementById('oef-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam('Reference', reference);
		qSearch.setParam('Vente_Achat', "A");
		if (!isEmpty(oef_fournisseurId)) {
			qSearch.setParam('Fournisseur_Id', oef_fournisseurId);
		}
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oef-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oef-quantite').focus();
			oef_ajouterLigne("S", articleId);
		}
		else {
			oef_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oef_mode=="C") {
			ok = oef_enregistrerFacture();
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/Factu_Fournisseur/addLigneFactureFournisseur.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Facture_Id", oef_factureId);
			qAdd.execute();

			oef_ajouterLigne("I");
			oef_aLignes.initTree(oef_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oef_ouvrirLigne() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {

			if (oef_aLignes.nbSelection()==1) {
				var i = oef_aLignes.getCurrentIndex();
				oef_aLignes.setCellSrc(i, 'oef-colReference', "");
				oef_currentIndex = i;

				oef_typeLigne = oef_aLignes.getCellText(i,'oef-colTypeLigne');
				document.getElementById("oef-bConsultSerieLigne").disabled = (oef_typeLigne!="S");
				document.getElementById('oef-bMultiSuppression').disabled = true;

				if (oef_aLignes.getCellText(i,'oef-colTypeLigne')=="C") {
					oef_ajouterLigne("I");
				}
				else {
					oef_modeLigne = "M";

					document.getElementById("oef-reference").value = oef_aLignes.getCellText(i,'oef-colReference');
					document.getElementById("oef-designation").value = oef_aLignes.getCellText(i,'oef-colDesignation');
					document.getElementById("oef-numLot").value = oef_aLignes.getCellText(i,'oef-colNumLot');
					document.getElementById("oef-nbPieces").value = oef_aLignes.getCellText(i,'oef-colNbPieces');
					document.getElementById("oef-quantite").value = oef_aLignes.getCellText(i,'oef-colQuantite');
					document.getElementById("oef-unite").value = oef_aLignes.getCellText(i,'oef-colUnite');
					document.getElementById("oef-datePeremption").value = oef_aLignes.getCellText(i,'oef-colDatePeremption');
					document.getElementById("oef-PU").value = oef_aLignes.getCellText(i,'oef-colPU');
					document.getElementById("oef-ristourne").value = oef_aLignes.getCellValue(i,'oef-colRistourne');
					oef_typeRistourne = oef_aLignes.getSelectedCellText('oef-colTypeRistourne');
					document.getElementById('oef-bRistourne').setAttribute("class", (oef_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					oef_ligneId = oef_aLignes.getCellText(i,'oef-colLigneId');
					oef_articleId = oef_aLignes.getCellText(i,'oef-colArticleId');
        	document.getElementById("oef-codeTVA").value = oef_aLignes.getCellText(i,'oef-colCodeTVA');

        	if (oef_mode == "M") {
						document.getElementById('oef-bAjouterLigne').disabled = false;
						oef_insertionLigneId = 0;
						document.getElementById('oef-actInsert').collapsed = true;

        		document.getElementById('oef-bCommentaire').disabled = false;
  		    	document.getElementById('oef-bSupprimer').disabled = false;

  		    	// on ignore les lignes de commentaires
  					var firstIndex = 0;
  					var lastIndex = oef_aLignes.nbLignes()-1;
  					if (oef_aLignes.getCellText(firstIndex,'oef-colTypeLigne')=="C") { firstIndex++; }
  					if (oef_aLignes.getCellText(lastIndex,'oef-colTypeLigne')=="C") { lastIndex--; }

  					document.getElementById('oef-bMoveUp').disabled = (i==firstIndex);
  					document.getElementById('oef-bMoveDown').disabled = (i==lastIndex);
						document.getElementById('oef-bMoveFirst').disabled = (i==firstIndex);
  					document.getElementById('oef-bMoveLast').disabled = (i==lastIndex);
        	}
					oef_formatLigne(oef_typeLigne);
				}
			}
			else {
				oef_ajouterLigne("I");
				document.getElementById('oef-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_ouvrirCommentaire() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {
			var i = oef_aLignes.getCurrentIndex();

			if (oef_aLignes.getCellText(i,'oef-colTypeLigne')=="C") {
				oef_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_deplacerLigne(moveType) {
	try {

		if (oef_aLignes.isSelected() && oef_mode=="M" && oef_aLignes.getSelectedCellText('oef-colTypeLigne')!="C") {

			document.getElementById('oef-bMoveUp').disabled = true;
			document.getElementById('oef-bMoveDown').disabled = true;
			document.getElementById('oef-bMoveFirst').disabled = true;
			document.getElementById('oef-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Factu_Fournisseur/moveLigneFactureFournisseur.tmpl");
			qMove.setParam("Ligne_Id", oef_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oef_toSelectLigne = oef_ligneId;
				oef_ajouterLigne("I");
				oef_aLignes.initTree(oef_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_validerLigne() {
  try {

		var reference = document.getElementById("oef-reference").value;
		var designation = document.getElementById("oef-designation").value;
		var numLot = document.getElementById("oef-numLot").value;
		var nbPieces = document.getElementById("oef-nbPieces").value;
		var quantite = document.getElementById("oef-quantite").value;
		var unite = document.getElementById("oef-unite").value;
		var datePeremption = document.getElementById("oef-datePeremption").value;
		var prixUnitaire = document.getElementById("oef-PU").value;
		var ristourne = document.getElementById("oef-ristourne").value;
		var codeTVA = document.getElementById("oef-codeTVA").value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		var ok = true;

		if (oef_mode=="C") {
			ok = oef_enregistrerFacture();
		}

		if (oef_modeLigne=="M" && checkQte(quantite)) {
			var qCheckImputation = new QueryHttp("Facturation/Factu_Fournisseur/checkImputationArticleBR.tmpl");
			qCheckImputation.setParam("Ligne_Id", oef_ligneId);
			qCheckImputation.setParam("Quantite", quantite);
			var result = qCheckImputation.execute();
		  if (result.responseXML.documentElement.getAttribute("Surplus")=="true") {
		    ok = ok && window.confirm("Attention : la quantit\u00E9 factur\u00E9e d\u00E9passe la quantit\u00E9 r\u00E9ceptionn\u00E9e. Voulez-vous continuer ?");
		  }
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if (isEmpty(prixUnitaire) || !checkDecimal(prixUnitaire,4) || !isPositiveOrNull(prixUnitaire)) { showWarning("Prix unitaire incorrect !");	}
			else if (isEmpty(ristourne) || (oef_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (oef_checkNumLotLigne(numLot, datePeremption)) {

				var qSave;

				if (oef_modeLigne=="C") {
					if (oef_insertionLigneId==0) {
						oef_currentIndex = oef_aLignes.nbLignes();
					}
					qSave = new QueryHttp("Facturation/Factu_Fournisseur/ajouterArticle.tmpl");
					qSave.setParam("Facture_Id", oef_factureId);
				}
				else {
					qSave = new QueryHttp("Facturation/Factu_Fournisseur/modifierArticle.tmpl");
					qSave.setParam("Ligne_Id", oef_ligneId);
				}

				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oef_typeRistourne);
				qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Num_Lot", numLot);
				qSave.setParam("Nb_Pieces", nbPieces);
				qSave.setParam("Unite", unite);
				qSave.setParam("Date_Peremption", datePeremption);
				qSave.setParam("Insertion_Ligne_Id", oef_insertionLigneId);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var contenu = result.responseXML.documentElement;

					if (oef_modeLigne=="C") {
						oef_ligneId = contenu.getAttribute('Ligne_Id');
					}

					oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);
				  var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
				  document.getElementById('oef-echeance').disabled = !echModifiable;
				  document.getElementById('oef-modeReglement').disabled = !echModifiable;
				  document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

					oef_checkNumSerieLigne(quantite);

					oef_ajouterLigne("I");
					oef_aLignes.initTree(oef_afterRefreshArticles);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_annulerLigne() {
  try {

  	oef_aLignes.clearSelection();
  	oef_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oef_ligneId)) {
			listLigneId = oef_ligneId;
			maxIndex = oef_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oef_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oef_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oef_aLignes.getCellText(v,'oef-colTypeLigne')!="C") {
			  		listLigneId += oef_aLignes.getCellText(v,'oef-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Factu_Fournisseur/supprimerArticle.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
    		var contenu = result.responseXML.documentElement;
    		oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);
    		var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
    		document.getElementById('oef-echeance').disabled = !echModifiable;
    		document.getElementById('oef-modeReglement').disabled = !echModifiable;
    		document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

				oef_currentIndex = maxIndex-1;
				oef_ajouterLigne("I");
				oef_aLignes.initTree(oef_afterRefreshArticles);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_appliquerRistourne() {
	try {
		
		var listLigneId = "";
		var maxIndex = 0;

		if (oef_aLignes.isSelected()) {
			var start = new Object();
			var end = new Object();
			var numRanges = oef_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oef_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oef_aLignes.getCellText(v,'oef-colTypeLigne')!="C") {
			  		listLigneId += oef_aLignes.getCellText(v,'oef-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "FF", listLigneId, oef_retourAppliquerRistourne);

			oef_currentIndex = maxIndex;
			oef_ajouterLigne("I");
			oef_aLignes.initTree(oef_afterRefreshArticles);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_retourAppliquerRistourne(bloquerEcheance, echModifiable) {
	try {

		oef_bloquerEcheance = bloquerEcheance;
 		document.getElementById('oef-echeance').disabled = !echModifiable;
 		document.getElementById('oef-modeReglement').disabled = !echModifiable;
 		document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_enregistrerFacture() {
  try {

		var ok = false;

		var modeReglement = document.getElementById('oef-modeReglement').value;
		var fraisPort = document.getElementById('oef-fraisPort').value;
		var escompte = document.getElementById('oef-escompte').value;
		var echeance = document.getElementById('oef-echeance').value;
    var denomination = document.getElementById('oef-denomination').value;
    var adresse1 = document.getElementById('oef-adresse1').value;
    var adresse2 = document.getElementById('oef-adresse2').value;
		var adresse3 = document.getElementById('oef-adresse3').value;
    var cp = document.getElementById('oef-codePostal').value;
    var ville = document.getElementById('oef-ville').value;
		var codePays = document.getElementById('oef-codePays').value;
		var civInter = document.getElementById('oef-civInter').value;
		var nomInter = document.getElementById('oef-nomInter').value;
		var prenomInter = document.getElementById('oef-prenomInter').value;
		var telInter1 = document.getElementById('oef-telInter1').value;
		var telInter2 = document.getElementById('oef-telInter2').value;
		var faxInter = document.getElementById('oef-faxInter').value;
		var emailInter = document.getElementById('oef-emailInter').value;
		var numero = document.getElementById('oef-numFacture').value;
		var dateFact = document.getElementById('oef-dateFacture').value;
		var etablissement = document.getElementById('oef-etablissement').value;
		var secteurActivite = document.getElementById("oef-secteur").value;
		var responsable = document.getElementById('oef-responsable').value;
		var commentairesFin = document.getElementById('oef-commentairesFin').value;
		var commentairesInt = document.getElementById('oef-commentairesInt').value;

		var remise = document.getElementById('oef-remise').value;
	  var remiseFP = document.getElementById('oef-remiseFP').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;

		var montantBase = oef_montantHT;

		oef_codeTVAPort = document.getElementById('oef-codeTVAFraisPort').value;
		oef_tauxTVAPort = getTva(oef_codeTVAPort);

		if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination du fournisseur !"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez saisir l'adresse du fournisseur !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez saisir la ville du fournisseur !"); }
		else if (isEmpty(echeance) || !isDate(echeance)) { showWarning("Date d'\u00E9ch\u00E9ance incorrecte !"); }
		else if (isEmpty(remise) || (oef_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oef_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (isEmpty(numero)) { showWarning("Num\u00E9ro de facture incorrect !"); }
		else if (isEmpty(dateFact) || !isDate(dateFact)) { showWarning("Date de la facture incorrecte !"); }
    else if (!isEmpty(telInter1) && !isPhone(telInter1)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
    else if (!isEmpty(telInter2) && !isPhone(telInter2)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (!isEmpty(faxInter) && !isPhone(faxInter)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(emailInter) && !isEmail(emailInter)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
		else {

		  fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			var qSave;

			if (oef_mode=="C") {
			  qSave = new QueryHttp("Facturation/Factu_Fournisseur/creerFacture.tmpl");
			} else {
			  qSave = new QueryHttp("Facturation/Factu_Fournisseur/modifierFacture.tmpl");
				qSave.setParam("Facture_Id", oef_factureId);
			}

			if (oef_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oef_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			qSave.setParam("Fournisseur_Id", oef_fournisseurId);
			qSave.setParam("PRemise", tauxRemise);
			qSave.setParam("MRemise", montantRemise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
			qSave.setParam("Date_Facture", dateFact);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Numero", numero);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", cp);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Util_R", responsable);
			qSave.setParam("Civ_Inter", civInter);
			qSave.setParam("Nom_Inter", nomInter);
			qSave.setParam("Prenom_Inter", prenomInter);
			qSave.setParam("Tel_Inter_1", telInter1);
			qSave.setParam("Tel_Inter_2", telInter2);
			qSave.setParam("Fax_Inter", faxInter);
			qSave.setParam("Email_Inter", emailInter);
			qSave.setParam("Code_TVA_Port", oef_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oef_tauxTVAPort);
			qSave.setParam("Pole_Activite", secteurActivite);
			qSave.setParam("Frais_Port", fraisPort);
			qSave.setParam("Date_Echeance", echeance);
			qSave.setParam("Mode_Reg_Id", modeReglement);
			qSave.setParam("Escompte", escompte);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				if (oef_mode=="C") {
					oef_factureId = contenu.getAttribute("Facture_Id");
					oef_aLignes.setParam("Facture_Id", oef_factureId);
					oef_chargerFacture();
				}
				else if (oef_mode=="M") {
					oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);
			    var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
			    document.getElementById('oef-echeance').disabled = !echModifiable;
			    document.getElementById('oef-modeReglement').disabled = !echModifiable;
			    document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;
			    oef_initAcomptes();
			  }
			  oef_setModifie(false);
				ok = true;
			}
		}

    return ok;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_calculTotaux() {
  try {

		var fournisseurConnu = (oef_fournisseurId!="");

  	if (oef_mode!='V') {
			document.getElementById('oef-bRechFournisseur').collapsed = (oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-codePays').disabled = (oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-bChercherAdr').disabled = (!fournisseurConnu || oef_aLignes.nbLignes()>0);
		}

		var tauxEscompte = parseFloat(document.getElementById('oef-escompte').value);
		var fraisPort = parseFloat(document.getElementById('oef-fraisPort').value);
		var remise = parseFloat(document.getElementById('oef-remise').value);
		var remiseFP = parseFloat(document.getElementById('oef-remiseFP').value);

		if ((oef_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oef_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(tauxEscompte) && isPositiveOrNull(fraisPort)) {

			var calculDocument = new CalculDocument();
			if (oef_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(fraisPort);
			if (oef_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oef-codeTVAFraisPort').value, getTva(document.getElementById('oef-codeTVAFraisPort').value));
			calculDocument.setEscompteP(tauxEscompte);
			calculDocument.setAcompte(oef_montantAcompte);

			var nbLignes = oef_aLignes.nbLignes();
			for (var i=0; i<nbLignes; i++) {
				if (oef_aLignes.getCellText(i,'oef-colTypeLigne')!="C") {
					var montantLigne = oef_aLignes.getCellText(i,'oef-colTotalHT');
					var codeTVA = oef_aLignes.getCellText(i,'oef-colCodeTVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			document.getElementById('oef-montantHT').value = calculDocument.getMontantHT();
			document.getElementById('oef-montantRemise').value = calculDocument.getRemiseM();
			document.getElementById('oef-montantFraisPort').value = calculDocument.getFraisPortBruts();
			document.getElementById('oef-montantRemiseFP').value = calculDocument.getRemiseFPM();
			document.getElementById('oef-totalHT').value = calculDocument.getTotalHT();
			document.getElementById('oef-TVA').value = calculDocument.getTotalTVA();
			document.getElementById('oef-montantEscompte').value = calculDocument.getEscompteM();
			document.getElementById('oef-netCommercial').value = calculDocument.getNetCommercial();
			document.getElementById('oef-montantAcompte').value = calculDocument.getAcompte();
			document.getElementById('oef-totalTTC').value = calculDocument.getTotalTTC();

			oef_montantHT = calculDocument.getMontantHTSansFormat();

			document.getElementById('oef-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
			document.getElementById('oef-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
			document.getElementById('oef-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
			document.getElementById('oef-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_afterRefreshArticles() {
	try {

		if (oef_toSelectLigne!=null) {
			for (var i=0; i<oef_aLignes.nbLignes(); i++) {
				if (oef_aLignes.getCellText(i, "oef-colLigneId")==oef_toSelectLigne && oef_aLignes.getCellText(i, "oef-colTypeLigne")!="C") {
					oef_aLignes.select(i);
					break;
				}
			}
			oef_toSelectLigne = null;
		}
		oef_aLignes.ensureRowIsVisible(oef_currentIndex);

		oef_initAcomptes();
		oef_calculTotaux();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_demandeEnregistrement() {
  try {

		if (oef_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la facture ?")) {
				oef_enregistrerFacture();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_setModifie(m) {
  try {

  	oef_modifie = m;
  	document.getElementById('oef-bVisualiser').disabled = m;
		document.getElementById('oef-bValiderFacture').disabled = m;
		document.getElementById('oef-bGenererEcarts').disabled = m;
		if (m) {
			document.getElementById('oef-tabFacture').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oef-bEchMultiples').disabled = true;
			document.getElementById('oef-bAffecterAcomptes').disabled = true;
		}
		else {
			document.getElementById('oef-tabFacture').setAttribute('image', null);
			document.getElementById('oef-bEchMultiples').disabled = (oef_mode=="C" || oef_bloquerEcheance);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_nouvelleFacture() {
	try {

		oef_mode = "C";
		oef_ecartsGen = false;
		oef_reinitialiser();
		document.getElementById('oef-echeance').value = getDateCourante();
		oef_chargerResponsables(getProfil().getLoggedUser());
		oef_chargerEtablissement(etablissementDefaut);
		oef_chargerModesReglements(oef_defModeReglement);
		oef_chargerPolesActivite("");
		oef_rechargerTVA();
		oef_debloquerChamps();
		oef_typeRistourne = 'P';
		document.getElementById('oef-bRistourne').setAttribute("class", "bIcoPourcentage");

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_visualiserFacture() {
  try {

		if (isEmpty(document.getElementById('oef-numFacture').value)) {
			showWarning("Num\u00E9ro de facture incorrect !");
		}
		else {
			var ok = true;
			if (oef_mode=="M") {
				ok = oef_enregistrerFacture();
			}

			if (ok) {
		  	var modeReglement = document.getElementById('oef-modeReglement').value;

				if (oef_aLignes.nbLignes()==0 && document.getElementById('oef-fraisPort').value==0) {
					showWarning("La facture ne contient aucune ligne");
				}
				else {

			    if (oef_mode != "V") {
			    	var qCheck = new QueryHttp("Facturation/Factu_Fournisseur/checkEcheancesFacture.tmpl");
			    	qCheck.setParam("Facture_Id", oef_factureId);
			    	var result = qCheck.execute();

						var errors = new Errors(result);
						if (errors.hasNext()) {
							errors.show();
							ok = false;
						}
			    }

			    if (ok) {
			    	var qCheck = new QueryHttp("Facturation/Factu_Fournisseur/checkImputationsAcomptes.tmpl");
			    	qCheck.setParam("Facture_Id", oef_factureId);
			    	var result = qCheck.execute();

			    	var errors = new Errors(result);
						if (errors.hasNext()) {
							errors.show();
							ok = false;
						}
			    }

					if (ok && oef_actSuiviSerie) {
						var qCheck = new QueryHttp("Facturation/Factu_Fournisseur/checkNumSerieFF.tmpl");
						qCheck.setParam("Facture_Id", oef_factureId);
						var result = qCheck.execute();

						var errors = new Errors(result);
						if (errors.hasNext()) {
							errors.show();
							ok = false;
						}
					}

					if (ok && (oef_mode=="V" ||	window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de la facture ?\n(Attention la facture g\u00E9n\u00E9r\u00E9e ne pourra plus \u00EAtre modifi\u00E9e !)"))) {
						document.getElementById('oef-deckFacture').selectedIndex=1;
						document.getElementById('bRetourFacture').collapsed = false;
						oef_typeDocPdf = "FF";

						var qGenPdf = new QueryHttp("Facturation/Factu_Fournisseur/facture_pdf.tmpl");
						qGenPdf.setParam("Facture_Id", oef_factureId);
						var result = qGenPdf.execute();
						var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
						document.getElementById('oef-pdfFacture').setAttribute("src",page);
					}
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_supprimerFacture() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la facture ?")) {

			var qSupprimer = new QueryHttp("Facturation/Factu_Fournisseur/deleteFactureFournisseur.tmpl");
			qSupprimer.setParam("Facture_Id", oef_factureId);
			var result = qSupprimer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La facture a \u00E9t\u00E9 supprim\u00E9e !");
			}

			retourMenuFactures();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerCommentaire() {
  try {

		if (oef_aLignes.isSelected()) {
			var ligneId = oef_aLignes.getSelectedCellText('oef-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "FF", ligneId);

    	oef_aLignes.initTree(oef_afterRefreshArticles);
    	oef_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FF", oef_factureId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oef-commentairesFin').value;
		var commentairesInt = document.getElementById('oef-commentairesInt').value;
		var readOnly = (oef_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourEditerCommentaires, "FF", oef_factureId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oef-commentairesFin').value = commentairesFin;
		document.getElementById('oef-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_choisirMentions() {
  try {

  	var ok = true;

  	if (oef_mode=="C") {
			ok = oef_enregistrerFacture();
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "FF", oef_factureId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_initVersion() {
	try {

		oef_aVersion.setParam("Facture_Id", oef_factureId);
		oef_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_envoyerMail() {
	try {

		var docId = (oef_typeDocPdf=="FF"?oef_factureId:oef_acompteId);

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oef_typeDocPdf, docId);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oef_initAcomptes() {
	try {

		oef_acompteId = "";

		var qExist = new QueryHttp("Facturation/Factu_Fournisseur/existAcompteImputable.tmpl");
		qExist.setParam("Facture_Id", oef_factureId);
		var result = qExist.execute();
		var existAcompteImputable = (result.responseXML.documentElement.getAttribute("Exist")=="true");

		document.getElementById('oef-bAffecterAcomptes').disabled = (oef_mode!="V" && oef_aAcomptes.nbLignes()>0?false:!existAcompteImputable);
		document.getElementById('oef-bReediterAcompte').disabled = true;

		if (oef_mode!="V") {
			var desactiver = (oef_aAcomptes.nbLignes()>0 && isEmpty(oef_fournisseurId));
			if (desactiver) {
				document.getElementById('oef-denomination').setAttribute('readonly', true);
			}
			else {
				document.getElementById('oef-denomination').removeAttribute('readonly');
			}
			document.getElementById('oef-bRechFournisseur').disabled = desactiver;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_retourAcompte() {
	try {

		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('bRetourFacture').collapsed = true;
		oef_aAcomptes.initTree(oef_initAcomptes);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_pressOnListeAcomptes() {
	try {

		if (oef_aAcomptes.isSelected()) {
			document.getElementById('oef-bReediterAcompte').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_editerAcompte() {
	try {

		if (oef_aAcomptes.isSelected()) {
			oef_acompteId = oef_aAcomptes.getSelectedCellText('oef-colAcompteId');

			oef_typeDocPdf = "FAF";

			document.getElementById('oef-pdfFacture').setAttribute('src', '');
			document.getElementById('oef-deckFacture').selectedIndex = 1;
			document.getElementById('bRetourFacture').collapsed = false;

			var qGenPdf = new QueryHttp("Facturation/Commandes/pdfAcompte.tmpl");
			qGenPdf.setParam('Acompte_Id', oef_acompteId);

			var result = qGenPdf.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

			document.getElementById('oef-pdfFacture').setAttribute('src', page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_affecterAcomptes() {
	try {

		var url = "chrome://opensi/content/facturation/user/factu_fournisseur/popup-imputationAcomptes.xul?"+ cookie();

		window.openDialog(url,'','chrome,modal,centerscreen', oef_factureId);

		// on ne met pas cet appel dans les arguments du popup, car on veut que la fonction soit appele mme si l'utilisateur
		// sort du popup en passant par la croix (auquel cas aucune vrif ne peut tre faite)
		oef_retourAffecterAcomptes();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_retourAffecterAcomptes() {
	try {

		var qLoad = new QueryHttp("Facturation/Factu_Fournisseur/loadFactureFournisseur.tmpl");
		qLoad.setParam("Facture_Id", oef_factureId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;
    oef_montantAcompte = contenu.getAttribute('Acompte');
    oef_calculTotaux();
		oef_aAcomptes.initTree(oef_initAcomptes);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_checkNumSerieLigne(quantite) {
	try {

		if (oef_actSuiviSerie && !isEmpty(oef_articleId)) {

			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", oef_articleId);
			var result = qSuiviSerie.execute();
			var isSuiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true") && gConfig.isTracabiliteNSFF();

			var wrongNbSerie = false;

			if (oef_modeLigne=="M") {
			  var qNbSerie = new QueryHttp("Facturation/Factu_Fournisseur/getNbNumSerieLigneFF.tmpl");
			  qNbSerie.setParam("Ligne_Id", oef_ligneId);
			  var resNS = qNbSerie.execute();
			  var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			  if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
					wrongNbSerie = true;
			  }
		  }

			if ((oef_modeLigne=="C" && isSuiviSerie) || wrongNbSerie) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "FF", oef_ligneId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_consulterNumSerie() {
	try {

		if (oef_aLignes.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (oef_mode!="V"?"S":"C"), "FF", oef_ligneId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_checkNumLotLigne(numero, datePeremption) {
	try {

		var ok = true;

		if (oef_actSuiviLot && !isEmpty(oef_articleId)) {

			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", oef_articleId);
			var result = qSuiviLotDLC.execute();
			var isSuiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true") && gConfig.isTracabiliteNLFF();
			var isSuiviDLC = (result.responseXML.documentElement.getAttribute("Suivi_DLC")=="true") && gConfig.isTracabiliteNLFF();

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_onKeyPressNumLot(ev) {
	try {

		if (ev.keyCode==13 && !isEmpty(oef_articleId)) {
			var numero = document.getElementById("oef-numLot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherLot, oef_articleId, numero, null, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oef-numLot").value = numero;
		document.getElementById("oef-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_updateDLC() {
	try {

		var numero = document.getElementById("oef-numLot").value;

		if (!isEmpty(numero) && !isEmpty(oef_articleId)) {
			var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
			qGetDLC.setParam("Article_Id", oef_articleId);
			qGetDLC.setParam("Numero", numero);
			var result = qGetDLC.execute();
			var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
			if (!isEmpty(datePeremption)) {
				document.getElementById("oef-datePeremption").value = datePeremption;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_afficherFichiers() {
	try {

 	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
   	window.openDialog(url,'','chrome,modal,centerscreen', "FF", oef_factureId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_transformerAvoir() {
	try {

		if (window.confirm("Voulez-vous cr\u00E9er un avoir \u00E0 partir de cette facture ?")) {
			var qTrans = new QueryHttp("Facturation/Factu_Fournisseur/transFactureAvoir.tmpl");
			qTrans.setParam("Facture_Id", oef_factureId);
			var result = qTrans.execute();
			oea_avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
			document.getElementById('deck').selectedIndex = 2;
			oea_chargerAvoir();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_genererEcarts() {
	try {

		if (isEmpty(document.getElementById('oef-numFacture').value)) {
			showWarning("Num\u00E9ro de facture incorrect");
		}
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration des \u00E9carts de facturation fournisseur ? (attention la facture ne sera plus modifiable en cas d'\u00E9cart)")) {
			var qGen = new QueryHttp("Facturation/Factu_Fournisseur/generateEcartFacturation.tmpl");
			qGen.setParam("Facture_Id", oef_factureId);
			var result = qGen.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (result.responseXML.documentElement.getAttribute("Has_Ecarts")=="false") {
					showMessage("La facture ne comporte pas d'\u00E9carts avec la commande");
				}
				oef_ecartsGen = true;
			}

			oef_chargerFacture();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
