/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var off_aFamilles = new Arbre("ComboListe/combo-famillesFournisseur.tmpl", "off-famille");
var off_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "off-responsable");
var off_aDepots = new Arbre("Facturation/Fournisseurs/list-depotFournisseur.tmpl", "off-listeDepots");
var off_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "off-modeReglement");
var off_aModalitesReg = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "off-modaliteReg");
var off_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "off-poleActivite");
var off_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'off-banqueRetrait');

var off_fournisseurId;
var off_modified = false;
var off_mode;
var off_numerotationAuto;
var off_typePort;
var off_numAutoCompteFournisseur;

var off_curFamille = "";
var off_curResponsable = "";
var off_curModeReglement = "";
var off_curModaliteReg = "";
var off_selPoleActivite;
var off_selBanqueId = "";

var off_defautCFChiffre;
var off_defautModeReglement;
var off_defautModaliteReg;



function off_init() {
  try {

		var config = getConfig();

		off_numerotationAuto = !isEmpty(config.getFormatNF());
		off_numAutoCompteFournisseur = config.isNumAutoCompteFourn();
		off_defautCFChiffre = config.isCFChiffre();
		off_defautModeReglement = config.getDefModeReglementF();
		off_defautModaliteReg = config.getDefModaliteF();

		document.getElementById('off-rowGroupeCFReaCC').collapsed = !config.isActReassortCC();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "off-codePays");
		aPays.initTree(off_initPays);

		var aFormes = new Arbre("ComboListe/combo-formesJuridiques.tmpl", "off-formeJuridique");
		aFormes.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function off_initPays() {
	try {

    document.getElementById('off-codePays').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function off_selectFormeJuridique(formeJuridique) {
	try {

		var selected = false;
		var i = 0;
		var menulist = document.getElementById('off-formeJuridique');
		var items = menulist.getElementsByTagName("menuitem");
		while (!selected && i<items.length) {
			if (items[i].getAttribute("label")==formeJuridique) {
				menulist.selectedIndex = i;
				selected = true;
			}
			i++;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function off_chargerFamilles(selection) {
	try {

		off_curFamille = selection;
		off_aFamilles.setParam("Selection", off_curFamille);
		off_aFamilles.initTree(off_initFamille);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initFamille() {
  try {

		document.getElementById('off-famille').value = off_curFamille;

	} catch (e) {
		recup_erreur(e);
	}
}


function off_chargerResponsables(selection) {
	try {

		off_curResponsable = selection;
		off_aResponsables.setParam("Selection", off_curResponsable);
		off_aResponsables.initTree(off_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initResponsable() {
  try {

		document.getElementById('off-responsable').value = off_curResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function off_chargerBanques(selection) {
	try {

		off_selBanqueId = selection;
		off_aBanques.setParam("Selection", off_selBanqueId);
		off_aBanques.initTree(off_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initBanque() {
  try {

		document.getElementById('off-banqueRetrait').value = off_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function off_chargerPolesActivite(selection) {
	try {

		off_selPoleActivite = selection;
		off_aPolesActivite.setParam("Selection", off_selPoleActivite);
		off_aPolesActivite.initTree(off_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initPoleActivite() {
  try {

		document.getElementById('off-poleActivite').value = off_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function off_chargerModesReglement(selection) {
	try {

		off_curModeReglement = selection;
		off_aModesReglement.setParam("Selection", off_curModeReglement);
		off_aModesReglement.initTree(off_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initModeReglement() {
	try {

  	document.getElementById('off-modeReglement').value = off_curModeReglement;

	} catch (e) {
    recup_erreur(e);
  }
}


function off_chargerModalitesReg(selection) {
	try {

		off_curModaliteReg = selection;
		off_aModalitesReg.setParam("Selection", off_curModaliteReg);
		off_aModalitesReg.setParam("Type_Tiers", "F");
		off_aModalitesReg.initTree(off_initModaliteReg);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initModaliteReg() {
	try {

  	document.getElementById('off-modaliteReg').value = off_curModaliteReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function off_ouvrirEditionListeFamille() {
	try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=FFOURN";
    window.openDialog(url,'','chrome,modal,centerscreen', off_chargerFamilles);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_afficherFichiers() {
	try {

	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FFOU", off_fournisseurId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function off_initListeDepots() {
	try {

		off_aDepots.deleteTree();
		var logisticien = document.getElementById('off-logisticien').checked;

		if (!isEmpty(off_fournisseurId) && logisticien) {
			off_aDepots.setParam("Fournisseur_Id", off_fournisseurId);
			off_aDepots.initTree(off_initDepots);
		}
		else {
			document.getElementById('off-grpLogisticien').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initDepots() {
	try {

		document.getElementById('off-grpLogisticien').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function off_changerNumFournisseur() {
	try {

		var numFournisseur = document.getElementById('off-numFournisseur').value;

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-changementNumFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', off_remplaceNumFournisseur, off_fournisseurId, numFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_remplaceNumFournisseur(newNumFournisseur) {
	try {

		document.getElementById('off-numFournisseur').value = newNumFournisseur;
		document.getElementById('off-lblFournisseur').value = "Fiche fournisseur "+ newNumFournisseur;
		document.getElementById('off-document').setAttribute("label", "Fournisseur N\u00B0 "+ newNumFournisseur +" - "+ document.getElementById('off-denomination').value);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_getCompteCollectif() {
	try {

		var numCompte = document.getElementById('off-compteFournisseur').value;

		if (!isEmpty(numCompte)) {
			var qGet = new QueryHttp("Compta/Comptes/loadCompte.tmpl");
			qGet.setParam("Num_Compte", numCompte);
			var result = qGet.execute();
			document.getElementById('off-collectif').value = result.responseXML.documentElement.getAttribute('Collectif');
		}
		else {
			document.getElementById('off-collectif').value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function off_rechercherCompte() {
	try {

    var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', off_retourRechercherCompte, "", "F", "FOURNISSEUR", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById("off-compteFournisseur").value = numCompte;
		off_getCompteCollectif();
		off_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_switchTypePort() {
	try {

		if (off_typePort=='P') {
			document.getElementById('off-bTypePort').setAttribute("class", "bIcoEuro");
			off_typePort = 'M';
		}
		else {
			document.getElementById('off-bTypePort').setAttribute("class", "bIcoPourcentage");
			off_typePort = 'P';
		}
		off_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function off_pressOnFrancoPort() {
	try {

		var francoPort = document.getElementById('off-francoPort').checked;
		document.getElementById('off-montantFranco').disabled = !francoPort;
		if (!francoPort) {
			document.getElementById('off-montantFranco').value = "0.00";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function off_initIHM() {
	try {

		document.getElementById('off-panneau').selectedIndex = 0;
		off_hideButtons(false);

		if (off_mode=="M" || off_numerotationAuto) {
			document.getElementById('off-numFournisseur').setAttribute('readonly', true);
		}
		else {
			document.getElementById('off-numFournisseur').removeAttribute('readonly');
		}

		document.getElementById('off-tabAdresses').collapsed = off_mode=="C";
		document.getElementById('off-tabContacts').collapsed = off_mode=="C";
		document.getElementById('off-tabBanques').collapsed = off_mode=="C" || !gProfil.isAccesBanqueFou();
		document.getElementById('off-tabStatistiques').collapsed = off_mode=="C";

		document.getElementById('off-bSupprimer').collapsed = off_mode=="C";
		document.getElementById('off-numFournisseur').collapsed = off_mode=="C" && off_numerotationAuto;
		document.getElementById('off-lblAuto').collapsed = off_mode=="M" || !off_numerotationAuto;
		document.getElementById('off-bChgCodeFournisseur').collapsed = off_mode=="C" || off_numerotationAuto;
		document.getElementById('off-rowFichiers').collapsed = off_mode=="C";
		document.getElementById('off-bRechCompte').collapsed = off_mode=="C" && off_numAutoCompteFournisseur;
		document.getElementById('off-compteFournisseur').collapsed = off_mode=="C" && off_numAutoCompteFournisseur;
		document.getElementById('off-lblCpteAuto').collapsed = off_mode=="M" || !off_numAutoCompteFournisseur;

		off_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function off_nouveauFournisseur() {
  try {

		document.getElementById('off-deckFournisseur').selectedIndex = 0;

		off_mode = "C";
		off_fournisseurId = "";

		// onglet fiche signaltique
		document.getElementById('off-lblFournisseur').value = "Fiche fournisseur";

		document.getElementById('off-numFournisseur').value = "";
		document.getElementById('off-denomination').value = "";
		document.getElementById('off-civilite').value = "0";
		document.getElementById('off-nom').value = "";
		document.getElementById('off-prenom').value = "";
		document.getElementById('off-adresse1').value = "";
		document.getElementById('off-adresse2').value = "";
		document.getElementById('off-adresse3').value = "";
		document.getElementById('off-codePostal').value = "";
		document.getElementById('off-ville').value = "";
		document.getElementById('off-codePays').value = "FR";
		document.getElementById('off-tel1').value = "";
		document.getElementById('off-tel2').value = "";
		document.getElementById('off-tel3').value = "";
		document.getElementById('off-fax1').value = "";
		document.getElementById('off-fax2').value = "";
		document.getElementById('off-email1').value = "";
		document.getElementById('off-email2').value = "";
		document.getElementById('off-siteWeb').value = "";
		document.getElementById('off-comLibre').value = "";
		document.getElementById('off-codeCouleur').value = 2;
		document.getElementById('off-formeJuridique').value = "";
		document.getElementById('off-numeroTVA').value = "";
		document.getElementById('off-numSIRET').value = "";
		document.getElementById('off-codeNAF').value = "";
		off_chargerPolesActivite("");
		document.getElementById('off-codeClient').value = "";
		document.getElementById('off-indications').value = "";
		document.getElementById('off-actif').checked = true;
		document.getElementById('off-logisticien').checked = false;
		document.getElementById('off-dateOuverture').value = "";
		off_selectFormeJuridique('SARL');
		off_chargerFamilles("");
		off_chargerResponsables(gProfil.getLoggedUser());
		off_initListeDepots();

		// onglet lments de gestion
		document.getElementById('off-compteFournisseur').value = "";
		document.getElementById('off-collectif').value = "";
		document.getElementById('off-tauxRemise').value = "0.00";
		document.getElementById('off-encoursAuto').value = "0.00";
		document.getElementById('off-cfChiffre').checked = off_defautCFChiffre;
		document.getElementById('off-groupeCFReaCC').checked = true;
		document.getElementById('off-livDirecte').checked = false;
		document.getElementById('off-delaiLivraison').value = 0;
		document.getElementById('off-siteWebCom').value = "";
		document.getElementById('off-loginWeb').value = "";
		document.getElementById('off-passWeb').value = "";
		document.getElementById('off-francoPort').checked = false;
		document.getElementById('off-montantFranco').disabled = true;
		document.getElementById('off-montantFranco').value = "0.00";
		document.getElementById('off-fraisPort').value = "0.00";
		off_typePort = 'M';
		document.getElementById('off-bTypePort').setAttribute("class", "bIcoEuro");

		off_chargerBanques("");
		off_chargerModesReglement(off_defautModeReglement);
		off_chargerModalitesReg(off_defautModaliteReg);

		document.getElementById('off-creation').setAttribute("label", "");
		document.getElementById('off-modification').setAttribute("label", "");
		document.getElementById('off-document').setAttribute("label", "");

		off_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function off_chargerFournisseur() {
  try {

		document.getElementById('off-deckFournisseur').selectedIndex = 0;

		off_mode = "M";

		var qLoad = new QueryHttp("Facturation/Fournisseurs/loadFicheFournisseur.tmpl");
		qLoad.setParam('Fournisseur_Id', off_fournisseurId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		// onglet fiche signaltique
		document.getElementById('off-lblFournisseur').value = "Fiche fournisseur "+ contenu.getAttribute('Num_Fournisseur');

		document.getElementById('off-numFournisseur').value = contenu.getAttribute('Num_Fournisseur');
		document.getElementById('off-denomination').value = contenu.getAttribute('Denomination');
		document.getElementById('off-civilite').value = contenu.getAttribute('Civilite');
		document.getElementById('off-nom').value = contenu.getAttribute('Nom');
		document.getElementById('off-prenom').value = contenu.getAttribute('Prenom');
		document.getElementById('off-adresse1').value = contenu.getAttribute('Adresse_1');
		document.getElementById('off-adresse2').value = contenu.getAttribute('Adresse_2');
		document.getElementById('off-adresse3').value = contenu.getAttribute('Adresse_3');
		document.getElementById('off-codePostal').value = contenu.getAttribute('Code_Postal');
		document.getElementById('off-ville').value = contenu.getAttribute('Ville');
		document.getElementById('off-codePays').value = contenu.getAttribute('Code_Pays');
		document.getElementById('off-tel1').value = contenu.getAttribute('Tel_1');
		document.getElementById('off-tel2').value = contenu.getAttribute('Tel_2');
		document.getElementById('off-tel3').value = contenu.getAttribute('Tel_3');
		document.getElementById('off-fax1').value = contenu.getAttribute('Fax_1');
		document.getElementById('off-fax2').value = contenu.getAttribute('Fax_2');
		document.getElementById('off-email1').value = contenu.getAttribute('Email_1');
		document.getElementById('off-email2').value = contenu.getAttribute('Email_2');
		document.getElementById('off-siteWeb').value = contenu.getAttribute('Site_Web');
		document.getElementById('off-comLibre').value = contenu.getAttribute('Com_Libre');
		document.getElementById('off-codeCouleur').value = contenu.getAttribute('Code_Couleur');
		document.getElementById('off-formeJuridique').value = contenu.getAttribute('Forme_Juridique');
		document.getElementById('off-numeroTVA').value = contenu.getAttribute('Numero_TVA');
		document.getElementById('off-numSIRET').value = contenu.getAttribute('Num_SIRET');
		document.getElementById('off-codeNAF').value = contenu.getAttribute('Code_NAF');
		document.getElementById('off-codeClient').value = contenu.getAttribute('Code_Client');
		document.getElementById('off-indications').value = contenu.getAttribute('Indications');
		document.getElementById('off-actif').checked = (contenu.getAttribute('Actif')=="true");
		document.getElementById('off-logisticien').checked = (contenu.getAttribute('Logisticien')=="true");
		document.getElementById('off-dateOuverture').value = contenu.getAttribute('Date_Ouverture');

		off_chargerFamilles(contenu.getAttribute('Famille'));
		off_chargerResponsables(contenu.getAttribute('Util_R'));
		off_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		off_initListeDepots();

		// onglet lments de gestion
		document.getElementById('off-compteFournisseur').value = contenu.getAttribute('Compte_Fournisseur');
		document.getElementById('off-tauxRemise').value = contenu.getAttribute('Taux_Remise');
		document.getElementById('off-encoursAuto').value = contenu.getAttribute('Encours_Auto');
		document.getElementById('off-cfChiffre').checked = (contenu.getAttribute('CF_Chiffre')=="true");
		document.getElementById('off-groupeCFReaCC').checked = (contenu.getAttribute('Groupe_CF_Rea_CC')=="true");
		document.getElementById('off-livDirecte').checked = (contenu.getAttribute('Liv_Directe')=="true");
		document.getElementById('off-delaiLivraison').value = contenu.getAttribute('Delai_Livraison');
		document.getElementById('off-siteWebCom').value = contenu.getAttribute('Site_Web_Com');
		document.getElementById('off-loginWeb').value = contenu.getAttribute('Login_Web');
		document.getElementById('off-passWeb').value = contenu.getAttribute('Pass_Web');

		var francoPort = (contenu.getAttribute('Franco_Port')=="true");
		document.getElementById('off-francoPort').checked = francoPort;
		document.getElementById('off-montantFranco').value = contenu.getAttribute('Montant_Franco');
		document.getElementById('off-montantFranco').disabled = !francoPort;
		document.getElementById('off-fraisPort').value = contenu.getAttribute('Frais_Port');
		off_typePort = contenu.getAttribute('Type_Port');
		document.getElementById('off-bTypePort').setAttribute("class", off_typePort=="P"?"bIcoPourcentage":"bIcoEuro");

		off_getCompteCollectif();
		off_chargerBanques(contenu.getAttribute('Banque_Retrait'));
		off_chargerModesReglement(contenu.getAttribute('Mode_Reg_Id'));
		off_chargerModalitesReg(contenu.getAttribute('Modalite_Id'));

		oob_initOngletBanques();
		ooc_initOngletContacts();
		ooa_initOngletAdresses();
		oos_initOngletStatistiques();

		document.getElementById('off-creation').setAttribute("label", "Fournisseur cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('off-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('off-document').setAttribute("label", "Fournisseur N\u00B0 "+ contenu.getAttribute('Num_Fournisseur') +" - "+ contenu.getAttribute('Denomination'));

		off_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function off_enregistrerFournisseur() {
	try {

		// champs onglet fiche signaltique

		var numFournisseur = document.getElementById('off-numFournisseur').value;
		var denomination = document.getElementById('off-denomination').value;
		var civilite = document.getElementById('off-civilite').value;
		var nom = document.getElementById('off-nom').value;
		var prenom = document.getElementById('off-prenom').value;
		var adresse1 = document.getElementById('off-adresse1').value;
		var adresse2 = document.getElementById('off-adresse2').value;
		var adresse3 = document.getElementById('off-adresse3').value;
		var codePostal = document.getElementById('off-codePostal').value;
		var ville = document.getElementById('off-ville').value;
		var codePays = document.getElementById('off-codePays').value;
		var tel1 = document.getElementById('off-tel1').value;
		var tel2 = document.getElementById('off-tel2').value;
		var tel3 = document.getElementById('off-tel3').value;
		var fax1 = document.getElementById('off-fax1').value;
		var fax2 = document.getElementById('off-fax2').value;
		var email1 = document.getElementById('off-email1').value;
		var email2 = document.getElementById('off-email2').value;
		var siteWeb = document.getElementById('off-siteWeb').value;
		var comLibre = document.getElementById('off-comLibre').value;
		var codeCouleur = document.getElementById('off-codeCouleur').value;
		var formeJuridique = document.getElementById('off-formeJuridique').value;
		var numeroTVA = document.getElementById('off-numeroTVA').value;
		var numSIRET = document.getElementById('off-numSIRET').value;
		var codeNAF = document.getElementById('off-codeNAF').value;
		var famille = document.getElementById('off-famille').value;
		var poleActivite = document.getElementById('off-poleActivite').value;
		var actif = document.getElementById('off-actif').checked;
		var logisticien = document.getElementById('off-logisticien').checked;
		var responsable = document.getElementById('off-responsable').value;
		var codeClient = document.getElementById('off-codeClient').value;
		var indications = document.getElementById('off-indications').value;
		var dateOuverture = document.getElementById('off-dateOuverture').value;

		// champs onglet lments de gestion

    var compteFournisseur = document.getElementById('off-compteFournisseur').value;
		var modeReglement = document.getElementById('off-modeReglement').value;
		var modaliteReg = document.getElementById('off-modaliteReg').value;
		var tauxRemise = document.getElementById('off-tauxRemise').value;
		var banqueRetrait = document.getElementById('off-banqueRetrait').value;
		var cfChiffre = document.getElementById('off-cfChiffre').checked;
		var groupeCFReaCC = document.getElementById('off-groupeCFReaCC').checked;
		var livDirecte = document.getElementById('off-livDirecte').checked;
		var delaiLivraison = document.getElementById('off-delaiLivraison').value;
		var siteWebCom = document.getElementById('off-siteWebCom').value;
		var loginWeb = document.getElementById('off-loginWeb').value;
		var passWeb = document.getElementById('off-passWeb').value;
		var encoursAuto = document.getElementById('off-encoursAuto').value;
		var francoPort = document.getElementById('off-francoPort').checked;
		var montantFranco = document.getElementById('off-montantFranco').value;
		var fraisPort = document.getElementById('off-fraisPort').value;

		if (off_mode=="C" && isEmpty(numFournisseur) && !off_numerotationAuto) {
			showWarning("Veuillez sp\u00E9cifier un num\u00E9ro fournisseur (Onglet fiche signal\u00E9tique)");
		}
		else if (off_mode=="C" && !isCleAlpha(numFournisseur) && !off_numerotationAuto) {
			showWarning("Num\u00E9ro fournisseur invalide (Onglet fiche signal\u00E9tique)");
		}
		else if (isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination du fournisseur (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez sp\u00E9cifier l'adresse du fournisseur (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville du fournisseur (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(dateOuverture) && !isDate(dateOuverture)) { showWarning("Date d'ouverture de compte incorrecte ! (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 1 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 2 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel3) && !isPhone(tel3)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 3 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(fax1) && !isPhone(fax1)) { showWarning("Num\u00E9ro de fax 1 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(fax2) && !isPhone(fax2)) { showWarning("Num\u00E9ro de fax 2 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(email1) && !isEmail(email1)) { showWarning("Adresse e-mail 1 incorrecte (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(email2) && !isEmail(email2)) { showWarning("Adresse e-mail 2 incorrecte (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(siteWeb) && !isWeb(siteWeb)) { showWarning("Site Web incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(numSIRET) && (numSIRET.length != 14 || !isDigitList(numSIRET))) { showWarning("Num\u00E9ro SIRET incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(tauxRemise) || !isTaux(tauxRemise) || parseFloat(tauxRemise)>=100) { showWarning("Taux de remise incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(encoursAuto) || !isPositiveOrNull(encoursAuto)) { showWarning("Encours autoris\u00E9 incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(delaiLivraison) || !isPositiveOrNullInteger(delaiLivraison)) { showWarning("D\u00E9lai de livraison incorrect ! (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (francoPort && !isPositiveOrNull(montantFranco)) { showWarning("Le montant du franco de port est incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (off_typePort=='P'?!isTaux(fraisPort):!isPositiveOrNull(fraisPort)) { showWarning("Le montant des frais de port est incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else {

			var qSave;

			if (off_mode=="C") {
				qSave = new QueryHttp("Facturation/Fournisseurs/createFicheFournisseur.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Fournisseurs/updateFicheFournisseur.tmpl");
				qSave.setParam("Fournisseur_Id", off_fournisseurId);
			}

			if (off_mode=="M" || !off_numerotationAuto) {
				qSave.setParam('Num_Fournisseur', numFournisseur);
			}
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Civilite", civilite);
			qSave.setParam("Nom", nom);
			qSave.setParam("Prenom", prenom);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Tel_1", tel1);
			qSave.setParam("Tel_2", tel2);
			qSave.setParam("Tel_3", tel3);
			qSave.setParam("Fax_1", fax1);
			qSave.setParam("Fax_2", fax2);
			qSave.setParam("Email_1", email1);
			qSave.setParam("Email_2", email2);
			qSave.setParam("Site_Web", siteWeb);
			qSave.setParam("Com_Libre", comLibre);
			qSave.setParam("Code_Couleur", codeCouleur);
			qSave.setParam("Forme_Juridique", formeJuridique);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Num_SIRET", numSIRET);
			qSave.setParam("Code_NAF", codeNAF);
			qSave.setParam("Famille_Id", famille);
			qSave.setParam("Pole_Activite", poleActivite);
			qSave.setParam("Actif", actif);
			qSave.setParam("Logisticien", logisticien);
			qSave.setParam("Util_R", responsable);
			qSave.setParam("Code_Client", codeClient);
			qSave.setParam("Indications", indications);
			qSave.setParam("Date_Ouverture", dateOuverture);

			qSave.setParam("Compte_Fournisseur", compteFournisseur);
			qSave.setParam("Mode_Reg_Id", modeReglement);
			qSave.setParam("Modalite_Id", modaliteReg);
			qSave.setParam("Taux_Remise", tauxRemise);
			qSave.setParam("Banque_Retrait", banqueRetrait);
			qSave.setParam("CF_Chiffre", cfChiffre);
			qSave.setParam("Groupe_CF_Rea_CC", groupeCFReaCC);
			qSave.setParam("Liv_Directe", livDirecte);
			qSave.setParam("Delai_Livraison", delaiLivraison);
			qSave.setParam("Site_Web_Com", siteWebCom);
			qSave.setParam("Login_Web", loginWeb);
			qSave.setParam("Pass_Web", passWeb);
			qSave.setParam("Encours_Auto", encoursAuto);
			qSave.setParam("Franco_Port", francoPort);
			qSave.setParam("Montant_Franco", montantFranco);
			qSave.setParam("Frais_Port", fraisPort);
			qSave.setParam("Type_Port", off_typePort);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (off_mode=="C") {
					off_fournisseurId = result.responseXML.documentElement.getAttribute("Fournisseur_Id");
					off_chargerFournisseur();
				}
				else {
					ooc_initOngletContacts();
					ooa_initOngletAdresses();
					off_initListeDepots();
					off_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function off_supprimerFournisseur() {
	try {

		var numFournisseur = document.getElementById('off-numFournisseur').value;

		if (window.confirm("Confirmez-vous la suppression du fournisseur "+ numFournisseur +" ?")) {

			var qSupFou = new QueryHttp("Facturation/Fournisseurs/deleteFicheFournisseur.tmpl");
			qSupFou.setParam('Fournisseur_Id', off_fournisseurId);
			var result = qSupFou.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
    		showMessage("Le fournisseur a \u00E9t\u00E9 supprim\u00E9");
				retourMenuFournisseurs();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function off_hideButtons(b) {
	try {

		document.getElementById('off-buttons').collapsed = b;

	} catch (e) {
  	recup_erreur(e);
  }
}


function off_demandeEnregistrement() {
  try {

		if (off_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche fournisseur ?")) {
				off_enregistrerFournisseur();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function off_setModified(m) {
  try {

  	off_modified = m;
		if (m) {
			if (document.getElementById('off-panneau').selectedIndex==0) {
				document.getElementById('off-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
			else {
				document.getElementById('off-tabElements').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
		}
		else {
			document.getElementById('off-tabFiche').setAttribute('image', null);
			document.getElementById('off-tabElements').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}
