/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ooc_currentContact;
var ooc_aContacts = new Arbre("Facturation/Fournisseurs/list-contactFournisseur.tmpl", "ooc-liste_contacts");
var ooc_adresseContact = "";



function ooc_initOngletContacts() {
	try {

		ooc_aContacts.setParam("Fournisseur_Id", off_fournisseurId);
		ooc_aContacts.initTree(ooc_nouveauContact);

	} catch (e) {
		recup_erreur(e);
  }
}


function ooc_nouveauContact() {
	try {

		ooc_aContacts.clearSelection();

	  document.getElementById('ooc-Civilite').value = "0";
		document.getElementById('ooc-Nom').value = "";
		document.getElementById('ooc-Prenom').value = "";
		document.getElementById('ooc-Fonction').value = "";
		document.getElementById('ooc-denomination').value = "";
		document.getElementById('ooc-Adresse_1').value = "";
		document.getElementById('ooc-Adresse_2').value = "";
		document.getElementById('ooc-Adresse_3').value = "";
		document.getElementById('ooc-Code_Postal').value = "";
		document.getElementById('ooc-Ville').value = "";
		document.getElementById('ooc-Pays').value = "";
		document.getElementById('ooc-tel1').value = "";
		document.getElementById('ooc-tel2').value = "";
		document.getElementById('ooc-Fax').value = "";
		document.getElementById('ooc-Email').value = "";
		document.getElementById('ooc-Relation').value = "O";
		document.getElementById('ooc-Defaut').checked = false;
		document.getElementById('ooc-Defaut').disabled = false;
		document.getElementById('ooc-Infos').value = "";
		document.getElementById('ooc-Principal').checked = false;
		document.getElementById('ooc-Principal').disabled = false;
		ooc_adresseContact = "";

		document.getElementById('ooc-bNouveauContact').collapsed = true;
		document.getElementById('ooc-bSupprimerContact').collapsed = true;
		document.getElementById('ooc-bModifierContact').collapsed = true;
		document.getElementById('ooc-bCreerContact').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function ooc_supprimerContact() {
	try {

		var prenom = document.getElementById('ooc-Prenom').value;
		var nom = document.getElementById('ooc-Nom').value;

		if (window.confirm("Confirmez-vous la suppression du contact '"+ prenom +" "+ nom +"' ?")) {

			var qSupContact = new QueryHttp("Facturation/Fournisseurs/deleteContactFournisseur.tmpl");
			qSupContact.setParam('Contact_Id', ooc_currentContact);
			var result = qSupContact.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('ooc-bSupprimerContact').collapsed = true;
				document.getElementById('ooc-bModifierContact').collapsed = true;
				document.getElementById('ooc-bCreerContact').collapsed = false;
				document.getElementById('ooc-bNouveauContact').collapsed = true;
				ooc_aContacts.initTree(ooc_nouveauContact);
				ooa_initOngletAdresses();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooc_enregistrerContact(mode) {
	try {

    var civilite = document.getElementById('ooc-Civilite').value;
		var nom = document.getElementById('ooc-Nom').value;
		var prenom = document.getElementById('ooc-Prenom').value;
		var fonction = document.getElementById('ooc-Fonction').value;
		var relation = document.getElementById('ooc-Relation').value;
		var infos = document.getElementById('ooc-Infos').value;
		var tel1 = document.getElementById('ooc-tel1').value;
		var tel2 = document.getElementById('ooc-tel2').value;
		var fax = document.getElementById('ooc-Fax').value;
		var email = document.getElementById('ooc-Email').value;
		var defaut = document.getElementById('ooc-Defaut').checked;
		var principal = document.getElementById('ooc-Principal').checked;

		if (isEmpty(nom)) {
			showWarning("Veuillez sp\u00E9cifier le nom du contact !");
		}
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("Le num\u00E9ro de t\u00E9l\u00E9phone 1 est invalide !"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("Le num\u00E9ro de t\u00E9l\u00E9phone 2 est invalide !"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le num\u00E9ro de fax est invalide !"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'adresse e-mail est invalide !"); }
		else {

			var qSaveContact;

			if (mode=="C") {
				qSaveContact = new QueryHttp("Facturation/Fournisseurs/createContactFournisseur.tmpl");
			}
			else {
				qSaveContact = new QueryHttp("Facturation/Fournisseurs/updateContactFournisseur.tmpl");
				qSaveContact.setParam('Contact_Id', ooc_currentContact);
			}

			qSaveContact.setParam('Fournisseur_Id', off_fournisseurId);
			qSaveContact.setParam('Civilite', civilite);
			qSaveContact.setParam('Nom', nom);
			qSaveContact.setParam('Prenom', prenom);
			qSaveContact.setParam('Fonction', fonction);
			qSaveContact.setParam('Relation', relation);
			qSaveContact.setParam('Infos', infos);
			qSaveContact.setParam('Tel_1', tel1);
			qSaveContact.setParam('Tel_2', tel2);
			qSaveContact.setParam('Fax', fax);
			qSaveContact.setParam('Email', email);
			qSaveContact.setParam('Defaut', defaut);
			qSaveContact.setParam('Adresse_Id', ooc_adresseContact);
			qSaveContact.setParam('Principal', principal);

			var result = qSaveContact.execute();

			document.getElementById('ooc-Principal').disabled = principal;
			document.getElementById('ooc-Defaut').disabled = defaut;

			if (mode=="C") {
				ooc_currentContact = result.responseXML.documentElement.getAttribute('Contact_Id');

				document.getElementById('ooc-bCreerContact').collapsed = true;
				document.getElementById('ooc-bModifierContact').collapsed = false;
				document.getElementById('ooc-bNouveauContact').collapsed = false;
				document.getElementById('ooc-bSupprimerContact').collapsed = false;
			}

			if (principal) {
				document.getElementById('off-civilite').value = civilite;
				document.getElementById('off-nom').value = nom;
				document.getElementById('off-prenom').value = prenom;
			}

			ooc_aContacts.initTree();
			ooa_initOngletAdresses();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooc_chargerContact() {
	try {

		if (ooc_aContacts.isSelected()) {

			ooc_currentContact = ooc_aContacts.getSelectedCellValue('ooc-ColCivilite');

			document.getElementById('ooc-Civilite').value = ooc_aContacts.getSelectedCellText('ooc-ColNum_Civ');
			document.getElementById('ooc-Nom').value = ooc_aContacts.getSelectedCellText('ooc-ColNom');
			document.getElementById('ooc-Prenom').value = ooc_aContacts.getSelectedCellText('ooc-ColPrenom');
			document.getElementById('ooc-Fonction').value = ooc_aContacts.getSelectedCellText('ooc-ColFonction');
			document.getElementById('ooc-Relation').value = ooc_aContacts.getSelectedCellText('ooc-ColRelation');
			document.getElementById('ooc-Infos').value = ooc_aContacts.getSelectedCellText('ooc-ColInfos');
			document.getElementById('ooc-denomination').value = ooc_aContacts.getSelectedCellText('ooc-ColDenomination');
			document.getElementById('ooc-Adresse_1').value = ooc_aContacts.getSelectedCellText('ooc-ColAdresse_1');
			document.getElementById('ooc-Adresse_2').value = ooc_aContacts.getSelectedCellText('ooc-ColAdresse_2');
			document.getElementById('ooc-Adresse_3').value = ooc_aContacts.getSelectedCellText('ooc-ColAdresse_3');
			document.getElementById('ooc-Code_Postal').value = ooc_aContacts.getSelectedCellText('ooc-ColCode_Postal');
			document.getElementById('ooc-Ville').value = ooc_aContacts.getSelectedCellText('ooc-ColVille');
			document.getElementById('ooc-Pays').value = ooc_aContacts.getSelectedCellText('ooc-ColPays');
			document.getElementById('ooc-tel1').value = ooc_aContacts.getSelectedCellText('ooc-ColTel1');
			document.getElementById('ooc-tel2').value = ooc_aContacts.getSelectedCellText('ooc-ColTel2');
			document.getElementById('ooc-Fax').value = ooc_aContacts.getSelectedCellText('ooc-ColFax');
			document.getElementById('ooc-Email').value = ooc_aContacts.getSelectedCellText('ooc-ColEmail');
			document.getElementById('ooc-Defaut').checked = (ooc_aContacts.getSelectedCellText('ooc-ColDefaut')=="true");
			ooc_adresseContact = ooc_aContacts.getSelectedCellText('ooc-ColAdresse_Id');
			document.getElementById('ooc-Principal').checked = (ooc_aContacts.getSelectedCellText('ooc-ColPrincipal')=="true");
			document.getElementById('ooc-Principal').disabled = document.getElementById('ooc-Principal').checked;
			document.getElementById('ooc-Defaut').disabled = document.getElementById('ooc-Defaut').checked;

      document.getElementById('ooc-bSupprimerContact').collapsed = false;
			document.getElementById('ooc-bModifierContact').collapsed = false;
			document.getElementById('ooc-bNouveauContact').collapsed = false;
			document.getElementById('ooc-bCreerContact').collapsed = true;
		}

 	} catch (e) {
    recup_erreur(e);
  }
}


function ooc_rechercherAdresse() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdrCom.xul?"+ cookie() +"&NoPrinc=1&Fournisseur_Id="+ off_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', ooc_reporterAdresse);
		ooa_initOngletAdresses();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ooc_reporterAdresse(denomination, adr1, adr2, adr3, cp, ville, pays, code_pays, contact, depotId, adresseId) {
  try {

		document.getElementById("ooc-denomination").value = denomination;
		document.getElementById("ooc-Adresse_1").value = adr1;
		document.getElementById("ooc-Adresse_2").value = adr2;
		document.getElementById("ooc-Adresse_3").value = adr3;
		document.getElementById("ooc-Code_Postal").value = cp;
		document.getElementById("ooc-Ville").value = ville;
	  document.getElementById("ooc-Pays").value = pays;

		ooc_adresseContact = adresseId;

	} catch (e) {
  	recup_erreur(e);
  }
}


