/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oei_aFamilles2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oei-famille2');
var oei_aFamilles3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oei-famille3');
var oei_aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "oei-zoneStockage");
var oei_aLignes = new Arbre('Facturation/Inventaire/list-ligneInventaire.tmpl', 'oei-lignesInventaire');
var oei_qListLI = new QueryHttp("Facturation/Inventaire/getDataListLI.tmpl");


var oei_inventaireId;
var oei_currentLigneId = "";
var oei_currentIndex = -1;
var oei_pageCourante;
var oei_nbPages;
var oei_etat;
var oei_depotId;
var oei_importFile;
var oei_methode = "E";
var oei_searchLigneId = "";



function oei_init() {
  try {

		if (!gActEmplacements) {
			document.getElementById('oei-bRechEmplacement').collapsed = true;
			document.getElementById('oei-lblFiltreZone').collapsed = true;
			document.getElementById('oei-zoneStockage').collapsed = true;
			document.getElementById('oei-colZoneStockage').collapsed = true;
			document.getElementById('oei-colZoneStockage').setAttribute("ignoreincolumnpicker", true);
		}

		var aMarques = new Arbre("ComboListe/combo-marquesArticle.tmpl", "oei-marque");
		aMarques.setParam("Search_Mode", true);
		aMarques.initTree();

		var oei_aFamilles1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oei-famille1');
		oei_aFamilles1.setParam("Search_Mode", true);
		oei_aFamilles1.initTree();

		oei_aFamilles2.setParam("Search_Mode", true);
		oei_aFamilles3.setParam("Search_Mode", true);

		document.getElementById('oei-famille2').disabled = true;
		document.getElementById('oei-famille3').disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oei_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('oei-famille1').value;

		document.getElementById('oei-famille2').value = "";
		document.getElementById('oei-famille2').disabled = isEmpty(famille1);

		oei_aFamilles3.deleteTree();
		document.getElementById('oei-famille3').value = "";
		document.getElementById('oei-famille3').disabled = true;

		oei_aFamilles2.setParam('Parent_Id', famille1);
		oei_aFamilles2.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('oei-famille2').value;

		document.getElementById('oei-famille3').value = "";
		document.getElementById('oei-famille3').disabled = isEmpty(famille2);

		oei_aFamilles3.setParam('Parent_Id', famille2);
		oei_aFamilles3.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_initCriteres() {
	try {

		document.getElementById('oei-famille2').disabled = true;
		document.getElementById('oei-famille3').disabled = true;
		oei_aFamilles2.deleteTree();
		oei_aFamilles3.deleteTree();

		document.getElementById('oei-marque').value = "";
		document.getElementById('oei-famille1').value = "";
		document.getElementById('oei-famille2').value = "";
		document.getElementById('oei-famille3').value = "";
		document.getElementById('oei-ecarts').checked = false;
		document.getElementById('oei-zoneStockage').value = "";
		document.getElementById('oei-codeEmplacement').value = "";

		oei_listerLignes();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oei_listerLignes();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oei_listerLignes() {
	try {

		var marque = document.getElementById('oei-marque').value;
		var famille1 = document.getElementById('oei-famille1').value;
		var famille2 = document.getElementById('oei-famille2').value;
		var famille3 = document.getElementById('oei-famille3').value;
		var ecarts = document.getElementById('oei-ecarts').checked;
		var zoneStockage = document.getElementById('oei-zoneStockage').value;
		var codeEmplacement = document.getElementById('oei-codeEmplacement').value;
		var nbLignesParPage = document.getElementById('oei-nbLignesParPage').value;

		oei_pageCourante = 1;
		oei_nbPages = 1;
		document.getElementById('oei-pageDeb').value = 1;
		document.getElementById('oei-pageFin').value = 1;
		document.getElementById('oei-bPrec').disabled = true;
		document.getElementById('oei-bSuiv').disabled = true;
		document.getElementById('oei-pageDeb').disabled = true;

		document.getElementById('oei-lignesInventaire').disabled = true;
		oei_aLignes.deleteTree();

		oei_qListLI.setParam("Inventaire_Id", oei_inventaireId);
		oei_qListLI.setParam("Marque", marque);
		oei_qListLI.setParam("Famille_1", famille1);
		oei_qListLI.setParam("Famille_2", famille2);
		oei_qListLI.setParam("Famille_3", famille3);
		oei_qListLI.setParam("Ecarts", ecarts);
		oei_qListLI.setParam("Zone_Stockage", zoneStockage);
		oei_qListLI.setParam("Code_Emplacement", codeEmplacement);
		oei_qListLI.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		oei_qListLI.setParam("Current_Page", oei_pageCourante);
		if (!isEmpty(oei_searchLigneId)) {
			oei_qListLI.setParam("Search_Ligne_Id", oei_searchLigneId);
		}

		var result = oei_qListLI.execute();

		var contenu = result.responseXML.documentElement;

		if (!isEmpty(oei_searchLigneId)) {
			oei_pageCourante = contenu.getAttribute("Page_Courante");
			oei_qListLI.removeParam("Search_Ligne_Id");
		}

		oei_nbPages = contenu.getAttribute("Nb_Pages");
		var listLigneId = contenu.getAttribute("List_Ligne_Id");

		oei_aLignes.setParam("List_Ligne_Id", listLigneId);
		oei_aLignes.initTree(oei_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_initPagination() {
	try {

		document.getElementById('oei-pageDeb').value = oei_pageCourante;
		document.getElementById('oei-pageFin').value = (oei_nbPages>0?oei_nbPages:1);
		document.getElementById('oei-bPrec').disabled = (oei_pageCourante==1);
		document.getElementById('oei-bSuiv').disabled = (oei_pageCourante>=oei_nbPages); // peut se produire si oei_nbPages=0

		oei_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_pressOnPagePrec() {
	try {

		oei_pageCourante--;
		oei_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_pressOnPageSuiv() {
	try {

		oei_pageCourante++;
		oei_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_pressOnPageDeb(ev) {
  try {

		if (ev.keyCode==13) {
			var pageDeb = document.getElementById("oei-pageDeb").value;

			if (!isPositiveInteger(pageDeb) || parseIntBis(pageDeb)>oei_nbPages) {
				showWarning("Num\u00E9ro de page incorrect");
			}
			else {
				oei_pageCourante = pageDeb;
				oei_majPagination();
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oei_majPagination() {
	try {

		document.getElementById('oei-pageDeb').value = oei_pageCourante;
		document.getElementById('oei-bPrec').disabled = (oei_pageCourante==1);
		document.getElementById('oei-bSuiv').disabled = (oei_pageCourante==oei_nbPages);
		document.getElementById('oei-pageDeb').disabled = true;

		document.getElementById('oei-lignesInventaire').disabled = true;

		oei_qListLI.setParam("Current_Page", oei_pageCourante);
		var result = oei_qListLI.execute();
		var listLigneId = result.responseXML.documentElement.getAttribute("List_Ligne_Id");

		oei_aLignes.setParam("List_Ligne_Id", listLigneId);
		oei_aLignes.initTree(oei_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_afterMajPagination() {
	try {

		document.getElementById('oei-lignesInventaire').disabled = false;
		document.getElementById('oei-pageDeb').disabled = (oei_nbPages<=1);

		if (!isEmpty(oei_currentLigneId)) {
			oei_viderLigne();

			if (oei_methode!='L') {
				oei_aLignes.ensureRowIsVisible(oei_currentIndex);
			}
			else {
				if (oei_aLignes.nbLignes()!=oei_currentIndex+1) {
					oei_aLignes.ensureRowIsVisible(oei_currentIndex+1);
					oei_aLignes.select(oei_currentIndex+1);
				}
				else {
					// dernire ligne de la dernire page
					oei_aLignes.ensureRowIsVisible(oei_currentIndex);
				}
			}
		}
		else if (!isEmpty(oei_searchLigneId)) {

			var idx = 0;
			var found = false;

			while (!found && idx<oei_aLignes.nbLignes()) {
				if (oei_aLignes.getCellText(idx, "oei-colLigneId")==oei_searchLigneId) {
					found = true;
					break;
				}
				idx++;
			}

			if (found) {
				oei_aLignes.ensureRowIsVisible(idx);
      	oei_aLignes.select(idx);
			}

			oei_searchLigneId = "";
    }
		else {
			oei_viderLigne();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_initIHM() {
	try {

		document.getElementById('oei-boxSaisie').collapsed = oei_etat!='T';
		document.getElementById('oei-boxImport').collapsed = oei_etat!='T';
		document.getElementById('oei-bAnnuler').collapsed = oei_etat!='T';
		document.getElementById('oei-bCloturer').collapsed = oei_etat!='T';

		document.getElementById('oei-bEditerInventaire').disabled = oei_etat!='C';

		document.getElementById('oei-pathFile').value = "";

		document.getElementById('oei-methode').value = "E";
		oei_viderLigne();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_chargerInventaire() {
	try {

		var qLoad = new QueryHttp("Facturation/Inventaire/loadInventaire.tmpl");
		qLoad.setParam("Inventaire_Id", oei_inventaireId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		oei_etat = contenu.getAttribute('Etat');
		oei_depotId = contenu.getAttribute('Depot_Id');
		document.getElementById('oei-boxCriteres').collapsed = contenu.getAttribute('Type_Inventaire')=="C";

		document.getElementById('oei-lblInventaire').value = "Inventaire N\u00B0 "+ contenu.getAttribute('Num_Inventaire');
		document.getElementById('oei-lblNumInventaire').value = contenu.getAttribute('Num_Inventaire');
		document.getElementById('oei-lblDepotStock').value = contenu.getAttribute('Depot_Stock');
		document.getElementById('oei-lblTypeInventaire').value = contenu.getAttribute('Lib_Type_Inventaire');
		document.getElementById('oei-lblEtat').value = contenu.getAttribute('Lib_Etat');

		document.getElementById('oei-lblZoneStockage').value = contenu.getAttribute('Zone_Stockage');
		document.getElementById('oei-lblCodeEmplacement').value = contenu.getAttribute('Code_Emplacement');
		document.getElementById('oei-lblMarque').value = contenu.getAttribute('Marque');
		document.getElementById('oei-lblFamille1').value = contenu.getAttribute('Famille_1');
		document.getElementById('oei-lblFamille2').value = contenu.getAttribute('Famille_2');
		document.getElementById('oei-lblFamille3').value = contenu.getAttribute('Famille_3');

		oei_aZones.setParam('Depot_Id', oei_depotId);
		oei_aZones.initTree();

		oei_initIHM();
		oei_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_validerLigneInventaire() {
  try {

		var qteInventaire = document.getElementById('oei-qteInventaire').value;

		if (isEmpty(oei_currentLigneId)) {
			showWarning("Veuillez s\u00E9lectionner une ligne");
		}
		else if (!checkDecimal(qteInventaire,3)) {
			showWarning("Quantit\u00E9 incorrecte");
		}
		else {
			var qAdd = new QueryHttp("Facturation/Inventaire/addQuantiteLigneInventaire.tmpl");
			qAdd.setParam('Quantite', qteInventaire);
			qAdd.setParam('Ligne_Id', oei_currentLigneId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oei_methode!='L') {
					oei_majPagination();
				}
				else {
					if (oei_pageCourante<oei_nbPages && oei_aLignes.nbLignes()==oei_currentIndex+1) {
						oei_currentIndex = -1;
						oei_pressOnPageSuiv();
					}
					else {
						oei_majPagination();
					}
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_reporterLigneInventaire() {
  try {

		if (oei_aLignes.isSelected()) {
			document.getElementById('oei-emplacement').value = oei_aLignes.getSelectedCellText('oei-colCodeEmplacement');
			document.getElementById('oei-reference').value = oei_aLignes.getSelectedCellText('oei-colReference');
			document.getElementById('oei-designation').value = oei_aLignes.getSelectedCellText('oei-colDesignation');
			var qteTheorique = oei_aLignes.getSelectedCellText('oei-colQteTheorique');
			document.getElementById('oei-qteTheorique').value = qteTheorique;
			if (parseFloat(qteTheorique)<0) {
				qteTheorique = 0;
			}
			document.getElementById('oei-qteInventaire').value = qteTheorique;

			oei_currentLigneId = oei_aLignes.getSelectedCellText('oei-colLigneId');
			oei_currentIndex = oei_aLignes.getCurrentIndex();

			document.getElementById('oei-emplacement').disabled = true;
			document.getElementById('oei-reference').disabled = true;

			document.getElementById('oei-bValiderLigne').disabled = false;
			document.getElementById('oei-qteInventaire').disabled = false;
			document.getElementById('oei-qteInventaire').select();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_pressOnQteInventaire(ev) {
  try {

		if (ev.keyCode==13) {
			oei_validerLigneInventaire();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_cloturerInventaire() {
  try {

		var qCheck = new QueryHttp("Facturation/Inventaire/checkInventaire.tmpl");
		qCheck.setParam("Inventaire_Id", oei_inventaireId);
		var result = qCheck.execute();
		var contenu = result.responseXML.documentElement;

		var ok = false;

		if (contenu.getAttribute('Message_Ecart')=="true") {
			ok = window.confirm("L'inventaire contient des \u00E9carts, voulez-vous poursuivre la cl\u00F4ture de l'inventaire ?");
		}
		else if (contenu.getAttribute('Complet')=="false") {
			ok = window.confirm("L'inventaire est incomplet, voulez-vous poursuivre la cl\u00F4ture de l'inventaire ?");
		}
		else {
			ok = window.confirm("Confirmez-vous la cl\u00F4ture de l'inventaire ?")
		}

		if (ok) {
			document.getElementById('oei-boxSaisie').collapsed = true;
			document.getElementById('oei-boxImport').collapsed = true;
			document.getElementById('oei-bAnnuler').collapsed = true;
			document.getElementById('oei-bCloturer').collapsed = true;

			document.getElementById('oei-pmbox').collapsed = false;
			document.getElementById('oei-pm').setAttribute('mode', 'undetermined');

			var qValid = new QueryHttp("Facturation/Inventaire/validInventaire.tmpl");
			qValid.setParam("Inventaire_Id", oei_inventaireId);
			qValid.execute(oei_cloturerInventaire_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_cloturerInventaire_2(result) {
	try {

		document.getElementById('oei-pmbox').collapsed = true;
		document.getElementById('oei-pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var nbExclues = result.responseXML.documentElement.getAttribute("Nb_Exclues");
			if (parseIntBis(nbExclues)>0) {
				showWarning("OpenSi a d\u00E9tect\u00E9 "+ nbExclues +" ligne(s) mouvement\u00E9e(s) pendant la p\u00E9riode d'ouverture d'inventaire. Ces lignes ne seront donc pas prises en compte. Exportez la liste des lignes concern\u00E9es en cliquant sur Ok.");

				var fichier = result.responseXML.documentElement.getAttribute("FichierCSV");
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}

			showMessage("L'inventaire a \u00E9t\u00E9 cl\u00F4tur\u00E9");
		}

		oei_chargerInventaire();

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_annulerInventaire() {
  try {

		if (window.confirm("Confirmez-vous l'annulation de l'inventaire en cours ?")) {

			var qCancel = new QueryHttp("Facturation/Inventaire/cancelInventaire.tmpl");
			qCancel.setParam("Inventaire_Id", oei_inventaireId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'inventaire a \u00E9t\u00E9 annul\u00E9");
			}

			retourMenuInventaires();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_switchMethode() {
  try {

		oei_methode = document.getElementById('oei-methode').value;

		oei_viderLigne();

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_rechercherLigneInventaire(typeScan) {
	try {

		var reference = document.getElementById('oei-reference').value;
		var codeEmplacement = document.getElementById('oei-emplacement').value;

		if (typeScan=="A" && isEmpty(reference)) {
			showWarning("Veuillez scanner un code barre ou saisir une r\u00E9f\u00E9rence article");
		}
		else {
			var qSearch = new QueryHttp("Facturation/Inventaire/searchLigneInventaire.tmpl");
			qSearch.setParam("Inventaire_Id", oei_inventaireId);
			qSearch.setParam('Reference', reference);
			if (typeScan=="E" || oei_methode=="E") {
				// on veut rechercher par le code emplacement uniquement si on scanne un emplacement ou bien si l'on a dj pass le scan emplacement
				// conditions ncessaires pour grer la recherche d'emplacement non localis (vide)
				qSearch.setParam('Code_Emplacement', codeEmplacement);
			}
			var result = qSearch.execute();

			var contenu = result.responseXML.documentElement;
			var ligneId = contenu.getAttribute('Ligne_Id');

			if (!isEmpty(ligneId)) {
				oei_searchLigneId = contenu.getAttribute('Ligne_Id');
				oei_listerLignes();
			}
			else {
				if (oei_methode=="E" && typeScan=="E") {
					document.getElementById('oei-emplacement').disabled = true;
					document.getElementById('oei-reference').disabled = false;
					document.getElementById('oei-reference').focus();
				}
				else if (oei_methode=="A" && typeScan=="A") {
					document.getElementById('oei-reference').disabled = true;
					document.getElementById('oei-emplacement').disabled = false;
					document.getElementById('oei-emplacement').focus();
				}
				else {
					showWarning("Aucune ligne ne correspond \u00E0 votre recherche");
					oei_viderLigne();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_pressOnEmplacement(ev) {
  try {

		if (ev.keyCode==13) {
			oei_rechercherLigneInventaire("E");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_pressOnReference(ev) {
  try {

		if (ev.keyCode==13) {
			oei_rechercherLigneInventaire("A");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_editionInventaire(typeEdition) {
  try {

		var sortie = document.getElementById('oei-rgpSortie').value;
		var filtrer = document.getElementById('oei-filtrer').checked;

		var marque = document.getElementById('oei-marque').value;
		var famille1 = document.getElementById('oei-famille1').value;
		var famille2 = document.getElementById('oei-famille2').value;
		var famille3 = document.getElementById('oei-famille3').value;
		var ecarts = document.getElementById('oei-ecarts').checked;
		var zoneStockage = document.getElementById('oei-zoneStockage').value;
		var codeEmplacement = document.getElementById('oei-codeEmplacement').value;

		if (sortie=="PDF") {
			document.getElementById('oei-deckInventaire').selectedIndex = 1;
			document.getElementById('bRetourInventaire').collapsed = false;

			var qEditionPdf = new QueryHttp("Facturation/Inventaire/pdfInventaire.tmpl");
			qEditionPdf.setParam("Inventaire_Id", oei_inventaireId);
			qEditionPdf.setParam("Type_Edition", typeEdition);
			qEditionPdf.setParam("Filtrer", filtrer);
			qEditionPdf.setParam("Marque", marque);
			qEditionPdf.setParam("Famille_1", famille1);
			qEditionPdf.setParam("Famille_2", famille2);
			qEditionPdf.setParam("Famille_3", famille3);
			qEditionPdf.setParam("Ecarts", ecarts);
			qEditionPdf.setParam("Zone_Stockage", zoneStockage);
			qEditionPdf.setParam("Code_Emplacement", codeEmplacement);

			var result = qEditionPdf.execute();

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oei-pdfInventaire').setAttribute("src", page);
		}
		else {
			var qEditionCsv = new QueryHttp("Facturation/Inventaire/csvInventaire.tmpl");
			qEditionCsv.setParam("Inventaire_Id", oei_inventaireId);
			qEditionCsv.setParam("Type_Edition", typeEdition);
			qEditionCsv.setParam("Format", sortie);
			qEditionCsv.setParam("Filtrer", filtrer);
			qEditionCsv.setParam("Marque", marque);
			qEditionCsv.setParam("Famille_1", famille1);
			qEditionCsv.setParam("Famille_2", famille2);
			qEditionCsv.setParam("Famille_3", famille3);
			qEditionCsv.setParam("Ecarts", ecarts);
			qEditionCsv.setParam("Zone_Stockage", zoneStockage);
			qEditionCsv.setParam("Code_Emplacement", codeEmplacement);

			var result = qEditionCsv.execute();
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_viderLigne() {
	try {

		document.getElementById('oei-bValiderLigne').disabled = true;
		document.getElementById('oei-qteInventaire').disabled = true;

		document.getElementById('oei-emplacement').value = "";
		document.getElementById('oei-reference').value = "";
		document.getElementById('oei-designation').value = "";
		document.getElementById('oei-qteTheorique').value = "";
		document.getElementById('oei-qteInventaire').value = "";

		oei_aLignes.clearSelection();
		oei_currentLigneId = "";

		if (oei_methode=="E") {
			document.getElementById('oei-reference').disabled = true;
			document.getElementById('oei-emplacement').disabled = false;
			document.getElementById('oei-emplacement').focus();
		}
		else if (oei_methode=="A") {
			document.getElementById('oei-emplacement').disabled = true;
			document.getElementById('oei-reference').disabled = false;
			document.getElementById('oei-reference').focus();
		}
		else {
			document.getElementById('oei-reference').disabled = true;
			document.getElementById('oei-emplacement').disabled = true;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			oei_importFile = file;
			document.getElementById("oei-pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_importerFichier() {
	try {

		if (oei_importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier");
		}
		else {
			var extension = getFileExtension(oei_importFile.leafName).toLowerCase();

			if (!isEmpty(extension) && extension!="csv" && extension!="txt" && extension!="xlsx" && extension!="xls") {
				showWarning("Format de fichier incorrect (formats accept\u00E9s : *.csv, *.txt, *.xls, *.xlsx)");
			}
			else if (checkUploadFile(oei_importFile)) {

				uploadFile(oei_importFile);

	   		var qImport = new QueryHttp("Facturation/Inventaire/importInventaire.tmpl");
	   		qImport.setParam("Inventaire_Id", oei_inventaireId);
	   		qImport.setParam("Fichier", oei_importFile.leafName);
				qImport.setParam("Type_Import", document.getElementById('oei-formatImport').value);
				qImport.setParam("Extension", extension);
	   		var result = qImport.execute();

	   		var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var nbLines = result.responseXML.documentElement.getElementsByTagName("erreurs").length;

					if (nbLines==0) {
						showMessage("Import termin\u00E9 avec succ\u00E8s : "+ result.responseXML.documentElement.getAttribute('Nb_Lines_OK') +" lignes import\u00E9es");
					}
					else {
						var rapport = result.responseXML.documentElement.getAttribute('Fichier_Rapport');

						var messages = new Array();
						var lines = new Array();
						var cells = new Array();

						for (var j=0; j<nbLines; j++) {
							var erreur = result.responseXML.documentElement.getElementsByTagName('erreurs')[j];
							messages[j] = erreur.getAttribute("Message");
							lines[j] = erreur.getAttribute("Ligne");
							cells[j] = erreur.getAttribute("Cellule");
						}

						window.openDialog("chrome://opensi/content/facturation/user/csv/popup-rapportErreurs.xul",'','chrome,modal,centerscreen', lines, cells, messages, rapport);
					}

					document.getElementById('oei-pathFile').value = "";
				}

				oei_listerLignes();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_switchPictoSortie(sortie) {
	try {

		if (sortie=="pdf") {
			document.getElementById('oei-bEditerPdfVierge').setAttribute('class', 'bPDF');
			document.getElementById('oei-bEditerInventaire').setAttribute('class', 'bPDF');
			document.getElementById('oei-bEditerEcarts').setAttribute('class', 'bPDF');
		}
		else if (sortie=="xlsx") {
			document.getElementById('oei-bEditerPdfVierge').setAttribute('class', 'bXLS');
			document.getElementById('oei-bEditerInventaire').setAttribute('class', 'bXLS');
			document.getElementById('oei-bEditerEcarts').setAttribute('class', 'bXLS');
		}
		else {
			document.getElementById('oei-bEditerPdfVierge').setAttribute('class', 'bCSV');
			document.getElementById('oei-bEditerInventaire').setAttribute('class', 'bCSV');
			document.getElementById('oei-bEditerEcarts').setAttribute('class', 'bCSV');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oei_rechercherEmplacement() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oei_retourRechercherEmplacement, oei_depotId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oei_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oei-codeEmplacement').value = codeEmplacement;
  	oei_listerLignes();

	} catch (e) {
		recup_erreur(e);
	}
}
